/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskHelper;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import com.intellij.database.util.ObjectPath;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/introspection/SingleDatabaseIntrospectionTaskHelper;", "Lcom/intellij/database/introspection/IntrospectionTaskHelper;", "root", "Lcom/intellij/database/model/basic/BasicSingleDatabaseRoot;", "<init>", "(Lcom/intellij/database/model/basic/BasicSingleDatabaseRoot;)V", "getRoot", "()Lcom/intellij/database/model/basic/BasicSingleDatabaseRoot;", "specifiedDatabaseOf", "Lcom/intellij/database/model/basic/BasicDatabase;", "task", "Lcom/intellij/database/introspection/IntrospectionTask;", "databaseOf", "databaseByName", "name", "", "databaseIsKnown", "", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "distributeObjectPathsBetweenDatabases", "", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "", "Lcom/intellij/database/util/ObjectPath;", "paths", "", "intellij.database.core.impl"})
public final class SingleDatabaseIntrospectionTaskHelper
extends IntrospectionTaskHelper {
    @NotNull
    private final BasicSingleDatabaseRoot root;

    public SingleDatabaseIntrospectionTaskHelper(@NotNull BasicSingleDatabaseRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(null);
        this.root = root;
    }

    @Override
    @NotNull
    public BasicSingleDatabaseRoot getRoot() {
        return this.root;
    }

    @Override
    @Nullable
    public BasicDatabase specifiedDatabaseOf(@NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.getRoot();
    }

    @Override
    @Nullable
    public BasicDatabase databaseOf(@NotNull IntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return this.getRoot();
    }

    @Override
    @Nullable
    public BasicDatabase databaseByName(@Nullable String name) {
        return name == null || ((CharSequence)name).length() == 0 || Intrinsics.areEqual((Object)name, (Object)"@") || Intrinsics.areEqual((Object)this.getRoot().getName(), (Object)name) ? (BasicDatabase)this.getRoot() : null;
    }

    @Override
    public boolean databaseIsKnown(@NotNull DefiniteIntrospectionTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String dbName = task.getDatabaseName();
        return Intrinsics.areEqual((Object)dbName, (Object)"@") || Intrinsics.areEqual((Object)this.getRoot().getName(), (Object)dbName);
    }

    @Override
    @NotNull
    public Map<BasicNamespaceOwner, Set<ObjectPath>> distributeObjectPathsBetweenDatabases(@NotNull Collection<? extends ObjectPath> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Set set = paths instanceof Set ? (Set)paths : null;
        if (set == null) {
            Iterable iterable = paths;
            Comparator comparator = ObjectPath.PATH_COMPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"PATH_COMPARATOR");
            set = CollectionsKt.toSortedSet((Iterable)iterable, (Comparator)comparator);
        }
        Set allPaths = set;
        Map<BasicNamespaceOwner, Set<ObjectPath>> map = Collections.singletonMap(this.getRoot(), allPaths);
        Intrinsics.checkNotNullExpressionValue(map, (String)"singletonMap(...)");
        return map;
    }
}

