/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.Dbms;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.references.BasicByColumnsReference;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class BasicByColumnPositionsReference
extends BasicByColumnsReference {
    private final List<Short> colPositions;

    private BasicByColumnPositionsReference(@NotNull List<Short> colPositions) {
        if (colPositions == null) {
            BasicByColumnPositionsReference.$$$reportNull$$$0(0);
        }
        this.colPositions = colPositions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicByColumnPositionsReference)) {
            return false;
        }
        BasicByColumnPositionsReference reference = (BasicByColumnPositionsReference)o;
        return this.colPositions.equals(reference.colPositions);
    }

    public int hashCode() {
        return Objects.hash(this.colPositions);
    }

    @Override
    public <T extends BasicElement> @Unmodifiable @Nullable List<String> getColNames(@NotNull T target) {
        BasicLikeTable targetTable;
        if (target == null) {
            BasicByColumnPositionsReference.$$$reportNull$$$0(1);
        }
        if ((targetTable = (BasicLikeTable)DasUtil.getParentOfClass(target, BasicLikeTable.class, (boolean)false)) == null) {
            return null;
        }
        Dbms dbms = DbImplUtilCore.getDbms(target);
        ModelHelper helper = ModelFacade.forDbms(dbms).getModelHelper();
        PositioningNamingFamily<? extends BasicLikeColumn> columns = targetTable.getColumns();
        return ContainerUtil.map(this.colPositions, p -> helper.getColumnName((PositioningFamily<? extends BasicLikeColumn>)columns, (short)p));
    }

    @Nullable
    public static BasicByColumnPositionsReference create(@NotNull List<Short> colPositions) {
        if (colPositions == null) {
            BasicByColumnPositionsReference.$$$reportNull$$$0(2);
        }
        return BasicByColumnPositionsReference.isDefault(colPositions) ? null : new BasicByColumnPositionsReference(colPositions);
    }

    private static boolean isDefault(@NotNull List<Short> colPositions) {
        if (colPositions == null) {
            BasicByColumnPositionsReference.$$$reportNull$$$0(3);
        }
        return colPositions.isEmpty();
    }

    @Override
    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            BasicByColumnPositionsReference.$$$reportNull$$$0(4);
        }
        if (!BasicByColumnPositionsReference.isDefault(this.colPositions)) {
            consumer.accept("ColPositions", StringUtil.notNullize((String)PropertyConverter.exportListOfShort(this.colPositions)));
        }
    }

    @Nullable
    public static BasicByColumnPositionsReference importProperties(@NotNull NameValueGetter<String> properties) {
        String prop;
        if (properties == null) {
            BasicByColumnPositionsReference.$$$reportNull$$$0(5);
        }
        List<Short> colPositions = (prop = properties.get("ColPositions")) == null ? Collections.emptyList() : PropertyConverter.importListOfShort(prop);
        return BasicByColumnPositionsReference.create(colPositions);
    }

    public String toString() {
        return "colPositions=[" + StringUtil.join(this.colPositions, (String)", ") + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colPositions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/model/properties/references/BasicByColumnPositionsReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getColNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefault";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "exportProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "importProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

