/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.Dbms;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.common.MapFun;
import com.intellij.database.util.common.TreeFun;
import com.intellij.database.util.tree.AbstractTree;
import com.intellij.database.view.structure.DvMutableViewOptions;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeDsFoldersLayer;
import com.intellij.database.view.structure.DvTreeFundamentLayer;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeLayerDef;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeRootLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB'\b\u0017\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\rJ\u0016\u0010,\u001a\u00020-2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0006\u00106\u001a\u00020\u001dJ\u0010\u00107\u001a\u0004\u0018\u00010\u001d2\u0006\u00108\u001a\u00020\u001dJ\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u001d0:2\u0006\u00108\u001a\u00020\u001dJ\u000e\u0010;\u001a\u00020<2\u0006\u00108\u001a\u00020\u001dJ\u000e\u0010=\u001a\u00020<2\u0006\u00108\u001a\u00020\u001dJ\u000e\u0010>\u001a\u00020+2\u0006\u00108\u001a\u00020\u001dJ\u0013\u0010?\u001a\u00070@\u00a2\u0006\u0002\bA2\u0006\u00108\u001a\u00020\u001dJ\u000e\u0010B\u001a\u00020+2\u0006\u00108\u001a\u00020\u001dJ\u0019\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001d0!2\u0006\u00108\u001a\u00020\u001d\u00a2\u0006\u0002\u0010DJ#\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001d0!2\u0006\u00108\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020<H\u0002\u00a2\u0006\u0002\u0010GJ\u0006\u0010H\u001a\u00020+J\u0006\u0010I\u001a\u00020-J\u0006\u0010J\u001a\u00020-J\u0010\u0010K\u001a\u00020-2\u0006\u0010L\u001a\u00020(H\u0002J\u0010\u0010M\u001a\u00020-2\u0006\u0010L\u001a\u00020(H\u0002J$\u0010N\u001a\u00020-2\u0006\u0010L\u001a\u00020(2\b\u0010O\u001a\u0004\u0018\u00010P2\b\u0010Q\u001a\u0004\u0018\u00010PH\u0002J\u0010\u0010R\u001a\u00020-2\u0006\u0010L\u001a\u00020(H\u0002J\u0018\u0010S\u001a\u00020-2\u0006\u0010L\u001a\u00020(2\u0006\u0010T\u001a\u00020)H\u0002J\u000e\u0010U\u001a\u00020-2\u0006\u0010V\u001a\u00020(J\u0018\u0010U\u001a\u00020-2\u0006\u0010V\u001a\u00020(2\u0006\u0010T\u001a\u00020)H\u0002J\u000e\u0010W\u001a\u00020-2\u0006\u0010V\u001a\u00020(J\"\u0010X\u001a\u00020-2\u0006\u0010L\u001a\u00020(2\b\u0010O\u001a\u0004\u0018\u00010P2\b\u0010Q\u001a\u0004\u0018\u00010PJ\u000e\u0010Y\u001a\u00020-2\u0006\u0010V\u001a\u00020(J\u000e\u0010Z\u001a\u00020-2\u0006\u0010V\u001a\u00020(J\u0018\u0010Z\u001a\u00020-2\u0006\u0010V\u001a\u00020(2\u0006\u0010T\u001a\u00020)H\u0002J\u0010\u0010[\u001a\u00020-2\u0006\u0010T\u001a\u00020)H\u0002J\u0006\u0010\\\u001a\u00020-J\u0013\u0010]\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0007\u00a2\u0006\u0002\u0010^J\u0006\u0010_\u001a\u00020@R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082.\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010$\u001a\u00020%X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020+0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010.\u001a\u0004\u0018\u00010%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R \u00103\u001a\u0004\u0018\u00010%8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00100\"\u0004\b5\u00102\u00a8\u0006`"}, d2={"Lcom/intellij/database/view/structure/DvTreeStructure;", "", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "layerDefs", "", "Lcom/intellij/database/view/structure/DvTreeLayerDef;", "<init>", "(Lcom/intellij/database/view/structure/DvTreeContext;Ljava/util/Set;)V", "project", "Lcom/intellij/openapi/project/Project;", "options", "Lcom/intellij/database/view/structure/DvMutableViewOptions;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/view/structure/DvMutableViewOptions;Ljava/util/Set;)V", "getContext", "()Lcom/intellij/database/view/structure/DvTreeContext;", "fundamentLayer", "Lcom/intellij/database/view/structure/DvTreeFundamentLayer;", "allStoreyLayers", "Ljava/util/SortedMap;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "getAllStoreyLayers", "()Ljava/util/SortedMap;", "value", "selectedLayerDefs", "getSelectedLayerDefs", "()Ljava/util/Set;", "abstractTree", "Lcom/intellij/database/util/tree/AbstractTree;", "Lcom/intellij/database/model/basic/BasicNode;", "getAbstractTree", "()Lcom/intellij/database/util/tree/AbstractTree;", "activeLayers", "", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "[Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "upperLayer", "Lcom/intellij/database/view/structure/DvTreeLayer;", "dsDbms", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/database/model/RawDataSource;", "Lcom/intellij/database/Dbms;", "actualDbms", "", "setupLayers", "", "layoutLayer", "getLayoutLayer", "()Lcom/intellij/database/view/structure/DvTreeLayer;", "setLayoutLayer", "(Lcom/intellij/database/view/structure/DvTreeLayer;)V", "foldersLayer", "getFoldersLayer", "setFoldersLayer", "getRootNode", "parentOf", "node", "childrenOf", "Lkotlin/sequences/Sequence;", "countAllChildrenOf", "", "countRealChildrenOf", "isAlwaysLeaf", "presentableNameOf", "", "Lcom/intellij/openapi/util/NlsSafe;", "isValid", "getPath", "(Lcom/intellij/database/model/basic/BasicNode;)[Lcom/intellij/database/model/basic/BasicNode;", "getPathArray", "depth", "(Lcom/intellij/database/model/basic/BasicNode;I)[Lcom/intellij/database/model/basic/BasicNode;", "hasDataSourcesThatSupportMultilevel", "onFoldersChanged", "onViewOptionsChanged", "onDataSourceAdded", "dataSource", "onDataSourcePathChanged", "onDataSourceModelReplaced", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "onDataSourceChanged", "onDataSourceRemoved", "dbms", "dataSourceAdded", "ds", "notifyDataSourcePathChanged", "dataSourceModelReplaced", "dataSourceChanged", "dataSourceRemoved", "recheckDbms", "clearAll", "getActiveLayers", "()[Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "dumpTheTree", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeStructure.kt\ncom/intellij/database/view/structure/DvTreeStructure\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArrayFun.kt\ncom/intellij/database/util/common/ArrayFun\n*L\n1#1,244:1\n37#2,2:245\n37#2,2:261\n13805#3,2:247\n13805#3,2:249\n13805#3,2:251\n13805#3,2:253\n13805#3,2:255\n13805#3,2:257\n11#4,2:259\n11#4,2:263\n*S KotlinDebug\n*F\n+ 1 DvTreeStructure.kt\ncom/intellij/database/view/structure/DvTreeStructure\n*L\n84#1:245,2\n228#1:261,2\n134#1:247,2\n138#1:249,2\n142#1:251,2\n146#1:253,2\n150#1:255,2\n154#1:257,2\n158#1:259,2\n229#1:263,2\n*E\n"})
public class DvTreeStructure {
    @NotNull
    private final DvTreeContext context;
    @NotNull
    private final DvTreeFundamentLayer fundamentLayer;
    @NotNull
    private final SortedMap<DvTreeLayerDef, DvTreeStoreyLayer> allStoreyLayers;
    @NotNull
    private Set<? extends DvTreeLayerDef> selectedLayerDefs;
    private DvTreeAbstractLayer[] activeLayers;
    private DvTreeLayer upperLayer;
    @NotNull
    private final ConcurrentHashMap<RawDataSource, Dbms> dsDbms;
    @NotNull
    private final ConcurrentHashMap<Dbms, Boolean> actualDbms;
    @ApiStatus.Internal
    @Nullable
    private DvTreeLayer layoutLayer;
    @ApiStatus.Internal
    @Nullable
    private DvTreeLayer foldersLayer;

    @NotNull
    public final DvTreeContext getContext() {
        return this.context;
    }

    @NotNull
    public final SortedMap<DvTreeLayerDef, DvTreeStoreyLayer> getAllStoreyLayers() {
        return this.allStoreyLayers;
    }

    @NotNull
    public final Set<DvTreeLayerDef> getSelectedLayerDefs() {
        return this.selectedLayerDefs;
    }

    @NotNull
    public final AbstractTree<BasicNode> getAbstractTree() {
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.getAbstractTree();
    }

    public DvTreeStructure(@NotNull DvTreeContext context, @NotNull Set<? extends DvTreeLayerDef> layerDefs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(layerDefs, (String)"layerDefs");
        this.selectedLayerDefs = SetsKt.emptySet();
        this.context = context;
        this.fundamentLayer = new DvTreeRootLayer();
        this.dsDbms = new ConcurrentHashMap();
        this.actualDbms = new ConcurrentHashMap();
        this.fundamentLayer.setup$intellij_database_core_impl(context);
        TreeMap<DvTreeLayerDef, DvTreeStoreyLayer> layers = new TreeMap<DvTreeLayerDef, DvTreeStoreyLayer>();
        for (DvTreeLayerDef dvTreeLayerDef : layerDefs) {
            DvTreeStoreyLayer layer = (DvTreeStoreyLayer)dvTreeLayerDef.getCreateLayer().invoke();
            layers.put(dvTreeLayerDef, layer);
            DvTreeStoreyLayer dvTreeStoreyLayer = layer;
            if (dvTreeStoreyLayer instanceof DvTreeDsFoldersLayer) {
                this.foldersLayer = layer;
                continue;
            }
            if (!(dvTreeStoreyLayer instanceof DvTreeLayoutLayer)) continue;
            this.layoutLayer = layer;
        }
        this.allStoreyLayers = layers;
    }

    @Deprecated(message="Use DvTreeStructure(DvTreeContext, Set<DvTreeLayerDef>) instead", replaceWith=@ReplaceWith(expression="DvTreeStructure(context, layerDefs)", imports={}))
    public DvTreeStructure(@NotNull Project project, @NotNull DvMutableViewOptions options, @NotNull Set<? extends DvTreeLayerDef> layerDefs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(layerDefs, (String)"layerDefs");
        DvViewOptions dvViewOptions = options;
        Logger logger2 = Logger.getInstance((String)"another.DvTreeStructure");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this(new DvTreeContext(project, dvViewOptions, logger2), layerDefs);
    }

    public void setupLayers(@NotNull Set<? extends DvTreeLayerDef> selectedLayerDefs) {
        Intrinsics.checkNotNullParameter(selectedLayerDefs, (String)"selectedLayerDefs");
        this.selectedLayerDefs = selectedLayerDefs;
        ArrayList layers = new ArrayList(this.allStoreyLayers.size() + 1);
        ((Collection)layers).add(this.fundamentLayer);
        DvTreeAbstractLayer currentLayer = this.fundamentLayer;
        for (Map.Entry entry : ((Map)this.allStoreyLayers).entrySet()) {
            DvTreeLayerDef def = (DvTreeLayerDef)entry.getKey();
            DvTreeStoreyLayer layer = (DvTreeStoreyLayer)entry.getValue();
            if (!this.selectedLayerDefs.contains(def)) continue;
            layer.setup$intellij_database_core_impl(currentLayer);
            ((Collection)layers).add(layer);
            Intrinsics.checkNotNull((Object)layer);
            currentLayer = layer;
        }
        this.upperLayer = currentLayer;
        Collection $this$toTypedArray$iv = layers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.activeLayers = thisCollection$iv.toArray(new DvTreeAbstractLayer[0]);
    }

    @Nullable
    public final DvTreeLayer getLayoutLayer() {
        return this.layoutLayer;
    }

    public final void setLayoutLayer(@Nullable DvTreeLayer dvTreeLayer) {
        this.layoutLayer = dvTreeLayer;
    }

    @Nullable
    public final DvTreeLayer getFoldersLayer() {
        return this.foldersLayer;
    }

    public final void setFoldersLayer(@Nullable DvTreeLayer dvTreeLayer) {
        this.foldersLayer = dvTreeLayer;
    }

    @NotNull
    public final BasicNode getRootNode() {
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.getRoot();
    }

    @Nullable
    public final BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.parentOf(node);
    }

    @NotNull
    public final Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.childrenOf(node);
    }

    public final int countAllChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.countAllChildrenOf(node);
    }

    public final int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.countRealChildrenOf(node);
    }

    public final boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.isAlwaysLeaf(node);
    }

    @NotNull
    public final String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.presentableNameOf(node);
    }

    public final boolean isValid(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.upperLayer;
        if (dvTreeLayer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"upperLayer");
            dvTreeLayer = null;
        }
        return dvTreeLayer.isValid(node);
    }

    @NotNull
    public final BasicNode[] getPath(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getPathArray(node, 1);
    }

    private final BasicNode[] getPathArray(BasicNode node, int depth) {
        BasicNode p = this.parentOf(node);
        if (p == node) {
            throw new InternalError("The method DvTreeStructureService.parentOf() works incorrectly for node: " + node + " (node class: " + node.getClass().getSimpleName() + ")");
        }
        if (p == null) {
            BasicNode[] result = new BasicNode[depth];
            result[0] = node;
            return result;
        }
        BasicNode[] result = this.getPathArray(p, depth + 1);
        result[result.length - depth] = node;
        return result;
    }

    public final boolean hasDataSourcesThatSupportMultilevel() {
        return MapFun.containsKeys((Map)this.actualDbms, DvTreeStructure::hasDataSourcesThatSupportMultilevel$lambda$0);
    }

    public final void onFoldersChanged() {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onFoldersChanged$intellij_database_core_impl();
        }
    }

    public final void onViewOptionsChanged() {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onViewOptionsChanged$intellij_database_core_impl();
        }
    }

    private final void onDataSourceAdded(RawDataSource dataSource) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onDataSourceAdded$intellij_database_core_impl(dataSource);
        }
    }

    private final void onDataSourcePathChanged(RawDataSource dataSource) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onDataSourcePathChanged$intellij_database_core_impl(dataSource);
        }
    }

    private final void onDataSourceModelReplaced(RawDataSource dataSource, BasicModel oldModel, BasicModel newModel) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onDataSourceModelReplaced$intellij_database_core_impl(dataSource, oldModel, newModel);
        }
    }

    private final void onDataSourceChanged(RawDataSource dataSource) {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        DvTreeAbstractLayer[] $this$forEach$iv = dvTreeAbstractLayerArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            DvTreeAbstractLayer element$iv;
            DvTreeAbstractLayer it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            it.onDataSourceChanged$intellij_database_core_impl(dataSource);
        }
    }

    private final void onDataSourceRemoved(RawDataSource dataSource, Dbms dbms) {
        Object[] objectArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            objectArray = null;
        }
        Object[] $this$forEachReversed$iv = objectArray;
        boolean $i$f$forEachReversed = false;
        for (int i$iv = ArraysKt.getLastIndex((Object[])$this$forEachReversed$iv); -1 < i$iv; --i$iv) {
            Object it = $this$forEachReversed$iv[i$iv];
            boolean bl = false;
            ((DvTreeAbstractLayer)it).onDataSourceRemoved$intellij_database_core_impl(dataSource, dbms);
        }
    }

    public final void dataSourceAdded(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Dbms dbms = ds.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.dataSourceAdded(ds, dbms);
    }

    private final void dataSourceAdded(RawDataSource ds, Dbms dbms) {
        ((Map)this.dsDbms).put(ds, dbms);
        ((Map)this.actualDbms).put(dbms, true);
        this.onDataSourceAdded(ds);
    }

    public final void notifyDataSourcePathChanged(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.onDataSourcePathChanged(ds);
    }

    public final void dataSourceModelReplaced(@NotNull RawDataSource dataSource, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.onDataSourceModelReplaced(dataSource, oldModel, newModel);
    }

    public final void dataSourceChanged(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Dbms dbms = ds.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms newDbms = dbms;
        Dbms oldDbms = this.dsDbms.get(ds);
        if (oldDbms == null) {
            this.dataSourceAdded(ds, newDbms);
        } else if (!Intrinsics.areEqual((Object)oldDbms, (Object)newDbms)) {
            this.dataSourceRemoved(ds, oldDbms);
            this.dataSourceAdded(ds, newDbms);
        } else {
            this.onDataSourceChanged(ds);
        }
    }

    public final void dataSourceRemoved(@NotNull RawDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Dbms dbms = ds.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.dataSourceRemoved(ds, dbms);
    }

    private final void dataSourceRemoved(RawDataSource ds, Dbms dbms) {
        this.dsDbms.remove(ds);
        this.onDataSourceRemoved(ds, dbms);
        if (this.actualDbms.containsKey(dbms)) {
            this.recheckDbms(dbms);
        }
    }

    private final void recheckDbms(Dbms dbms) {
        boolean exists = this.dsDbms.containsValue(dbms);
        if (exists) {
            ((Map)this.actualDbms).put(dbms, true);
        } else {
            this.actualDbms.remove(dbms);
        }
    }

    public final void clearAll() {
        Object[] layersToCleanup;
        Collection<DvTreeStoreyLayer> collection = this.allStoreyLayers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<DvTreeStoreyLayer> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<DvTreeStoreyLayer> thisCollection$iv = $this$toTypedArray$iv;
        Object[] $this$forEachReversed$iv = layersToCleanup = thisCollection$iv.toArray(new DvTreeStoreyLayer[0]);
        boolean $i$f$forEachReversed = false;
        for (int i$iv = ArraysKt.getLastIndex((Object[])$this$forEachReversed$iv); -1 < i$iv; --i$iv) {
            Object it = $this$forEachReversed$iv[i$iv];
            boolean bl = false;
            ((DvTreeAbstractLayer)it).clearAll();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public final DvTreeAbstractLayer[] getActiveLayers() {
        DvTreeAbstractLayer[] dvTreeAbstractLayerArray = this.activeLayers;
        if (this.activeLayers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activeLayers");
            dvTreeAbstractLayerArray = null;
        }
        return (DvTreeAbstractLayer[])dvTreeAbstractLayerArray.clone();
    }

    @NotNull
    public final String dumpTheTree() {
        BasicNode root = this.getRootNode();
        String text2 = TreeFun.dumpTree((Object)root, (Function1)((Function1)new Function1<BasicNode, Sequence<? extends BasicNode>>((Object)this){

            public final Sequence<BasicNode> invoke(BasicNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((DvTreeStructure)this.receiver).childrenOf(p0);
            }
        }), (String)"    ", DvTreeStructure::dumpTheTree$lambda$0);
        return text2;
    }

    private static final boolean hasDataSourcesThatSupportMultilevel$lambda$0(Dbms d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return DBIntrospectorFeatures.supportsMultilevelIntrospection(d);
    }

    private static final String dumpTheTree$lambda$0(BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }
}

