/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.CloudDataSourceInfo;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceStorageScope;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseConnectivityConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSourceSerialization;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiLevelRoot;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.properties.Level;
import com.intellij.database.run.actions.TxIsolation;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LocalDataSource
extends AbstractDataSource
implements DatabaseConnectionConfig,
DatabaseConnectivityConfiguration,
Iconable {
    private static final Logger LOG = Logger.getInstance(LocalDataSource.class);
    static final int DEFAULT_AUTO_CLOSE_TIMEOUT_S = 300;
    static final int DEFAULT_KEEP_ALIVE_TIMEOUT_S = 60;
    public static final String MY_ELEMENT_FLAG = "LOCAL";
    static final String USER_KEY = "user";
    static final String STORAGE_KEY = "storage";
    public static final String PASSWORD_KEY = "password";
    public static final String FORCE_USE_DRIVER_ICON = "forceUseDriverIcon";
    private boolean myReadOnly;
    private boolean mySingleConnection;
    private boolean myCheckOutdated = true;
    private boolean myTrackNamespaces = true;
    @NotNull
    private DataSourceStorageScope myStorageScope = DataSourceStorageScope.DSSS_PROJECT;
    private final DataSourceInfo myInfo = new DataSourceInfo();
    @NotNull
    private volatile DasModel myModel = DasUtil.emptyModel();
    private final AtomicInteger myBatchCounter = new AtomicInteger();
    private final AtomicInteger myBatchChanges = new AtomicInteger();
    private String myDriverRef;
    private DatabaseDriver myDriver;
    private String myDriverClass;
    private String myUrl;
    private Couple<String> myFakeCurrentSchema;
    private String myObjectPattern;
    private boolean myUseJdbcIntrospector;
    @Nullable
    private Level myIntrospectionLevel = null;
    private DBIntrospectionOptions.SourceLoading mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
    private String myIntrospectorSessionId;
    private String myInitScript;
    private String myVmOptions;
    private final Map<String, String> myVmEnv = new LinkedHashMap<String, String>();
    private final Map<String, String> myDriverProperties = new LinkedHashMap<String, String>();
    private String myWorkingDir = "$ProjectFileDir$";
    private boolean myKeepAlive;
    private boolean myAutoClose;
    private String myTimeZone;
    private int myKeepAliveTimeout = 60;
    private int myAutoCloseTimeout = 300;
    private boolean myAutoSynchronize;
    private boolean myAutoCommit = true;
    private int myIsolation = TxIsolation.DEFAULT.getIsolation();
    private String myAuthProviderId = "user-pass";
    private boolean myConfiguredByUrl = false;
    @Nullable
    private SchemaControl mySchemaControl;
    private boolean myRewriteBounds = true;
    private DataSourceSshTunnelConfiguration mySshConfiguration;
    private DataSourceSslConfiguration mySslCfg;
    private final Map<String, String> myAdditionalProperties = new HashMap<String, String>();
    private boolean myImported = false;
    @Nullable
    private String myCodeStyleName;
    private final Map<String, String> myLayoutConfigurations = new LinkedHashMap<String, String>();
    @Nullable
    private Listener myStorageListener;
    protected boolean myTemporary;
    private final DataSourceSchemaMapping mySchemaMapping = new DataSourceSchemaMapping();
    private final List<BeforeTask> myBeforeTasks = new ArrayList<BeforeTask>(0);
    private final List<DataSourceSessionTemplate> mySessionTemplates = new ArrayList<DataSourceSessionTemplate>(0);
    private final Map<ObjectPath, String> myLinkedDataSourceIds = new HashMap<ObjectPath, String>(0);
    @Nullable
    private CloudDataSourceInfo myCloudInfo;
    private final BasicModelListener myModelListener = (created, modified, removed) -> {
        if (this.isInBatch()) {
            this.myBatchChanges.incrementAndGet();
        }
        this.modelChanged();
    };

    public LocalDataSource() {
    }

    @Nullable
    public DataSourceSessionTemplate getIntrospectorSessionTemplate() {
        return this.myIntrospectorSessionId == null ? null : (DataSourceSessionTemplate)ContainerUtil.find(this.mySessionTemplates, t -> t.getTemplateId().equals(this.myIntrospectorSessionId));
    }

    @Nullable
    public String getIntrospectorSessionId() {
        return this.myIntrospectorSessionId;
    }

    public void setIntrospectorSessionId(@Nullable String introspectorSessionId) {
        this.myIntrospectorSessionId = introspectorSessionId;
    }

    @NotNull
    public static LocalDataSource temporary() {
        LocalDataSource res = new LocalDataSource();
        res.myTemporary = true;
        LocalDataSource localDataSource = res;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(0);
        }
        return localDataSource;
    }

    public LocalDataSource(boolean imported) {
        this.myImported = imported;
    }

    @TestOnly
    @NotNull
    public static LocalDataSource create(String name, String driver, String url, String userName) {
        LocalDataSource ds = new LocalDataSource();
        ds.setName(name);
        ds.setDriverClass(driver);
        ds.setUrl(url);
        ds.setUsername(userName);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(1);
        }
        return localDataSource;
    }

    @NotNull
    public static LocalDataSource fromDriver(@NotNull DatabaseDriver driver, @NotNull String url, boolean temporary) {
        if (driver == null) {
            LocalDataSource.$$$reportNull$$$0(2);
        }
        if (url == null) {
            LocalDataSource.$$$reportNull$$$0(3);
        }
        LocalDataSource ds = new LocalDataSource();
        ds.myTemporary = temporary;
        ds.setUrlSmart(url);
        ds.setDatabaseDriver(driver);
        ds.setPasswordStorage(Storage.PERSIST);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(4);
        }
        return localDataSource;
    }

    @Override
    @Nullable
    public DatabaseConnectivityConfiguration getParentConfiguration() {
        return this.myDriver;
    }

    public boolean isTemporary() {
        return this.myTemporary;
    }

    @Override
    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public boolean shouldCheckOutdated() {
        return this.myCheckOutdated;
    }

    public void setCheckOutdated(boolean checkOutdated) {
        this.myCheckOutdated = checkOutdated;
    }

    public boolean shouldTrackNamespaces() {
        return this.myTrackNamespaces;
    }

    public void setTrackNamespaces(boolean trackNamespaces) {
        this.myTrackNamespaces = trackNamespaces;
    }

    public boolean isSingleConnection() {
        return this.mySingleConnection;
    }

    public void setSingleConnection(boolean singleConnection) {
        this.mySingleConnection = singleConnection;
    }

    @NotNull
    public Map<ObjectPath, String> getLinkedDataSourceIds() {
        Map<ObjectPath, String> map = this.myLinkedDataSourceIds;
        if (map == null) {
            LocalDataSource.$$$reportNull$$$0(5);
        }
        return map;
    }

    public void setLinkedDataSourceIds(Map<ObjectPath, String> linkedDataSourceIds) {
        this.myLinkedDataSourceIds.clear();
        this.myLinkedDataSourceIds.putAll(linkedDataSourceIds);
    }

    @Override
    @NotNull
    public DataSourceStorageScope getStorageScope() {
        DataSourceStorageScope dataSourceStorageScope = this.myStorageScope;
        if (dataSourceStorageScope == null) {
            LocalDataSource.$$$reportNull$$$0(6);
        }
        return dataSourceStorageScope;
    }

    public void setStorageScope(@NotNull DataSourceStorageScope storageScope) {
        if (storageScope == null) {
            LocalDataSource.$$$reportNull$$$0(7);
        }
        this.myStorageScope = storageScope;
    }

    @Deprecated(since="2026.1", forRemoval=true)
    public void setGlobal(boolean global) {
        DataSourceStorageScope theTenancy = global ? DataSourceStorageScope.DSSS_APPLICATION : DataSourceStorageScope.DSSS_PROJECT;
        this.setStorageScope(theTenancy);
    }

    public boolean isRewriteBounds() {
        return this.myRewriteBounds;
    }

    public void setRewriteBounds(boolean rewriteBounds) {
        this.myRewriteBounds = rewriteBounds;
    }

    public void setSchemaControl(@Nullable SchemaControl schemaControl) {
        this.mySchemaControl = schemaControl;
    }

    @Override
    @NotNull
    public SchemaControl getSchemaControl() {
        SchemaControl schemaControl = this.mySchemaControl != null ? this.mySchemaControl : DatabaseDriver.OPTION_SCHEMA_CONTROL.get(this.myDriver);
        if (schemaControl == null) {
            LocalDataSource.$$$reportNull$$$0(8);
        }
        return schemaControl;
    }

    @Nullable
    SchemaControl getSchemaControlOrtNull() {
        return this.mySchemaControl;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.getInfo().getDbms();
        if (dbms == null) {
            LocalDataSource.$$$reportNull$$$0(9);
        }
        return dbms;
    }

    @NotNull
    public Version getVersion() {
        Version version = this.getInfo().getExactVersion();
        if (version == null) {
            LocalDataSource.$$$reportNull$$$0(10);
        }
        return version;
    }

    @NotNull
    public Version getExactDriverVersion() {
        Version version = this.getInfo().getExactDriverVersion();
        if (version == null) {
            LocalDataSource.$$$reportNull$$$0(11);
        }
        return version;
    }

    @Override
    @Nullable
    public DatabaseDriver getDatabaseDriver() {
        return this.myDriver;
    }

    public void setDatabaseDriver(@Nullable DatabaseDriver databaseDriver) {
        if (this.myDriver == databaseDriver) {
            return;
        }
        this.myDriver = databaseDriver;
        this.myDriverClass = this.myDriver == null ? null : this.myDriver.getDriverClass();
    }

    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    @NotNull
    public Storage getPasswordStorage() {
        return LocalDataSource.getPasswordStorage(this);
    }

    public void setPasswordStorage(@NotNull Storage passwordStorage) {
        if (passwordStorage == null) {
            LocalDataSource.$$$reportNull$$$0(12);
        }
        LocalDataSource.setPasswordStorage(this, passwordStorage);
    }

    @NotNull
    public String getUsername() {
        return LocalDataSource.getUsername(this);
    }

    public void setUsername(String username) {
        LocalDataSource.setUsername(this, username);
    }

    public void setAutoSynchronize(boolean autoSynchronize) {
        this.myAutoSynchronize = autoSynchronize;
    }

    public boolean isAutoSynchronize() {
        return this.myAutoSynchronize;
    }

    @Override
    public boolean isAutoCommit() {
        return this.myAutoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.myAutoCommit = autoCommit;
    }

    public void setTxIsolation(int isolation) {
        this.myIsolation = isolation;
    }

    @Override
    public int getTxIsolation() {
        return this.myIsolation;
    }

    @NotNull
    public final Icon getIcon() {
        return this.getIcon(0);
    }

    @NotNull
    public final Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.getBaseIcon();
        int theFlags = this.isReadOnly() ? 2048 : 0;
        RowIcon rowIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, icon, theFlags);
        if (rowIcon == null) {
            LocalDataSource.$$$reportNull$$$0(13);
        }
        return rowIcon;
    }

    public Icon getBaseIcon() {
        if (this.myDriver != null && ("true".equals(this.getAdditionalProperty(FORCE_USE_DRIVER_ICON)) || "true".equals(this.myDriver.getAdditionalProperty(FORCE_USE_DRIVER_ICON)))) {
            return this.myDriver.getIcon(0);
        }
        Dbms dbms = this.getDbms();
        if (dbms != Dbms.UNKNOWN) {
            return dbms.getIcon();
        }
        if (this.myDriver != null) {
            return this.myDriver.getIcon(0);
        }
        return Dbms.UNKNOWN.getIcon();
    }

    public void resolveDriver() {
        if (this.myDriver != null) {
            return;
        }
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        DatabaseDriver driver = null;
        if (this.myDriverRef != null && (driver = DatabaseDriverManager.getInstance().getDriver(this.myDriverRef)) == null) {
            LOG.warn(LocalDataSource.logMessage(this, "failed to find driver with id \"" + this.myDriverRef + "\""));
        }
        if (driver == null) {
            driver = DbImplUtilCore.guessDatabaseDriver(this);
            if (driver == null) {
                LOG.warn(LocalDataSource.logMessage(this, "failed to guess driver"));
            } else {
                LOG.debug(LocalDataSource.logMessage(this, "using driver \"" + driver.getName() + "\" (" + driver.getId() + ")"));
            }
        }
        this.setDatabaseDriver(driver);
    }

    public void ensureDriverConfigured() {
        if (StringUtil.isEmpty((String)this.myDriverClass)) {
            return;
        }
        if (this.myDriver != null && this.acceptsDriver(this.myDriver)) {
            return;
        }
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        if (this.myDriver != null) {
            for (DatabaseDriver databaseDriver : driverManager.getDrivers()) {
                if (!this.acceptsDriver(databaseDriver)) continue;
                this.myDriver = databaseDriver;
                return;
            }
            this.myDriver = this.myDriver.copy(this.getName() + " driver", false);
        } else {
            this.myDriver = driverManager.createDriver(this.myDriverClass, this.myDriverClass, null);
        }
        driverManager.updateDriver(this.myDriver);
    }

    private boolean acceptsDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            LocalDataSource.$$$reportNull$$$0(14);
        }
        return Objects.equals(this.myDriverClass, driver.getDriverClass());
    }

    public void setIntrospectionScope(@NotNull TreePattern scope) {
        if (scope == null) {
            LocalDataSource.$$$reportNull$$$0(15);
        }
        this.getSchemaMapping().setIntrospectionScope(scope);
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)this.getModel(), BasicModModel.class);
        if (model != null) {
            DataSourceSnapshotManager.getInstance().clearOrReviveNamespacesLater(model, scope);
        }
    }

    public void setSchemaMapping(@NotNull DataSourceSchemaMapping mapping) {
        if (mapping == null) {
            LocalDataSource.$$$reportNull$$$0(16);
        }
        this.mySchemaMapping.assign(mapping);
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)this.getModel(), BasicModModel.class);
        if (model != null) {
            DataSourceSnapshotManager.getInstance().clearOrReviveNamespacesLater(model, this.getIntrospectionScope());
        }
    }

    @Nullable
    public Couple<String> getFakeCurrentSchema() {
        return this.myFakeCurrentSchema;
    }

    public void setFakeCurrentSchema(@Nullable Couple<String> fakeCurrentSchema) {
        this.myFakeCurrentSchema = fakeCurrentSchema != null && fakeCurrentSchema.first == null && fakeCurrentSchema.second == null ? null : fakeCurrentSchema;
    }

    @Override
    @NotNull
    public Properties getConnectionProperties() {
        Properties connectionProperties = new Properties();
        if (this.myDriver != null) {
            LocalDataSource.putProperties(connectionProperties, this.myDriver.getDriverProperties());
        }
        LocalDataSource.putProperties(connectionProperties, this.myDriverProperties);
        Properties properties = connectionProperties;
        if (properties == null) {
            LocalDataSource.$$$reportNull$$$0(17);
        }
        return properties;
    }

    private static void putProperties(Properties result, Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getValue() != null) {
                result.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            result.remove(entry.getKey());
        }
    }

    public String getSourceName() {
        return MY_ELEMENT_FLAG;
    }

    public String getDriverClass() {
        if (this.myDriver != null) {
            return this.myDriver.getDriverClass();
        }
        return this.myDriverClass;
    }

    public void setDriverClass(String driver) {
        this.myDriverClass = driver;
    }

    public void setUrl(String url) {
        this.myUrl = url;
    }

    public void setUrlSmart(String url) {
        this.setUrl(url);
        this.setConfiguredByUrl(this.checkUrlOnly());
    }

    private boolean checkUrlOnly() {
        if (this.myUrl == null || this.myDriver == null) {
            return false;
        }
        StatelessJdbcUrlParser parser = JdbcUrlParserUtil.select(this.myDriver.getJDBCUrlParsers(), this.myUrl);
        if (parser == null) {
            return !StringUtil.isEmptyOrSpaces((String)this.myUrl);
        }
        JdbcUrlParser sparser = parser.createStateful();
        sparser.setUrlText(this.myUrl);
        return !sparser.isValid() || !StringUtil.isEmpty((String)sparser.getParameter(USER_KEY)) || !StringUtil.isEmpty((String)sparser.getParameter(PASSWORD_KEY));
    }

    public String getDriverRef() {
        return this.myDriverRef;
    }

    void setDriverRef(String driverRef) {
        this.myDriverRef = driverRef;
    }

    public String getDefaultDialect() {
        if (this.myDriver != null) {
            return this.myDriver.getSqlDialect();
        }
        return null;
    }

    @NotNull
    public List<BeforeTask> getBeforeTasks() {
        List<BeforeTask> list = this.myBeforeTasks;
        if (list == null) {
            LocalDataSource.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public List<DataSourceSessionTemplate> getSessionTemplates() {
        List<DataSourceSessionTemplate> list = this.mySessionTemplates;
        if (list == null) {
            LocalDataSource.$$$reportNull$$$0(19);
        }
        return list;
    }

    public void setSessionTemplates(@NotNull List<DataSourceSessionTemplate> templates) {
        if (templates == null) {
            LocalDataSource.$$$reportNull$$$0(20);
        }
        this.mySessionTemplates.clear();
        this.mySessionTemplates.addAll(templates);
    }

    @Override
    @Nullable
    public String getInitScript() {
        return this.myInitScript;
    }

    @Override
    public void setInitScript(@Nullable String initScript) {
        this.myInitScript = initScript;
    }

    public boolean isKeepAlive() {
        return this.myKeepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.myKeepAlive = keepAlive;
    }

    public void setTimeZone(@Nullable String timeZone) {
        this.myTimeZone = timeZone;
    }

    @Nullable
    public String getTimeZone() {
        return this.myTimeZone;
    }

    public boolean isAutoClose() {
        return this.myAutoClose;
    }

    public void setAutoClose(boolean autoClose) {
        this.myAutoClose = autoClose;
    }

    public int getKeepAliveTimeout() {
        return this.myKeepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.myKeepAliveTimeout = keepAliveTimeout;
    }

    public int getAutoCloseTimeout() {
        return this.myAutoCloseTimeout;
    }

    public void setAutoCloseTimeout(int autoCloseTimeout) {
        this.myAutoCloseTimeout = autoCloseTimeout;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    @Nullable
    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public void setWorkingDir(@Nullable String workingDir) {
        this.myWorkingDir = workingDir;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @NotNull
    public Map<String, String> getDriverProperties() {
        Map<String, String> map = this.myDriverProperties;
        if (map == null) {
            LocalDataSource.$$$reportNull$$$0(21);
        }
        return map;
    }

    public String getObjectPattern() {
        return this.myObjectPattern;
    }

    public boolean useJdbcIntrospector() {
        return this.myUseJdbcIntrospector;
    }

    public void setUseJdbcIntrospector(boolean useJdbcIntrospector) {
        this.myUseJdbcIntrospector = useJdbcIntrospector;
    }

    @Nullable
    public Level getIntrospectionLevel() {
        return this.myIntrospectionLevel;
    }

    public void setIntrospectionLevel(@Nullable Level introspectionLevel) {
        this.myIntrospectionLevel = introspectionLevel;
        if (this.myModel instanceof BasicModModel) {
            LocalDataSource.setIntrospectionLevelInModelSafely((BasicModModel)this.myModel, introspectionLevel);
        }
    }

    private static void setIntrospectionLevelInModelSafely(@NotNull BasicModModel mm, @Nullable Level introspectionLevel) {
        Application application;
        if (mm == null) {
            LocalDataSource.$$$reportNull$$$0(22);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            application.executeOnPooledThread(() -> LocalDataSource.setIntrospectionLevelInModel(mm, introspectionLevel));
        } else {
            LocalDataSource.setIntrospectionLevelInModel(mm, introspectionLevel);
        }
    }

    private static void setIntrospectionLevelInModel(@NotNull BasicModModel mm, @Nullable Level introspectionLevel) {
        if (mm == null) {
            LocalDataSource.$$$reportNull$$$0(23);
        }
        mm.modify(BasicModRoot.class, root -> {
            if (root instanceof BasicModMultiLevelRoot) {
                BasicModMultiLevelRoot r = (BasicModMultiLevelRoot)root;
                r.setExplicitIntrospectionLevel(introspectionLevel);
            }
        });
    }

    @NotNull
    public DBIntrospectionOptions.SourceLoading getSourceLoading() {
        DBIntrospectionOptions.SourceLoading sourceLoading = this.mySourceLoading != null ? this.mySourceLoading : DatabaseDriver.OPTION_SOURCE_LOADING.get(this.myDriver);
        if (sourceLoading == null) {
            LocalDataSource.$$$reportNull$$$0(24);
        }
        return sourceLoading;
    }

    @Nullable
    DBIntrospectionOptions.SourceLoading getSourceLoadingOrNull() {
        return this.mySourceLoading;
    }

    public void setSourceLoading(@Nullable DBIntrospectionOptions.SourceLoading sourceLoading) {
        this.mySourceLoading = sourceLoading;
    }

    public void setObjectPattern(String objectPattern) {
        this.myObjectPattern = objectPattern;
    }

    @Nullable
    public DataSourceSshTunnelConfiguration getSshConfiguration() {
        return this.mySshConfiguration;
    }

    public void setSshConfiguration(DataSourceSshTunnelConfiguration configuration) {
        this.mySshConfiguration = configuration;
    }

    @Nullable
    public DataSourceSslConfiguration getSslCfg() {
        return this.mySslCfg;
    }

    public void setSslCfg(DataSourceSslConfiguration sslCfg) {
        this.mySslCfg = sslCfg;
    }

    @Override
    @NotNull
    public String getAuthProviderId() {
        String string = this.myAuthProviderId;
        if (string == null) {
            LocalDataSource.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Override
    public void setAuthProviderId(@NotNull String authProviderId) {
        if (authProviderId == null) {
            LocalDataSource.$$$reportNull$$$0(26);
        }
        this.myAuthProviderId = authProviderId;
    }

    @NotNull
    public LocalDataSource copy(boolean temporary) {
        LocalDataSource clone = LocalDataSourceSerialization.INSTANCE.copyBySettings(null, this, temporary);
        this.copyExtraParametersTo(clone);
        clone.setDatabaseDriver(this.getDatabaseDriver());
        LocalDataSource localDataSource = clone;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(27);
        }
        return localDataSource;
    }

    private void copyExtraParametersTo(@NotNull LocalDataSource ds) {
        if (ds == null) {
            LocalDataSource.$$$reportNull$$$0(28);
        }
        ds.setStorageScope(this.getStorageScope());
        ds.setDatabaseDriver(this.getDatabaseDriver());
        ds.setIntrospectionScope(this.getIntrospectionScope());
        ds.setPasswordStorage(ds.getPasswordStorage());
        ds.setUsername(this.getUsername());
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return this;
    }

    public boolean equalConfiguration(@NotNull LocalDataSource o) {
        boolean hasSsl2;
        boolean hasSsh2;
        if (o == null) {
            LocalDataSource.$$$reportNull$$$0(29);
        }
        if (this.isConfiguredByUrl() != o.isConfiguredByUrl()) {
            return false;
        }
        if (this.isImported() != o.isImported()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (this.getPasswordStorage() != o.getPasswordStorage()) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), o.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getIntrospectorSessionId(), o.getIntrospectorSessionId())) {
            return false;
        }
        if (this.getSchemaControl() != o.getSchemaControl()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getUrl()), (CharSequence)StringUtil.nullize((String)o.getUrl()))) {
            return false;
        }
        if (this.isAutoSynchronize() != o.isAutoSynchronize()) {
            return false;
        }
        if (this.isReadOnly() != o.isReadOnly()) {
            return false;
        }
        if (this.shouldCheckOutdated() != o.shouldCheckOutdated()) {
            return false;
        }
        if (this.shouldTrackNamespaces() != o.shouldTrackNamespaces()) {
            return false;
        }
        if (this.isAutoCommit() != o.isAutoCommit()) {
            return false;
        }
        if (this.getTxIsolation() != o.getTxIsolation()) {
            return false;
        }
        if (this.getStorageScope() != o.getStorageScope()) {
            return false;
        }
        if (!LocalDataSource.driversEqual(this.getDatabaseDriver(), o.getDatabaseDriver())) {
            return false;
        }
        if (!Objects.equals(this.getAuthProviderId(), o.getAuthProviderId())) {
            return false;
        }
        if (!this.myDriverProperties.equals(o.myDriverProperties)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getDriverClass(), (CharSequence)o.getDriverClass())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getSchemaMapping(), (Object)o.getSchemaMapping())) {
            return false;
        }
        if (!Comparing.equal(this.getFakeCurrentSchema(), o.getFakeCurrentSchema())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getObjectPattern(), (CharSequence)o.getObjectPattern())) {
            return false;
        }
        if (this.myUseJdbcIntrospector != o.useJdbcIntrospector()) {
            return false;
        }
        if (this.myIntrospectionLevel != o.getIntrospectionLevel()) {
            return false;
        }
        if (this.mySourceLoading != o.getSourceLoading()) {
            return false;
        }
        if (this.myRewriteBounds != o.isRewriteBounds()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myVmOptions), (CharSequence)StringUtil.nullize((String)o.myVmOptions))) {
            return false;
        }
        if (!LocalDataSource.equals(this.myVmEnv, o.myVmEnv)) {
            return false;
        }
        if (!LocalDataSource.equals(this.myAdditionalProperties, o.myAdditionalProperties)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myInitScript), (CharSequence)StringUtil.nullize((String)o.myInitScript))) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myCodeStyleName, (String)"Default"), (CharSequence)StringUtil.nullize((String)o.myCodeStyleName, (String)"Default"))) {
            return false;
        }
        if (!this.myLayoutConfigurations.equals(o.myLayoutConfigurations)) {
            return false;
        }
        if (this.isSingleConnection() != o.isSingleConnection()) {
            return false;
        }
        if (this.isKeepAlive() != o.isKeepAlive()) {
            return false;
        }
        if (this.isAutoClose() != o.isAutoClose()) {
            return false;
        }
        if (this.getKeepAliveTimeout() != o.getKeepAliveTimeout()) {
            return false;
        }
        if (this.getAutoCloseTimeout() != o.getAutoCloseTimeout()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getTimeZone(), (CharSequence)o.getTimeZone())) {
            return false;
        }
        if (!this.getBeforeTasks().equals(o.getBeforeTasks())) {
            return false;
        }
        if (!DbImplUtilCore.equals(this.getSessionTemplates(), o.getSessionTemplates(), DataSourceSessionTemplate::equalConfiguration)) {
            return false;
        }
        if (!this.getLinkedDataSourceIds().equals(o.getLinkedDataSourceIds())) {
            return false;
        }
        boolean hasSsh1 = this.mySshConfiguration != null && !this.mySshConfiguration.isEmpty();
        boolean bl = hasSsh2 = o.mySshConfiguration != null && !o.mySshConfiguration.isEmpty();
        if (hasSsh1 != hasSsh2) {
            return false;
        }
        if (hasSsh1 && !this.mySshConfiguration.equalConfiguration(o.mySshConfiguration)) {
            return false;
        }
        boolean hasSsl1 = this.mySslCfg != null && !this.mySslCfg.isEmpty();
        boolean bl2 = hasSsl2 = o.mySslCfg != null && !o.mySslCfg.isEmpty();
        if (hasSsl1 != hasSsl2) {
            return false;
        }
        return !hasSsl1 || this.mySslCfg.equalConfiguration(o.mySslCfg);
    }

    private static boolean driversEqual(@Nullable DatabaseDriver a, @Nullable DatabaseDriver b) {
        if (a == null || b == null) {
            return a == b;
        }
        return Objects.equals(a.getId(), b.getId());
    }

    private static <K, V> boolean equals(@NotNull Map<K, V> m1, @NotNull Map<K, V> m2) {
        if (m1 == null) {
            LocalDataSource.$$$reportNull$$$0(30);
        }
        if (m2 == null) {
            LocalDataSource.$$$reportNull$$$0(31);
        }
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            if (Comparing.equal(entry.getValue(), m2.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<K, V> entry : m2.entrySet()) {
            if (Comparing.equal(entry.getValue(), m1.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public void setAdditionalProperties(@NotNull Map<String, String> additionalProperties) {
        if (additionalProperties == null) {
            LocalDataSource.$$$reportNull$$$0(32);
        }
        this.myAdditionalProperties.clear();
        this.myAdditionalProperties.putAll(additionalProperties);
    }

    @Override
    @NotNull
    public Set<String> getAdditionalPropertiesNames() {
        Set<String> set = this.myAdditionalProperties.keySet();
        if (set == null) {
            LocalDataSource.$$$reportNull$$$0(33);
        }
        return set;
    }

    @Override
    @Nullable
    public String getAdditionalProperty(@NotNull String name) {
        if (name == null) {
            LocalDataSource.$$$reportNull$$$0(34);
        }
        return this.myAdditionalProperties.get(name);
    }

    @Override
    public void setAdditionalProperty(@NotNull String name, @Nullable String value) {
        if (name == null) {
            LocalDataSource.$$$reportNull$$$0(35);
        }
        DbImplUtilCore.putOrRemove(this.myAdditionalProperties, name, value);
    }

    public boolean isImported() {
        return this.myImported;
    }

    void setImported(boolean imported) {
        this.myImported = imported;
    }

    public boolean isConfiguredByUrl() {
        return this.myConfiguredByUrl;
    }

    public void setConfiguredByUrl(boolean configuredByUrl) {
        this.myConfiguredByUrl = configuredByUrl;
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map = this.myVmEnv;
        if (map == null) {
            LocalDataSource.$$$reportNull$$$0(36);
        }
        return map;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            LocalDataSource.$$$reportNull$$$0(37);
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    @Override
    @NotNull
    public String toString() {
        Object str = super.toString();
        String dialect = this.getDefaultDialect();
        Object object = str = (String)str + (String)(dialect != null && !dialect.isEmpty() ? " (" + dialect + ")" : " (unknown dialect)");
        if (object == null) {
            LocalDataSource.$$$reportNull$$$0(38);
        }
        return object;
    }

    @Override
    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myModel;
        if (dasModel == null) {
            LocalDataSource.$$$reportNull$$$0(39);
        }
        return dasModel;
    }

    public void setModel(@NotNull DasModel newModel) {
        BasicModel newBasicModel;
        BasicModel oldBasicModel;
        DasModel oldModel;
        if (newModel == null) {
            LocalDataSource.$$$reportNull$$$0(40);
        }
        if ((oldModel = this.myModel) == newModel) {
            return;
        }
        BasicModel basicModel = oldBasicModel = oldModel instanceof BasicModel ? (BasicModel)oldModel : null;
        if (oldBasicModel != null) {
            ((BasicModModel)oldBasicModel).removeListener(this.myModelListener);
            ((BasicModModel)oldBasicModel).shelve(false);
        }
        this.myModel = newModel;
        this.incModificationCount();
        BasicModel basicModel2 = newBasicModel = newModel instanceof BasicModel ? (BasicModel)newModel : null;
        if (newBasicModel instanceof BasicModModel) {
            ((BasicModModel)newBasicModel).addListener(this.myModelListener);
        }
        this.notifyModelReplaced(oldBasicModel, newBasicModel);
        this.modelChanged();
    }

    private void modelChanged() {
        Listener listener = this.myStorageListener;
        if (listener != null) {
            try {
                listener.dataSourceModelUpdated(this);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    void addStorageListener(@NotNull Listener listener) {
        if (listener == null) {
            LocalDataSource.$$$reportNull$$$0(41);
        }
        if (this.myStorageListener != null) {
            throw new AssertionError((Object)"Already has a storage listener");
        }
        this.myStorageListener = listener;
    }

    void removeStorageListener(@NotNull Listener listener) {
        if (listener == null) {
            LocalDataSource.$$$reportNull$$$0(42);
        }
        if (this.myStorageListener != listener) {
            throw new AssertionError((Object)"Attempt to remove wrong listener");
        }
        this.myStorageListener = null;
    }

    public void clearModel() {
        LOG.info(LocalDataSource.logMessage(this, "clearModel"));
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)this.myModel, BasicModModel.class);
        if (model != null) {
            this.clearIntrospectionCache(model);
            DbImplUtilCore.performSrcOperation(null, model, ModalityState.defaultModalityState(), false, model::clearModel);
        } else {
            this.setModel(DasUtil.emptyModel());
        }
    }

    public void clearIntrospectionCache() {
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)this.myModel, BasicModModel.class);
        if (model != null) {
            this.clearIntrospectionCache(model);
        }
    }

    private void clearIntrospectionCache(@NotNull BasicModModel model) {
        if (model == null) {
            LocalDataSource.$$$reportNull$$$0(43);
        }
        ModelHelper helper = DbImplUtilCore.getModelHelper(this.getDbms());
        helper.invalidateIntrospectionCache(model);
    }

    public void performBatch(Runnable runnable) {
        this.myBatchCounter.incrementAndGet();
        try {
            runnable.run();
        }
        finally {
            if (this.myBatchCounter.decrementAndGet() == 0 && this.myBatchChanges.getAndSet(0) != 0) {
                this.modelChanged();
            }
        }
    }

    public boolean isInBatch() {
        return this.myBatchCounter.get() != 0;
    }

    @Override
    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(44);
        }
        return localDataSource;
    }

    @Override
    @NotNull
    public DatabaseConnectionConfig getMutableConfig() {
        LocalDataSource localDataSource = this;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(45);
        }
        return localDataSource;
    }

    @NotNull
    public NameVersion getDatabaseVersion() {
        NameVersion nameVersion = this.getInfo().getDatabaseVersion();
        if (nameVersion == null) {
            LocalDataSource.$$$reportNull$$$0(46);
        }
        return nameVersion;
    }

    @NotNull
    public NameVersion getDriverVersion() {
        NameVersion nameVersion = this.getInfo().getDriverVersion();
        if (nameVersion == null) {
            LocalDataSource.$$$reportNull$$$0(47);
        }
        return nameVersion;
    }

    public String getJDBCVersion() {
        return this.getInfo().getJdbcVersion();
    }

    public Casing getCaseModes() {
        return this.getInfo().getCasing();
    }

    public DataSourceInfo getInfo() {
        DataSourceInfo.initDbmsFromJdbcIfNeeded(this, this.myInfo);
        return this.myInfo;
    }

    @NlsSafe
    @Nullable
    public String getCodeStyleName() {
        return this.myCodeStyleName;
    }

    public void setCodeStyleName(@Nullable String codeStyleName) {
        this.myCodeStyleName = codeStyleName;
    }

    @Nullable
    @NlsSafe
    public String getLayoutConfigurationFor(@NotNull String key) {
        if (key == null) {
            LocalDataSource.$$$reportNull$$$0(48);
        }
        return this.myLayoutConfigurations.get(key);
    }

    public void setLayoutConfigurationFor(@NotNull String key, @Nullable String layoutConfiguration) {
        if (key == null) {
            LocalDataSource.$$$reportNull$$$0(49);
        }
        this.myLayoutConfigurations.put(key, Strings.nullize((String)layoutConfiguration, (boolean)true));
    }

    @NotNull
    public Map<String, String> getLayoutConfigurations() {
        Map<String, String> map = this.myLayoutConfigurations;
        if (map == null) {
            LocalDataSource.$$$reportNull$$$0(50);
        }
        return map;
    }

    public void setLayoutConfigurations(@Nullable Map<String, String> layoutConfigurations) {
        this.myLayoutConfigurations.clear();
        if (layoutConfigurations != null) {
            this.myLayoutConfigurations.putAll(layoutConfigurations);
        }
    }

    @NotNull
    public DataSourceSchemaMapping getSchemaMapping() {
        DataSourceSchemaMapping dataSourceSchemaMapping = this.mySchemaMapping;
        if (dataSourceSchemaMapping == null) {
            LocalDataSource.$$$reportNull$$$0(51);
        }
        return dataSourceSchemaMapping;
    }

    @NotNull
    public TreePattern getIntrospectionScope() {
        TreePattern treePattern = this.getSchemaMapping().getIntrospectionScope();
        if (treePattern == null) {
            LocalDataSource.$$$reportNull$$$0(52);
        }
        return treePattern;
    }

    @NotNull
    private static String logMessage(@NotNull LocalDataSource ds, @NotNull String message) {
        if (ds == null) {
            LocalDataSource.$$$reportNull$$$0(53);
        }
        if (message == null) {
            LocalDataSource.$$$reportNull$$$0(54);
        }
        String string = "Data source \"" + ds.getName() + "\" {" + ds.getUniqueId() + "}: " + message;
        if (string == null) {
            LocalDataSource.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NotNull
    public static Storage getPasswordStorage(@NotNull DatabaseConnectionPoint point) {
        if (point == null) {
            LocalDataSource.$$$reportNull$$$0(56);
        }
        Storage storage = Storage.deserialize(point.getAdditionalProperty(STORAGE_KEY));
        if (storage == null) {
            LocalDataSource.$$$reportNull$$$0(57);
        }
        return storage;
    }

    public static void setPasswordStorage(@NotNull DatabaseConnectionConfig config, @NotNull Storage passwordStorage) {
        if (config == null) {
            LocalDataSource.$$$reportNull$$$0(58);
        }
        if (passwordStorage == null) {
            LocalDataSource.$$$reportNull$$$0(59);
        }
        config.setAdditionalProperty(STORAGE_KEY, passwordStorage.serialize());
    }

    @NotNull
    public static String getUsername(@NotNull DatabaseConnectionPoint point) {
        if (point == null) {
            LocalDataSource.$$$reportNull$$$0(60);
        }
        String string = StringUtil.notNullize((String)point.getAdditionalProperty(USER_KEY));
        if (string == null) {
            LocalDataSource.$$$reportNull$$$0(61);
        }
        return string;
    }

    public static void setUsername(@NotNull DatabaseConnectionConfig config, String username) {
        if (config == null) {
            LocalDataSource.$$$reportNull$$$0(62);
        }
        config.setAdditionalProperty(USER_KEY, StringUtil.nullize((String)username));
    }

    @NotNull
    public static Map<String, String> getAdditionalPropertiesMap(@NotNull LocalDataSource ds) {
        if (ds == null) {
            LocalDataSource.$$$reportNull$$$0(63);
        }
        Map<String, String> map = ds.myAdditionalProperties;
        if (map == null) {
            LocalDataSource.$$$reportNull$$$0(64);
        }
        return map;
    }

    static DataSourceInfo getInfoInner(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            LocalDataSource.$$$reportNull$$$0(65);
        }
        return dataSource.myInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 7, 12, 14, 15, 16, 20, 22, 23, 26, 28, 29, 30, 31, 32, 34, 35, 37, 40, 41, 42, 43, 48, 49, 53, 54, 56, 58, 59, 60, 62, 63, 65 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LocalDataSource";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageScope";
                break;
            }
            case 12: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passwordStorage";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mm";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authProviderId";
                break;
            }
            case 28: 
            case 53: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m1";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m2";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalProperties";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmEnv";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModel";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "temporary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 49: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDriver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedDataSourceIds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaControl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactDriverVersion";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionProperties";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeTasks";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionTemplates";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverProperties";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceLoading";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthProviderId";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPropertiesNames";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmEnv";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutableConfig";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseVersion";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverVersion";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutConfigurations";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaMapping";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrospectionScope";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "logMessage";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getPasswordStorage";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsername";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPropertiesMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromDriver";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setStorageScope";
                break;
            }
            case 12: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "setPasswordStorage";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDriver";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSchemaMapping";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setSessionTemplates";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionLevelInModelSafely";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionLevelInModel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setAuthProviderId";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "copyExtraParametersTo";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalProperties";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProperty";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalProperty";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addStorageListener";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeStorageListener";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "clearIntrospectionCache";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLayoutConfigurationFor";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setLayoutConfigurationFor";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "logMessage";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getPasswordStorage";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getUsername";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setUsername";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPropertiesMap";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getInfoInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 7, 12, 14, 15, 16, 20, 22, 23, 26, 28, 29, 30, 31, 32, 34, 35, 37, 40, 41, 42, 43, 48, 49, 53, 54, 56, 58, 59, 60, 62, 63, 65 -> new IllegalArgumentException(string);
        };
    }

    public static enum Storage {
        PERSIST,
        MEMORY,
        SESSION,
        NO;

        private static final String MASTER_KEY = "MASTER_KEY";
        private static final String FOR_SESSION = "SESSION";
        private static final String FORGET = "FORGET";

        public boolean isMemory() {
            return this == MEMORY || this == SESSION;
        }

        public boolean isPersisted() {
            return this == PERSIST;
        }

        public boolean isOneTime() {
            return this == NO;
        }

        public static Storage deserialize(@Nullable String s) {
            if (MASTER_KEY.equalsIgnoreCase(s)) {
                return PERSIST;
            }
            if (FOR_SESSION.equalsIgnoreCase(s)) {
                return SESSION;
            }
            if (FORGET.equalsIgnoreCase(s)) {
                return NO;
            }
            return MEMORY;
        }

        @Nullable
        public String serialize() {
            if (this == PERSIST) {
                return StringUtil.toLowerCase((String)MASTER_KEY);
            }
            if (this == SESSION) {
                return StringUtil.toLowerCase((String)FOR_SESSION);
            }
            if (this == NO) {
                return StringUtil.toLowerCase((String)FORGET);
            }
            return null;
        }
    }

    public static interface Listener
    extends EventListener {
        public void dataSourceModelUpdated(@NotNull LocalDataSource var1);
    }

    public static class BeforeTask {
        public final String providerId;
        public final Element serialized;

        public BeforeTask(String providerId, Element serialized) {
            this.providerId = providerId;
            this.serialized = serialized;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BeforeTask)) {
                return false;
            }
            BeforeTask task = (BeforeTask)o;
            return this.providerId.equals(task.providerId) && JDOMInterner.equals((Element)this.serialized, (Element)task.serialized);
        }

        public int hashCode() {
            return Objects.hash(this.providerId, JDOMInterner.hashCode((Element)this.serialized));
        }
    }
}

