/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.base.Predicates;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.SimpleCache;
import com.intellij.database.util.common.MapFun;
import com.intellij.database.util.sequences.EmptyMatSequence;
import com.intellij.database.util.sequences.MatSequence;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.view.structure.DvExtraTreeNode;
import com.intellij.database.view.structure.DvFamilyDivision;
import com.intellij.database.view.structure.DvFamilyFilterDescriptor;
import com.intellij.database.view.structure.DvFamilyHierarchyDescriptor;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.database.view.structure.DvFamilyNestDescriptor;
import com.intellij.database.view.structure.DvFamilyRelocationDescriptor;
import com.intellij.database.view.structure.DvFamilySeparationDescriptor;
import com.intellij.database.view.structure.DvFamilyUnnestDescriptor;
import com.intellij.database.view.structure.DvNestFamily;
import com.intellij.database.view.structure.DvStructureExtension;
import com.intellij.database.view.structure.DvTransformDescriptor;
import com.intellij.database.view.structure.DvTransformDescriptors;
import com.intellij.database.view.structure.DvTreeInternalFunKt;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.database.view.structure.DvTreeTransformLayer;
import com.intellij.database.view.structure.DvTreeTransformLayer$childrenOfElement$;
import com.intellij.database.view.structure.DvTreeTransformLayer$childrenOfUnnestFamily$;
import com.intellij.database.view.structure.DvUnnestFamily;
import com.intellij.database.view.structure.DvViewOptionsFun;
import com.intellij.database.view.structure.HostFamilyKin;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 _2\u00020\u0001:\u0003]^_B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J0\u0010\u0011\u001a\"\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u0018\u00010\u0012j\u0004\u0018\u0001`\u00152\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J0\u0010\u0016\u001a\"\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u0018\u00010\u0012j\u0004\u0018\u0001`\u00152\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J0\u0010\u0017\u001a\"\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u0018\u00010\u0012j\u0004\u0018\u0001`\u00152\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0013H\u0002J\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0002J\u0016\u0010'\u001a\u0004\u0018\u00010\u00142\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0002J0\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\u0006\u0010+\u001a\u00020,H\u0002J*\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010\"\u001a\u00020\f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u00100\u001a\u000201H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\u0006\u00103\u001a\u00020/H\u0002J\u001e\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u0010\"\u001a\u00020\f2\u0006\u00107\u001a\u00020\u001dH\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\u0006\u0010%\u001a\u000206H\u0002J\u001e\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u001f2\u0006\u0010\"\u001a\u00020\f2\u0006\u00107\u001a\u00020\u001dH\u0002J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u0006\u0010%\u001a\u00020:H\u0002J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\u0006\u0010\u001a\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010@\u001a\u00020?2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0017\u0010A\u001a\u0004\u0018\u00010?2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010BJ\u001b\u0010C\u001a\u0004\u0018\u00010?2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0002\u00a2\u0006\u0002\u0010DJ\u0010\u0010E\u001a\u00020F2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010G\u001a\u00020F2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010H\u001a\u00020F2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010I\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010J\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J)\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\b\u0010P\u001a\u0004\u0018\u00010Q2\b\u0010R\u001a\u0004\u0018\u00010QH\u0010\u00a2\u0006\u0002\bSJ\u0015\u0010T\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0010\u00a2\u0006\u0002\bUJ\u001d\u0010V\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010\u000f\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\bWJ \u0010X\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010Y\u001a\u00020QH\u0002J\r\u0010Z\u001a\u00020MH\u0010\u00a2\u0006\u0002\b[J\b\u0010\\\u001a\u00020MH\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/intellij/database/view/structure/DvTreeTransformLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "<init>", "()V", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "dbmsContexts", "Ljava/util/HashMap;", "Lcom/intellij/database/Dbms;", "Lcom/intellij/database/view/structure/DvTreeTransformLayer$DbmsContext;", "emptyDbmsContext", "ensureDbmsContext", "dbms", "prepareDbmsContext", "prepareTransformDescriptors", "", "Lcom/intellij/database/model/ObjectKind;", "Lcom/intellij/database/view/structure/DvTransformDescriptor;", "Lcom/intellij/database/view/structure/DvTransformDescriptors;", "prepareCommonTransformDescriptors", "prepareCustomTransformDescriptors", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "parentOfElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "childrenOf", "Lkotlin/sequences/Sequence;", "childrenOfElement", "getHostTransformDescriptorsFor", "ctx", "hostKind", "childrenOfFamily", "family", "Lcom/intellij/database/model/families/HostFamily;", "findDescriptorForFamily", "childrenOfFamilyPartiallyRelocated", "Lcom/intellij/database/model/families/Family;", "children", "descriptor", "Lcom/intellij/database/view/structure/DvFamilyRelocationDescriptor;", "obtainFamilyDivisions", "", "Lcom/intellij/database/view/structure/DvFamilyDivision;", "fsd", "Lcom/intellij/database/view/structure/DvFamilySeparationDescriptor;", "childrenOfFamilyDivision", "ff", "obtainUnnestFamilies", "Lcom/intellij/database/util/sequences/MatSequence;", "Lcom/intellij/database/view/structure/DvUnnestFamily;", "host", "childrenOfUnnestFamily", "obtainNestFamilies", "Lcom/intellij/database/view/structure/DvNestFamily;", "childrenOfNestFamily", "childrenOfExtraTreeNode", "Lcom/intellij/database/view/structure/DvExtraTreeNode;", "countAllChildrenOf", "", "countRealChildrenOf", "countChildrenOf", "(Lcom/intellij/database/model/basic/BasicNode;)Ljava/lang/Integer;", "countChildrenOfFamily", "(Lcom/intellij/database/model/families/HostFamily;)Ljava/lang/Integer;", "isAlwaysLeaf", "", "ifAlwaysLeafElement", "ifAlwaysLeafOther", "presentableNameOf", "presentableNameOfElement", "getDescriptorsOfElement", "onDataSourceModelReplaced", "", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "oldModel", "Lcom/intellij/database/model/basic/BasicModel;", "newModel", "onDataSourceModelReplaced$intellij_database_core_impl", "onDataSourceChanged", "onDataSourceChanged$intellij_database_core_impl", "onDataSourceRemoved", "onDataSourceRemoved$intellij_database_core_impl", "clearCachesForDataSource", "model", "onViewOptionsChanged", "onViewOptionsChanged$intellij_database_core_impl", "clearAll", "DbmsContext", "Handler", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeTransformLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeTransformLayer.kt\ncom/intellij/database/view/structure/DvTreeTransformLayer\n+ 2 MapFun.kt\ncom/intellij/database/util/common/MapFun\n+ 3 AnyFun.kt\ncom/intellij/database/util/common/AnyFun\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 SequenceFun.kt\ncom/intellij/database/util/sequences/SequenceFun\n*L\n1#1,607:1\n151#2:608\n50#3:609\n50#3:610\n1#4:611\n296#5,2:612\n777#5:619\n873#5,2:620\n1915#5,2:625\n777#5:627\n873#5,2:628\n184#6,2:614\n479#6:616\n479#6:622\n1342#6,2:623\n49#7:617\n49#7:618\n*S KotlinDebug\n*F\n+ 1 DvTreeTransformLayer.kt\ncom/intellij/database/view/structure/DvTreeTransformLayer\n*L\n195#1:608\n239#1:609\n240#1:610\n247#1:612,2\n425#1:619\n425#1:620,2\n577#1:625,2\n308#1:627\n308#1:628,2\n260#1:614,2\n340#1:616\n434#1:622\n465#1:623,2\n359#1:617\n405#1:618\n*E\n"})
public final class DvTreeTransformLayer
extends DvTreeStoreyLayer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<Dbms, DbmsContext> dbmsContexts = new HashMap(16);
    @NotNull
    private final DbmsContext emptyDbmsContext = new DbmsContext(null);
    @NotNull
    private static final Logger logger;

    @Override
    @NotNull
    protected String getName() {
        return "Transformation";
    }

    private final DbmsContext ensureDbmsContext(Dbms dbms) {
        DbmsContext ctx = this.dbmsContexts.get(dbms);
        if (ctx == null) {
            ctx = this.prepareDbmsContext(dbms);
            DbmsContext dbmsContext = ctx;
            if (dbmsContext == null) {
                dbmsContext = this.emptyDbmsContext;
            }
            ctx = dbmsContext;
            ((Map)this.dbmsContexts).put(dbms, ctx);
        }
        return ctx;
    }

    private final DbmsContext prepareDbmsContext(Dbms dbms) {
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map = this.prepareTransformDescriptors(dbms);
        if (map == null) {
            return null;
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> descriptors = map;
        return new DbmsContext(descriptors);
    }

    private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> prepareTransformDescriptors(Dbms dbms) {
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> commonDescriptors = this.prepareCommonTransformDescriptors(dbms);
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> customDescriptors = this.prepareCustomTransformDescriptors(dbms);
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> descriptors = DvTransformDescriptors.orElse(customDescriptors, commonDescriptors);
        return descriptors;
    }

    private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> prepareCommonTransformDescriptors(Dbms dbms) {
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> descriptors = null;
        if (this.getContext().vo.getSeparateRoutines() && Handler.INSTANCE.getOurDbmsHasSeparatedProceduresAndFunctions().get(dbms).booleanValue()) {
            descriptors = Handler.INSTANCE.getOurDbmsRoutineSeparationFamilyDescriptors().get(dbms);
        }
        if (DvViewOptionsFun.getUnnestTableSubObjectsAndGroupSchemaObjects(this.getContext().vo)) {
            descriptors = DvTransformDescriptors.orElse(descriptors, Handler.INSTANCE.getOurDbmsUnnestTableSubObjectsDescriptors().get(dbms));
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> $this$nullize$iv = descriptors;
        boolean $i$f$nullize = false;
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map = $this$nullize$iv;
        return !(map == null || map.isEmpty()) ? $this$nullize$iv : null;
    }

    private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> prepareCustomTransformDescriptors(Dbms dbms) {
        DvStructureExtension dvStructureExtension = this.extension(dbms);
        if (dvStructureExtension == null) {
            return null;
        }
        DvStructureExtension extension = dvStructureExtension;
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> descriptors = extension.getTransformDescriptors(this.getVo());
        return descriptors;
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof BasicElement ? this.parentOfElement((BasicElement)node) : (basicNode instanceof DvExtraTreeNode ? ((DvExtraTreeNode)node).getParentNode() : this.baseParentOf(node));
    }

    /*
     * WARNING - void declaration
     */
    private final BasicNode parentOfElement(BasicElement element) {
        boolean skip;
        BasicNode p = this.baseParentOf(element);
        if (element instanceof BasicNamespace || element instanceof BasicRoot) {
            return p;
        }
        BasicModel basicModel = element.getModel();
        if (basicModel == null || (basicModel = basicModel.getDbms()) == null) {
            return null;
        }
        BasicModel dbms = basicModel;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        Family<? extends BasicElement> family = element.getParentFamily();
        HostFamily hostFamily = family instanceof HostFamily ? (HostFamily)family : null;
        if (hostFamily == null) {
            return p;
        }
        HostFamily parentFamily = hostFamily;
        BasicElement basicElement = parentFamily.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        BasicElement parentElement = basicElement;
        ObjectKind objectKind = parentElement.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        ObjectKind parentKind = objectKind;
        boolean bl = DbImplUtilCore.SCHEMA_KINDS.contains(parentKind) ? !this.getVo().getGroupSchemaObjects() : (skip = !this.getVo().getGroupObjectElements());
        if (skip) {
            return p;
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map = ctx.getTransformDescriptors();
        if (map == null || (map = map.get(parentKind)) == null || (map = (DvTransformDescriptor)map.get(element.getKind())) == null) {
            return p;
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> transformDescriptor = map;
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map2 = transformDescriptor;
        if (map2 instanceof DvFamilySeparationDescriptor) {
            List<DvFamilyDivision> ffs = this.obtainFamilyDivisions(ctx, parentFamily, (DvFamilySeparationDescriptor)((Object)transformDescriptor));
            for (DvFamilyDivision ff : ffs) {
                if (!ff.predicate.test(element)) continue;
                return ff;
            }
        } else if (map2 instanceof DvFamilyRelocationDescriptor) {
            HostFamily elementFamily;
            HostFamily hostFamily2 = element.getParentFamily();
            HostFamily hostFamily3 = elementFamily = hostFamily2 instanceof HostFamily ? (HostFamily)hostFamily2 : null;
            if (elementFamily != null) {
                BasicElement $this$meets$iv;
                hostFamily2 = elementFamily;
                Predicate<BasicNode> predicate$iv = ((DvFamilyRelocationDescriptor)((Object)transformDescriptor)).getFamilyPredicate();
                boolean $i$f$meets = false;
                if (predicate$iv.test($this$meets$iv)) {
                    $this$meets$iv = element;
                    predicate$iv = ((DvFamilyRelocationDescriptor)((Object)transformDescriptor)).getElementPredicate();
                    $i$f$meets = false;
                    if (predicate$iv.test($this$meets$iv)) {
                        DvTransformDescriptor locationDescriptor = ((DvFamilyRelocationDescriptor)((Object)transformDescriptor)).getLocationDescriptor();
                        DvTransformDescriptor dvTransformDescriptor = locationDescriptor;
                        if (dvTransformDescriptor instanceof DvFamilyUnnestDescriptor) {
                            DvUnnestFamily unnestFamily;
                            DvUnnestFamily dvUnnestFamily;
                            List unnestFamilies;
                            List list;
                            BasicElement grandHost;
                            HostFamilyKin locationKin = locationDescriptor.kin;
                            BasicElement basicElement2 = grandHost = ModelFun.ancestorOf(element, locationKin.hostKind);
                            if (basicElement2 != null) {
                                BasicElement gh = basicElement2;
                                boolean bl2 = false;
                                list = (List)ctx.getUnnestFamilyCache().getIfPresent((Object)gh);
                            } else {
                                list = null;
                            }
                            List list2 = unnestFamilies = list;
                            if (list2 != null) {
                                Object v10;
                                block29: {
                                    List list3 = list2;
                                    boolean bl3 = false;
                                    Iterable $this$firstOrNull$iv = list3;
                                    boolean $i$f$firstOrNull = false;
                                    for (Object element$iv : $this$firstOrNull$iv) {
                                        DvUnnestFamily it = (DvUnnestFamily)element$iv;
                                        boolean bl4 = false;
                                        if (!Intrinsics.areEqual((Object)it.getChildrenKind(), (Object)locationKin.childrenKind)) continue;
                                        v10 = element$iv;
                                        break block29;
                                    }
                                    v10 = null;
                                }
                                dvUnnestFamily = v10;
                            } else {
                                dvUnnestFamily = null;
                            }
                            DvUnnestFamily dvUnnestFamily2 = unnestFamily = dvUnnestFamily;
                            if (dvUnnestFamily2 != null) {
                                return dvUnnestFamily2;
                            }
                        } else if (dvTransformDescriptor instanceof DvFamilyNestDescriptor) {
                            HostFamilyKin locationKin = locationDescriptor.kin;
                            DvNestFamily npFamily = (DvNestFamily)ctx.getNestParentFamilyCache().getIfPresent((Object)element);
                            if (npFamily == null) {
                                HostFamily sourceFamily;
                                HostFamily unnestFamily;
                                HostFamily it = unnestFamily = elementFamily;
                                boolean bl5 = false;
                                HostFamily hostFamily4 = sourceFamily = Intrinsics.areEqual((Object)it.getChildrenKind(), (Object)locationKin.hostKind) ? unnestFamily : null;
                                if (sourceFamily != null) {
                                    Object v14;
                                    block30: {
                                        void $this$firstOrNull$iv;
                                        unnestFamily = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull((Sequence)((Sequence)ModelFun.asSequence(sourceFamily)), arg_0 -> DvTreeTransformLayer.parentOfElement$lambda$3(ctx, arg_0)));
                                        boolean $i$f$firstOrNull = false;
                                        for (Object element$iv : $this$firstOrNull$iv) {
                                            DvNestFamily it2 = (DvNestFamily)element$iv;
                                            boolean bl6 = false;
                                            if (!(Intrinsics.areEqual((Object)it2.getChildrenKind(), (Object)locationKin.childrenKind) && (Boolean)((DvFamilyNestDescriptor)locationDescriptor).isInnerElementOf().invoke((Object)it2.host, (Object)element) != false)) continue;
                                            v14 = element$iv;
                                            break block30;
                                        }
                                        v14 = null;
                                    }
                                    npFamily = v14;
                                    if (npFamily != null) {
                                        ctx.getNestParentFamilyCache().put((Object)element, (Object)npFamily);
                                    }
                                }
                            }
                            DvNestFamily dvNestFamily = npFamily;
                            if (dvNestFamily != null) {
                                return dvNestFamily;
                            }
                        } else if (dvTransformDescriptor instanceof DvFamilyHierarchyDescriptor) {
                            BasicNode basicNode = (BasicNode)((DvFamilyHierarchyDescriptor)locationDescriptor).getDoFindParent().invoke((Object)elementFamily, (Object)element);
                            if (basicNode == null) {
                                basicNode = p;
                            }
                            return basicNode;
                        }
                    }
                }
            }
        }
        return p;
    }

    @Override
    @NotNull
    public Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof BasicElement ? this.childrenOfElement((BasicElement)node) : (basicNode instanceof HostFamily ? this.childrenOfFamily((HostFamily)node) : (basicNode instanceof DvFamilyDivision ? this.childrenOfFamilyDivision((DvFamilyDivision)node) : (basicNode instanceof DvUnnestFamily ? this.childrenOfUnnestFamily((DvUnnestFamily)node) : (basicNode instanceof DvNestFamily ? this.childrenOfNestFamily((DvNestFamily)node) : (basicNode instanceof DvExtraTreeNode ? this.childrenOfExtraTreeNode((DvExtraTreeNode)node) : this.getBase().childrenOf(node))))));
    }

    private final Sequence<BasicNode> childrenOfElement(BasicElement element) {
        Sequence<DvNestFamily> nestFamilies;
        boolean possibleNestFamilies;
        MatSequence<DvUnnestFamily> unnestFamilies;
        boolean possibleUnnestFamilies;
        DvFamilyRelocationDescriptor familyRelocationDescriptor;
        DvTransformDescriptor dvTransformDescriptor;
        Sequence children = this.getBase().childrenOf(element);
        if (element instanceof BasicNamespaceOwner) {
            return children;
        }
        BasicModel basicModel = element.getModel();
        if (basicModel == null || (basicModel = basicModel.getDbms()) == null) {
            return children;
        }
        BasicModel dbms = basicModel;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        ObjectKind objectKind = element.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        Map<ObjectKind, DvTransformDescriptor> map = this.getHostTransformDescriptorsFor(ctx, objectKind);
        if (map == null) {
            return children;
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map;
        children = SequencesKt.flatMap(children, arg_0 -> DvTreeTransformLayer.childrenOfElement$lambda$0(descriptors, this, ctx, arg_0));
        Family<? extends BasicElement> family = element.getParentFamily();
        DvFamilyRelocationDescriptor dvFamilyRelocationDescriptor = family instanceof HostFamily ? ((dvTransformDescriptor = descriptors.get(((HostFamily)family).getHost().getKind())) instanceof DvFamilyRelocationDescriptor ? (DvFamilyRelocationDescriptor)dvTransformDescriptor : null) : (familyRelocationDescriptor = null);
        if (familyRelocationDescriptor != null) {
            DvFamilyHierarchyDescriptor hierarchyDescriptor;
            DvTransformDescriptor dvTransformDescriptor2 = familyRelocationDescriptor.getLocationDescriptor();
            DvFamilyHierarchyDescriptor dvFamilyHierarchyDescriptor = hierarchyDescriptor = dvTransformDescriptor2 instanceof DvFamilyHierarchyDescriptor ? (DvFamilyHierarchyDescriptor)dvTransformDescriptor2 : null;
            if (hierarchyDescriptor != null && Intrinsics.areEqual((Object)hierarchyDescriptor.kin.childrenKind, (Object)element.getKind()) && family != null) {
                Sequence successors = (Sequence)hierarchyDescriptor.getDoFetchChildren().invoke(family, (Object)element);
                children = SequencesKt.plus((Sequence)children, (Sequence)successors);
            }
        }
        if ((possibleUnnestFamilies = MapFun.containsValues(descriptors, DvTreeTransformLayer::childrenOfElement$lambda$1)) && (unnestFamilies = this.obtainUnnestFamilies(ctx, element)).isNotEmpty()) {
            children = SequencesKt.plus((Sequence)children, (Sequence)((Sequence)unnestFamilies));
        }
        if ((possibleNestFamilies = MapFun.containsValues(descriptors, DvTreeTransformLayer::childrenOfElement$lambda$2)) && SequenceFun.isNotEmpty(nestFamilies = this.obtainNestFamilies(ctx, element))) {
            children = SequencesKt.plus((Sequence)children, nestFamilies);
        }
        Sequence $this$filterIsInstance$iv = (Sequence)SequenceFun.asSequence(descriptors.values());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)childrenOfElement$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Set removedFamilies = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence, DvTreeTransformLayer::childrenOfElement$lambda$3), DvTreeTransformLayer::childrenOfElement$lambda$4));
        if (!((Collection)removedFamilies).isEmpty()) {
            children = SequencesKt.filter((Sequence)children, arg_0 -> DvTreeTransformLayer.childrenOfElement$lambda$5(removedFamilies, arg_0));
        }
        return children;
    }

    private final Map<ObjectKind, DvTransformDescriptor> getHostTransformDescriptorsFor(DbmsContext ctx, ObjectKind hostKind) {
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> map = ctx.getTransformDescriptors();
        if (map == null) {
            return null;
        }
        Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> transformDescriptors = map;
        return transformDescriptors.get(hostKind);
    }

    private final Sequence<BasicNode> childrenOfFamily(HostFamily<?> family) {
        Sequence children;
        Sequence $this$isEmpty$iv = children = this.getBase().childrenOf(family);
        boolean $i$f$isEmpty = false;
        if (!SequenceFun.isNotEmpty($this$isEmpty$iv)) {
            return children;
        }
        DvTransformDescriptor dvTransformDescriptor = this.findDescriptorForFamily(family);
        if (dvTransformDescriptor == null) {
            return children;
        }
        DvTransformDescriptor descriptor = dvTransformDescriptor;
        DvTransformDescriptor dvTransformDescriptor2 = descriptor;
        return dvTransformDescriptor2 instanceof DvFamilyHierarchyDescriptor ? (Sequence)((DvFamilyHierarchyDescriptor)descriptor).getDoFetchTopNodes().invoke(family) : (dvTransformDescriptor2 instanceof DvFamilyRelocationDescriptor ? this.childrenOfFamilyPartiallyRelocated((Family)family, children, (DvFamilyRelocationDescriptor)descriptor) : (dvTransformDescriptor2 instanceof DvFamilyFilterDescriptor ? SequencesKt.filter(children, arg_0 -> DvTreeTransformLayer.childrenOfFamily$lambda$0(descriptor, arg_0)) : children));
    }

    private final DvTransformDescriptor findDescriptorForFamily(HostFamily<?> family) {
        BasicElement basicElement = family.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        BasicElement host = basicElement;
        ObjectKind objectKind = host.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        ObjectKind hostKind = objectKind;
        BasicModel basicModel = host.getModel();
        if (basicModel == null || (basicModel = basicModel.getDbms()) == null) {
            return null;
        }
        BasicModel dbms = basicModel;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        Map<ObjectKind, DvTransformDescriptor> map = this.getHostTransformDescriptorsFor(ctx, hostKind);
        if (map == null) {
            return null;
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map;
        DvTransformDescriptor descriptor = descriptors.get(family.getChildrenKind());
        return descriptor;
    }

    private final Sequence<BasicNode> childrenOfFamilyPartiallyRelocated(Family<?> family, Sequence<? extends BasicNode> children, DvFamilyRelocationDescriptor descriptor) {
        DvTransformDescriptor ld = descriptor.getLocationDescriptor();
        return ld instanceof DvFamilyHierarchyDescriptor ? (Sequence)((DvFamilyHierarchyDescriptor)ld).getDoFetchTopNodes().invoke(family) : SequencesKt.filter(children, arg_0 -> DvTreeTransformLayer.childrenOfFamilyPartiallyRelocated$lambda$0(descriptor, arg_0));
    }

    private final List<DvFamilyDivision> obtainFamilyDivisions(DbmsContext ctx, HostFamily<?> family, DvFamilySeparationDescriptor fsd) {
        List ffs = (List)ctx.getFdCache().getIfPresent(family);
        if (ffs == null) {
            List<DvFamilySeparationDescriptor.Division> filterDescriptors = fsd.getFilterDescriptors();
            ffs = new ArrayList(filterDescriptors.size());
            for (DvFamilySeparationDescriptor.Division d : filterDescriptors) {
                BasicElement basicElement = family.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
                DvFamilyDivision f = new DvFamilyDivision(basicElement, family, d.orderNum, d.displayName, d.familyId, d.predicate);
                ((ArrayList)ffs).add(f);
            }
            ctx.getFdCache().put(family, (Object)ffs);
        }
        return ffs;
    }

    private final Sequence<BasicNode> childrenOfFamilyDivision(DvFamilyDivision ff) {
        Sequence children;
        Sequence $this$isEmpty$iv = children = this.getBase().childrenOf(ff.family);
        boolean $i$f$isEmpty = false;
        if (!SequenceFun.isNotEmpty($this$isEmpty$iv)) {
            return (Sequence)EmptyMatSequence.INSTANCE;
        }
        children = SequencesKt.filter(children, arg_0 -> DvTreeTransformLayer.childrenOfFamilyDivision$lambda$0(ff, arg_0));
        return children;
    }

    /*
     * WARNING - void declaration
     */
    private final MatSequence<DvUnnestFamily> obtainUnnestFamilies(DbmsContext ctx, BasicElement host) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object descriptors;
        List unnestFamilies = (List)ctx.getUnnestFamilyCache().getIfPresent((Object)host);
        if (unnestFamilies == null) {
            ObjectKind objectKind = host.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            Map<ObjectKind, DvTransformDescriptor> map = this.getHostTransformDescriptorsFor(ctx, objectKind);
            if (map == null) {
                return (MatSequence)EmptyMatSequence.INSTANCE;
            }
            descriptors = map;
            ArrayList newUnnestFamilies = new ArrayList(descriptors.size());
            for (DvTransformDescriptor descriptor : descriptors.values()) {
                if (!(descriptor instanceof DvFamilyUnnestDescriptor)) continue;
                DvUnnestFamily f = new DvUnnestFamily(host, (DvFamilyUnnestDescriptor)descriptor);
                ((Collection)newUnnestFamilies).add(f);
            }
            unnestFamilies = newUnnestFamilies;
            ctx.getUnnestFamilyCache().put((Object)host, (Object)unnestFamilies);
        }
        descriptors = unnestFamilies;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DvUnnestFamily it = (DvUnnestFamily)element$iv$iv;
            boolean bl = false;
            if (!SequenceFun.isNotEmpty(this.childrenOfUnnestFamily(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return SequenceFun.asSequence((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<BasicNode> childrenOfUnnestFamily(DvUnnestFamily family) {
        void $this$filterIsInstance$iv;
        DvFamilyUnnestDescriptor descriptor = family.getDescriptor();
        Set<ObjectKind> nestedHostKinds = descriptor.getNestedHostKinds();
        List<? extends Family<? extends BasicElement>> list = family.host.getFamilies();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFamilies(...)");
        Sequence sequence = (Sequence)SequenceFun.asSequence((Collection)list);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)childrenOfUnnestFamily$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence result = SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)sequence2, arg_0 -> DvTreeTransformLayer.childrenOfUnnestFamily$lambda$0(nestedHostKinds, arg_0)), DvTreeTransformLayer::childrenOfUnnestFamily$lambda$1), arg_0 -> DvTreeTransformLayer.childrenOfUnnestFamily$lambda$2(descriptor, arg_0)), arg_0 -> DvTreeTransformLayer.childrenOfUnnestFamily$lambda$3(this, arg_0));
        return result;
    }

    private final Sequence<DvNestFamily> obtainNestFamilies(DbmsContext ctx, BasicElement host) {
        List nestFamilies = (List)ctx.getNestFamilyCache().getIfPresent((Object)host);
        if (nestFamilies == null) {
            ObjectKind objectKind = host.getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            Map<ObjectKind, DvTransformDescriptor> map = this.getHostTransformDescriptorsFor(ctx, objectKind);
            if (map == null) {
                return SequencesKt.emptySequence();
            }
            Map<ObjectKind, DvTransformDescriptor> descriptors = map;
            ArrayList newNestFamilies = new ArrayList(descriptors.size());
            for (DvTransformDescriptor descriptor : descriptors.values()) {
                if (!(descriptor instanceof DvFamilyNestDescriptor)) continue;
                DvNestFamily f = new DvNestFamily(host, (DvFamilyNestDescriptor)descriptor);
                ((Collection)newNestFamilies).add(f);
            }
            nestFamilies = newNestFamilies;
            ctx.getNestFamilyCache().put((Object)host, (Object)nestFamilies);
        }
        return SequencesKt.filter((Sequence)((Sequence)SequenceFun.asSequence((Collection)nestFamilies)), arg_0 -> DvTreeTransformLayer.obtainNestFamilies$lambda$0(this, arg_0));
    }

    private final Sequence<BasicElement> childrenOfNestFamily(DvNestFamily family) {
        Sequence result;
        Object object;
        Object ctx;
        BasicElement host;
        DvFamilyNestDescriptor descriptor;
        block8: {
            block7: {
                Object it;
                Object object2;
                block6: {
                    block5: {
                        descriptor = family.getDescriptor();
                        host = family.host;
                        object2 = host.getModel();
                        if (object2 == null) break block5;
                        it = object2;
                        boolean bl = false;
                        Dbms dbms = it.getDbms();
                        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                        DbmsContext dbmsContext = this.ensureDbmsContext(dbms);
                        object2 = dbmsContext;
                        if (dbmsContext != null) break block6;
                    }
                    return SequencesKt.emptySequence();
                }
                ctx = object2;
                object = host.getParentFamily();
                if (object == null) break block7;
                Object it2 = it = object;
                boolean bl = false;
                object = it2 instanceof HostFamily && Intrinsics.areEqual((Object)((HostFamily)it2).getChildrenKind(), (Object)family.getChildrenKind()) ? it : null;
                if (object != null) break block8;
            }
            return SequencesKt.emptySequence();
        }
        Family<? extends BasicElement> sourceFamily = object;
        Sequence $this$forEach$iv = result = SequencesKt.filter((Sequence)((Sequence)ModelFun.asSequence(sourceFamily)), arg_0 -> DvTreeTransformLayer.childrenOfNestFamily$lambda$2((DbmsContext)ctx, family, descriptor, host, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicElement it = (BasicElement)element$iv;
            boolean bl = false;
            ((DbmsContext)ctx).getNestParentFamilyCache().put((Object)it, (Object)family);
        }
        return result;
    }

    private final Sequence<BasicNode> childrenOfExtraTreeNode(DvExtraTreeNode node) {
        BasicModel basicModel = node.getModel();
        if (basicModel == null || (basicModel = basicModel.getDbms()) == null) {
            return SequencesKt.emptySequence();
        }
        BasicModel dbms = basicModel;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        HostFamily<? extends BasicElement> family = node.getFamily();
        ObjectKind objectKind = family.getChildrenKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getChildrenKind(...)");
        Map<ObjectKind, DvTransformDescriptor> map = this.getHostTransformDescriptorsFor(ctx, objectKind);
        if (map == null) {
            return SequencesKt.emptySequence();
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map;
        DvTransformDescriptor dvTransformDescriptor = descriptors.get(family.getChildrenKind());
        DvFamilyHierarchyDescriptor dvFamilyHierarchyDescriptor = dvTransformDescriptor instanceof DvFamilyHierarchyDescriptor ? (DvFamilyHierarchyDescriptor)dvTransformDescriptor : null;
        if (dvFamilyHierarchyDescriptor == null) {
            return SequencesKt.emptySequence();
        }
        DvFamilyHierarchyDescriptor descriptor = dvFamilyHierarchyDescriptor;
        return (Sequence)descriptor.getDoFetchChildren().invoke(family, (Object)node);
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Integer n = this.countChildrenOf(node);
        return n != null ? n.intValue() : this.getBase().countAllChildrenOf(node);
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Integer n = this.countChildrenOf(node);
        return n != null ? n.intValue() : this.getBase().countRealChildrenOf(node);
    }

    private final Integer countChildrenOf(BasicNode node) {
        return node instanceof HostFamily ? this.countChildrenOfFamily((HostFamily)node) : null;
    }

    private final Integer countChildrenOfFamily(HostFamily<?> family) {
        DvTransformDescriptor ld;
        if (family.isEmpty()) {
            return null;
        }
        DvTransformDescriptor dvTransformDescriptor = this.findDescriptorForFamily(family);
        if (dvTransformDescriptor == null) {
            return null;
        }
        DvTransformDescriptor descriptor = dvTransformDescriptor;
        return descriptor instanceof DvFamilyRelocationDescriptor ? ((ld = ((DvFamilyRelocationDescriptor)descriptor).getLocationDescriptor()) instanceof DvFamilyHierarchyDescriptor ? Integer.valueOf(SequencesKt.count((Sequence)((Sequence)((DvFamilyHierarchyDescriptor)ld).getDoFetchTopNodes().invoke(family)))) : null) : null;
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof BasicElement ? this.ifAlwaysLeafElement((BasicElement)node) : (basicNode instanceof DvExtraTreeNode ? false : this.ifAlwaysLeafOther(node));
    }

    private final boolean ifAlwaysLeafElement(BasicElement element) {
        Family<? extends BasicElement> family;
        DvFamilyHierarchyDescriptor hierarchyDescriptor;
        Map<ObjectKind, DvTransformDescriptor> map = this.getDescriptorsOfElement(element);
        if (map == null) {
            return this.ifAlwaysLeafOther(element);
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map;
        DvTransformDescriptor dvTransformDescriptor = descriptors.get(element.getKind());
        DvFamilyHierarchyDescriptor dvFamilyHierarchyDescriptor = hierarchyDescriptor = dvTransformDescriptor instanceof DvFamilyHierarchyDescriptor ? (DvFamilyHierarchyDescriptor)dvTransformDescriptor : null;
        if (hierarchyDescriptor != null && (family = element.getParentFamily()) != null) {
            return ((Number)hierarchyDescriptor.getDoCountChildren().invoke(family, (Object)element)).intValue() <= 0;
        }
        return this.ifAlwaysLeafOther(element);
    }

    private final boolean ifAlwaysLeafOther(BasicNode node) {
        Object object;
        block5: {
            block4: {
                boolean baseIsAlwaysLeaf = this.getBase().isAlwaysLeaf(node);
                if (!baseIsAlwaysLeaf || !(node instanceof BasicElement)) {
                    return baseIsAlwaysLeaf;
                }
                object = ((BasicElement)node).getModel();
                if (object == null) break block4;
                BasicModel it = object;
                boolean bl = false;
                Dbms dbms = it.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                DbmsContext dbmsContext = this.ensureDbmsContext(dbms);
                object = dbmsContext;
                if (dbmsContext != null) break block5;
            }
            return true;
        }
        Object ctx = object;
        return !((DbmsContext)ctx).getNestRelocationTargetKinds().contains(((BasicElement)node).getKind());
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        if (basicNode instanceof BasicElement) {
            string = this.presentableNameOfElement((BasicElement)node);
        } else if (basicNode instanceof DvExtraTreeNode) {
            String string2 = ((DvExtraTreeNode)node).getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        } else {
            string = this.getBase().presentableNameOf(node);
        }
        return string;
    }

    private final String presentableNameOfElement(BasicElement element) {
        String pName;
        DvFamilyHierarchyDescriptor hierarchyDescriptor;
        Map<ObjectKind, DvTransformDescriptor> map = this.getDescriptorsOfElement(element);
        if (map == null) {
            return this.getBase().presentableNameOf(element);
        }
        Map<ObjectKind, DvTransformDescriptor> descriptors = map;
        DvTransformDescriptor dvTransformDescriptor = descriptors.get(element.getKind());
        DvFamilyHierarchyDescriptor dvFamilyHierarchyDescriptor = hierarchyDescriptor = dvTransformDescriptor instanceof DvFamilyHierarchyDescriptor ? (DvFamilyHierarchyDescriptor)dvTransformDescriptor : null;
        if (hierarchyDescriptor != null && (pName = (String)hierarchyDescriptor.getDoGetPresentableName().invoke((Object)element)) != null) {
            return pName;
        }
        return this.getBase().presentableNameOf(element);
    }

    private final Map<ObjectKind, DvTransformDescriptor> getDescriptorsOfElement(BasicElement element) {
        if (element instanceof BasicNamespaceOwner) {
            return null;
        }
        BasicModel basicModel = element.getModel();
        if (basicModel == null || (basicModel = basicModel.getDbms()) == null) {
            return null;
        }
        BasicModel dbms = basicModel;
        DbmsContext ctx = this.ensureDbmsContext((Dbms)dbms);
        ObjectKind objectKind = element.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
        return this.getHostTransformDescriptorsFor(ctx, objectKind);
    }

    @Override
    public void onDataSourceModelReplaced$intellij_database_core_impl(@NotNull RawDataSource dataSource, @Nullable BasicModel oldModel, @Nullable BasicModel newModel) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (oldModel != null) {
            Dbms dbms = oldModel.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            this.clearCachesForDataSource(dataSource, dbms, oldModel);
        }
    }

    @Override
    public void onDataSourceChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        BasicModel basicModel = DataSourceFun.getBasicModel(dataSource);
        if (basicModel == null) {
            return;
        }
        BasicModel model = basicModel;
        Dbms dbms = model.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.clearCachesForDataSource(dataSource, dbms, model);
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        BasicModel basicModel = DataSourceFun.getBasicModel(dataSource);
        if (basicModel == null) {
            return;
        }
        BasicModel model = basicModel;
        this.clearCachesForDataSource(dataSource, dbms, model);
    }

    private final void clearCachesForDataSource(RawDataSource dataSource, Dbms dbms, BasicModel model) {
        DbmsContext dbmsContext = this.dbmsContexts.get(dbms);
        if (dbmsContext == null) {
            return;
        }
        DbmsContext ctx = dbmsContext;
        DasModel dasModel = dataSource.getModel();
        BasicModel basicModel = dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
        if (basicModel == null) {
            return;
        }
        BasicModel model2 = basicModel;
        DvTreeInternalFunKt.invalidateThat(ctx.getNestFamilyCache(), arg_0 -> DvTreeTransformLayer.clearCachesForDataSource$lambda$0(model2, arg_0));
        DvTreeInternalFunKt.invalidateThat(ctx.getUnnestFamilyCache(), arg_0 -> DvTreeTransformLayer.clearCachesForDataSource$lambda$1(model2, arg_0));
        DvTreeInternalFunKt.invalidateThat(ctx.getFdCache(), arg_0 -> DvTreeTransformLayer.clearCachesForDataSource$lambda$2(model2, arg_0));
        Iterable $this$forEach$iv = this.extensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbmsExtension.Bean it = (DbmsExtension.Bean)element$iv;
            boolean bl = false;
            Object object = it.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(...)");
            DvStructureExtension extension = (DvStructureExtension)object;
            try {
                if (!Intrinsics.areEqual((Object)it.getDbms(), (Object)dbms)) continue;
                extension.clearCachesForDataSource(dataSource, model2);
            }
            catch (Exception e) {
                logger.error("Failed to clean caches in in the DvTreeExtension " + extension, (Throwable)e);
            }
        }
    }

    @Override
    public void onViewOptionsChanged$intellij_database_core_impl() {
        this.dbmsContexts.clear();
    }

    @Override
    public void clearAll() {
        this.dbmsContexts.clear();
    }

    private static final List parentOfElement$lambda$3(DbmsContext $ctx, BasicElement it) {
        return (List)$ctx.getNestFamilyCache().getIfPresent((Object)it);
    }

    /*
     * WARNING - void declaration
     */
    private static final Sequence childrenOfElement$lambda$0(Map $descriptors, DvTreeTransformLayer this$0, DbmsContext $ctx, BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof HostFamily) {
            DvFamilySeparationDescriptor fsd;
            ObjectKind objectKind = ((HostFamily)node).getChildrenKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getChildrenKind(...)");
            ObjectKind childrenKind = objectKind;
            Object v = $descriptors.get(childrenKind);
            DvFamilySeparationDescriptor dvFamilySeparationDescriptor = fsd = v instanceof DvFamilySeparationDescriptor ? (DvFamilySeparationDescriptor)v : null;
            if (fsd != null) {
                List ffs = this$0.obtainFamilyDivisions($ctx, (HostFamily)node, fsd);
                if (!this$0.getVo().getShowEmptyGroups()) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = ffs;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        DvFamilyDivision it = (DvFamilyDivision)element$iv$iv;
                        boolean bl = false;
                        if (!SequenceFun.isNotEmpty(this$0.childrenOfFamilyDivision(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    ffs = (List)destination$iv$iv;
                }
                return (Sequence)SequenceFun.asSequence((Collection)ffs);
            }
        }
        return SequencesKt.sequenceOf((Object)node);
    }

    private static final boolean childrenOfElement$lambda$1(DvTransformDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DvFamilyUnnestDescriptor;
    }

    private static final boolean childrenOfElement$lambda$2(DvTransformDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof DvFamilyNestDescriptor;
    }

    private static final boolean childrenOfElement$lambda$3(DvFamilyRelocationDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getElementPredicate() == Predicates.alwaysTrue();
    }

    private static final ObjectKind childrenOfElement$lambda$4(DvFamilyRelocationDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.kin.childrenKind;
    }

    private static final boolean childrenOfElement$lambda$5(Set $removedFamilies, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof HostFamily ? !$removedFamilies.contains(((HostFamily)it).getChildrenKind()) : true;
    }

    private static final boolean childrenOfFamily$lambda$0(DvTransformDescriptor $descriptor, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof BasicElement && ((DvFamilyFilterDescriptor)$descriptor).getPredicate().test((BasicElement)it);
    }

    private static final boolean childrenOfFamilyPartiallyRelocated$lambda$0(DvFamilyRelocationDescriptor $descriptor, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof BasicElement && !$descriptor.getElementPredicate().test((BasicElement)it);
    }

    private static final boolean childrenOfFamilyDivision$lambda$0(DvFamilyDivision $ff, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof BasicElement && $ff.predicate.test((BasicElement)it);
    }

    private static final boolean childrenOfUnnestFamily$lambda$0(Set $nestedHostKinds, HostFamily f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        return $nestedHostKinds.contains(f.getChildrenKind()) && f.hasChildren();
    }

    private static final Sequence childrenOfUnnestFamily$lambda$1(HostFamily f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        return (Sequence)ModelFun.asSequence(f);
    }

    private static final HostFamily childrenOfUnnestFamily$lambda$2(DvFamilyUnnestDescriptor $descriptor, BasicElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Family<? extends BasicElement> family = e.familyOf($descriptor.kin.childrenKind);
        return family instanceof HostFamily ? (HostFamily)family : null;
    }

    private static final Sequence childrenOfUnnestFamily$lambda$3(DvTreeTransformLayer this$0, HostFamily f) {
        DvTreeLayer dvTreeLayer = this$0.getBase();
        HostFamily hostFamily = f;
        Intrinsics.checkNotNull((Object)hostFamily);
        return dvTreeLayer.childrenOf(hostFamily);
    }

    private static final boolean obtainNestFamilies$lambda$0(DvTreeTransformLayer this$0, DvNestFamily it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SequenceFun.isNotEmpty(this$0.childrenOfNestFamily(it));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean childrenOfNestFamily$lambda$2(DbmsContext $ctx, DvNestFamily $family, DvFamilyNestDescriptor $descriptor, BasicElement $host, BasicElement it) {
        if (Intrinsics.areEqual((Object)$ctx.getNestParentFamilyCache().getIfPresent((Object)it), (Object)$family)) return true;
        Function2<BasicElement, BasicElement, Boolean> function2 = $descriptor.isInnerElementOf();
        Intrinsics.checkNotNull((Object)it);
        if ((Boolean)function2.invoke((Object)$host, (Object)it) == false) return false;
        return true;
    }

    private static final boolean clearCachesForDataSource$lambda$0(BasicModel $model, BasicElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getModel(), (Object)$model);
    }

    private static final boolean clearCachesForDataSource$lambda$1(BasicModel $model, BasicElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getModel(), (Object)$model);
    }

    private static final boolean clearCachesForDataSource$lambda$2(BasicModel $model, HostFamily it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getModel(), (Object)$model);
    }

    @NotNull
    public static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        Logger logger2 = Logger.getInstance(DvTreeTransformLayer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/view/structure/DvTreeTransformLayer$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        public static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B/\u0012&\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0018\u00010\u0003j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR1\u0010\u0002\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0018\u00010\u0003j\u0004\u0018\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR'\u0010\u000f\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R#\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/view/structure/DvTreeTransformLayer$DbmsContext;", "", "transformDescriptors", "", "Lcom/intellij/database/model/ObjectKind;", "Lcom/intellij/database/view/structure/DvTransformDescriptor;", "Lcom/intellij/database/view/structure/DvTransformDescriptors;", "<init>", "(Ljava/util/Map;)V", "getTransformDescriptors", "()Ljava/util/Map;", "nestRelocationTargetKinds", "", "getNestRelocationTargetKinds", "()Ljava/util/Set;", "fdCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/database/model/families/HostFamily;", "", "Lcom/intellij/database/view/structure/DvFamilyDivision;", "getFdCache", "()Lcom/github/benmanes/caffeine/cache/Cache;", "unnestFamilyCache", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/view/structure/DvUnnestFamily;", "getUnnestFamilyCache", "nestFamilyCache", "Lcom/intellij/database/view/structure/DvNestFamily;", "getNestFamilyCache", "nestParentFamilyCache", "getNestParentFamilyCache", "intellij.database.core.impl"})
    private static final class DbmsContext {
        @Nullable
        private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> transformDescriptors;
        @NotNull
        private final Set<ObjectKind> nestRelocationTargetKinds;
        @NotNull
        private final Cache<HostFamily<?>, List<DvFamilyDivision>> fdCache;
        @NotNull
        private final Cache<BasicElement, List<DvUnnestFamily>> unnestFamilyCache;
        @NotNull
        private final Cache<BasicElement, List<DvNestFamily>> nestFamilyCache;
        @NotNull
        private final Cache<BasicElement, DvNestFamily> nestParentFamilyCache;

        public DbmsContext(@Nullable Map<ObjectKind, ? extends Map<ObjectKind, ? extends DvTransformDescriptor>> transformDescriptors) {
            this.transformDescriptors = transformDescriptors;
            this.nestRelocationTargetKinds = this.transformDescriptors != null ? SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)((Sequence)SequenceFun.asSequence(this.transformDescriptors.values())), DbmsContext::nestRelocationTargetKinds$lambda$0), DbmsContext::nestRelocationTargetKinds$lambda$1), DbmsContext::nestRelocationTargetKinds$lambda$2)) : SetsKt.emptySet();
            this.fdCache = DvTreeInternalFunKt.createWeakCache$default(false, 1, null);
            this.unnestFamilyCache = DvTreeInternalFunKt.createWeakCache$default(false, 1, null);
            this.nestFamilyCache = DvTreeInternalFunKt.createWeakCache$default(false, 1, null);
            this.nestParentFamilyCache = DvTreeInternalFunKt.createWeakCache(true);
        }

        @Nullable
        public final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> getTransformDescriptors() {
            return this.transformDescriptors;
        }

        @NotNull
        public final Set<ObjectKind> getNestRelocationTargetKinds() {
            return this.nestRelocationTargetKinds;
        }

        @NotNull
        public final Cache<HostFamily<?>, List<DvFamilyDivision>> getFdCache() {
            return this.fdCache;
        }

        @NotNull
        public final Cache<BasicElement, List<DvUnnestFamily>> getUnnestFamilyCache() {
            return this.unnestFamilyCache;
        }

        @NotNull
        public final Cache<BasicElement, List<DvNestFamily>> getNestFamilyCache() {
            return this.nestFamilyCache;
        }

        @NotNull
        public final Cache<BasicElement, DvNestFamily> getNestParentFamilyCache() {
            return this.nestParentFamilyCache;
        }

        private static final Iterable nestRelocationTargetKinds$lambda$0(Map it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.entrySet();
        }

        private static final boolean nestRelocationTargetKinds$lambda$1(Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((DvTransformDescriptor)it.getValue()).getAppendsTarget();
        }

        private static final ObjectKind nestRelocationTargetKinds$lambda$2(Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (ObjectKind)it.getKey();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J,\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u000bj\u0002`\u000e2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J,\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u000bj\u0002`\u000e2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR9\u0010\n\u001a*\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u000bj\u0002`\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR9\u0010\u0010\u001a*\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u000bj\u0002`\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001c\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\f0\f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/database/view/structure/DvTreeTransformLayer$Handler;", "", "<init>", "()V", "ourDbmsHasSeparatedProceduresAndFunctions", "Lcom/intellij/database/util/SimpleCache;", "Lcom/intellij/database/Dbms;", "", "getOurDbmsHasSeparatedProceduresAndFunctions", "()Lcom/intellij/database/util/SimpleCache;", "ourDbmsRoutineSeparationFamilyDescriptors", "", "Lcom/intellij/database/model/ObjectKind;", "Lcom/intellij/database/view/structure/DvTransformDescriptor;", "Lcom/intellij/database/view/structure/DvTransformDescriptors;", "getOurDbmsRoutineSeparationFamilyDescriptors", "ourDbmsUnnestTableSubObjectsDescriptors", "getOurDbmsUnnestTableSubObjectsDescriptors", "routineIsProcedurePredicate", "Ljava/util/function/Predicate;", "Lcom/intellij/database/model/basic/BasicElement;", "getRoutineIsProcedurePredicate", "()Ljava/util/function/Predicate;", "routineIsFunctionPredicate", "getRoutineIsFunctionPredicate", "checkDbmsHasProceduresAndFunctions", "dbms", "computeRoutineSeparationFamilyDescriptors", "unnestingFromTablesKinds", "", "kotlin.jvm.PlatformType", "computeUnnestTableSubObjectsDescriptors", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDvTreeTransformLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeTransformLayer.kt\ncom/intellij/database/view/structure/DvTreeTransformLayer$Handler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,607:1\n1#2:608\n777#3:609\n873#3:610\n874#3:613\n1661#3,3:614\n13225#4,2:611\n*S KotlinDebug\n*F\n+ 1 DvTreeTransformLayer.kt\ncom/intellij/database/view/structure/DvTreeTransformLayer$Handler\n*L\n139#1:609\n139#1:610\n139#1:613\n140#1:614,3\n139#1:611,2\n*E\n"})
    private static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();
        @NotNull
        private static final SimpleCache<Dbms, Boolean> ourDbmsHasSeparatedProceduresAndFunctions = new SimpleCache((Function1)new Function1<Dbms, Boolean>((Object)INSTANCE){

            public final Boolean invoke(Dbms p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Handler.access$checkDbmsHasProceduresAndFunctions((Handler)this.receiver, p0);
            }
        });
        @NotNull
        private static final SimpleCache<Dbms, Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>>> ourDbmsRoutineSeparationFamilyDescriptors = new SimpleCache((Function1)new Function1<Dbms, Map<ObjectKind, ? extends Map<ObjectKind, ? extends DvTransformDescriptor>>>((Object)INSTANCE){

            public final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> invoke(Dbms p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Handler.access$computeRoutineSeparationFamilyDescriptors((Handler)this.receiver, p0);
            }
        });
        @NotNull
        private static final SimpleCache<Dbms, Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>>> ourDbmsUnnestTableSubObjectsDescriptors = new SimpleCache((Function1)new Function1<Dbms, Map<ObjectKind, ? extends Map<ObjectKind, ? extends DvTransformDescriptor>>>((Object)INSTANCE){

            public final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> invoke(Dbms p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Handler.access$computeUnnestTableSubObjectsDescriptors((Handler)this.receiver, p0);
            }
        });
        @NotNull
        private static final Predicate<BasicElement> routineIsProcedurePredicate = Handler::routineIsProcedurePredicate$lambda$0;
        @NotNull
        private static final Predicate<BasicElement> routineIsFunctionPredicate = Handler::routineIsFunctionPredicate$lambda$0;
        @NotNull
        private static final Set<ObjectKind> unnestingFromTablesKinds;

        private Handler() {
        }

        @NotNull
        public final SimpleCache<Dbms, Boolean> getOurDbmsHasSeparatedProceduresAndFunctions() {
            return ourDbmsHasSeparatedProceduresAndFunctions;
        }

        @NotNull
        public final SimpleCache<Dbms, Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>>> getOurDbmsRoutineSeparationFamilyDescriptors() {
            return ourDbmsRoutineSeparationFamilyDescriptors;
        }

        @NotNull
        public final SimpleCache<Dbms, Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>>> getOurDbmsUnnestTableSubObjectsDescriptors() {
            return ourDbmsUnnestTableSubObjectsDescriptors;
        }

        @NotNull
        public final Predicate<BasicElement> getRoutineIsProcedurePredicate() {
            return routineIsProcedurePredicate;
        }

        @NotNull
        public final Predicate<BasicElement> getRoutineIsFunctionPredicate() {
            return routineIsFunctionPredicate;
        }

        private final boolean checkDbmsHasProceduresAndFunctions(Dbms dbms) {
            BasicMetaModel<?> basicMetaModel = ModelFacade.forDbms(dbms).getMetaModel();
            Intrinsics.checkNotNullExpressionValue(basicMetaModel, (String)"getMetaModel(...)");
            BasicMetaModel<?> mm = basicMetaModel;
            JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.of(arg_0 -> Handler.checkDbmsHasProceduresAndFunctions$lambda$0((Function1)checkDbmsHasProceduresAndFunctions.metaElements.1.INSTANCE, arg_0)).withRoot(mm.root)).traverse();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
            Iterable metaElements2 = (Iterable)jBIterable;
            for (BasicMetaObject metaElement : metaElements2) {
                BasicMetaProperty property;
                if (!Intrinsics.areEqual((Object)metaElement.kind, (Object)ObjectKind.ROUTINE) || (property = metaElement.getObjectProperty(BasicModRoutine.ROUTINE_KIND)) == null || property.isAbstract()) continue;
                return true;
            }
            return false;
        }

        private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> computeRoutineSeparationFamilyDescriptors(Dbms dbms) {
            BasicMetaModel<?> basicMetaModel = ModelFacade.forDbms(dbms).getMetaModel();
            Intrinsics.checkNotNullExpressionValue(basicMetaModel, (String)"getMetaModel(...)");
            BasicMetaModel<?> mm = basicMetaModel;
            Map result = new TreeMap();
            BasicMetaObject<?> basicMetaObject = mm.root;
            Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"root");
            Handler.computeRoutineSeparationFamilyDescriptors$travers(result, basicMetaObject);
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> computeUnnestTableSubObjectsDescriptors(Dbms dbms) {
            Map map;
            Object object;
            BasicMetaObject metaMView;
            BasicMetaObject metaTable;
            block14: {
                Object object2;
                BasicMetaObject metaSchema;
                block13: {
                    Object object3;
                    Object it;
                    int n;
                    block12: {
                        BasicMetaModel<?> basicMetaModel = ModelFacade.forDbms(dbms).getMetaModel();
                        Intrinsics.checkNotNullExpressionValue(basicMetaModel, (String)"getMetaModel(...)");
                        BasicMetaModel<?> mm = basicMetaModel;
                        BasicMetaObject basicMetaObject = (BasicMetaObject)mm.findMetaObjects(ObjectKind.SCHEMA).first();
                        if (basicMetaObject == null) {
                            return DvTransformDescriptors.emptyTransformDescriptors;
                        }
                        metaSchema = basicMetaObject;
                        Intrinsics.checkNotNullExpressionValue(metaSchema.children, (String)"children");
                        Object[] objectArray = metaSchema.children;
                        n = objectArray.length;
                        for (int j = 0; j < n; ++j) {
                            Object object4 = objectArray[j];
                            it = (BasicMetaObject)object4;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)((BasicMetaObject)it).kind, (Object)ObjectKind.TABLE)) continue;
                            object3 = object4;
                            break block12;
                        }
                        object3 = null;
                    }
                    metaTable = (BasicMetaObject)object3;
                    Intrinsics.checkNotNullExpressionValue(metaSchema.children, (String)"children");
                    Object[] objectArray = metaSchema.children;
                    int n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = objectArray[n];
                        BasicMetaObject it2 = (BasicMetaObject)it;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it2.kind, (Object)ObjectKind.MAT_VIEW)) continue;
                        object2 = it;
                        break block13;
                    }
                    object2 = null;
                }
                metaMView = (BasicMetaObject)object2;
                Intrinsics.checkNotNullExpressionValue(metaSchema.children, (String)"children");
                for (Object it2 : (Object[])metaSchema.children) {
                    BasicMetaObject it = (BasicMetaObject)it2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.kind, (Object)ObjectKind.VIEW)) continue;
                    object = it2;
                    break block14;
                }
                object = null;
            }
            BasicMetaObject metaView = (BasicMetaObject)object;
            Object[] objectArray = new BasicMetaObject[]{metaTable, metaMView, metaView};
            Set metaHosts = SetsKt.setOfNotNull((Object[])objectArray);
            if (metaHosts.isEmpty()) {
                return DvTransformDescriptors.emptyTransformDescriptors;
            }
            TreeMap<ObjectKind, TreeMap<ObjectKind, DvTransformDescriptor>> descriptors = new TreeMap<ObjectKind, TreeMap<ObjectKind, DvTransformDescriptor>>();
            for (ObjectKind unnestingKind : unnestingFromTablesKinds) {
                void $this$mapTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = metaHosts;
                boolean $i$f$filter22 = false;
                Object object5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block15: {
                        BasicMetaObject mh = (BasicMetaObject)element$iv$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue(mh.children, (String)"children");
                        Object[] $this$any$iv = mh.children;
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            BasicMetaObject x = (BasicMetaObject)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)x.kind, (Object)unnestingKind)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List theHosts = (List)destination$iv$iv;
                Iterable $i$f$filter22 = theHosts;
                Collection destination$iv = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    Object element$iv$iv;
                    element$iv$iv = (BasicMetaObject)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.kind);
                }
                LinkedHashSet theHostKinds = (LinkedHashSet)destination$iv;
                ObjectKind objectKind = ObjectKind.SCHEMA;
                Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"SCHEMA");
                Intrinsics.checkNotNull((Object)unnestingKind);
                DvFamilyUnnestDescriptor aggregationDescriptor = new DvFamilyUnnestDescriptor(new HostFamilyKin(objectKind, unnestingKind), theHostKinds);
                DvTransformDescriptors.addDescriptor(descriptors, aggregationDescriptor);
                Iterator iterator = theHostKinds.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                object5 = iterator;
                while (object5.hasNext()) {
                    ObjectKind hostKind = (ObjectKind)object5.next();
                    Intrinsics.checkNotNull((Object)hostKind);
                    DvFamilyRelocationDescriptor relocationDescriptor = new DvFamilyRelocationDescriptor(new HostFamilyKin(hostKind, unnestingKind), aggregationDescriptor, null, null, 12, null);
                    DvTransformDescriptors.addDescriptor(descriptors, relocationDescriptor);
                }
            }
            Map map2 = descriptors;
            if (map2.isEmpty()) {
                boolean bl = false;
                map = DvTransformDescriptors.emptyTransformDescriptors;
            } else {
                map = map2;
            }
            return map;
        }

        private static final boolean routineIsProcedurePredicate$lambda$0(BasicElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof BasicRoutine && ((BasicRoutine)it).getRoutineKind() == DasRoutine.Kind.PROCEDURE;
        }

        private static final boolean routineIsFunctionPredicate$lambda$0(BasicElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof BasicRoutine && ((BasicRoutine)it).getRoutineKind() == DasRoutine.Kind.FUNCTION;
        }

        private static final BasicMetaObject[] checkDbmsHasProceduresAndFunctions$lambda$0(Function1 $tmp0, Object p0) {
            return (BasicMetaObject[])$tmp0.invoke(p0);
        }

        private static final void computeRoutineSeparationFamilyDescriptors$addTransformDescriptors(Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> result, ObjectKind parentKind, ObjectKind childKind, DvTransformDescriptor transformDescriptor) {
            Map m2 = result.get(parentKind);
            if (m2 == null) {
                m2 = new TreeMap();
                result.put(parentKind, m2);
            } else {
                boolean bl;
                boolean bl2 = bl = !m2.containsKey(childKind);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            m2.put(childKind, transformDescriptor);
        }

        private static final void computeRoutineSeparationFamilyDescriptors$travers(Map<ObjectKind, Map<ObjectKind, DvTransformDescriptor>> result, BasicMetaObject<?> m) {
            Intrinsics.checkNotNullExpressionValue(m.children, (String)"children");
            for (BasicMetaObject<?> child : m.children) {
                if (Intrinsics.areEqual((Object)child.kind, (Object)ObjectKind.ROUTINE)) {
                    BasicMetaProperty<?, DasRoutine.Kind> property = child.getObjectProperty(BasicModRoutine.ROUTINE_KIND);
                    if (property == null || property.isAbstract()) continue;
                    ObjectKind parentKind = m.kind;
                    Intrinsics.checkNotNull((Object)parentKind);
                    ObjectKind objectKind = ObjectKind.ROUTINE;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
                    HostFamilyKin kin = new HostFamilyKin(parentKind, objectKind);
                    DvFamilySeparationDescriptor.Division d1 = new DvFamilySeparationDescriptor.Division(kin, 1, DvFamilyId.PROCEDURE, routineIsProcedurePredicate);
                    DvFamilySeparationDescriptor.Division d2 = new DvFamilySeparationDescriptor.Division(kin, 2, DvFamilyId.FUNCTION, routineIsFunctionPredicate);
                    ObjectKind objectKind2 = ObjectKind.ROUTINE;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"ROUTINE");
                    Object[] objectArray = new DvFamilySeparationDescriptor.Division[]{d1, d2};
                    Handler.computeRoutineSeparationFamilyDescriptors$addTransformDescriptors(result, parentKind, objectKind2, new DvFamilySeparationDescriptor(kin, CollectionsKt.listOf((Object[])objectArray)));
                    continue;
                }
                Intrinsics.checkNotNull(child);
                Handler.computeRoutineSeparationFamilyDescriptors$travers(result, child);
            }
        }

        public static final /* synthetic */ boolean access$checkDbmsHasProceduresAndFunctions(Handler $this, Dbms dbms) {
            return $this.checkDbmsHasProceduresAndFunctions(dbms);
        }

        public static final /* synthetic */ Map access$computeRoutineSeparationFamilyDescriptors(Handler $this, Dbms dbms) {
            return $this.computeRoutineSeparationFamilyDescriptors(dbms);
        }

        public static final /* synthetic */ Map access$computeUnnestTableSubObjectsDescriptors(Handler $this, Dbms dbms) {
            return $this.computeUnnestTableSubObjectsDescriptors(dbms);
        }

        static {
            Object[] objectArray = new ObjectKind[]{ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.TRIGGER, ObjectKind.RULE};
            unnestingFromTablesKinds = SetsKt.setOf((Object[])objectArray);
        }
    }
}

