/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.introspection.ElevationIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.RegularIntrospectionTask;
import com.intellij.database.introspection.SchemaFragmentIntrospectionTask;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u000eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0016\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH&J\b\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/model/LevelAnalyzer;", "", "addElementToAnalysis", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "addElementsToAnalysis", "elements", "", "analyzeForAllDetailsAccessing", "Lcom/intellij/database/model/LevelAnalyzer$Recommendation;", "analyzeForScripting", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "Recommendation", "intellij.database.core.impl"})
public interface LevelAnalyzer {
    public void addElementToAnalysis(@NotNull BasicElement var1);

    public void addElementsToAnalysis(@NotNull Iterable<? extends BasicElement> var1);

    @NotNull
    public Recommendation analyzeForAllDetailsAccessing();

    @NotNull
    public Recommendation analyzeForScripting(@NotNull ScriptCategory var1);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0013\u001a\u00020\u000fH\u0096\u0080\u0004R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0016\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/model/LevelAnalyzer$Recommendation;", "", "tasks", "", "Lcom/intellij/database/introspection/IntrospectionTask;", "<init>", "(Ljava/util/List;)V", "schemaCount", "", "fragmentCount", "otherTaskCount", "hasContent", "", "()Z", "title", "", "Lorg/jetbrains/annotations/Nls;", "getTitle", "()Ljava/lang/String;", "toString", "Companion", "intellij.database.core.impl"})
    public static final class Recommendation {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final List<IntrospectionTask> tasks;
        private final int schemaCount;
        private final int fragmentCount;
        private final int otherTaskCount;
        @JvmField
        @NotNull
        public static final Recommendation nothing = new Recommendation(CollectionsKt.emptyList());

        public Recommendation(@NotNull List<? extends IntrospectionTask> tasks) {
            Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
            this.tasks = tasks;
            int s = 0;
            int f = 0;
            int z = 0;
            for (IntrospectionTask task : this.tasks) {
                IntrospectionTask introspectionTask = task;
                if (introspectionTask instanceof ElevationIntrospectionTask) {
                    s += ((ElevationIntrospectionTask)task).schemas.size();
                    continue;
                }
                if (introspectionTask instanceof SchemaFragmentIntrospectionTask) {
                    f += ((SchemaFragmentIntrospectionTask)task).getCountOfNames();
                    continue;
                }
                if (introspectionTask instanceof RegularIntrospectionTask) {
                    f += ((RegularIntrospectionTask)task).getElementsToRefresh().size();
                    continue;
                }
                ++z;
            }
            this.schemaCount = s;
            this.fragmentCount = f;
            this.otherTaskCount = z;
        }

        @JvmName(name="hasContent")
        public final boolean hasContent() {
            return !((Collection)this.tasks).isEmpty();
        }

        @NotNull
        public final String getTitle() {
            String string;
            if (this.schemaCount > 0 && this.fragmentCount == 0 && this.otherTaskCount == 0) {
                Object[] objectArray = new Object[]{this.schemaCount};
                String string2 = DatabaseBundle.message((String)"introspection.recommendation.schemasOnly", (Object[])objectArray);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            } else if (this.fragmentCount > 0 && this.schemaCount == 0 && this.otherTaskCount == 0) {
                Object[] objectArray = new Object[]{this.fragmentCount};
                String string3 = DatabaseBundle.message((String)"introspection.recommendation.fragmentsOnly", (Object[])objectArray);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            } else {
                String string4 = DatabaseBundle.message((String)"introspection.recommendation.mix", (Object[])new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            }
            return string;
        }

        @NotNull
        public String toString() {
            CharSequence[] charSequenceArray = new CharSequence[]{this.schemaCount > 0 ? StringUtil.pluralize((String)("elevate " + this.schemaCount + " schema"), (int)this.schemaCount) : null, this.fragmentCount > 0 ? StringUtil.pluralize((String)("introspect " + this.fragmentCount + " fragment"), (int)this.fragmentCount) : null, this.otherTaskCount > 0 ? StringUtil.pluralize((String)("perform " + this.otherTaskCount + " other task"), (int)this.fragmentCount) : null};
            return StringFun.phraseOf$default((CharSequence[])charSequenceArray, (String)" and ", (String)"Recommended to ", null, (String)"Nothing recommended", (int)8, null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/model/LevelAnalyzer$Recommendation$Companion;", "", "<init>", "()V", "nothing", "Lcom/intellij/database/model/LevelAnalyzer$Recommendation;", "intellij.database.core.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

