/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.basic.BasicGrantsHolder;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.GrantsKt;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.StringKt;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PrimitiveIterator;
import java.util.SortedSet;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003./0B'\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB%\b\u0016\u0012\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0014\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0082\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003J\u0010\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0096\u0082\u0004J\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001f\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001dJ6\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010$\"\b\b\u0001\u0010%*\u00020&2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H%0\u00052\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u001c\u0010'\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001f\u0018\u00010!2\u0006\u0010(\u001a\u00020\u001dJ\n\u0010)\u001a\u00020\u000bH\u0096\u0080\u0004J\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+J\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\u0006\u0010-\u001a\u00020\u000bR\u001b\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/database/model/properties/Grants;", "T", "Lcom/intellij/database/model/properties/Grants$Grant;", "", "controller", "Lcom/intellij/database/model/properties/Grants$Controller;", "gs", "<init>", "(Lcom/intellij/database/model/properties/Grants$Controller;Ljava/lang/Iterable;)V", "c", "text", "", "(Lcom/intellij/database/model/properties/Grants$Controller;Ljava/lang/String;)V", "getController", "()Lcom/intellij/database/model/properties/Grants$Controller;", "grants", "Ljava/util/NavigableSet;", "equals", "", "other", "", "hashCode", "", "with", "iterator", "", "grantsFor", "Ljava/util/SortedSet;", "e", "Lcom/intellij/database/model/basic/BasicElement;", "grantsForByGrantee", "", "grantsForGrantee", "Lcom/intellij/util/containers/JBIterable;", "u", "granteeFilter", "Lcom/intellij/openapi/util/Condition;", "U", "Lcom/intellij/database/model/basic/BasicGrantee;", "grantsForGranteeByTarget", "g", "toString", "toMutableList", "", "toMutableSet", "serialize", "Grant", "Controller", "State", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nGrants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,291:1\n1#2:292\n18#3:293\n*S KotlinDebug\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants\n*L\n32#1:293\n*E\n"})
public final class Grants<T extends Grant>
implements Iterable<T>,
KMappedMarker {
    @NotNull
    private final Controller<T, ?> controller;
    @NotNull
    private final NavigableSet<T> grants;

    public Grants(@NotNull Controller<T, ?> controller, @NotNull Iterable<? extends T> gs) {
        Intrinsics.checkNotNullParameter(controller, (String)"controller");
        Intrinsics.checkNotNullParameter(gs, (String)"gs");
        this.controller = controller;
        ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf((Comparator)this.controller, gs);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSortedSet, (String)"copyOf(...)");
        this.grants = (NavigableSet)immutableSortedSet;
    }

    @NotNull
    public final Controller<T, ?> getController() {
        return this.controller;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Grants(@NotNull Controller<T, ?> c, @Nullable String text) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        v0 = this;
        v1 = c;
        var3_3 = StringKt.nullize$default((String)text, (boolean)false, (int)1, null);
        if (var3_3 == null) ** GOTO lbl-1000
        var5_4 /* !! */  = new char[]{'\n'};
        var4_5 = StringsKt.splitToSequence$default((CharSequence)var3_3, (char[])var5_4 /* !! */ , (boolean)false, (int)0, (int)6, null);
        if (var4_5 == null || (var5_4 /* !! */  = (char[])SequencesKt.map((Sequence)var4_5, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, _init_$lambda$0(com.intellij.database.model.properties.Grants$Controller java.lang.String ), (Ljava/lang/String;)Lcom/intellij/database/model/properties/Grants$Grant;)(c))) == null || (var6_6 = var5_4 /* !! */ .iterator()) == null) ** GOTO lbl-1000
        var8_7 = var6_6;
        var11_8 = v1;
        var10_9 = v0;
        $i$a$-let-Grants$2 = false;
        var12_11 = JBIterable.once((Iterator)it);
        v0 = var10_9;
        v1 = var11_8;
        var7_12 = var12_11;
        if (var7_12 != null) {
            v2 = (Iterable)var7_12;
        } else lbl-1000:
        // 3 sources

        {
            v3 = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"empty(...)");
            v2 = (Iterable)v3;
        }
        v0(v1, v2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        Object object = other;
        Object object2 = object;
        if (object == null) return false;
        Object $this$asSafely$iv = object2;
        boolean $i$f$asSafely = false;
        Object object3 = $this$asSafely$iv;
        if (!(object3 instanceof Grants)) {
            object3 = null;
        }
        Grants grants = (Grants)object3;
        object2 = grants;
        if (grants == null) return false;
        Object it = object2;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual(this.grants, ((Grants)it).grants);
        return bl2;
    }

    public int hashCode() {
        return this.grants.hashCode();
    }

    @NotNull
    public final Grants<T> with(@NotNull Iterable<? extends T> gs) {
        Intrinsics.checkNotNullParameter(gs, (String)"gs");
        return new Grants<T>(this.controller, gs);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> iterator = this.grants.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        return iterator;
    }

    @Nullable
    public final SortedSet<T> grantsFor(@NotNull BasicElement e) {
        SortedSet<T> sortedSet;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.grants.isEmpty()) {
            return null;
        }
        T t = this.controller.lower(e);
        if (t == null) {
            return Collections.emptySortedSet();
        }
        T l = t;
        T u = this.controller.upper(l);
        SortedSet<T> it = sortedSet = this.grants.subSet(l, u);
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        return !((Collection)it).isEmpty() ? sortedSet : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Iterable<Collection<T>> grantsForByGrantee(@NotNull BasicElement e) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = this.grantsFor(e);
        if (object != null) {
            JBIterable it = object;
            boolean bl = false;
            JBIterable jBIterable = JBIterable.from((Iterable)((Iterable)it));
            object = jBIterable;
            if (jBIterable != null && (object = GrantsKt.groupByGrantee((Iterable)object, this.controller)) != null) {
                collection = object.values();
                return collection;
            }
        }
        collection = null;
        return collection;
    }

    @Nullable
    public final JBIterable<T> grantsForGrantee(@NotNull BasicElement u) {
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        if (this.grants.isEmpty()) {
            return null;
        }
        Condition<T> condition = this.granteeFilter(this.controller, u);
        if (condition == null) {
            return null;
        }
        Condition<T> filter = condition;
        return JBIterable.from((Iterable)this.grants).filter(filter);
    }

    private final <U extends BasicGrantee> Condition<T> granteeFilter(Controller<T, U> c2, BasicElement u) {
        U u2 = c2.asGrantee(u);
        if (u2 == null) {
            return null;
        }
        U g = u2;
        T key = c2.withGrantee(c2.create(), g);
        return arg_0 -> Grants.granteeFilter$lambda$0(c2, key, arg_0);
    }

    @Nullable
    public final JBIterable<Collection<T>> grantsForGranteeByTarget(@NotNull BasicElement g) {
        Object object;
        block3: {
            block2: {
                JBIterable jBIterable;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                object = this.grantsForGrantee(g);
                if (object == null || (object = object.collect()) == null) break block2;
                JBIterable it = jBIterable = object;
                boolean bl = false;
                object = it.isNotEmpty() ? jBIterable : null;
                if (object != null) break block3;
            }
            return null;
        }
        JBIterable res = object;
        return res.split(JBIterable.Split.BEFORE, (Condition)new JBIterable.SCond<T>(this){
            private T u;
            final /* synthetic */ Grants<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean value(T t) {
                Intrinsics.checkNotNullParameter(t, (String)"t");
                T fu = this.u;
                if (fu != null && this.this$0.getController().compare(t, fu) < 0) {
                    return false;
                }
                this.u = this.this$0.getController().upper(t);
                return fu != null;
            }
        }).map(arg_0 -> Grants.grantsForGranteeByTarget$lambda$2(Grants::grantsForGranteeByTarget$lambda$1, arg_0));
    }

    @NotNull
    public String toString() {
        return "Grants(size=" + this.grants.size() + ")";
    }

    @NotNull
    public final List<T> toMutableList() {
        return CollectionsKt.toMutableList((Collection)this.grants);
    }

    @NotNull
    public final SortedSet<T> toMutableSet() {
        return CollectionsKt.toSortedSet((Iterable)this.grants, (Comparator)this.controller);
    }

    @NotNull
    public final String serialize() {
        StringBuilder sb = new StringBuilder();
        Iterator<T> iterator = this.grants.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<T> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Grant grant = (Grant)iterator2.next();
            if (((CharSequence)sb).length() > 0) {
                sb.append('\n');
            }
            Intrinsics.checkNotNull((Object)grant);
            sb.append(PropertyConverter.escapeSlashN(this.controller.serialize(grant)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Grant _init_$lambda$0(Controller $c, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = StringUtil.unescapeStringCharacters((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeStringCharacters(...)");
        return $c.deserialize(string);
    }

    private static final boolean granteeFilter$lambda$0(Controller $c, Grant $key, Grant it) {
        return $c.getGranteeStrategy().equals((Object)$key, (Object)it);
    }

    private static final Collection grantsForGranteeByTarget$lambda$1(JBIterable it) {
        return it.toList();
    }

    private static final Collection grantsForGranteeByTarget$lambda$2(Function1 $tmp0, Object p0) {
        return (Collection)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b&\u0018\u0000 i*\b\b\u0001\u0010\u0001*\u00020\u0002*\b\b\u0002\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005:\u0001iB\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0003\u0010\u0016J\u0018\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0003\u0010\u0016J\u001e\u0010\u0018\u001a\u00020\u0019*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0084\b\u00f8\u0001\u0000J3\u0010\u0018\u001a\u00020\u0019\"\f\b\u0003\u0010\u0016*\u0006\u0012\u0002\b\u00030\u001c*\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u0001H\u00162\b\u0010\u001e\u001a\u0004\u0018\u0001H\u0016H\u0004\u00a2\u0006\u0002\u0010\u001fJ\u001d\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00028\u00012\u0006\u0010\"\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010#J\u0017\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00028\u00012\u0006\u0010)\u001a\u00020%H&\u00a2\u0006\u0002\u0010*J\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020%0,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H&J\u001f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H&\u00a2\u0006\u0002\u00102J\r\u00103\u001a\u00028\u0001H&\u00a2\u0006\u0002\u00104J\u0017\u00105\u001a\u0004\u0018\u00018\u00012\u0006\u00106\u001a\u000207H&\u00a2\u0006\u0002\u00108J\u0015\u00109\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010:J\u0019\u0010;\u001a\u0004\u0018\u00018\u00022\b\u0010<\u001a\u0004\u0018\u000107H&\u00a2\u0006\u0002\u0010=J+\u0010>\u001a\u0004\u0018\u00018\u00022\b\u0010&\u001a\u0004\u0018\u00018\u00012\b\u0010?\u001a\u0004\u0018\u0001072\u0006\u0010@\u001a\u00020AH&\u00a2\u0006\u0002\u0010BJ!\u0010C\u001a\u00020%2\b\u0010<\u001a\u0004\u0018\u00018\u00022\b\u0010&\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010DJ \u0010E\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00020G0F2\b\u0010?\u001a\u0004\u0018\u000107H&J\u001e\u0010H\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002070G0F2\b\u0010?\u001a\u0004\u0018\u000107J\u001f\u0010>\u001a\u0004\u0018\u00018\u00022\u0006\u0010?\u001a\u0002072\u0006\u0010)\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010IJ+\u0010J\u001a\u0004\u0018\u0001072\b\u0010&\u001a\u0004\u0018\u00018\u00012\b\u0010?\u001a\u0004\u0018\u0001072\u0006\u0010@\u001a\u00020AH&\u00a2\u0006\u0002\u0010KJ!\u0010L\u001a\u00020%2\b\u00106\u001a\u0004\u0018\u0001072\b\u0010&\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010MJ\u001b\u0010N\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u00106\u001a\u000207\u00a2\u0006\u0002\u0010OJ\u001d\u0010P\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u00106\u001a\u000207H$\u00a2\u0006\u0002\u0010OJ\u001d\u0010Q\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010R\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010SJ\u001d\u0010T\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010)\u001a\u00020%H&\u00a2\u0006\u0002\u0010UJ\u001d\u0010V\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010<\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010WJ\u001d\u0010X\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010)\u001a\u00020%H&\u00a2\u0006\u0002\u0010UJ\u001d\u0010Y\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010R\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010SJ/\u0010Z\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010[\u001a\u00020%2\b\u0010\\\u001a\u0004\u0018\u00010]2\u0006\u0010^\u001a\u000201H&\u00a2\u0006\u0002\u0010_J\u001d\u0010`\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u00012\u0006\u0010^\u001a\u000201H&\u00a2\u0006\u0002\u0010aJ\u0013\u0010b\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u0001\u00a2\u0006\u0002\u0010:J\u0016\u0010c\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010d2\u0006\u00106\u001a\u000207J\u000e\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u000207J\u0014\u0010e\u001a\u00020f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H&J\u0013\u0010h\u001a\u00020%2\u0006\u0010&\u001a\u00028\u0001\u00a2\u0006\u0002\u0010'R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006j"}, d2={"Lcom/intellij/database/model/properties/Grants$Controller;", "G", "Lcom/intellij/database/model/properties/Grants$Grant;", "U", "Lcom/intellij/database/model/basic/BasicGrantee;", "Ljava/util/Comparator;", "<init>", "()V", "noGrants", "Lcom/intellij/database/model/properties/Grants;", "getNoGrants", "()Lcom/intellij/database/model/properties/Grants;", "granteeStrategy", "Lit/unimi/dsi/fastutil/Hash$Strategy;", "getGranteeStrategy", "()Lit/unimi/dsi/fastutil/Hash$Strategy;", "targetStrategy", "getTargetStrategy", "bothStrategy", "getBothStrategy", "byGrantee", "", "V", "byTarget", "thenCompare", "", "nextStage", "Lkotlin/Function0;", "", "a", "b", "(ILjava/lang/Comparable;Ljava/lang/Comparable;)I", "compare", "o1", "o2", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/properties/Grants$Grant;)I", "serialize", "", "g", "(Lcom/intellij/database/model/properties/Grants$Grant;)Ljava/lang/String;", "deserialize", "text", "(Ljava/lang/String;)Lcom/intellij/database/model/properties/Grants$Grant;", "possiblePrivileges", "", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "possibleStates", "", "Lcom/intellij/database/model/properties/Grants$State;", "(Lcom/intellij/database/model/meta/BasicMetaObject;)[Lcom/intellij/database/model/properties/Grants$State;", "create", "()Lcom/intellij/database/model/properties/Grants$Grant;", "lower", "e", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/properties/Grants$Grant;", "upper", "(Lcom/intellij/database/model/properties/Grants$Grant;)Lcom/intellij/database/model/properties/Grants$Grant;", "asGrantee", "u", "(Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/basic/BasicGrantee;", "findGrantee", "h", "assistant", "Lcom/intellij/database/model/meta/BasicResolveAssistant;", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/meta/BasicResolveAssistant;)Lcom/intellij/database/model/basic/BasicGrantee;", "granteeText", "(Lcom/intellij/database/model/basic/BasicGrantee;Lcom/intellij/database/model/properties/Grants$Grant;)Ljava/lang/String;", "granteeFamiliesFor", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/families/Family;", "targetFamiliesFor", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/String;)Lcom/intellij/database/model/basic/BasicGrantee;", "findTarget", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/meta/BasicResolveAssistant;)Lcom/intellij/database/model/basic/BasicElement;", "targetText", "(Lcom/intellij/database/model/basic/BasicElement;Lcom/intellij/database/model/properties/Grants$Grant;)Ljava/lang/String;", "withTarget", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicElement;)Lcom/intellij/database/model/properties/Grants$Grant;", "withTargetImpl", "withTargetFrom", "src", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/properties/Grants$Grant;)Lcom/intellij/database/model/properties/Grants$Grant;", "withUnresolvedTarget", "(Lcom/intellij/database/model/properties/Grants$Grant;Ljava/lang/String;)Lcom/intellij/database/model/properties/Grants$Grant;", "withGrantee", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/basic/BasicGrantee;)Lcom/intellij/database/model/properties/Grants$Grant;", "withUnresolvedGrantee", "withGranteeFrom", "withPermission", "perm", "subs", "Ljava/util/BitSet;", "state", "(Lcom/intellij/database/model/properties/Grants$Grant;Ljava/lang/String;Ljava/util/BitSet;Lcom/intellij/database/model/properties/Grants$State;)Lcom/intellij/database/model/properties/Grants$Grant;", "withState", "(Lcom/intellij/database/model/properties/Grants$Grant;Lcom/intellij/database/model/properties/Grants$State;)Lcom/intellij/database/model/properties/Grants$Grant;", "withAntiState", "grantsHolder", "Lcom/intellij/database/model/basic/BasicGrantsHolder;", "holdsItsGrants", "", "element", "serializeState", "Companion", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nGrants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Controller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Grants.kt\ncom/intellij/database/model/properties/GrantsKt\n*L\n1#1,291:1\n150#1:293\n150#1:295\n1#2:292\n1#2:294\n1#2:296\n268#3:297\n*S KotlinDebug\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Controller\n*L\n151#1:293\n156#1:295\n151#1:294\n156#1:296\n212#1:297\n*E\n"})
    public static abstract class Controller<G extends Grant, U extends BasicGrantee>
    implements Comparator<G> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Grants<G> noGrants = new Grants(this, CollectionsKt.emptyList());
        @NotNull
        private final Hash.Strategy<G> bothStrategy = new Hash.Strategy<G>(this){
            final /* synthetic */ Controller<G, U> this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean equals(G o1, G o2) {
                return this.this$0.getGranteeStrategy().equals(o1, o2) && this.this$0.getTargetStrategy().equals(o1, o2);
            }

            public int hashCode(G object) {
                return this.this$0.getGranteeStrategy().hashCode(object) + 31 * this.this$0.getTargetStrategy().hashCode(object);
            }
        };

        @NotNull
        public final Grants<G> getNoGrants() {
            return this.noGrants;
        }

        @NotNull
        public abstract Hash.Strategy<G> getGranteeStrategy();

        @NotNull
        public abstract Hash.Strategy<G> getTargetStrategy();

        @NotNull
        public final Hash.Strategy<G> getBothStrategy() {
            return this.bothStrategy;
        }

        @NotNull
        public final <V> Map<G, V> byGrantee() {
            return (Map)new Object2ObjectOpenCustomHashMap(this.getGranteeStrategy());
        }

        @NotNull
        public final <V> Map<G, V> byTarget() {
            return (Map)new Object2ObjectOpenCustomHashMap(this.getTargetStrategy());
        }

        protected final int thenCompare(int $this$thenCompare, @NotNull Function0<Integer> nextStage) {
            Intrinsics.checkNotNullParameter(nextStage, (String)"nextStage");
            boolean $i$f$thenCompare = false;
            Integer n = $this$thenCompare;
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it != 0 ? n : null;
            return n2 != null ? n2.intValue() : ((Number)nextStage.invoke()).intValue();
        }

        protected final <V extends Comparable<?>> int thenCompare(int $this$thenCompare, @Nullable V a, @Nullable V b) {
            int n;
            Controller controller = this;
            int $this$thenCompare$iv = $this$thenCompare;
            boolean $i$f$thenCompare = false;
            Integer n2 = $this$thenCompare$iv;
            int it$iv = ((Number)n2).intValue();
            boolean bl = false;
            Integer n3 = it$iv != 0 ? n2 : null;
            if (n3 != null) {
                n = n3;
            } else {
                boolean bl2 = false;
                n = ComparisonsKt.compareValues(a, b);
            }
            return n;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(@NotNull G o1, @NotNull G o2) {
            int n;
            void $this$thenCompare$iv;
            Controller controller;
            Intrinsics.checkNotNullParameter(o1, (String)"o1");
            Intrinsics.checkNotNullParameter(o2, (String)"o2");
            Controller controller2 = controller = this;
            BitSet bitSet = ((Grant)o1).getSubs();
            BitSet bitSet2 = ((Grant)o2).getSubs();
            int n2 = this.thenCompare(ComparisonsKt.compareValues((Comparable)((Comparable)((Object)((Grant)o1).getPermission())), (Comparable)((Comparable)((Object)((Grant)o2).getPermission()))), (Comparable)(bitSet != null ? Integer.valueOf(bitSet.length()) : null), (Comparable)(bitSet2 != null ? Integer.valueOf(bitSet2.length()) : null));
            boolean $i$f$thenCompare = false;
            Integer n3 = (int)$this$thenCompare$iv;
            int it$iv = ((Number)n3).intValue();
            boolean bl = false;
            Integer n4 = it$iv != 0 ? n3 : null;
            if (n4 != null) {
                n = n4;
            } else {
                int n5;
                Controller controller3;
                block3: {
                    controller3 = controller2;
                    boolean bl2 = false;
                    PrimitiveIterator.OfInt it1 = ((Grant)o1).getSubsStream().iterator();
                    PrimitiveIterator.OfInt it2 = ((Grant)o2).getSubsStream().iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        int res = ComparisonsKt.compareValues((Comparable)Integer.valueOf(it1.nextInt()), (Comparable)Integer.valueOf(it2.nextInt()));
                        if (res == 0) continue;
                        n5 = res;
                        break block3;
                    }
                    n5 = ComparisonsKt.compareValues((Comparable)Boolean.valueOf(it1.hasNext()), (Comparable)Boolean.valueOf(it2.hasNext()));
                }
                int n6 = n5;
                controller2 = controller3;
                n = n6;
            }
            return controller2.thenCompare(n, (Comparable)((Object)((Grant)o1).getState()), (Comparable)((Object)((Grant)o2).getState()));
        }

        @Nullable
        public abstract String serialize(@NotNull G var1);

        @NotNull
        public abstract G deserialize(@NotNull String var1);

        @NotNull
        public abstract Iterable<String> possiblePrivileges(@NotNull BasicMetaObject<?> var1);

        @NotNull
        public abstract State[] possibleStates(@NotNull BasicMetaObject<?> var1);

        @NotNull
        public abstract G create();

        @Nullable
        public abstract G lower(@NotNull BasicElement var1);

        @NotNull
        public abstract G upper(@NotNull G var1);

        @Nullable
        public abstract U asGrantee(@Nullable BasicElement var1);

        @Nullable
        public abstract U findGrantee(@Nullable G var1, @Nullable BasicElement var2, @NotNull BasicResolveAssistant var3);

        @NotNull
        public String granteeText(@Nullable U u, @Nullable G g) {
            Object object = u;
            if (object == null || (object = ((BasicNamedElement)object).getName()) == null) {
                object = "";
            }
            return object;
        }

        @NotNull
        public abstract JBIterable<Family<? extends U>> granteeFamiliesFor(@Nullable BasicElement var1);

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final JBIterable<Family<? extends BasicElement>> targetFamiliesFor(@Nullable BasicElement h) {
            JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(arg_0 -> Controller.targetFamiliesFor$lambda$1(Controller::targetFamiliesFor$lambda$0, arg_0)).filter(arg_0 -> Controller.targetFamiliesFor$lambda$3(arg_0 -> Controller.targetFamiliesFor$lambda$2(this, arg_0), arg_0));
            Object object = h;
            if (object == null || (object = object.getParent()) == null || (object = object.getFamilies()) == null) {
                BasicNode basicNode = h;
                if (basicNode != null && (basicNode = basicNode.getParentFamily()) != null) {
                    void it;
                    BasicNode basicNode2 = basicNode;
                    JBTreeTraverser jBTreeTraverser2 = jBTreeTraverser;
                    boolean bl = false;
                    object = CollectionsKt.listOf((Object)it);
                    jBTreeTraverser = jBTreeTraverser2;
                } else {
                    object = null;
                }
            }
            JBIterable jBIterable = ((JBTreeTraverser)jBTreeTraverser.withRoots((Iterable)object)).traverse();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
            return jBIterable;
        }

        @Nullable
        public U findGrantee(@NotNull BasicElement h, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)h, (String)"h");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return (U)((BasicGrantee)this.granteeFamiliesFor(h).filterMap(arg_0 -> Controller.findGrantee$lambda$1(arg_0 -> Controller.findGrantee$lambda$0(this, text2, arg_0), arg_0)).first());
        }

        @Nullable
        public abstract BasicElement findTarget(@Nullable G var1, @Nullable BasicElement var2, @NotNull BasicResolveAssistant var3);

        @NotNull
        public String targetText(@Nullable BasicElement e, @Nullable G g) {
            Object object;
            block5: {
                block6: {
                    Object object2;
                    block8: {
                        block7: {
                            block4: {
                                if (!(e instanceof BasicRoot)) break block4;
                                object = "server";
                                break block5;
                            }
                            object = e;
                            if (object == null) break block6;
                            Object it = object;
                            boolean bl = false;
                            object2 = StringKt.nullize$default((String)BasicPaths.getIdentity(e), (boolean)false, (int)1, null);
                            if (object2 == null) break block7;
                            String it2 = object2;
                            boolean bl2 = false;
                            String string = e.getName() + it2;
                            object2 = string;
                            if (string != null) break block8;
                        }
                        String string = e.getName();
                        object2 = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    }
                    object = object2;
                    if (object2 != null) break block5;
                }
                object = "";
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final G withTarget(@NotNull G g, @NotNull BasicElement e) {
            Object object;
            block5: {
                block2: {
                    void $this$withTarget_u24lambda_u241;
                    BitSet bitSet;
                    Controller controller;
                    BasicElement basicElement;
                    Controller controller2;
                    block4: {
                        block3: {
                            void it;
                            Intrinsics.checkNotNullParameter(g, (String)"g");
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            if (!(e instanceof BasicLikeColumn)) break block2;
                            controller2 = this;
                            basicElement = ((BasicLikeColumn)e).getParent();
                            if (basicElement == null) break block3;
                            BasicElement basicElement2 = basicElement;
                            controller = controller2;
                            boolean bl = false;
                            G g2 = this.withTargetImpl(g, (BasicElement)it);
                            controller2 = controller;
                            basicElement = g2;
                            if (g2 != null) break block4;
                        }
                        basicElement = this.withUnresolvedTarget(g, "");
                    }
                    BitSet bitSet2 = bitSet = new BitSet();
                    String string = ((Grant)g).getPermission();
                    BasicElement basicElement3 = basicElement;
                    controller = controller2;
                    boolean bl = false;
                    $this$withTarget_u24lambda_u241.set(((BasicLikeColumn)e).getPosition());
                    Unit unit = Unit.INSTANCE;
                    object = controller.withPermission(basicElement3, string, bitSet, ((Grant)g).getState());
                    break block5;
                }
                object = this.withTargetImpl(g, e);
            }
            return object;
        }

        @NotNull
        protected abstract G withTargetImpl(@NotNull G var1, @NotNull BasicElement var2);

        @NotNull
        public abstract G withTargetFrom(@NotNull G var1, @NotNull G var2);

        @NotNull
        public abstract G withUnresolvedTarget(@NotNull G var1, @NotNull String var2);

        @NotNull
        public abstract G withGrantee(@NotNull G var1, @NotNull U var2);

        @NotNull
        public abstract G withUnresolvedGrantee(@NotNull G var1, @NotNull String var2);

        @NotNull
        public abstract G withGranteeFrom(@NotNull G var1, @NotNull G var2);

        @NotNull
        public abstract G withPermission(@NotNull G var1, @NotNull String var2, @Nullable BitSet var3, @NotNull State var4);

        @NotNull
        public abstract G withState(@NotNull G var1, @NotNull State var2);

        @NotNull
        public final G withAntiState(@NotNull G g) {
            Intrinsics.checkNotNullParameter(g, (String)"g");
            return this.withState(g, switch (WhenMappings.$EnumSwitchMapping$0[((Grant)g).getState().ordinal()]) {
                case 1, 2 -> State.REVOKE;
                case 3, 4 -> State.GRANT;
                default -> throw new NoWhenBranchMatchedException();
            });
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final BasicGrantsHolder<G> grantsHolder(@NotNull BasicElement e) {
            void $this$grantsHolder$iv;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BasicElement basicElement = e;
            boolean strict$iv = !this.holdsItsGrants(e);
            boolean $i$f$grantsHolder = false;
            return (BasicGrantsHolder)DasUtil.getParentOfClass((DasObject)((DasObject)$this$grantsHolder$iv), BasicGrantsHolder.class, (boolean)strict$iv);
        }

        public final boolean holdsItsGrants(@NotNull BasicElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            BasicMetaObject basicMetaObject = element.getMetaObject();
            Intrinsics.checkNotNullExpressionValue((Object)basicMetaObject, (String)"getMetaObject(...)");
            return this.holdsItsGrants(basicMetaObject);
        }

        public abstract boolean holdsItsGrants(@NotNull BasicMetaObject<?> var1);

        @NotNull
        public final String serializeState(@NotNull G g) {
            Intrinsics.checkNotNullParameter(g, (String)"g");
            return String.valueOf(((Grant)g).getState().getCode());
        }

        private static final Iterable targetFamiliesFor$lambda$0$0(BasicElement it) {
            return ((BasicMixinElement)it).getFamilies();
        }

        private static final Iterable targetFamiliesFor$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Iterable)$tmp0.invoke(p0);
        }

        private static final Iterable targetFamiliesFor$lambda$0(Family f) {
            return (Iterable)f.jbi().flatten(arg_0 -> Controller.targetFamiliesFor$lambda$0$1(Controller::targetFamiliesFor$lambda$0$0, arg_0));
        }

        private static final Iterable targetFamiliesFor$lambda$1(Function1 $tmp0, Object p0) {
            return (Iterable)$tmp0.invoke(p0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean targetFamiliesFor$lambda$2(Controller this$0, Family it) {
            if (Intrinsics.areEqual((Object)it.getMetaObject().kind, (Object)ObjectKind.COLUMN)) return false;
            BasicMetaObject<?> basicMetaObject = it.getMetaObject();
            Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
            if (!this$0.possiblePrivileges(basicMetaObject).iterator().hasNext()) return false;
            return true;
        }

        private static final boolean targetFamiliesFor$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean findGrantee$lambda$0$0(Controller this$0, String $text, BasicGrantee it) {
            return Intrinsics.areEqual((Object)this$0.granteeText(it, null), (Object)$text);
        }

        private static final boolean findGrantee$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final BasicGrantee findGrantee$lambda$0(Controller this$0, String $text, Family f) {
            return (BasicGrantee)f.find(arg_0 -> Controller.findGrantee$lambda$0$1(arg_0 -> Controller.findGrantee$lambda$0$0(this$0, $text, arg_0), arg_0));
        }

        private static final BasicGrantee findGrantee$lambda$1(Function1 $tmp0, Object p0) {
            return (BasicGrantee)$tmp0.invoke(p0);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0002H\u0005\"\u0010\b\u0003\u0010\u0005\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00050\u0006H\u0082\b\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0015\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/model/properties/Grants$Controller$Companion;", "", "<init>", "()V", "minEnum", "T", "", "()Ljava/lang/Enum;", "minState", "Lcom/intellij/database/model/properties/Grants$State;", "minId", "", "nextId", "id", "nextName", "", "name", "deserializeState", "text", "deserializeKind", "Lcom/intellij/database/model/ObjectKind;", "deserializeId", "serializeKind", "kind", "deserializeSubs", "Ljava/util/BitSet;", "intellij.database.core.impl"})
        @SourceDebugExtension(value={"SMAP\nGrants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Controller$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,291:1\n219#1:292\n1#2:293\n1342#3,2:294\n*S KotlinDebug\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Controller$Companion\n*L\n220#1:292\n248#1:294,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final /* synthetic */ <T extends Enum<T>> T minEnum() {
                boolean $i$f$minEnum = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                Object[] objectArray = Enum.class.getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getEnumConstants(...)");
                Object object = ArraysKt.first((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                return (T)((Enum)object);
            }

            @NotNull
            public final State minState() {
                Companion this_$iv = this;
                boolean $i$f$minEnum = false;
                Object[] objectArray = State.class.getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getEnumConstants(...)");
                Object object = ArraysKt.first((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                return (State)((Enum)object);
            }

            public final long minId() {
                return Long.MIN_VALUE;
            }

            public final long nextId(long id) {
                return id + 1L;
            }

            @NotNull
            public final String nextName(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return name + "\u0000";
            }

            @NotNull
            public final State deserializeState(@Nullable String text2) {
                State state;
                State state2;
                block3: {
                    String string = text2;
                    if (!(string != null ? string.length() == 1 : false)) {
                        return State.GRANT;
                    }
                    char c2 = text2.charAt(0);
                    State[] stateArray = State.values();
                    int n = stateArray.length;
                    for (int j = 0; j < n; ++j) {
                        State state3;
                        State it = state3 = stateArray[j];
                        boolean bl = false;
                        if (!(it.getCode() == c2)) continue;
                        state2 = state3;
                        break block3;
                    }
                    state2 = state = null;
                }
                if (state2 == null) {
                    state = State.GRANT;
                }
                return state;
            }

            @NotNull
            public final ObjectKind deserializeKind(@Nullable String text2) {
                CharSequence charSequence = text2;
                if (charSequence == null || charSequence.length() == 0) {
                    ObjectKind objectKind = ObjectKind.NONE;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"NONE");
                    return objectKind;
                }
                ObjectKind objectKind = ObjectKind.getKind((String)text2);
                if (objectKind == null) {
                    ObjectKind objectKind2 = ObjectKind.NONE;
                    objectKind = objectKind2;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"NONE");
                }
                return objectKind;
            }

            public final long deserializeId(@Nullable String text2) {
                String string = StringKt.nullize$default((String)text2, (boolean)false, (int)1, null);
                return string != null ? Long.parseLong(string) : Long.MIN_VALUE;
            }

            @NotNull
            public final String serializeKind(@NotNull ObjectKind kind) {
                ObjectKind objectKind;
                Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
                ObjectKind it = objectKind = kind;
                boolean bl = false;
                Object object = !Intrinsics.areEqual((Object)it, (Object)ObjectKind.NONE) ? objectKind : null;
                if (object == null || (object = object.code()) == null) {
                    object = "";
                }
                return object;
            }

            @Nullable
            public final BitSet deserializeSubs(@Nullable String text2) {
                CharSequence charSequence = text2;
                if (charSequence == null || charSequence.length() == 0) {
                    return null;
                }
                BitSet subs = new BitSet();
                String[] stringArray = new String[]{","};
                Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)StringsKt.splitToSequence$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null), Companion::deserializeSubs$lambda$0);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    subs.set(it);
                }
                return subs;
            }

            private static final Integer deserializeSubs$lambda$0(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.toIntOrNull((String)it);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                try {
                    nArray[State.GRANT_WITH_GRANT_OPTION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.GRANT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.REVOKE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[State.DENY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B#\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0005J\u0014\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u0096\u0080\u0004R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/intellij/database/model/properties/Grants$Grant;", "", "subs", "Ljava/util/BitSet;", "permission", "", "state", "Lcom/intellij/database/model/properties/Grants$State;", "<init>", "(Ljava/util/BitSet;Ljava/lang/String;Lcom/intellij/database/model/properties/Grants$State;)V", "getState", "()Lcom/intellij/database/model/properties/Grants$State;", "getPermission", "()Ljava/lang/String;", "permissionName", "getPermissionName", "mySubs", "isSub", "", "()Z", "subsStream", "Ljava/util/stream/IntStream;", "getSubsStream", "()Ljava/util/stream/IntStream;", "getSubs", "()Ljava/util/BitSet;", "hasGrantOption", "serializeSubs", "equals", "other", "hashCode", "", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nGrants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Grants.kt\ncom/intellij/database/model/properties/Grants$Grant\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n1#2:292\n*E\n"})
    public static abstract class Grant {
        @NotNull
        private final State state;
        @NotNull
        private final String permission;
        @Nullable
        private final BitSet mySubs;

        /*
         * Unable to fully structure code
         */
        protected Grant(@Nullable BitSet subs, @NotNull String permission, @NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super();
            this.state = state;
            v0 = DbUtil.intern((String)permission);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"intern(...)");
            this.permission = v0;
            v1 = this;
            v2 = subs;
            if (v2 == null) ** GOTO lbl-1000
            var5_5 = var4_4 = v2;
            var7_6 = v1;
            $i$a$-takeIf-Grants$Grant$mySubs$1 = false;
            var8_8 = it.isEmpty() == false;
            v1 = var7_6;
            v2 = var8_8 != false ? var4_4 : null;
            if (v2 != null) {
                it = v2;
                var7_6 = v1;
                $i$a$-run-Grants$Grant$mySubs$2 = false;
                v3 = $this$mySubs_u24lambda_u241.clone();
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type java.util.BitSet");
                v4 = (BitSet)v3;
                v1 = var7_6;
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            v1.mySubs = v4;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        @NotNull
        public final String getPermission() {
            return this.permission;
        }

        @NotNull
        public final String getPermissionName() {
            String string = StringUtil.toLowerCase((String)this.permission);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public final boolean isSub() {
            return this.mySubs != null;
        }

        @NotNull
        public final IntStream getSubsStream() {
            IntStream intStream;
            if (this.mySubs == null) {
                IntStream intStream2 = IntStream.empty();
                intStream = intStream2;
                Intrinsics.checkNotNullExpressionValue((Object)intStream2, (String)"empty(...)");
            } else {
                IntStream intStream3 = this.mySubs.stream();
                intStream = intStream3;
                Intrinsics.checkNotNullExpressionValue((Object)intStream3, (String)"stream(...)");
            }
            return intStream;
        }

        @Nullable
        public final BitSet getSubs() {
            BitSet bitSet = this.mySubs;
            return (BitSet)(bitSet != null ? bitSet.clone() : null);
        }

        public final boolean hasGrantOption() {
            return this.state.getWithGrantOption();
        }

        @NotNull
        public final String serializeSubs() {
            StringBuilder sb = new StringBuilder();
            if (this.mySubs != null) {
                int l = sb.length();
                PrimitiveIterator.OfInt it = this.mySubs.stream().iterator();
                while (it.hasNext()) {
                    if (l != sb.length()) {
                        sb.append(",");
                    }
                    Integer n = it.next();
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"next(...)");
                    sb.append(((Number)n).intValue());
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Grant && Intrinsics.areEqual((Object)this.permission, (Object)((Grant)other).permission) && this.state == ((Grant)other).state && Intrinsics.areEqual((Object)this.mySubs, (Object)((Grant)other).mySubs);
        }

        public int hashCode() {
            int result = this.permission.hashCode();
            result = 31 * result + this.state.hashCode();
            BitSet bitSet = this.mySubs;
            result = 31 * result + (bitSet != null ? bitSet.hashCode() : 0);
            return result;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/model/properties/Grants$State;", "", "code", "", "<init>", "(Ljava/lang/String;IC)V", "getCode", "()C", "GRANT", "GRANT_WITH_GRANT_OPTION", "REVOKE", "DENY", "term", "", "getTerm", "()Ljava/lang/String;", "withGrantOption", "", "getWithGrantOption", "()Z", "intellij.database.core.impl"})
    public static final class State
    extends Enum<State> {
        private final char code;
        public static final /* enum */ State GRANT = new State('G');
        public static final /* enum */ State GRANT_WITH_GRANT_OPTION = new GRANT_WITH_GRANT_OPTION("GRANT_WITH_GRANT_OPTION", 1);
        public static final /* enum */ State REVOKE = new State('R');
        public static final /* enum */ State DENY = new State('D');
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private State(char code) {
            this.code = code;
        }

        public final char getCode() {
            return this.code;
        }

        @NotNull
        public String getTerm() {
            String string = StringUtil.toLowerCase((String)this.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public final boolean getWithGrantOption() {
            return this == GRANT_WITH_GRANT_OPTION;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ State(String $enum$name, int $enum$ordinal, char code, DefaultConstructorMarker $constructor_marker) {
            this(code);
        }

        static {
            $VALUES = stateArray = new State[]{State.GRANT, State.GRANT_WITH_GRANT_OPTION, State.REVOKE, State.DENY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"com/intellij/database/model/properties/Grants.State.GRANT_WITH_GRANT_OPTION", "Lcom/intellij/database/model/properties/Grants$State;", "term", "", "getTerm", "()Ljava/lang/String;", "intellij.database.core.impl"})
        static final class GRANT_WITH_GRANT_OPTION
        extends State {
            /*
             * WARNING - void declaration
             */
            GRANT_WITH_GRANT_OPTION() {
                void var1_1;
            }

            @Override
            @NotNull
            public String getTerm() {
                return GRANT.getTerm();
            }
        }
    }
}

