/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.BatchesContainer;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a:\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\r0\u0001\"\u0004\b\u0000\u0010\r*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011\u001a:\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\r0\u0001\"\u0004\b\u0000\u0010\r*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011\u001a3\u0010\u0013\u001a\u0002H\r\"\u0004\b\u0000\u0010\r*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011\u00a2\u0006\u0002\u0010\u0014\u001a\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019\u001a&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u001c0\u001b\"\u0004\b\u0000\u0010\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\r0\u001d\"\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"executeBatch", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "batches", "Lcom/intellij/database/dataSource/connection/statements/BatchesContainer;", "runWithoutReporting", "T", "stage", "Lcom/intellij/database/dataSource/connection/statements/StagedException$Stage;", "runnable", "Lkotlin/Function0;", "runReporting", "runReportingAndGet", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/statements/StagedException$Stage;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "trimSql", "", "sql", "maxChars", "", "consumer", "Lkotlin/Function1;", "", "Lcom/intellij/util/Consumer;", "logPath", "Ljava/io/File;", "getLogPath", "()Ljava/io/File;", "intellij.database.core.impl"})
@JvmName(name="SmartStatementsUtil")
public final class SmartStatementsUtil {
    @NotNull
    public static final Either<StagedException, ClosableResultsProducer> executeBatch(@NotNull RemoteStatement statement, @NotNull DatabaseConnectionCore connection, @NotNull SmartStatementMark mark2, @NotNull BatchesContainer batches) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Intrinsics.checkNotNullParameter((Object)batches, (String)"batches");
        return SmartStatementsUtil.runReporting(connection, StagedException.Stage.EXECUTE, mark2, () -> SmartStatementsUtil.executeBatch$lambda$0(connection, batches, mark2, statement));
    }

    @NotNull
    public static final <T> Either<StagedException, T> runWithoutReporting(@NotNull DatabaseConnectionCore $this$runWithoutReporting, @NotNull StagedException.Stage stage, @NotNull SmartStatementMark mark2, @NotNull Function0<? extends T> runnable) {
        Either<Object, Object> either;
        Intrinsics.checkNotNullParameter((Object)$this$runWithoutReporting, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        try {
            either = Either.Companion.right(runnable.invoke());
        }
        catch (SQLException e) {
            either = Either.Companion.left(new StagedException(e, stage));
        }
        return either;
    }

    @NotNull
    public static final <T> Either<StagedException, T> runReporting(@NotNull DatabaseConnectionCore $this$runReporting, @NotNull StagedException.Stage stage, @NotNull SmartStatementMark mark2, @NotNull Function0<? extends T> runnable) {
        Either<Object, Object> either;
        Intrinsics.checkNotNullParameter((Object)$this$runReporting, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        try {
            either = Either.Companion.right(runnable.invoke());
        }
        catch (SQLException e) {
            $this$runReporting.getAuditService().error(e, mark2);
            either = Either.Companion.left(new StagedException(e, stage));
        }
        return either;
    }

    public static final <T> T runReportingAndGet(@NotNull DatabaseConnectionCore $this$runReportingAndGet, @NotNull StagedException.Stage stage, @NotNull SmartStatementMark mark2, @NotNull Function0<? extends T> runnable) {
        Intrinsics.checkNotNullParameter((Object)$this$runReportingAndGet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        Either<StagedException, T> result = SmartStatementsUtil.runReporting($this$runReportingAndGet, stage, mark2, runnable);
        if (result.isLeft()) {
            StagedException stagedException = result.getLeft();
            Intrinsics.checkNotNull((Object)stagedException);
            throw (Throwable)stagedException;
        }
        T t = result.getRight();
        Intrinsics.checkNotNull(t);
        return t;
    }

    @NotNull
    public static final String trimSql(@NotNull String sql, int maxChars) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        if (sql.length() <= maxChars) {
            return sql;
        }
        String string = sql.substring(0, maxChars);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String substring = string;
        int difference = sql.length() - maxChars;
        String moreString = "-- and " + difference + " " + StringUtil.pluralize((String)"character", (int)difference) + " more...";
        return moreString.length() >= difference ? sql : substring + " " + moreString;
    }

    @NotNull
    public static final <T> Function1<T, Unit> consumer(@NotNull Consumer<T> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return arg_0 -> SmartStatementsUtil.consumer$lambda$0(consumer, arg_0);
    }

    @NotNull
    public static final File getLogPath() {
        return new File(new File(PathManager.getSystemPath(), "database-log"), "database.0.log");
    }

    private static final boolean executeBatch$lambda$0$0(int it) {
        return it >= 0;
    }

    private static final Unit executeBatch$lambda$0$1(RemoteStatement $statement) {
        $statement.clearBatch();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClosableResultsProducer executeBatch$lambda$0(DatabaseConnectionCore $connection, BatchesContainer $batches, SmartStatementMark $mark, RemoteStatement $statement) {
        ClosableResultsProducer closableResultsProducer;
        AdvancedAuditService advancedAuditService = $connection.getAuditService();
        Intrinsics.checkNotNullExpressionValue((Object)advancedAuditService, (String)"getAuditService(...)");
        AdvancedAuditService auditService = advancedAuditService;
        try {
            int[] nArray;
            try {
                auditService.beforeSimpleStatement($batches.getSql(), $mark);
                nArray = $statement.executeBatch();
            }
            finally {
                auditService.afterStatement($mark);
            }
            int[] updates = nArray;
            Intrinsics.checkNotNull((Object)updates);
            int sum = SequencesKt.sumOfInt((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((int[])updates), SmartStatementsUtil::executeBatch$lambda$0$0));
            if (sum > 0) {
                auditService.updateCount(sum, $mark);
            }
            closableResultsProducer = new ClosableResultsProducer(updates){
                private int currentIdx;
                final /* synthetic */ int[] $updates;
                {
                    this.$updates = $updates;
                    this.currentIdx = -1;
                }

                public void processRemaining(ResultsProducer.Processor<Unit> processor) {
                    Intrinsics.checkNotNullParameter(processor, (String)"processor");
                    while (this.advance()) {
                        this.processCurrent(processor);
                    }
                }

                public boolean advance() {
                    ++this.currentIdx;
                    return this.currentIdx < this.$updates.length;
                }

                public <T> T processCurrent(ResultsProducer.Processor<T> processor) {
                    Intrinsics.checkNotNullParameter(processor, (String)"processor");
                    return processor.updateCount(this.$updates[this.currentIdx]);
                }

                public <T> Void getParameterValue(OutParameter<T> parameter) {
                    Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
                    throw new IllegalStateException("This statement has no out parameters");
                }

                public Object getParameterValue(int index) {
                    return null;
                }

                public void close() {
                }
            };
        }
        finally {
            try {
                auditService.resultsProcessed($mark);
            }
            finally {
                $batches.clear();
                SmartStatementsUtil.runReporting($connection, StagedException.Stage.BATCH_CLEARING, $mark, () -> SmartStatementsUtil.executeBatch$lambda$0$1($statement));
            }
        }
        return closableResultsProducer;
    }

    private static final Unit consumer$lambda$0(Consumer $consumer, Object it) {
        $consumer.consume(it);
        return Unit.INSTANCE;
    }
}

