/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.GeoHelper;
import com.intellij.database.datagrid.BaseObjectNormalizer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.extractors.DatabaseFormatterCreator;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DbObjectFormatterUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.TextInfo;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.database.remote.jdbc.GeoWrapper;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.NestedObjectWrapper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.UnparsedValue;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ResultReference;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.util.ObjectUtils;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.rmi.Remote;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectNormalizer
extends BaseObjectNormalizer {
    private final FormatterCreator myFormatterCreator;
    private final FormatsCache myFormatsCache;
    private final Dbms myDbms;

    public DatabaseObjectNormalizer(@NotNull Dbms dbms) {
        if (dbms == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(0);
        }
        this.myFormatsCache = new FormatsCache();
        this.put(TimeZonedValue.class, this.identity);
        this.put(LocalTime.class, this.identity);
        this.register(OffsetTime.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<OffsetTime, Object>(this){

            public TimeZonedTime convert(OffsetTime o, GridColumn column) {
                return new TimeZonedTime(o);
            }
        });
        this.register(ZonedDateTime.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<ZonedDateTime, Object>(this){

            public TimeZonedTimestamp convert(ZonedDateTime o, GridColumn column) {
                return new TimeZonedTimestamp(o.toOffsetDateTime());
            }
        });
        this.put(LobInfo.ClobInfo.class, this.identity);
        this.put(MongoJdbcHelper.MongoValue.class, this.identity);
        this.put(MongoJdbcHelper.MongoBlobInfo.class, this.identity);
        this.put(NestedObjectWrapper.class, this.identity);
        this.put(TextInfo.class, this.identity);
        this.put(ImageInfo.class, this.identity);
        this.put(GeoWrapper.class, this.identity);
        this.register(LobInfo.BlobInfo.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<LobInfo.BlobInfo, Object>(this){

            public Object convert(LobInfo.BlobInfo o, GridColumn column) {
                if (o.isTruncated()) {
                    return o;
                }
                Object detectedObject = DatabaseObjectNormalizer.tryDetectObject(o.data);
                return ObjectUtils.chooseNotNull((Object)detectedObject, (Object)o);
            }
        });
        this.register(UnparsedValue.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<UnparsedValue, Object>(){

            public Object convert(UnparsedValue o, GridColumn column) {
                return DatabaseObjectNormalizer.convertUnparsedValue(o, column, DatabaseObjectNormalizer.this.myFormatsCache, DatabaseObjectNormalizer.this.myFormatterCreator);
            }
        });
        this.register(BitString.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<BitString, Object>(this){

            public Object convert(BitString o, GridColumn column) {
                return DbObjectFormatterUtil.bitsToString(o, column);
            }
        });
        this.register(Date.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<Date, Object>(){

            public Object convert(Date o, GridColumn column) {
                String className;
                String string = className = column instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)column).getJavaClassName() : null;
                if (DatabaseObjectNormalizer.this.myDbms.is(Dbms.MONGO) || className != null && (className.endsWith("Timestamp") || className.endsWith("DateTime"))) {
                    return new Timestamp(o.getTime());
                }
                if (className != null && className.endsWith("Time")) {
                    return new Time(o.getTime());
                }
                return o;
            }
        });
        this.register(byte[].class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<byte[], Object>(){

            public Object convert(byte[] o, GridColumn column) {
                Object detectedObject = DatabaseObjectNormalizer.this.determineDetectedObject(o, column);
                return detectedObject != null ? detectedObject : LobInfo.fromByteArray((byte[])o, (int)o.length);
            }
        });
        this.register(Clob.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<Clob, Object>(this){

            public Object convert(Clob o, GridColumn column) {
                try {
                    return LobInfo.fromClob((Clob)o, (int)((int)o.length()));
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        this.register(Blob.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<Blob, Object>(this){

            public Object convert(Blob o, GridColumn column) {
                try {
                    return LobInfo.fromBlob((Blob)o, (int)((int)o.length()));
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        this.register(String.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<String, Object>(){

            public Object convert(String o, GridColumn column) {
                boolean isPgWithGeoType;
                GeoHelper geoHelper = (GeoHelper)GeoHelper.EP.forDbms(DatabaseObjectNormalizer.this.myDbms);
                boolean isShowGeoAsBinary = DatabaseSettings.getSettings().isShowGeoAsBinary();
                boolean bl = isPgWithGeoType = DatabaseObjectNormalizer.this.myDbms.isPostgres() && column.getTypeName() != null && geoHelper.isGeoType(column.getTypeName()) && !isShowGeoAsBinary;
                if (isPgWithGeoType) {
                    try {
                        String wkt = geoHelper.extractGeometryAsWkt(o, column);
                        byte[] binary = geoHelper.extractBinaryFromWkt(wkt, 0);
                        return new GeoWrapper(binary, wkt);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return LobInfo.fromString((String)o, (int)o.length());
            }
        });
        this.register(Map.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<Map, Object>(){

            public Object convert(Map o, GridColumn column) {
                return DatabaseObjectNormalizer.this.myDbms.isCassandra() || DbObjectFormatterUtil.isHstore(column) || DatabaseObjectNormalizer.this.myDbms.in(Dbms.DOCUMENT_ORIENTED) || DatabaseObjectNormalizer.this.myDbms.is(Dbms.CLICKHOUSE) ? o : null;
            }
        });
        this.register(Set.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<Set, Object>(){

            public Object convert(Set o, GridColumn column) {
                return DatabaseObjectNormalizer.this.myDbms.isCassandra() ? o : null;
            }
        });
        this.register(List.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<List, Object>(){

            public Object convert(List o, GridColumn column) {
                return DatabaseObjectNormalizer.this.myDbms.isCassandra() || DatabaseObjectNormalizer.this.myDbms.in(Dbms.DOCUMENT_ORIENTED) || DatabaseObjectNormalizer.this.myDbms.is(Dbms.CLICKHOUSE) ? o : null;
            }
        });
        this.register(InetAddress.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<InetAddress, Object>(){

            public Object convert(InetAddress o, GridColumn column) {
                if (!DatabaseObjectNormalizer.this.myDbms.isCassandra()) {
                    return null;
                }
                String value = o.toString();
                return value.substring(value.indexOf("/") + 1);
            }
        });
        this.register(UUID.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<UUID, Object>(){

            public Object convert(UUID o, GridColumn column) {
                return DatabaseObjectNormalizer.this.myDbms.isMongo() ? o : o.toString();
            }
        });
        this.register(ReservedCellValue.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<ReservedCellValue, Object>(this){

            public Object convert(ReservedCellValue o, GridColumn column) {
                return o;
            }
        });
        this.register(Remote.class, (BaseObjectNormalizer.Converter)new BaseObjectNormalizer.Converter<Remote, Object>(this){

            public Object convert(Remote o, GridColumn column) {
                return new ResultReference((Object)o);
            }
        });
        this.myDbms = dbms;
        this.myFormatterCreator = new DatabaseFormatterCreator(this.myDbms);
    }

    private Object determineDetectedObject(byte[] o, GridColumn column) {
        boolean isMysqlWithGeoType;
        GeoHelper geoHelper = (GeoHelper)GeoHelper.EP.forDbms(this.myDbms);
        boolean isMsHierarchyid = DbObjectFormatterUtil.isMsHierarchyid(this.myDbms, column);
        boolean isShowGeoAsBinary = DatabaseSettings.getSettings().isShowGeoAsBinary();
        boolean bl = isMysqlWithGeoType = this.myDbms.isMysql() && column.getTypeName() != null && geoHelper.isGeoType(column.getTypeName());
        if (isMsHierarchyid) {
            return null;
        }
        if (isMysqlWithGeoType && !isShowGeoAsBinary) {
            return new GeoWrapper(o, geoHelper.extractGeometryAsWkt(o, column));
        }
        return DatabaseObjectNormalizer.tryDetectObject(o);
    }

    @NotNull
    protected Class<?> getClass(@NotNull Object o) {
        Class c2;
        if (o == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(1);
        }
        Class clazz = DatabaseObjectNormalizer.isRemote(c2 = super.getClass(o)) ? Remote.class : c2;
        if (clazz == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    private static boolean isRemote(@NotNull Class<?> c2) {
        if (c2 == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(3);
        }
        if (Proxy.isProxyClass(c2)) {
            for (Class<Remote> clazz : c2.getInterfaces()) {
                if (!clazz.isAssignableFrom(Remote.class)) continue;
                return true;
            }
            return false;
        }
        return c2.isAssignableFrom(Remote.class);
    }

    @NotNull
    public static Object convertUnparsedValue(@NotNull UnparsedValue o, @NotNull GridColumn column, @NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        if (o == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(4);
        }
        if (column == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(5);
        }
        if (formatsCache == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(6);
        }
        if (formatterCreator == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(7);
        }
        String stringValue = o.getStringRepresentation();
        ParsePosition position = new ParsePosition(0);
        DatabaseObjectFormatterConfig config = new DatabaseObjectFormatterConfig(ObjectFormatterMode.NORMALIZE);
        FormatsCache.FormatProvider provider = switch (o.getKind()) {
            default -> throw new MatchException(null, null);
            case UnparsedValueKind.DATE -> FormatsCache.getDateFormatProvider((GridColumn)column, (ObjectFormatterConfig)config);
            case UnparsedValueKind.TIME -> FormatsCache.getTimeFormatProvider((GridColumn)column, (ObjectFormatterConfig)config);
            case UnparsedValueKind.TIMESTAMP -> FormatsCache.getTimestampFormatProvider((GridColumn)column, (ObjectFormatterConfig)config);
            case UnparsedValueKind.ZONED_TIME -> FormatsCache.getZonedTimeFormatProvider((GridColumn)column, (ObjectFormatterConfig)config);
            case UnparsedValueKind.ZONED_TIMESTAMP -> FormatsCache.getZonedTimestampFormatProvider((GridColumn)column, (ObjectFormatterConfig)config);
        };
        Object parsedValue = ((Formatter)formatsCache.get(provider, formatterCreator)).parse(stringValue, position);
        Object object = ObjectUtils.notNull((Object)parsedValue, (Object)stringValue);
        if (object == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(8);
        }
        return object;
    }

    @Nullable
    private static Object tryDetectObject(byte @NotNull [] bytes) {
        ImageInfo image;
        if (bytes == null) {
            DatabaseObjectNormalizer.$$$reportNull$$$0(9);
        }
        if ((image = ImageInfo.tryDetectImage((byte[])bytes)) != null) {
            return image;
        }
        return TextInfo.tryDetectString((byte[])bytes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DatabaseObjectNormalizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DatabaseObjectNormalizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertUnparsedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClass";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRemote";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertUnparsedValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8 -> new IllegalStateException(string);
        };
    }
}

