/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0082\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u0096\u0080\u0004J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/util/CodeMarker;", "A", "", "", "begin", "", "end", "annotation", "<init>", "(IILjava/lang/Object;)V", "getBegin", "()I", "getEnd", "getAnnotation", "()Ljava/lang/Object;", "Ljava/lang/Object;", "compareTo", "other", "toString", "", "equals", "", "that", "intellij.database.core.impl"})
public final class CodeMarker<A>
implements Comparable<CodeMarker<A>> {
    private final int begin;
    private final int end;
    @NotNull
    private final A annotation;

    public CodeMarker(int begin, int end, @NotNull A annotation) {
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        this.begin = begin;
        this.end = end;
        this.annotation = annotation;
    }

    public final int getBegin() {
        return this.begin;
    }

    public final int getEnd() {
        return this.end;
    }

    @NotNull
    public final A getAnnotation() {
        return this.annotation;
    }

    @Override
    public int compareTo(@NotNull CodeMarker<A> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (this == other) {
            return 0;
        }
        int z = this.begin - other.begin;
        if (z == 0) {
            z = -(this.end - other.end);
        }
        if (z == 0) {
            z = this.annotation.hashCode() - other.annotation.hashCode();
        }
        return z;
    }

    @NotNull
    public String toString() {
        return this.begin + ".." + this.end + " -> " + this.annotation;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CodeMarker && this.equals((CodeMarker)other);
    }

    public final boolean equals(@NotNull CodeMarker<?> that) {
        Intrinsics.checkNotNullParameter(that, (String)"that");
        return this.begin == that.begin && this.end == that.end && Intrinsics.areEqual(this.annotation, that.annotation);
    }
}

