/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.artifacts;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.ConfigUrlBean;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.util.Version;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.APP})
@ApiStatus.Internal
public final class DatabaseArtifactManager {
    private static final Logger LOG = Logger.getInstance(DatabaseArtifactManager.class);
    public static final String PROPERTY_DISABLE_ARTIFACT_UPDATES = "datagrip.disable.artifact.updates";
    public static final Topic<ArtifactListener> TOPIC = new Topic("ARTIFACTS_TOPIC", ArtifactListener.class);
    private static final int UPDATE_LIST_TIMEOUT_MS = 86400000;
    private volatile DatabaseArtifactList myArtifactList = DatabaseArtifactList.EMPTY;
    private volatile boolean myLoaded = true;
    private Long myLastUpdate = null;
    private final Object myFileLock = new Object();
    private final Object myLock = new Object();

    @NotNull
    public static DatabaseArtifactManager getInstance() {
        DatabaseArtifactManager databaseArtifactManager = (DatabaseArtifactManager)ApplicationManager.getApplication().getService(DatabaseArtifactManager.class);
        if (databaseArtifactManager == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(0);
        }
        return databaseArtifactManager;
    }

    public static DatabaseArtifactList getArtifacts() {
        return DatabaseArtifactManager.getInstance().getArtifactList();
    }

    @TestOnly
    public static void setArtifactsList(@Nullable DatabaseArtifactList list) {
        DatabaseArtifactManager instance = DatabaseArtifactManager.getInstance();
        if (list != null) {
            instance.myArtifactList = list;
        } else {
            instance.loadArtifacts(false);
        }
    }

    private DatabaseArtifactManager() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode()) {
            this.loadArtifacts(false);
            return;
        }
        File file = DatabaseArtifactLoader.getInstance().getLocalArtifactListPath().toFile();
        app.executeOnPooledThread(() -> this.loadArtifacts(file.exists()));
        DatabaseArtifactList.CONFIG_EP.addChangeListener(() -> {
            this.myLoaded = false;
        }, null);
    }

    private void loadArtifacts(boolean localOnly) {
        if (!localOnly) {
            this.loadArtifactsList();
        }
        this.loadLocalArtifactsList();
    }

    @NotNull
    public DatabaseArtifactList getArtifactList() {
        this.checkForUpdates();
        DatabaseArtifactList databaseArtifactList = this.myArtifactList;
        if (databaseArtifactList == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(1);
        }
        return databaseArtifactList;
    }

    @NotNull
    public CompletionStage<?> forceUpdate(@Nullable Project project) {
        return this.updateLists(project, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates() {
        boolean notLoaded;
        boolean outdated;
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isUnitTestMode()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            outdated = this.isOutdated();
            if (outdated) {
                this.setLastUpdate(System.currentTimeMillis());
            }
            notLoaded = !outdated && !this.myLoaded;
            this.myLoaded = true;
        }
        if (outdated) {
            this.updateLists(null, true);
        } else if (notLoaded) {
            this.initLocal();
            DatabaseArtifactManager.listLoaded();
        }
    }

    private void initLocal() {
        try {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.loadLocalArtifactsList()).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private CompletionStage<?> updateLists(@Nullable Project project, boolean background) {
        this.setLastUpdate(System.currentTimeMillis());
        final CompletableFuture res = new CompletableFuture();
        new Task.ConditionalModal(project, DatabaseBundle.message((String)"progress.title.update.database.drivers.list", (Object[])new Object[0]), false, () -> background){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(DatabaseBundle.message((String)"progress.text.loading.database.drivers.list", (Object[])new Object[0]));
                DatabaseArtifactManager.this.loadRemoteArtifactList();
                DatabaseArtifactManager.this.initLocal();
                DatabaseArtifactManager.listLoaded();
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.onThrowable(error);
                res.completeExceptionally(error);
            }

            public void onCancel() {
                res.completeExceptionally(new ProcessCanceledException());
            }

            public void onSuccess() {
                res.complete(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
        CompletableFuture completableFuture = res;
        if (completableFuture == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    private static void listLoaded() {
        ApplicationManager.getApplication().invokeLater(() -> DatabaseArtifactManager.fireChanged(null));
    }

    private static boolean isArtifactUpdatesDisabled() {
        return SystemProperties.getBooleanProperty((String)PROPERTY_DISABLE_ARTIFACT_UPDATES, (boolean)false);
    }

    private boolean isOutdated() {
        if (DatabaseArtifactManager.isArtifactUpdatesDisabled()) {
            return false;
        }
        if (this.myLastUpdate == null) {
            File path = DatabaseArtifactLoader.getInstance().getLocalArtifactListPath().toFile();
            if (path.exists()) {
                this.myLastUpdate = path.lastModified();
            } else {
                return true;
            }
        }
        return System.currentTimeMillis() - this.myLastUpdate > 86400000L;
    }

    private void loadRemoteArtifactList() {
        this.loadArtifactsList();
        this.loadLocalArtifactsList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalArtifactsList() {
        File listFile = DatabaseArtifactLoader.getInstance().getLocalArtifactListPath().toFile();
        DatabaseArtifactList list = new DatabaseArtifactList(false, new URL[0]);
        Exception wentWrong = null;
        boolean remoteLoadFailed = false;
        Object object = this.myFileLock;
        synchronized (object) {
            if (listFile.exists()) {
                try {
                    list.loadList(listFile.toURI().toURL(), false);
                }
                catch (Exception e) {
                    wentWrong = e;
                }
                remoteLoadFailed = list.getArtifacts().isEmpty();
            }
            for (URL builtin : DatabaseArtifactManager.getBuiltinArtifactLists()) {
                try {
                    list.loadList(builtin, false);
                }
                catch (Exception e) {
                    LOG.warn("Unable to load " + builtin.toString(), (Throwable)e);
                }
            }
        }
        if (remoteLoadFailed) {
            LOG.warn("Unable to load " + listFile.getName() + ". Will delete", (Throwable)wentWrong);
            FileUtil.delete((File)listFile);
            object = this.myLock;
            synchronized (object) {
                this.myLoaded = false;
                this.setLastUpdate(System.currentTimeMillis() - 86400000L + 300000L);
            }
        }
        this.myArtifactList = list;
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication().getMessageBus(), () -> DatabaseArtifactManager.fireChanged(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastUpdate(Long lastUpdate) {
        Object object = this.myLock;
        synchronized (object) {
            this.myLastUpdate = lastUpdate;
        }
    }

    private void loadArtifactsList() {
        if (DatabaseArtifactManager.isArtifactUpdatesDisabled()) {
            return;
        }
        File file = DatabaseArtifactLoader.getInstance().getLocalArtifactListPath().toFile();
        boolean tests = ApplicationManager.getApplication().isUnitTestMode();
        if (!tests) {
            this.loadProvidedArtifactList(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProvidedArtifactList(File file) {
        try {
            byte[] text2 = DatabaseArtifactLoader.getInstance().loadArtifactList();
            if (text2 == null) {
                return;
            }
            Object object = this.myFileLock;
            synchronized (object) {
                FileUtil.writeToFile((File)file, (byte[])text2);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public static @Unmodifiable List<URL> getBuiltinArtifactLists() {
        List<URL> extensionUrls = ConfigUrlBean.getUrls(DatabaseArtifactList.CONFIG_EP.getExtensionsIfPointIsRegistered());
        return ContainerUtil.concat(extensionUrls, DatabaseArtifactLoader.getInstance().getTestArtifactLists());
    }

    private static void fireChanged(@Nullable DatabaseArtifactList.ArtifactVersion version) {
        ((ArtifactListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).artifactChanged(version);
    }

    public void downloadArtifact(@NotNull DatabaseArtifactList.ArtifactVersion version, @NotNull DatabaseArtifactContext context, @Nullable Consumer<? super DatabaseArtifactList.ArtifactVersion> onFinish) throws IOException {
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(3);
        }
        if (context == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(4);
        }
        DatabaseArtifactLoader.getInstance().downloadArtifact(version, context);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (onFinish != null) {
                onFinish.consume((Object)version);
            }
            DatabaseArtifactManager.fireChanged(version);
        });
    }

    @NotNull
    public static List<SimpleClasspathElement> getClasspathElements(@NotNull String id, @NotNull Version version, @NotNull DatabaseArtifactContext context) {
        if (id == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(5);
        }
        if (version == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(6);
        }
        if (context == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(7);
        }
        if (Version.INFINITY.equals((Object)version)) {
            throw new AssertionError((Object)"Should be concrete version");
        }
        DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
        DatabaseArtifactList.ArtifactVersion resolved = DatabaseArtifactManager.getArtifacts().resolveVersion(id, version);
        final ArrayList<String> urls = new ArrayList<String>();
        if (resolved != null) {
            List<Path> paths = loader.getClasspathElements(resolved, context).stream().toList();
            for (Path path : paths) {
                urls.add(VfsUtilCore.pathToUrl((String)path.toString()));
            }
        } else {
            Path dir = loader.getArtifactDir(DatabaseArtifactManager.getArtifacts(), id, version, context);
            if (Files.exists(dir, new LinkOption[0])) {
                try {
                    Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        @NotNull
                        public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attrs) throws IOException {
                            if (path == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (attrs == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            urls.add(VfsUtilCore.pathToUrl((String)path.toString()));
                            FileVisitResult fileVisitResult = super.visitFile(path, attrs);
                            if (fileVisitResult == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            return fileVisitResult;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 2 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "path";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "attrs";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactManager$2";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactManager$2";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "visitFile";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "visitFile";
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 2 -> new IllegalStateException(string);
                            };
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        List list = SimpleClasspathElementFactory.createElements((String[])ArrayUtil.toStringArray(urls));
        if (list == null) {
            DatabaseArtifactManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    public static boolean hasClasspathElementsFast(@NotNull String id, @NotNull Version version, @NotNull DatabaseArtifactContext context) {
        boolean bl;
        block13: {
            if (id == null) {
                DatabaseArtifactManager.$$$reportNull$$$0(9);
            }
            if (version == null) {
                DatabaseArtifactManager.$$$reportNull$$$0(10);
            }
            if (context == null) {
                DatabaseArtifactManager.$$$reportNull$$$0(11);
            }
            if (Version.INFINITY.equals((Object)version)) {
                throw new AssertionError((Object)"Should be concrete version");
            }
            DatabaseArtifactLoader loader = DatabaseArtifactLoader.getInstance();
            DatabaseArtifactList.ArtifactVersion resolved = DatabaseArtifactManager.getArtifacts().resolveVersion(id, version);
            if (resolved != null) {
                return loader.hasClasspathElementsFast(resolved, context);
            }
            Path dir = loader.getArtifactDir(DatabaseArtifactManager.getArtifacts(), id, version, context);
            Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);
            try {
                bl = stream.anyMatch(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                if (stream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return bl;
    }

    @Nullable
    public static DatabaseArtifactList.ArtifactVersion resolveVersion(DatabaseDriver driver, DatabaseDriver.ArtifactRef a) {
        return DatabaseArtifactList.resolveVersion(DatabaseArtifactManager.getArtifacts(), a.getId(), a.getArtifactVersion(), a.getChannel(), driver);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactManager";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "updateLists";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/artifacts/DatabaseArtifactManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "downloadArtifact";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClasspathElements";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasClasspathElementsFast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }

    public static interface ArtifactListener
    extends EventListener {
        public void artifactChanged(@Nullable DatabaseArtifactList.ArtifactVersion var1);
    }
}

