/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cloudExplorer;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.cloudExplorer.CloudConnectionData;
import com.intellij.database.cloudExplorer.CloudDataSourceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="CloudConnectionData", storages={@Storage(value="cloud_connection_data.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0002H\u0016J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000bJ\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/cloudExplorer/CloudConnectionDataStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "connectionsData", "", "Lcom/intellij/database/cloudExplorer/CloudConnectionData;", "getConnectionData", "id", "", "removeConnectionData", "", "target", "update", "findById", "getState", "add", "cloud", "loadState", "state", "getConnectionsData", "", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nCloudConnectionDataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConnectionDataStorage.kt\ncom/intellij/database/cloudExplorer/CloudConnectionDataStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class CloudConnectionDataStorage
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final List<CloudConnectionData> connectionsData;

    public CloudConnectionDataStorage(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.connectionsData = list;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @Nullable
    public final CloudConnectionData getConnectionData(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.findById(id);
    }

    public final void removeConnectionData(@NotNull CloudConnectionData target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.connectionsData.removeIf(arg_0 -> CloudConnectionDataStorage.removeConnectionData$lambda$1(arg_0 -> CloudConnectionDataStorage.removeConnectionData$lambda$0(target, arg_0), arg_0));
    }

    public final void update(@NotNull CloudConnectionData target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        CloudConnectionData existing = this.findById(target.getId());
        if (existing == null) {
            this.add(target);
        }
    }

    private final CloudConnectionData findById(String id) {
        Object v0;
        block1: {
            Iterable iterable = this.connectionsData;
            for (Object t : iterable) {
                CloudConnectionData it = (CloudConnectionData)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public Element getState() {
        Element clouds = new Element("clouds");
        for (CloudConnectionData cloud : this.connectionsData) {
            clouds.addContent(cloud.save(new Element("cloud")));
        }
        return clouds;
    }

    public final void add(@NotNull CloudConnectionData cloud) {
        Intrinsics.checkNotNullParameter((Object)cloud, (String)"cloud");
        this.connectionsData.add(cloud);
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        for (Element cloud : state.getChildren("cloud")) {
            CloudConnectionData data;
            String cloudProviderId;
            if (cloud.getAttributeValue("cloudProviderId") == null) continue;
            CloudConnectionData cloudConnectionData = CloudDataSourceProvider.Companion.createConnectionData(cloudProviderId);
            if (cloudConnectionData != null) {
                Intrinsics.checkNotNull((Object)cloud);
                v1 = cloudConnectionData.load(cloud);
            } else {
                v1 = data = null;
            }
            if (data == null) continue;
            this.add(data);
        }
    }

    @NotNull
    public final List<CloudConnectionData> getConnectionsData() {
        return this.connectionsData;
    }

    private static final boolean removeConnectionData$lambda$0(CloudConnectionData $target, CloudConnectionData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getId(), (Object)$target.getId());
    }

    private static final boolean removeConnectionData$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/cloudExplorer/CloudConnectionDataStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/database/cloudExplorer/CloudConnectionDataStorage;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nCloudConnectionDataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudConnectionDataStorage.kt\ncom/intellij/database/cloudExplorer/CloudConnectionDataStorage$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,66:1\n42#2,3:67\n*S KotlinDebug\n*F\n+ 1 CloudConnectionDataStorage.kt\ncom/intellij/database/cloudExplorer/CloudConnectionDataStorage$Companion\n*L\n64#1:67,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CloudConnectionDataStorage getInstance() {
            boolean $i$f$service = false;
            Class<CloudConnectionDataStorage> serviceClass$iv = CloudConnectionDataStorage.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CloudConnectionDataStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

