/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.state;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.schemaEditor.DbEditorElementReference;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDirectReferenceModelState<T extends BasicElement>
extends DbEditorModelBase.StateBase
implements DbReferenceModelState<T> {
    private ElementIdentity<T> myTargetId;
    private BasicReference myReference;
    private DbModelRef<T, ?> myTargetStructureRef;

    public void setTargetId(@NotNull DbEditorModelController controller, @Nullable ElementIdentity<T> targetId, @Nullable BasicReference reference) {
        if (controller == null) {
            DbDirectReferenceModelState.$$$reportNull$$$0(0);
        }
        this.setTargetId(targetId, targetId == null ? null : DbModelRef.create(controller.getStructureNodeModel(targetId)), reference);
    }

    public void setTargetId(@Nullable ElementIdentity<T> targetId, @Nullable DbModelRef<T, ?> targetStructureRef, @Nullable BasicReference reference) {
        if (Objects.equals(targetId, this.getTargetId()) && Objects.equals(this.myReference, reference) && Objects.equals(this.myTargetStructureRef, targetStructureRef)) {
            return;
        }
        if (reference instanceof DbEditorElementReference) {
            throw new AssertionError((Object)"DbEditorElementReference should not be passed here");
        }
        this.myTargetId = targetId;
        this.myTargetStructureRef = targetStructureRef;
        this.myReference = reference;
        this.modified();
    }

    @Override
    @Nullable
    public BasicReference getActualRef() {
        return this.myReference;
    }

    @Override
    @Nullable
    public ElementIdentity<T> getTargetId() {
        return this.myTargetId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/intellij/database/schemaEditor/model/state/DbDirectReferenceModelState", "setTargetId"));
    }
}

