/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceFacade;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DataSourceSchemasPanel;
import com.intellij.database.dataSource.DataSourceSshSslPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceStorageScope;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.DdlMappingLink;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionComponent;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionManager;
import com.intellij.database.dataSource.ui.DbOptionsEditor;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.dataSource.url.ui.DynamicJdbcUrlEditor;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.properties.Level;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.ui.AdvancedPropertiesPanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DataSourceConfigurable
extends AbstractDataSourceConfigurable<LocalDataSourceManager, LocalDataSource>
implements DataSourceFacade {
    private static final Key<Boolean> RESET_CONNECTION_YES_FOR_ALL_KEY = Key.create((String)"RESET_CONNECTION_YES_FOR_ALL_KEY");
    public static final Key<Function<LocalDataSource, Collection<DatabaseDriver>>> DRIVER_VARIANTS_PROVIDER = Key.create((String)"DRIVER_VARIANTS_PROVIDER");
    private final JPanel myPanel = new JPanel(new BorderLayout(0, 5));
    private JBTabbedPane myTabbedPane;
    private final LocalDataSource myTempDataSource;
    private long myLastSaveStamp;
    private Couple<DataSourceInfo> myConnectionInfo;
    private final DataSourceTestConnectionManager myTestConnectionManager = new DataSourceTestConnectionManager(this);
    private DataSourceTestConnectionComponent myTestConnectionComponent;
    private DatabaseNameComponent myNameComponent;
    private DdlMappingLink myMappingLink;
    private DataSourceGeneralPanel myGeneralPanel;
    private DataSourceSchemasPanel mySchemasPanel;
    private DataSourceOptionsPanel myOptionsPanel;
    private DataSourceSshSslPanel mySshSslPanel;
    private AdvancedPropertiesPanel myAdvancedPanel;
    private DbOptionsEditor.DbOptionsEditors<LocalDataSource> myCustomTabs;
    @NotNull
    private DataSourceStorageScope myStorageScope = DataSourceStorageScope.DSSS_PROJECT;

    public DataSourceConfigurable(LocalDataSourceManager manager, LocalDataSource dataSource, Project project) {
        super(manager, dataSource, project);
        this.myTempDataSource = dataSource.copy(true);
    }

    public void updateDatabaseInfo(@NotNull LocalDataSource source) {
        if (source == null) {
            DataSourceConfigurable.$$$reportNull$$$0(0);
        }
        this.updateDatabaseInfo(source.getInfo());
    }

    public void updateDatabaseInfo(@NotNull DataSourceInfo info2) {
        if (info2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(1);
        }
        this.myConnectionInfo = Couple.of((Object)((LocalDataSource)this.myDataSource).getInfo(), (Object)info2);
    }

    public DataSourceInfo getDatabaseInfo() {
        DataSourceInfo main = ((LocalDataSource)this.myDataSource).getInfo();
        return Objects.equals(Pair.getFirst(this.myConnectionInfo), main) ? (DataSourceInfo)this.myConnectionInfo.second : main;
    }

    public void onTestConnectionUpdate(@NotNull DataSourceTestConnectionManager.TestInfo info2) {
        if (info2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(2);
        }
        if (info2.getSessionTemplateId() == null) {
            this.myTestConnectionComponent.update(info2);
        } else {
            this.myOptionsPanel.getSessionTemplates().update(info2);
        }
    }

    @Override
    @NotNull
    public LocalDataSource getTempDataSource() {
        long curStamp = this.getModificationCount();
        if (curStamp != this.myLastSaveStamp) {
            this.myLastSaveStamp = curStamp;
            this.saveData(this.myTempDataSource, false, true);
        } else {
            this.myTempDataSource.getInfo().copyFrom(this.getDatabaseInfo());
        }
        LocalDataSource localDataSource = this.myTempDataSource;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(3);
        }
        return localDataSource;
    }

    @NotNull
    public LocalDataSource getTempDataSourceForConnection() {
        LocalDataSource ds = ((LocalDataSource)this.myDataSource).copy(true);
        this.saveData(ds, true, true);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(4);
        }
        return localDataSource;
    }

    @NotNull
    public DynamicJdbcUrlEditor getUrlEditor() {
        DynamicJdbcUrlEditor dynamicJdbcUrlEditor = this.myGeneralPanel.getUrlEditor();
        if (dynamicJdbcUrlEditor == null) {
            DataSourceConfigurable.$$$reportNull$$$0(5);
        }
        return dynamicJdbcUrlEditor;
    }

    public DataSourceSshSslPanel getSshSslPanel() {
        return this.mySshSslPanel;
    }

    public void hidePasswords() {
        this.myGeneralPanel.hidePassword();
        this.mySshSslPanel.hidePassword();
        this.myOptionsPanel.hidePassword();
    }

    public void reloadCredentials() {
        this.myGeneralPanel.reloadCredentials();
        this.mySshSslPanel.reloadCredentials();
        this.myOptionsPanel.reloadCredentials();
        this.myController.clearModifiedCache();
    }

    private JComponent createCenterPanel() {
        this.myNameComponent = new DatabaseNameComponent(this, this.myController, true);
        this.myMappingLink = new DdlMappingLink(this.getController()){

            @Override
            protected void setUp(DdlMapping mapping) {
                mapping.setName(DataSourceConfigurable.this.getController().generateObjectName((Object)mapping, DataSourceConfigurable.this.getNameValue() + " Mapping"));
                mapping.setDataSourceId(((LocalDataSource)DataSourceConfigurable.this.getDataSource()).getUniqueId());
            }

            @Override
            protected JBIterable<DdlMapping> getMappings() {
                String id = ((LocalDataSource)DataSourceConfigurable.this.getTarget()).getUniqueId();
                return DataSourceConfigurable.this.getController().getMappings().map(arg_0 -> ((DatabaseConfigEditor)DataSourceConfigurable.this.getController()).getTempTargetOrTarget(arg_0)).filter(m -> id.equals(m.getDataSourceId()));
            }
        };
        this.myNameComponent.getComponent().add((Component)((Object)this.myMappingLink), DatabaseUIUtils.createSimpleConstraints(0, 3, 2));
        this.myGeneralPanel = new DataSourceGeneralPanel(this);
        this.mySchemasPanel = new DataSourceSchemasPanel(this);
        this.myOptionsPanel = new DataSourceOptionsPanel(this);
        this.myAdvancedPanel = new AdvancedPropertiesPanel(this.myProject, ((LocalDataSource)this.myDataSource).getDriverProperties(), this, this.myController);
        this.mySshSslPanel = new DataSourceSshSslPanel(this.myProject, (LocalDataSource)this.myDataSource, this);
        this.myTestConnectionComponent = new DataSourceTestConnectionComponent(this);
        this.myCustomTabs = new DbOptionsEditor.DbOptionsEditors<LocalDataSource>(LocalDataSource.class, p -> p.getLocation() == DbOptionProvider.UiLocation.NEW_TAB, null);
        this.myPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myTabbedPane = new JBTabbedPane(1);
        this.myTabbedPane.setTabComponentInsets(null);
        this.myPanel.add((Component)this.myTabbedPane, "Center");
        this.myTabbedPane.addTab(DatabaseBundle.message((String)"DataSourceConfigurable.tab.general", (Object[])new Object[0]), (Component)this.myGeneralPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message((String)"DataSourceConfigurable.tab.options", (Object[])new Object[0]), (Component)this.myOptionsPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message((String)"DataSourceConfigurable.tab.ssh.ssl", (Object[])new Object[0]), (Component)this.mySshSslPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message((String)"DataSourceConfigurable.tab.schemas", (Object[])new Object[0]), (Component)this.mySchemasPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message((String)"DataSourceConfigurable.tab.advanced", (Object[])new Object[0]), (Component)this.myAdvancedPanel.getComponent());
        this.updateMappingLink();
        DataSourceConfigurable.initTabbedPane(this.myTabbedPane, this.myController);
        return this.myPanel;
    }

    private void updateMappingLink() {
        this.myMappingLink.updateText();
    }

    public void beforeShowNotify() {
        super.beforeShowNotify();
        this.myTabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(this.myTabbedPane, this.myController));
    }

    public void onUserActivity() {
        this.saveGeneralSettings(this.myTempDataSource, false, true);
        this.myTestConnectionManager.resetStatus();
        this.myGeneralPanel.onActivity();
        this.validateDeps();
        this.validateCustomTabs(this.myTempDataSource);
    }

    private void validateCustomTabs(LocalDataSource dataSource) {
        Component comp;
        HashMap<DbOptionsEditor.DbOptionsEditors.OptionEditor, Component> active = new HashMap<DbOptionsEditor.DbOptionsEditors.OptionEditor, Component>();
        int count = this.myTabbedPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            comp = this.myTabbedPane.getComponentAt(i);
            DbOptionsEditor.DbOptionsEditors.OptionEditor editor2 = (DbOptionsEditor.DbOptionsEditors.OptionEditor)UIUtil.getClientProperty((Component)comp, DbOptionsEditor.DbOptionsEditors.OptionEditor.class);
            if (editor2 == null) continue;
            active.put(editor2, comp);
        }
        List<DbOptionsEditor.DbOptionsEditors.OptionEditor<LocalDataSource, ?>> toActivate = this.myCustomTabs.getFiltered(this.myProject, dataSource);
        if (toActivate.size() == active.size() && active.keySet().containsAll(toActivate)) {
            return;
        }
        for (int i = this.myTabbedPane.getTabCount() - 1; i >= 0; --i) {
            comp = this.myTabbedPane.getComponentAt(i);
            if (UIUtil.getClientProperty((Component)comp, DbOptionsEditor.DbOptionsEditors.OptionEditor.class) == null) continue;
            this.myTabbedPane.removeTabAt(i);
        }
        for (DbOptionsEditor.DbOptionsEditors.OptionEditor<LocalDataSource, ?> editor3 : toActivate) {
            Component component = (Component)active.get(editor3);
            if (component == null) {
                component = editor3.createComponent(dataSource, this.getDataContext());
                ((JComponent)component).putClientProperty(DbOptionsEditor.DbOptionsEditors.OptionEditor.class, editor3);
            }
            this.myTabbedPane.addTab(editor3.provider.getDisplayName(), null, component, editor3.provider.getDescription());
        }
    }

    protected void validateDeps() {
        this.mySshSslPanel.getSshPanel().updateInfoLabel();
        this.myGeneralPanel.updateDriverLink();
        this.updateMappingLink();
    }

    public DataSourceTestConnectionManager getTestConnectionManager() {
        return this.myTestConnectionManager;
    }

    public static void initTabbedPane(@NotNull JBTabbedPane tabbedPane, @NotNull DatabaseConfigEditor controller) {
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(6);
        }
        if (controller == null) {
            DataSourceConfigurable.$$$reportNull$$$0(7);
        }
        UIUtil.uiChildren((Component)tabbedPane).consumeEach(UIUtil::removeScrollBorder);
        tabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(tabbedPane, controller));
        tabbedPane.addChangeListener(e -> {
            int index = tabbedPane.getSelectedIndex();
            controller.putUserData(DatabaseConfigEditor.SELECTED_TAB_KEY, (Object)Pair.create((Object)(index < 0 ? null : tabbedPane.getTitleAt(index)), (Object)index));
        });
    }

    public static int getDefaultTabIndex(@NotNull JBTabbedPane tabbedPane, @NotNull DatabaseConfigEditor controller) {
        Pair p;
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(8);
        }
        if (controller == null) {
            DataSourceConfigurable.$$$reportNull$$$0(9);
        }
        if ((p = (Pair)controller.getUserData(DatabaseConfigEditor.SELECTED_TAB_KEY)) == null) {
            return 0;
        }
        if ((Integer)p.second < tabbedPane.getTabCount() && (Integer)p.second >= 0 && Objects.equals(p.first, tabbedPane.getTitleAt(((Integer)p.second).intValue()))) {
            return (Integer)p.second;
        }
        String title = (String)p.first;
        int idx = DataSourceConfigurable.findTabIndex(tabbedPane, title);
        return idx == -1 ? 0 : idx;
    }

    public static int findTabIndex(@NotNull JBTabbedPane tabbedPane, String title) {
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(10);
        }
        for (int i = tabbedPane.getTabCount() - 1; i >= 0; --i) {
            if (!Objects.equals(title, tabbedPane.getTitleAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static int findTabIndex(@NotNull JBTabbedPane tabbedPane, JComponent component) {
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(11);
        }
        for (int i = tabbedPane.getTabCount() - 1; i > 0; --i) {
            if (!Objects.equals(component, tabbedPane.getComponentAt(i))) continue;
            return i;
        }
        return -1;
    }

    @NlsSafe
    public String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    public void setGeneratedName(@NotNull String name) {
        if (name == null) {
            DataSourceConfigurable.$$$reportNull$$$0(12);
        }
        this.myNameComponent.setGeneratedName(name);
    }

    public void saveData(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(13);
        }
        dataSource.getInfo().copyFrom(this.getDatabaseInfo());
        this.saveGeneralSettings(dataSource, copyCredentials, actual);
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.saveData(dataSource);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.saveDataSource(dataSource);
        }
        if (this.mySshSslPanel != null) {
            this.mySshSslPanel.saveData(dataSource, copyCredentials);
        }
        if (this.myCustomTabs != null) {
            this.myCustomTabs.apply(dataSource);
        }
    }

    public void saveGeneralSettings(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(14);
        }
        dataSource.setStorageScope(this.myStorageScope);
        this.myNameComponent.save((AbstractDataSource)dataSource);
        this.myGeneralPanel.saveSettings(dataSource, copyCredentials, actual);
        this.mySchemasPanel.saveSettings(dataSource);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    private static String getDimensionServiceKey() {
        return "com.intellij.database.dataSource.DataSourceConfigurable";
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "data.sources.and.drivers.dialog";
    }

    @Nullable
    public JComponent createComponent() {
        return this.createCenterPanel();
    }

    public void apply() throws ConfigurationException {
        int ret;
        LocalDataSource tempDataSource = ((LocalDataSource)this.myDataSource).copy(true);
        this.saveData(tempDataSource, true, true);
        String error = StringUtil.isEmpty((String)tempDataSource.getDriverClass()) ? DatabaseBundle.message((String)"error.text.database.driver.not.configured", (Object[])new Object[0]) : null;
        if (error != null && (ret = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DatabaseBundle.message((String)"message.title.invalid.datasource", (Object[])new Object[0]), (String)DatabaseBundle.message((String)"confirmation.text.error.occurred.save.datasource", (Object[])new Object[]{error})).icon(Messages.getErrorIcon())).show()) != 0) {
            return;
        }
        DatabaseDriverClasspathManager artifactManager = DatabaseDriverClasspathManager.Companion.getInstance(this.myProject);
        boolean newDataSource = this.isNewDataSource();
        boolean isStorageScopeChanged = !newDataSource && tempDataSource.getStorageScope() != ((LocalDataSource)this.myDataSource).getStorageScope();
        boolean isUrlChanged = !Comparing.strEqual((String)tempDataSource.getUrl(), (String)((LocalDataSource)this.myDataSource).getUrl());
        DataSourceSshTunnelConfiguration prevSshConfiguration = ((LocalDataSource)this.myDataSource).getSshConfiguration();
        boolean areCredentialsChanged = !this.equalCredentials(tempDataSource, (LocalDataSource)this.myDataSource, this.isPasswordChanged());
        boolean isAuthChanged = areCredentialsChanged || !DataSourceSshTunnelConfiguration.equal((DataSourceSshTunnelConfiguration)tempDataSource.getSshConfiguration(), (DataSourceSshTunnelConfiguration)prevSshConfiguration) || !DataSourceSslConfiguration.equal((DataSourceSslConfiguration)tempDataSource.getSslCfg(), (DataSourceSslConfiguration)((LocalDataSource)this.myDataSource).getSslCfg());
        DatabaseDriver driver = ((LocalDataSource)this.myDataSource).getDatabaseDriver();
        DatabaseArtifactContext context = DatabaseArtifactContext.Companion.getInstance(this.myProject, (LocalDataSource)this.myDataSource);
        List cp = new ArrayList();
        if (driver != null) {
            cp = artifactManager.getClasspathElements(driver, context);
        }
        DatabaseDriver tempDriver = tempDataSource.getDatabaseDriver();
        DatabaseArtifactContext tempContext = DatabaseArtifactContext.Companion.getInstance(this.myProject, tempDataSource);
        List actualCp = new ArrayList();
        if (tempDriver != null) {
            actualCp = artifactManager.getClasspathElements(tempDriver, tempContext);
        }
        boolean resetConnections = isAuthChanged || tempDataSource.isSingleConnection() != ((LocalDataSource)this.myDataSource).isSingleConnection() || !Objects.equals(tempDataSource.getDriverClass(), ((LocalDataSource)this.myDataSource).getDriverClass()) || !actualCp.equals(cp) || !tempDataSource.getConnectionProperties().equals(((LocalDataSource)this.myDataSource).getConnectionProperties()) || !Objects.equals(tempDataSource.getVmOptions(), ((LocalDataSource)this.myDataSource).getVmOptions()) || !tempDataSource.getVmEnv().equals(((LocalDataSource)this.myDataSource).getVmEnv()) || !LocalDataSource.getAdditionalPropertiesMap((LocalDataSource)tempDataSource).equals(LocalDataSource.getAdditionalPropertiesMap((LocalDataSource)((LocalDataSource)this.myDataSource)));
        boolean isSchemaChanged = newDataSource || isAuthChanged || isUrlChanged || tempDataSource.isAutoSynchronize() && !((LocalDataSource)this.myDataSource).isAutoSynchronize() || !Comparing.equal((Object)this.myTempDataSource.getIntrospectionScope(), (Object)((LocalDataSource)this.myDataSource).getIntrospectionScope()) || !Comparing.strEqual((String)tempDataSource.getObjectPattern(), (String)((LocalDataSource)this.myDataSource).getObjectPattern()) || DbOptionProvider.getProviders((Project)this.myProject, (Object)((LocalDataSource)this.myDataSource)).filter(DbOptionProvider::isAffectsIntrospection).find(p -> !Comparing.equal((Object)p.getValue((Object)this.myTempDataSource), (Object)p.getValue((Object)((LocalDataSource)this.myDataSource)))) != null;
        this.enablePillsIfNeeded((LocalDataSource)this.myDataSource, this.myTempDataSource);
        this.saveData((LocalDataSource)this.myDataSource, true, false);
        this.applyCredentials(tempDataSource);
        this.myGeneralPanel.onApply();
        this.mySshSslPanel.onApply();
        this.myNameComponent.apply((AbstractDataSource)this.myDataSource);
        this.updateDatabaseInfo(tempDataSource);
        if (isStorageScopeChanged) {
            this.myController.onChangesApplied(indicator -> {
                try {
                    indicator.setText(DatabaseBundle.message((String)"progress.text.moving.storage", (Object[])new Object[]{((LocalDataSource)this.myDataSource).getName()}));
                    switch (((LocalDataSource)this.myDataSource).getStorageScope()) {
                        case DSSS_APPLICATION: {
                            DbSrcUtils.moveStorage((LocalDataSource)((LocalDataSource)this.myDataSource), (Project)this.getProject(), null);
                            break;
                        }
                        case DSSS_PROJECT: {
                            DbSrcUtils.moveStorage((LocalDataSource)((LocalDataSource)this.myDataSource), null, (Project)this.getProject());
                        }
                    }
                    switch (((LocalDataSource)this.myDataSource).getStorageScope()) {
                        case DSSS_APPLICATION: {
                            DatabaseColorManager.changeDsScopeToGlobal(this.getProject(), (LocalDataSource)this.myDataSource);
                            break;
                        }
                        case DSSS_PROJECT: {
                            DatabaseColorManager.changeDsScopeToProject(this.getProject(), (LocalDataSource)this.myDataSource);
                        }
                    }
                }
                catch (IOException e) {
                    DbUIUtil.createNotification((DasDataSource)this.myDataSource, DatabaseBundle.message((String)"notification.content.failed.to.move.storage", (Object[])new Object[]{e.getMessage()}), NotificationType.ERROR, "DataSourceConfigurable.storage.move.failed").notify(this.myProject);
                }
            });
        }
        JdbcDriverManager manager = JdbcDriverManager.getDriverManager((Project)this.myProject);
        if (resetConnections && !manager.getActiveConfigurations((LocalDataSource)this.myDataSource).isEmpty()) {
            boolean yesForAll;
            int answer = Boolean.TRUE.equals(this.myController.getUserData(RESET_CONNECTION_YES_FOR_ALL_KEY)) ? 0 : Messages.showYesNoCancelDialog((Component)this.myPanel, (String)DatabaseBundle.message((String)"DataSourceConfigurable.apply.reconnect", (Object[])new Object[]{((LocalDataSource)this.myDataSource).getName()}), (String)DatabaseBundle.message((String)"DataSourceConfigurable.apply.title", (Object[])new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (String)CommonBundle.getYesForAllButtonText(), (Icon)Messages.getQuestionIcon());
            boolean bl = yesForAll = answer == 2;
            if (yesForAll) {
                this.myController.putUserData(RESET_CONNECTION_YES_FOR_ALL_KEY, (Object)true);
            }
            if (answer == 0 || yesForAll) {
                this.myController.onChangesApplied(indicator -> {
                    this.myController.putUserData(RESET_CONNECTION_YES_FOR_ALL_KEY, null);
                    SessionsUtil.deactivateDataSourceAsync((Project)this.myProject, (LocalDataSource)((LocalDataSource)this.myDataSource), null);
                });
            }
        }
        if (isSchemaChanged) {
            this.myController.onChangesApplied(indicator -> DataSourceUtil.performAutoSyncTask((LoaderContext)LoaderContext.selectGeneralTask((Project)this.myProject, (LocalDataSource)((LocalDataSource)this.myDataSource)), (boolean)true));
        }
        if (newDataSource) {
            if (((LocalDataSourceManager)this.myManager).getDataSources().isEmpty() && SqlPsiFacade.getInstance((Project)this.getProject()).getConfiguredDefaultDialect() == null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    LocalDataSource ds = (LocalDataSource)ContainerUtil.find((Iterable)((LocalDataSourceManager)this.myManager).getDataSources(), o -> !SqlDialects.isGenericDialect((SqlLanguageDialect)DbSqlUtilCore.getSqlDialect((LocalDataSource)o)));
                    SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)this.getProject());
                    if (ds != null && psiFacade.getConfiguredDefaultDialect() == null) {
                        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect((LocalDataSource)ds);
                        ConnDatabaseNotifications.DATABASE_VIEW_GROUP().createNotification(DatabaseBundle.message((String)"notification.title.default.sql.dialect", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.you.can.set.as.default.sql.dialect", (Object[])new Object[]{dialect.getDisplayName()}), NotificationType.INFORMATION).setListener((notification, event) -> {
                            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                if ("set".equals(event.getDescription())) {
                                    psiFacade.setDialectMapping(null, dialect);
                                } else if ("configure".equals(event.getDescription())) {
                                    psiFacade.openDialectsConfigurable(Collections.emptyList());
                                }
                            }
                        }).setDisplayId("DataSourceConfigurable.set.default.dialect").notify(this.getProject());
                    }
                }, ModalityState.nonModal());
            }
            ((LocalDataSourceManager)this.myManager).addDataSource((LocalDataSource)this.myDataSource);
        } else {
            ((LocalDataSourceManager)this.myManager).fireDataSourceUpdated((LocalDataSource)this.myDataSource);
        }
    }

    private void enablePillsIfNeeded(LocalDataSource prev2, LocalDataSource cur) {
        byte oldLevelValue;
        byte newLevelValue;
        Level newLevel;
        Level oldLevel = prev2.getIntrospectionLevel();
        if (oldLevel == (newLevel = cur.getIntrospectionLevel())) {
            return;
        }
        if (newLevel != null && (newLevelValue = newLevel.level) < (oldLevelValue = oldLevel != null ? (byte)oldLevel.level : (byte)3)) {
            this.myController.onChangesApplied(indicator -> {
                DatabaseViewOptions viewOptions = (DatabaseViewOptions)this.getProject().getServiceIfCreated(DatabaseViewOptions.class);
                if (viewOptions != null) {
                    viewOptions.enableBluePillsIfWasNot();
                }
            });
        }
    }

    private void applyCredentials(LocalDataSource tempDataSource) {
        DatabaseCredentials dc = DatabaseCredentials.getInstance();
        DatabaseCredentials local = this.myController.getSecretService();
        DatabaseAuthProvider authProvider = DatabaseAuthProvider.get((DatabaseConnectionPoint)tempDataSource);
        Object credentials = authProvider.loadAuthConfig((DatabaseConnectionPoint)tempDataSource, local, true);
        authProvider.saveAuthConfig((DatabaseConnectionConfig)this.myDataSource, dc, credentials, true);
        dc.setSslPassphrase((DasDataSource)this.myDataSource, local.getSslPassphrase((DasDataSource)tempDataSource));
    }

    public void resetFromTemp() {
        this.bulkUpdate(() -> {
            this.myGeneralPanel.reset(this.myTempDataSource, false);
            this.mySchemasPanel.reset(this.myTempDataSource);
        });
    }

    public void init(@NotNull Runnable watcher) {
        if (watcher == null) {
            DataSourceConfigurable.$$$reportNull$$$0(15);
        }
        this.registerWatcher(watcher);
        this.bulkUpdate(() -> this.reset((LocalDataSource)this.getTarget(), false));
        this.myTracker.incModificationCount();
    }

    protected JComponent getComponent() {
        return this.myPanel;
    }

    protected void reset(@NotNull LocalDataSource o) {
        if (o == null) {
            DataSourceConfigurable.$$$reportNull$$$0(16);
        }
        this.reset(o, true);
    }

    public JComponent getCommonBar() {
        return this.myTestConnectionComponent.getComponent();
    }

    public void reset(@NotNull LocalDataSource o, boolean resetCredentials) {
        if (o == null) {
            DataSourceConfigurable.$$$reportNull$$$0(17);
        }
        this.myConnectionInfo = o.getInfo().equals(((LocalDataSource)this.myDataSource).getInfo()) ? null : Couple.of((Object)((LocalDataSource)this.myDataSource).getInfo(), (Object)o.getInfo());
        this.setStorageScope(o.getStorageScope());
        this.myGeneralPanel.reset(o, resetCredentials);
        this.myAdvancedPanel.resetDataSource(o);
        this.myNameComponent.reset((AbstractDataSource)o, (Computable<String>)((Computable)() -> this.myGeneralPanel.generateNameFromParameters()));
        this.mySshSslPanel.reset(o, resetCredentials);
        this.myOptionsPanel.reset(o);
        this.mySchemasPanel.reset(o);
        this.myCustomTabs.reset(o);
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        LocalDataSource tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((LocalDataSource)this.myDataSource).getName())) {
            return true;
        }
        if (!tempDataSource.equalConfiguration((LocalDataSource)this.myDataSource)) {
            return true;
        }
        if (this.isPasswordChanged()) {
            return true;
        }
        return this.myNameComponent.isModified();
    }

    private boolean isPasswordChanged() {
        return this.myGeneralPanel.isPasswordChanged() || this.mySshSslPanel.isSslPassphraseChanged();
    }

    private boolean equalCredentials(LocalDataSource d1, LocalDataSource d2, boolean loadCredentials) {
        if (!loadCredentials) {
            return this.equalCredentialsImpl(d1, d2, false);
        }
        return (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.equalCredentialsImpl(d1, d2, true), DatabaseBundle.message((String)"dialog.title.checking.configuration", (Object[])new Object[0]), true, this.myProject);
    }

    private boolean equalCredentialsImpl(LocalDataSource d1, LocalDataSource d2, boolean loadCredentials) {
        DatabaseAuthProvider p2;
        DatabaseAuthProvider p1 = DatabaseAuthProvider.get((DatabaseConnectionPoint)d1);
        if (p1 != (p2 = DatabaseAuthProvider.get((DatabaseConnectionPoint)d2))) {
            return false;
        }
        boolean loadPass = this.myGeneralPanel.isPasswordChanged();
        return Objects.equals(p1.loadAuthConfig((DatabaseConnectionPoint)d1, loadPass ? this.getSecretService() : null, !loadCredentials), p1.loadAuthConfig((DatabaseConnectionPoint)d2, (DatabaseCredentials)(loadPass ? DatabaseCredentials.getInstance() : null), !loadCredentials));
    }

    public void showErrorNotification(@Nls String message, @NotNull Object id) {
        if (id == null) {
            DataSourceConfigurable.$$$reportNull$$$0(18);
        }
        DbImplUtilCore.invokeLaterIfNeeded(() -> this.myController.showErrorNotification((AbstractDatabaseConfigurable)this, id, message == null ? null : DatabaseBundle.message((String)"notification.title.DatabaseConfigEditor.error", (Object[])new Object[0]), message, new Object[0]));
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        DatabaseDriver prevActualDriver = this.myGeneralPanel.getActualDriver();
        this.myGeneralPanel.setDriver(driver);
        DatabaseDriver newActualDriver = this.myGeneralPanel.getActualDriver();
        if (prevActualDriver != newActualDriver) {
            this.myAdvancedPanel.migrateDriver(prevActualDriver, newActualDriver);
        }
    }

    public void setStorageScope(@NotNull DataSourceStorageScope storageScope) {
        if (storageScope == null) {
            DataSourceConfigurable.$$$reportNull$$$0(19);
        }
        this.myStorageScope = storageScope;
        this.fireChanged();
    }

    @NotNull
    public DataSourceStorageScope getStorageScope() {
        DataSourceStorageScope dataSourceStorageScope = this.myStorageScope;
        if (dataSourceStorageScope == null) {
            DataSourceConfigurable.$$$reportNull$$$0(20);
        }
        return dataSourceStorageScope;
    }

    @Deprecated(since="2021.3", forRemoval=true)
    public boolean isGlobal() {
        return this.myStorageScope == DataSourceStorageScope.DSSS_APPLICATION;
    }

    public void actualizeDriver() {
        this.setDriver(this.getDriver());
    }

    @Nullable
    DatabaseDriver getDriver() {
        return this.myGeneralPanel.getDriver();
    }

    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.myGeneralPanel.getUrlEditorModel().getMeaningfulParser();
    }

    public CoroutineScope getCoroutineScope() {
        return this.myController.getCoroutineScope();
    }

    @NotNull
    public ParametersHolder getActualParameter() {
        UrlEditorModel urlEditorModel = this.myGeneralPanel.getUrlEditorModel();
        if (urlEditorModel == null) {
            DataSourceConfigurable.$$$reportNull$$$0(21);
        }
        return urlEditorModel;
    }

    public void setIntrospectionLevel(@NotNull Level level) {
        if (level == null) {
            DataSourceConfigurable.$$$reportNull$$$0(22);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.setIntrospectionLevel(level);
        }
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceConfigurable.$$$reportNull$$$0(23);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.setSourceLoading(mode);
        }
    }

    @TestOnly
    @Nullable
    public DatabaseAuthProvider.AuthWidget getAuthWidget() {
        return this.myGeneralPanel.getUrlEditor().getAuthPanel().getAuthWidget();
    }

    public String getUrl() {
        return this.myGeneralPanel.getUrlEditor().getUrl();
    }

    @TestOnly
    public void setUrl(String url) {
        this.myGeneralPanel.getUrlEditor().setUrl(url, false);
    }

    public void setExtraProperty(String name, String value) {
        this.myGeneralPanel.getUrlEditor().setExtraProperty(name, value);
    }

    @NotNull
    public JComponent selectAdvancedPanel() {
        int index = DataSourceConfigurable.findTabIndex(this.myTabbedPane, DatabaseBundle.message((String)"DataSourceConfigurable.tab.advanced", (Object[])new Object[0]));
        if (index != -1) {
            this.myTabbedPane.setSelectedIndex(index);
        }
        JPanel jPanel = this.myAdvancedPanel.getComponent();
        if (jPanel == null) {
            DataSourceConfigurable.$$$reportNull$$$0(24);
        }
        return jPanel;
    }

    public JComponent selectSslPanel() {
        int index = DataSourceConfigurable.findTabIndex(this.myTabbedPane, DatabaseBundle.message((String)"DataSourceConfigurable.tab.ssh.ssl", (Object[])new Object[0]));
        if (index != -1) {
            this.myTabbedPane.setSelectedIndex(index);
        }
        return this.mySshSslPanel.getComponent();
    }

    @NotNull
    public DefaultActionGroup getMoreOptionsAction() {
        DefaultActionGroup actions = new DefaultActionGroup();
        this.myGeneralPanel.getUrlEditor().addMoreActions(actions);
        actions.addSeparator();
        this.mySshSslPanel.addSshSslMoreActions(actions);
        DefaultActionGroup defaultActionGroup = actions;
        if (defaultActionGroup == null) {
            DataSourceConfigurable.$$$reportNull$$$0(25);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 20, 21, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedPane";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageScope";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSourceForConnection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlEditor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageScope";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameter";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "selectAdvancedPanel";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoreOptionsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateDatabaseInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onTestConnectionUpdate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initTabbedPane";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTabIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTabIndex";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setGeneratedName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveGeneralSettings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setStorageScope";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionLevel";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 20, 21, 24, 25 -> new IllegalStateException(string);
        };
    }
}

