/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.structure;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.explorer.forest.DvArm;
import com.intellij.database.explorer.forest.DvBushRef;
import com.intellij.database.explorer.forest.DvFolder;
import com.intellij.database.explorer.forest.DvForest;
import com.intellij.database.explorer.forest.DvForestRootFolder;
import com.intellij.database.explorer.forest.DvForestService;
import com.intellij.database.explorer.forest.DvNiceFolder;
import com.intellij.database.explorer.forest.ShiftDirection;
import com.intellij.database.explorer.structure.DvCreateFolderCommand;
import com.intellij.database.explorer.structure.DvForestActionService;
import com.intellij.database.explorer.structure.DvMoveArmsToFolder;
import com.intellij.database.explorer.structure.DvTreeNodeRank;
import com.intellij.database.explorer.structure.DvTreeStructureService;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.util.common.BooleanFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.registry.Registry;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000  2\u00020\u0001:\u000b !\"#$%&'()*B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0004J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0017H&J(\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH&J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0004\u0082\u0001\u0003+,-\u00a8\u0006."}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkActionStatus", "Lcom/intellij/database/actions/ActionStatus;", "place", "Lcom/intellij/database/explorer/structure/DvForestAction$Place;", "determinePlace", "checkAvailability", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "adjustPresentation", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "actionPerformed", "determineSelection", "Lcom/intellij/database/explorer/structure/DvForestAction$Selection;", "project", "Lcom/intellij/openapi/project/Project;", "checkApplicability", "selection", "performAction", "forest", "Lcom/intellij/database/explorer/forest/DvForest;", "Lcom/intellij/database/view/DataSourceNode;", "Companion", "Place", "Selection", "ShiftGroup", "CreateNewFolder", "ForestNodeShiftAction", "ForestNodeShiftUpAction", "ForestNodeShiftDownAction", "ForestNodeShiftLeftAction", "ForestNodeShiftRightAction", "ForestNodeMoveToTheTopLevelAction", "Lcom/intellij/database/explorer/structure/DvForestAction$CreateNewFolder;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeMoveToTheTopLevelAction;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftAction;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDvForestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/explorer/structure/DvForestAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,320:1\n30#2,2:321\n*S KotlinDebug\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/explorer/structure/DvForestAction\n*L\n137#1:321,2\n*E\n"})
public abstract sealed class DvForestAction
extends DumbAwareAction {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger ourLog;
    private static final boolean forestEnabled;
    private static final boolean quickMoveEnabled;

    private DvForestAction() {
    }

    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Place place = this.determinePlace(e);
        ActionStatus status = this.checkActionStatus(e, place);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (status.visible) {
            this.adjustPresentation(place, presentation2);
        }
        presentation2.setVisible(status.visible);
        presentation2.setEnabled(status.enabled);
    }

    private final ActionStatus checkActionStatus(AnActionEvent e, Place place) {
        if (!forestEnabled) {
            return ActionStatus.HIDDEN;
        }
        if (place.getGlobal() && place != Place.placeUnknown) {
            return ActionStatus.ENABLED;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dc = dataContext;
        return DatabaseContextFun.fromDatabaseTree(dc) ? this.checkAvailability(dc, place) : ActionStatus.HIDDEN;
    }

    private final Place determinePlace(AnActionEvent e) {
        Place place;
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"GoToAction")) {
            place = Place.placeFindAction;
        } else if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"MainMenu")) {
            place = Place.placeContextMenu;
        } else if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"keyboard shortcut")) {
            place = Place.placeKeyboard;
        } else {
            String string = e.getPlace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
            if (StringsKt.endsWith$default((String)string, (String)"DatabaseViewToolbar", (boolean)false, (int)2, null)) {
                place = Place.placeToolbar;
            } else {
                String string2 = e.getPlace();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPlace(...)");
                place = StringsKt.contains$default((CharSequence)string2, (CharSequence)"Popup", (boolean)false, (int)2, null) ? Place.placeContextMenu : Place.placeUnknown;
            }
        }
        return place;
    }

    @NotNull
    protected final ActionStatus checkAvailability(@NotNull DataContext dc, @NotNull Place place) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
        Project project = DatabaseContextFun.getProject(dc);
        if (project == null) {
            return ActionStatus.HIDDEN;
        }
        Project project2 = project;
        Selection selection = this.determineSelection(project2, dc);
        if (selection.isEmpty() && place != Place.placeUnknown) {
            return ActionStatus.ENABLED;
        }
        if (!selection.getHasFolders() && !selection.getHasDataSources() || selection.getOther()) {
            return ActionStatus.HIDDEN;
        }
        return this.checkApplicability(project2, place, selection);
    }

    protected void adjustPresentation(@NotNull Place place, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Place place = this.determinePlace(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dc = dataContext;
        if (place == Place.placeUnknown && !DatabaseContextFun.fromDatabaseTree(dc)) {
            return;
        }
        Selection selection = this.determineSelection(project2, dc);
        ActionStatus status = this.checkApplicability(project2, place, selection);
        if (!status.enabled) {
            return;
        }
        this.performAction(project2, selection, dc, place);
    }

    @NotNull
    protected final Selection determineSelection(@NotNull Project project, @NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        DvForest<DataSourceNode> forest = this.forest(project);
        ArrayList arms = new ArrayList();
        ArrayList folders = new ArrayList();
        ArrayList dataSources = new ArrayList();
        boolean other = false;
        for (BasicNode node : DatabaseContextFun.getSelectedNodes(dc)) {
            BasicNode basicNode = node;
            if (basicNode instanceof DvNiceFolder) {
                ((Collection)folders).add(node);
                ((Collection)arms).add(node);
                continue;
            }
            if (basicNode instanceof DataSourceNode) {
                DvBushRef bushRef = forest.getBushRef((BasicUniqueBush)node);
                if (bushRef == null) continue;
                ((Collection)dataSources).add(node);
                ((Collection)arms).add(bushRef);
                continue;
            }
            other = true;
        }
        return new Selection(project, arms, folders, dataSources, other);
    }

    @NotNull
    public abstract ActionStatus checkApplicability(@NotNull Project var1, @NotNull Place var2, @NotNull Selection var3);

    public abstract void performAction(@NotNull Project var1, @NotNull Selection var2, @NotNull DataContext var3, @NotNull Place var4);

    @NotNull
    protected final DvForest<DataSourceNode> forest(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((DvForestService)object).getForest();
    }

    @NotNull
    public static final Logger getOurLog() {
        return Companion.getOurLog();
    }

    public /* synthetic */ DvForestAction(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Logger logger = Logger.getInstance(DvForestAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ourLog = logger;
        forestEnabled = Registry.Companion.is("database.view.nice.folders.enabled");
        quickMoveEnabled = Registry.Companion.is("database.view.quick.move.enabled");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$Companion;", "", "<init>", "()V", "ourLog", "Lcom/intellij/openapi/diagnostic/Logger;", "getOurLog$annotations", "getOurLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "forestEnabled", "", "getForestEnabled", "()Z", "quickMoveEnabled", "getQuickMoveEnabled", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getOurLog() {
            return ourLog;
        }

        @JvmStatic
        public static /* synthetic */ void getOurLog$annotations() {
        }

        public final boolean getForestEnabled() {
            return forestEnabled;
        }

        public final boolean getQuickMoveEnabled() {
            return quickMoveEnabled;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J(\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$CreateNewFolder;", "Lcom/intellij/database/explorer/structure/DvForestAction;", "<init>", "()V", "checkApplicability", "Lcom/intellij/database/actions/ActionStatus;", "project", "Lcom/intellij/openapi/project/Project;", "place", "Lcom/intellij/database/explorer/structure/DvForestAction$Place;", "selection", "Lcom/intellij/database/explorer/structure/DvForestAction$Selection;", "adjustPresentation", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "performAction", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDvForestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/explorer/structure/DvForestAction$CreateNewFolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1#2:321\n*E\n"})
    public static final class CreateNewFolder
    extends DvForestAction {
        public CreateNewFolder() {
            super(null);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public ActionStatus checkApplicability(@NotNull Project project, @NotNull Place place, @NotNull Selection selection) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            if (place.getGlobal()) ** GOTO lbl-1000
            $this$checkApplicability_u24lambda_u240 = selection;
            $i$a$-with-DvForestAction$CreateNewFolder$checkApplicability$ok$1 = false;
            v0 = $this$checkApplicability_u24lambda_u240.getFolders().size() <= 1 && !$this$checkApplicability_u24lambda_u240.getHasDataSources() && !$this$checkApplicability_u24lambda_u240.getOther();
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            ok = v1;
            return ok != false ? ActionStatus.ENABLED : ActionStatus.DISABLED;
        }

        @Override
        protected void adjustPresentation(@NotNull Place place, @NotNull Presentation presentation) {
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            presentation.setText(switch (WhenMappings.$EnumSwitchMapping$0[place.ordinal()]) {
                case 1, 2, 3 -> DatabaseBundle.message((String)"action.DatabaseView.CreateNewFolder.textInsideGroupNew", (Object[])new Object[0]);
                case 4 -> DatabaseBundle.message((String)"action.DatabaseView.CreateNewFolder.textInsideFindAction", (Object[])new Object[0]);
                case 5, 6 -> DatabaseBundle.message((String)"action.DatabaseView.CreateNewFolder.text", (Object[])new Object[0]);
                default -> throw new NoWhenBranchMatchedException();
            });
        }

        @Override
        public void performAction(@NotNull Project project, @NotNull Selection selection, @NotNull DataContext dc, @NotNull Place place) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            int n = WhenMappings.$EnumSwitchMapping$0[place.ordinal()];
            DvNiceFolder parentFolder = n == 3 || n == 2 ? null : (n == 1 && selection.getHasFolders() ? (DvNiceFolder)CollectionsKt.firstOrNull((Iterable)selection.getFolders()) : (n == 4 && selection.getHasFolders() ? (DvNiceFolder)CollectionsKt.firstOrNull((Iterable)selection.getFolders()) : (n == 6 && selection.getHasFolders() ? (DvNiceFolder)CollectionsKt.firstOrNull((Iterable)selection.getFolders()) : null)));
            String newNameLemma = "New Folder";
            Object newName = newNameLemma;
            DvNiceFolder dvNiceFolder = parentFolder;
            DvFolder theParentFolder = dvNiceFolder != null ? (DvFolder)dvNiceFolder : (DvFolder)this.forest(project).getRoot();
            Set siblingNames = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)theParentFolder.getInnerFolders()), CreateNewFolder::performAction$lambda$0));
            int i = 0;
            while (siblingNames.contains(newName)) {
                newName = newNameLemma + " " + ++i;
            }
            NewItemSimplePopupPanel contentPanel = new NewItemSimplePopupPanel(true);
            JTextField nameField = contentPanel.getTextField();
            nameField.setText((String)newName);
            nameField.selectAll();
            String string = DatabaseBundle.message((String)"forest.dialog.createNewFolder.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            JBPopup popup2 = NewItemPopupUtil.createNewItemPopup((String)title, (JComponent)((JComponent)contentPanel), (JComponent)nameField);
            contentPanel.setApplyAction(arg_0 -> CreateNewFolder.performAction$lambda$2(arg_0 -> CreateNewFolder.performAction$lambda$1(nameField, popup2, project, theParentFolder, arg_0), arg_0));
            popup2.showInBestPositionFor(dc);
        }

        private static final String performAction$lambda$0(DvNiceFolder it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getName();
        }

        private static final Unit performAction$lambda$1(JTextField $nameField, JBPopup $popup, Project $project, DvFolder $theParentFolder, InputEvent e) {
            String string = $nameField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String newName = ((Object)StringsKt.trim((CharSequence)string)).toString();
            $popup.closeOk(e);
            new DvCreateFolderCommand($project, $theParentFolder, newName).doIt();
            return Unit.INSTANCE;
        }

        private static final void performAction$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Place.values().length];
                try {
                    nArray[Place.placeContextMenu.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Place.placeToolbar.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Place.placeMainMenu.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Place.placeFindAction.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Place.placeUnknown.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Place.placeKeyboard.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeMoveToTheTopLevelAction;", "Lcom/intellij/database/explorer/structure/DvForestAction;", "<init>", "()V", "checkApplicability", "Lcom/intellij/database/actions/ActionStatus;", "project", "Lcom/intellij/openapi/project/Project;", "place", "Lcom/intellij/database/explorer/structure/DvForestAction$Place;", "selection", "Lcom/intellij/database/explorer/structure/DvForestAction$Selection;", "performAction", "", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDvForestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/explorer/structure/DvForestAction$ForestNodeMoveToTheTopLevelAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n1807#2,3:321\n*S KotlinDebug\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/explorer/structure/DvForestAction$ForestNodeMoveToTheTopLevelAction\n*L\n309#1:321,3\n*E\n"})
    public static final class ForestNodeMoveToTheTopLevelAction
    extends DvForestAction {
        public ForestNodeMoveToTheTopLevelAction() {
            super(null);
        }

        @Override
        @NotNull
        public ActionStatus checkApplicability(@NotNull Project project, @NotNull Place place, @NotNull Selection selection) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
                Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
                if (!selection.getHasArms()) {
                    return ActionStatus.HIDDEN;
                }
                Iterable $this$any$iv = selection.getArms();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DvArm it = (DvArm)element$iv;
                        boolean bl2 = false;
                        if (!(it.getParent() instanceof DvNiceFolder)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean yes = bl;
            return yes ? ActionStatus.ENABLED : ActionStatus.DISABLED;
        }

        @Override
        public void performAction(@NotNull Project project, @NotNull Selection selection, @NotNull DataContext dc, @NotNull Place place) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            DvForestRootFolder theRootFolder = this.forest(project).getRoot();
            new DvMoveArmsToFolder(project, selection.getArms(), (DvFolder)theRootFolder).doIt();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0001\u0004\u001c\u001d\u001e\u001f\u00a8\u0006 "}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftAction;", "Lcom/intellij/database/explorer/structure/DvForestAction;", "direction", "Lcom/intellij/database/explorer/forest/ShiftDirection;", "keyCode", "", "<init>", "(Lcom/intellij/database/explorer/forest/ShiftDirection;I)V", "getDirection", "()Lcom/intellij/database/explorer/forest/ShiftDirection;", "allowManualOrder", "", "project", "Lcom/intellij/openapi/project/Project;", "checkApplicability", "Lcom/intellij/database/actions/ActionStatus;", "place", "Lcom/intellij/database/explorer/structure/DvForestAction$Place;", "selection", "Lcom/intellij/database/explorer/structure/DvForestAction$Selection;", "checkShiftApplicability", "performAction", "", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "setShortcutSet", "shortcutSet", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftDownAction;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftLeftAction;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftRightAction;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftUpAction;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDvForestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,320:1\n58#2:321\n30#2,2:322\n30#2,2:324\n*S KotlinDebug\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftAction\n*L\n258#1:321\n275#1:322,2\n282#1:324,2\n*E\n"})
    public static abstract sealed class ForestNodeShiftAction
    extends DvForestAction
    permits ForestNodeShiftDownAction, ForestNodeShiftLeftAction, ForestNodeShiftRightAction, ForestNodeShiftUpAction {
        @NotNull
        private final ShiftDirection direction;

        private ForestNodeShiftAction(ShiftDirection direction, int keyCode) {
            super(null);
            this.direction = direction;
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, 576)));
        }

        @NotNull
        public final ShiftDirection getDirection() {
            return this.direction;
        }

        private final boolean allowManualOrder(Project project) {
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            DvTreeStructureService dvTreeStructureService = (DvTreeStructureService)$this$serviceIfCreated$iv.getServiceIfCreated(DvTreeStructureService.class);
            if (dvTreeStructureService == null) {
                return false;
            }
            DvTreeStructureService structureService = dvTreeStructureService;
            return !structureService.getContext().vo.getSortForest();
        }

        @Override
        @NotNull
        public ActionStatus checkApplicability(@NotNull Project project, @NotNull Place place, @NotNull Selection selection) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            return (this.direction == ShiftDirection.shiftLevelUp || this.direction == ShiftDirection.shiftLevelDown) && !Companion.getQuickMoveEnabled() ? ActionStatus.HIDDEN : ((this.direction == ShiftDirection.shiftSiblingsUp || this.direction == ShiftDirection.shiftSiblingsDown) && !this.allowManualOrder(project) ? ActionStatus.HIDDEN : (selection.isEmpty() || selection.getOther() ? ActionStatus.HIDDEN : (this.checkShiftApplicability(selection) ? ActionStatus.ENABLED : ActionStatus.DISABLED)));
        }

        private final boolean checkShiftApplicability(Selection selection) {
            if (selection.findSingleParent() == null) {
                return false;
            }
            boolean fs = selection.getHasFolders();
            boolean ds = selection.getHasDataSources();
            ComponentManager $this$service$iv = (ComponentManager)selection.getProject();
            boolean $i$f$service = false;
            Class<DvForestActionService> serviceClass$iv = DvForestActionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DvForestActionService actionService = (DvForestActionService)object;
            return fs && !ds && actionService.canShiftFolders(selection.getFolders(), this.direction) || ds && !fs && actionService.canShiftDataSources(selection.getDataSources(), this.direction);
        }

        @Override
        public void performAction(@NotNull Project project, @NotNull Selection selection, @NotNull DataContext dc, @NotNull Place place) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            if (!this.checkShiftApplicability(selection)) {
                return;
            }
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DvForestActionService> serviceClass$iv = DvForestActionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DvForestActionService forestActionService = (DvForestActionService)object;
            try {
                if (selection.getHasFolders()) {
                    forestActionService.shiftFolders(selection.getFolders(), this.direction);
                } else if (selection.getHasDataSources()) {
                    forestActionService.shiftDataSources(selection.getDataSources(), this.direction);
                }
            }
            catch (Exception e) {
                Companion.getOurLog().debug("Cannot shift " + selection + " " + this.direction, (Throwable)e);
            }
        }

        public void setShortcutSet(@NotNull ShortcutSet shortcutSet) {
            Intrinsics.checkNotNullParameter((Object)shortcutSet, (String)"shortcutSet");
            if (shortcutSet instanceof CustomShortcutSet) {
                super.setShortcutSet(shortcutSet);
            }
        }

        public /* synthetic */ ForestNodeShiftAction(ShiftDirection direction, int keyCode, DefaultConstructorMarker $constructor_marker) {
            this(direction, keyCode);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftDownAction;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftAction;", "<init>", "()V", "intellij.database.impl"})
    public static final class ForestNodeShiftDownAction
    extends ForestNodeShiftAction {
        public ForestNodeShiftDownAction() {
            super(ShiftDirection.shiftSiblingsDown, 40, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftLeftAction;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftAction;", "<init>", "()V", "intellij.database.impl"})
    public static final class ForestNodeShiftLeftAction
    extends ForestNodeShiftAction {
        public ForestNodeShiftLeftAction() {
            super(ShiftDirection.shiftLevelUp, 37, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftRightAction;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftAction;", "<init>", "()V", "intellij.database.impl"})
    public static final class ForestNodeShiftRightAction
    extends ForestNodeShiftAction {
        public ForestNodeShiftRightAction() {
            super(ShiftDirection.shiftLevelDown, 39, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftUpAction;", "Lcom/intellij/database/explorer/structure/DvForestAction$ForestNodeShiftAction;", "<init>", "()V", "intellij.database.impl"})
    public static final class ForestNodeShiftUpAction
    extends ForestNodeShiftAction {
        public ForestNodeShiftUpAction() {
            super(ShiftDirection.shiftSiblingsUp, 38, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$Place;", "", "local", "", "<init>", "(Ljava/lang/String;IZ)V", "getLocal", "()Z", "placeUnknown", "placeFindAction", "placeMainMenu", "placeToolbar", "placeContextMenu", "placeKeyboard", "global", "getGlobal", "intellij.database.impl"})
    public static final class Place
    extends Enum<Place> {
        private final boolean local;
        public static final /* enum */ Place placeUnknown = new Place(false);
        public static final /* enum */ Place placeFindAction = new Place(false);
        public static final /* enum */ Place placeMainMenu = new Place(false);
        public static final /* enum */ Place placeToolbar = new Place(false);
        public static final /* enum */ Place placeContextMenu = new Place(true);
        public static final /* enum */ Place placeKeyboard = new Place(true);
        private static final /* synthetic */ Place[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Place(boolean local) {
            this.local = local;
        }

        public final boolean getLocal() {
            return this.local;
        }

        public final boolean getGlobal() {
            return !this.local;
        }

        public static Place[] values() {
            return (Place[])$VALUES.clone();
        }

        public static Place valueOf(String value) {
            return Enum.valueOf(Place.class, value);
        }

        @NotNull
        public static EnumEntries<Place> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = placeArray = new Place[]{Place.placeUnknown, Place.placeFindAction, Place.placeMainMenu, Place.placeToolbar, Place.placeContextMenu, Place.placeKeyboard};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010 \u001a\u0004\u0018\u00010!J\n\u0010\"\u001a\u00020#H\u0096\u0080\u0004J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u00c6\u0003J\t\u0010(\u001a\u00020\rH\u00c6\u0003JM\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0014\u0010*\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010+\u001a\u00020,H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001d\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\u001f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0018\u00a8\u0006-"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$Selection;", "", "project", "Lcom/intellij/openapi/project/Project;", "arms", "", "Lcom/intellij/database/explorer/forest/DvArm;", "folders", "", "Lcom/intellij/database/explorer/forest/DvNiceFolder;", "dataSources", "Lcom/intellij/database/view/DataSourceNode;", "other", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/Collection;Ljava/util/Collection;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getArms", "()Ljava/util/List;", "getFolders", "()Ljava/util/Collection;", "getDataSources", "getOther", "()Z", "hasArms", "getHasArms", "hasFolders", "getHasFolders", "hasDataSources", "getHasDataSources", "isEmpty", "findSingleParent", "Lcom/intellij/database/explorer/forest/DvFolder;", "toString", "", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "hashCode", "", "intellij.database.impl"})
    public static final class Selection {
        @NotNull
        private final Project project;
        @NotNull
        private final List<DvArm> arms;
        @NotNull
        private final Collection<DvNiceFolder> folders;
        @NotNull
        private final Collection<DataSourceNode> dataSources;
        private final boolean other;

        public Selection(@NotNull Project project, @NotNull List<? extends DvArm> arms, @NotNull Collection<DvNiceFolder> folders, @NotNull Collection<DataSourceNode> dataSources, boolean other) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(arms, (String)"arms");
            Intrinsics.checkNotNullParameter(folders, (String)"folders");
            Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
            this.project = project;
            this.arms = arms;
            this.folders = folders;
            this.dataSources = dataSources;
            this.other = other;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final List<DvArm> getArms() {
            return this.arms;
        }

        @NotNull
        public final Collection<DvNiceFolder> getFolders() {
            return this.folders;
        }

        @NotNull
        public final Collection<DataSourceNode> getDataSources() {
            return this.dataSources;
        }

        public final boolean getOther() {
            return this.other;
        }

        public final boolean getHasArms() {
            return !((Collection)this.arms).isEmpty();
        }

        public final boolean getHasFolders() {
            return !this.folders.isEmpty();
        }

        public final boolean getHasDataSources() {
            return !this.dataSources.isEmpty();
        }

        public final boolean isEmpty() {
            return this.arms.isEmpty() && !this.other;
        }

        @Nullable
        public final DvFolder findSingleParent() {
            return (DvFolder)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.arms), Selection::findSingleParent$lambda$0)));
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.getHasFolders()) {
                $this$toString_u24lambda_u240.append(this.folders.size()).append(" folders");
            }
            if (this.getHasFolders() && this.getHasDataSources()) {
                $this$toString_u24lambda_u240.append(" and ");
            }
            if (this.getHasDataSources()) {
                $this$toString_u24lambda_u240.append(this.dataSources.size()).append(" data sources");
            }
            if (this.isEmpty()) {
                $this$toString_u24lambda_u240.append("nothing");
            }
            return stringBuilder.toString();
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final List<DvArm> component2() {
            return this.arms;
        }

        @NotNull
        public final Collection<DvNiceFolder> component3() {
            return this.folders;
        }

        @NotNull
        public final Collection<DataSourceNode> component4() {
            return this.dataSources;
        }

        public final boolean component5() {
            return this.other;
        }

        @NotNull
        public final Selection copy(@NotNull Project project, @NotNull List<? extends DvArm> arms, @NotNull Collection<DvNiceFolder> folders, @NotNull Collection<DataSourceNode> dataSources, boolean other) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(arms, (String)"arms");
            Intrinsics.checkNotNullParameter(folders, (String)"folders");
            Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
            return new Selection(project, arms, folders, dataSources, other);
        }

        public static /* synthetic */ Selection copy$default(Selection selection, Project project, List list, Collection collection, Collection collection2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                project = selection.project;
            }
            if ((n & 2) != 0) {
                list = selection.arms;
            }
            if ((n & 4) != 0) {
                collection = selection.folders;
            }
            if ((n & 8) != 0) {
                collection2 = selection.dataSources;
            }
            if ((n & 0x10) != 0) {
                bl = selection.other;
            }
            return selection.copy(project, list, collection, collection2, bl);
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + ((Object)this.arms).hashCode();
            result2 = result2 * 31 + ((Object)this.folders).hashCode();
            result2 = result2 * 31 + ((Object)this.dataSources).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.other);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Selection)) {
                return false;
            }
            Selection selection = (Selection)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)selection.project)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.arms, selection.arms)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.folders, selection.folders)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dataSources, selection.dataSources)) {
                return false;
            }
            return this.other == selection.other;
        }

        private static final DvFolder findSingleParent$lambda$0(DvArm it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getParent();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/explorer/structure/DvForestAction$ShiftGroup;", "Lcom/intellij/ide/actions/NonTrivialActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    public static final class ShiftGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation p = presentation;
            if (!p.isVisible()) {
                return;
            }
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(dataContext);
            int m = BooleanFun.countTrues$default((boolean)ranks.contains(DvTreeNodeRank.TL_FOLDER), (boolean)ranks.contains(DvTreeNodeRank.TL_ROOT), (boolean)false, (int)4, null);
            int n = ranks.size();
            p.setEnabledAndVisible(m >= 1 && n == m);
        }
    }
}

