/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.cloudExplorer.CloudConnectionData;
import com.intellij.database.cloudExplorer.CloudConnectionDataStorage;
import com.intellij.database.cloudExplorer.CloudDataSourceProvider;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.database.view.ui.KnownCloudProviderPlugins;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudConnectionSideTab
extends DatabaseConfigSideTab {
    public CloudConnectionSideTab(@NotNull DatabaseConfigEditorImpl editor2) {
        if (editor2 == null) {
            CloudConnectionSideTab.$$$reportNull$$$0(0);
        }
        super(DatabaseBundle.message((String)"tab.clouds", (Object[])new Object[0]), editor2);
    }

    @Override
    void configureActionGroups(DefaultActionGroup left, DefaultActionGroup right, DefaultActionGroup context, JList<?> target) {
        AddAction addAction = new AddAction();
        addAction.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), target);
        DatabaseConfigSideTab.RemoveAction removeAction = new DatabaseConfigSideTab.RemoveAction();
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), target);
        left.addAll(new AnAction[]{addAction, removeAction});
        context.add((AnAction)addAction);
        context.add((AnAction)removeAction);
    }

    Collection<CloudConnectionData> getAllowedConnections(@NotNull DatabaseConfigEditorImpl.DataSourceSettings settings) {
        if (settings == null) {
            CloudConnectionSideTab.$$$reportNull$$$0(1);
        }
        CloudConnectionDataStorage storage = CloudConnectionDataStorage.Companion.getInstance();
        ArrayList<CloudConnectionData> result2 = new ArrayList<CloudConnectionData>(storage.getConnectionsData());
        result2.addAll(settings.newConnectionData);
        result2.removeAll(this.myRemovedObjects);
        result2.sort(Comparator.comparing(CloudConnectionData::getCloudProviderId, DbPresentation.NAMES_COMPARATOR));
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refillSidePanel(@NotNull DatabaseConfigEditorImpl.DataSourceSettings settings, boolean keepSelection) {
        if (settings == null) {
            CloudConnectionSideTab.$$$reportNull$$$0(2);
        }
        try {
            HashSet addedItems = new HashSet();
            Set selection = keepSelection ? this.getSelectedItems().toSet() : null;
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(true);
            this.mySidePanel.clear();
            List list = ContainerUtil.sorted((Collection)ContainerUtil.map(this.getAllowedConnections(settings), this::createItem), Comparator.comparing(SidePanelItem.CloudItem::getName, DbPresentation.NAMES_COMPARATOR));
            for (SidePanelItem item : list) {
                addedItems.add(this.addToSidePanel(item));
            }
            if (keepSelection) {
                this.restoreSelection(selection);
            }
            for (SidePanelItem item : new ArrayList(this.mySidePanelItems.values())) {
                if (addedItems.contains(item)) continue;
                this.removeSidePanelItem(item);
            }
        }
        finally {
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(false);
        }
    }

    private SidePanelItem.CloudItem createItem(@NotNull CloudConnectionData data) {
        SidePanelItem.CloudItem item;
        if (data == null) {
            CloudConnectionSideTab.$$$reportNull$$$0(3);
        }
        if ((item = (SidePanelItem.CloudItem)this.getSidePanelItem(data)) == null) {
            item = new SidePanelItem.CloudItem(this.myEditor, data);
        }
        return this.createItem(item);
    }

    @Override
    public boolean isMine(Object object) {
        return object instanceof CloudConnectionData;
    }

    @Override
    boolean canRemove(@NotNull SidePanelItem<?, ?> item) {
        SidePanelItem.CloudItem cloudItem;
        if (item == null) {
            CloudConnectionSideTab.$$$reportNull$$$0(4);
        }
        return (cloudItem = (SidePanelItem.CloudItem)ObjectUtils.tryCast(item, SidePanelItem.CloudItem.class)) != null;
    }

    @Override
    protected void ensureNewObjectDropped(Object object) {
        if (object instanceof CloudConnectionData) {
            this.myEditor.getSettings().newConnectionData.remove(object);
        }
    }

    @Override
    protected void removeObject(Object object) {
        if (object instanceof CloudConnectionData) {
            CloudConnectionData element = (CloudConnectionData)object;
            CloudConnectionData exists = CloudConnectionDataStorage.Companion.getInstance().getConnectionData(element.getId());
            if (exists != null) {
                CloudConnectionDataStorage.Companion.getInstance().removeConnectionData(exists);
            }
        }
    }

    @Override
    public void copy(@NotNull SidePanelItem<?, ?> item) {
        SidePanelItem.CloudItem cloudItem;
        if (item == null) {
            CloudConnectionSideTab.$$$reportNull$$$0(5);
        }
        if ((cloudItem = (SidePanelItem.CloudItem)ObjectUtils.tryCast(item, SidePanelItem.CloudItem.class)) == null) {
            return;
        }
        CloudConnectionData data = this.myEditor.getTempTargetOrTarget((CloudConnectionData)cloudItem.getObject());
        Set names = (Set)JBIterable.from(this.getAllowedConnections(this.myEditor.getSettings())).map(CloudConnectionData::getName).addAllTo((Collection)CollectionFactory.createCaseInsensitiveStringSet());
        String newName = DbUtil.generateUniqueName((String)data.getName(), (Set)names);
        CloudConnectionData copy = data.copy();
        data.setName(newName);
        this.onCloudCreated(copy);
    }

    @Override
    public boolean canCopy(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            CloudConnectionSideTab.$$$reportNull$$$0(6);
        }
        return item instanceof SidePanelItem.CloudItem;
    }

    void onCloudCreated(@NotNull CloudConnectionData data) {
        if (data == null) {
            CloudConnectionSideTab.$$$reportNull$$$0(7);
        }
        this.myEditor.getSettings().newConnectionData.add(data);
        data.setName(this.myEditor.generateObjectName(data, data.getName()));
        this.refillSidePanel(this.myEditor.getSettings(), false);
        this.myEditor.navigateTo(data, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/ui/CloudConnectionSideTab";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllowedConnections";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "refillSidePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canRemove";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "copy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canCopy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onCloudCreated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class AddAction
    extends ActionGroup
    implements DumbAware {
        public AddAction() {
            super(DatabaseBundle.message((String)"action.add.text", (Object[])new Object[0]), null, IconUtil.getAddIcon());
            this.setPopup(true);
            this.getTemplatePresentation().setPerformGroup(true);
            this.getTemplatePresentation().putClientProperty(ActionUtil.SUPPRESS_SUBMENU, (Object)true);
            this.getTemplatePresentation().putClientProperty(ActionUtil.ALWAYS_VISIBLE_GROUP, (Object)true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 20, null, ActionPlaces.getPopupPlace((String)"database"));
            DbUIUtil.showPopup((JBPopup)popup2, null, e);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = AddAction.getCloudActions().toArray(EMPTY_ARRAY);
            if (anActionArray == null) {
                AddAction.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        public static List<AnAction> getCloudActions() {
            ArrayList<AnAction> actions = new ArrayList<AnAction>();
            HashSet<String> presentedProviders = new HashSet<String>();
            CloudDataSourceProvider.Companion.getProviders().forEach(providerWithKey -> {
                presentedProviders.add((String)providerWithKey.getFirst());
                final CloudDataSourceProvider p = (CloudDataSourceProvider)providerWithKey.getSecond();
                actions.add((AnAction)new DumbAwareAction(p.getDisplayName(), null, p.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        CloudConnectionSideTab tab;
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((tab = AddAction.getCloudTab(e)) == null) {
                            return;
                        }
                        tab.onCloudCreated(p.createConnectionData());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/CloudConnectionSideTab$AddAction$1", "actionPerformed"));
                    }
                });
            });
            List<AnAction> stubsDownloadActions = KnownCloudProviderPlugins.Companion.createDownloadActions(presentedProviders);
            if (!stubsDownloadActions.isEmpty()) {
                actions.add((AnAction)new Separator(DatabaseBundle.message((String)"separator.download.cloud.provider.plugin", (Object[])new Object[0])));
                actions.addAll(stubsDownloadActions);
            }
            return actions;
        }

        private static CloudConnectionSideTab getCloudTab(@Nullable AnActionEvent e) {
            return e == null ? null : (CloudConnectionSideTab)ObjectUtils.tryCast((Object)e.getData(DatabaseConfigSideTab.SIDE_PANEL), CloudConnectionSideTab.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/CloudConnectionSideTab$AddAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/CloudConnectionSideTab$AddAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

