/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.migration.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.migration.ConsolesMigrationManagerImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u000245B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0012\u0010 \u001a\u00020\u001a2\b\b\u0001\u0010!\u001a\u00020\u0015H\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u000fH\u0002J\b\u0010$\u001a\u00020\u001aH\u0002J \u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u000f0&2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010)\u001a\u00020\u001aH\u0002J\b\u0010*\u001a\u00020\u000bH\u0002J(\u0010+\u001a\u00020\u001a*\u00020\u00012\u0006\u0010,\u001a\u00020'2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020.H\u0002J\b\u00100\u001a\u00020\u001aH\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\b\u00102\u001a\u00020\u001aH\u0002J\f\u00103\u001a\u00020\u0015*\u00020\u0007H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/database/console/migration/view/ConsolesMigrationSettingsPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "migrationInfo", "Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;)V", "exampleLabel", "Lcom/intellij/ui/components/JBLabel;", "fileNameInput", "Lcom/intellij/ui/components/JBTextField;", "localDirectoryInput", "Ljavax/swing/JTextField;", "validationStatusChangedListener", "Lcom/intellij/database/console/migration/view/ConsolesMigrationSettingsPanel$ValidationStatusChangedListener;", "isMigrationInfoValid", "", "exampleDataSourceName", "", "Lorg/jetbrains/annotations/NotNull;", "constraints", "Ljava/awt/GridBagConstraints;", "setValidationStatusChangedListener", "", "listener", "setupUI", "createFilePathsHeader", "Lcom/intellij/ui/TitledSeparator;", "createFileNamesHeader", "addDescriptionLabel", "text", "setDirectoryValidator", "textField", "addDirectoryChoosers", "createDirectoryChooserComponentAndTextField", "Lkotlin/Pair;", "Ljavax/swing/JComponent;", "preDefinedText", "addFileNameInput", "createPrefixLabel", "addComponent", "component", "bottomOffset", "", "leftOffset", "setupListeners", "checkValidation", "updateMigrationInfo", "getExampleLabelText", "ValidationStatusChangedListener", "OnTextUpdatedDocumentListener", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nConsolesMigrationSettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsolesMigrationSettingsPanel.kt\ncom/intellij/database/console/migration/view/ConsolesMigrationSettingsPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class ConsolesMigrationSettingsPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final ConsolesMigrationManagerImpl.MigrationInfo migrationInfo;
    @NotNull
    private final JBLabel exampleLabel;
    @NotNull
    private final JBTextField fileNameInput;
    @Nullable
    private JTextField localDirectoryInput;
    @Nullable
    private ValidationStatusChangedListener validationStatusChangedListener;
    private boolean isMigrationInfoValid;
    @NotNull
    private final String exampleDataSourceName;
    @NotNull
    private final GridBagConstraints constraints;

    public ConsolesMigrationSettingsPanel(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull ConsolesMigrationManagerImpl.MigrationInfo migrationInfo) {
        Object $this$exampleLabel_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        this.project = project;
        this.parentDisposable = parentDisposable;
        this.migrationInfo = migrationInfo;
        JBLabel jBLabel = object = new JBLabel();
        ConsolesMigrationSettingsPanel consolesMigrationSettingsPanel = this;
        boolean bl = false;
        $this$exampleLabel_u24lambda_u240.setAllowAutoWrapping(true);
        consolesMigrationSettingsPanel.exampleLabel = object;
        this.fileNameInput = new JBTextField(this.migrationInfo.getFileNameTemplate());
        Object object2 = (LocalDataSource)CollectionsKt.firstOrNull((List)CollectionsKt.toList((Iterable)this.migrationInfo.getConsolesToMigrate().keySet()));
        if (object2 == null || (object2 = object2.getDataSource()) == null || (object2 = object2.getName()) == null) {
            object2 = "DataSource";
        }
        this.exampleDataSourceName = object2;
        $this$exampleLabel_u24lambda_u240 = object = new GridBagConstraints();
        consolesMigrationSettingsPanel = this;
        boolean bl2 = false;
        $this$constraints_u24lambda_u240.fill = 2;
        $this$constraints_u24lambda_u240.anchor = 18;
        $this$constraints_u24lambda_u240.gridy = 0;
        $this$constraints_u24lambda_u240.gridx = 0;
        $this$constraints_u24lambda_u240.weightx = 1.0;
        $this$constraints_u24lambda_u240.weighty = 0.0;
        consolesMigrationSettingsPanel.constraints = object;
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)16, (int)40, (int)16));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setupUI();
        this.setupListeners();
        this.updateMigrationInfo();
    }

    public final void setValidationStatusChangedListener(@NotNull ValidationStatusChangedListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.validationStatusChangedListener = listener2;
    }

    private final void setupUI() {
        this.addComponent(this, (JComponent)this.createFilePathsHeader(), 8, 0);
        this.addDirectoryChoosers();
        this.addComponent(this, (JComponent)this.createFileNamesHeader(), 8, 0);
        ConsolesMigrationSettingsPanel.addComponent$default(this, this, (JComponent)this.exampleLabel, 0, 0, 6, null);
        String string = DatabaseBundle.message((String)"consoles.migration.files.names.description.migration", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addDescriptionLabel(string);
        this.addFileNameInput();
        Object[] objectArray = new Object[]{"$DATA_SOURCE$"};
        this.addDescriptionLabel("<html>" + DatabaseBundle.message((String)"settings.query.file.template.description", (Object[])objectArray) + "</html>");
        this.constraints.weighty = 1.0;
        this.add(Box.createVerticalGlue(), this.constraints);
    }

    private final TitledSeparator createFilePathsHeader() {
        return new TitledSeparator(DatabaseBundle.message((String)"consoles.migration.directory", (Object[])new Object[0]));
    }

    private final TitledSeparator createFileNamesHeader() {
        return new TitledSeparator(DatabaseBundle.message((String)"consoles.migration.files.names.migration", (Object[])new Object[0]));
    }

    private final void addDescriptionLabel(@Nls String text) {
        JBLabel jBLabel;
        JBLabel $this$addDescriptionLabel_u24lambda_u240 = jBLabel = new JBLabel(text);
        boolean bl = false;
        $this$addDescriptionLabel_u24lambda_u240.setForeground(JBUI.CurrentTheme.Label.disabledForeground());
        JBLabel descriptionLabel = jBLabel;
        ConsolesMigrationSettingsPanel.addComponent$default(this, this, (JComponent)descriptionLabel, 8, 0, 4, null);
    }

    private final void setDirectoryValidator(JTextField textField) {
        ComponentValidator validator = new ComponentValidator(this.parentDisposable).withValidator(() -> ConsolesMigrationSettingsPanel.setDirectoryValidator$lambda$0(textField, this)).andRegisterOnDocumentListener((JTextComponent)textField).installOn((JComponent)textField);
        validator.revalidate();
    }

    private final void addDirectoryChoosers() {
        CharSequence charSequence;
        ConsolesMigrationSettingsPanel consolesMigrationSettingsPanel = this;
        CharSequence charSequence2 = this.migrationInfo.getQueriesDirectory();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            ConsolesMigrationSettingsPanel consolesMigrationSettingsPanel2 = consolesMigrationSettingsPanel;
            boolean bl = false;
            charSequence = null;
            consolesMigrationSettingsPanel = consolesMigrationSettingsPanel2;
        } else {
            charSequence = charSequence2;
        }
        Pair<JComponent, JTextField> pair = consolesMigrationSettingsPanel.createDirectoryChooserComponentAndTextField((String)charSequence);
        JComponent localDirectoryComponent = (JComponent)pair.component1();
        JTextField localDirectoryChooser = (JTextField)pair.component2();
        this.addComponent(this, localDirectoryComponent, 0, 20);
        this.setDirectoryValidator(localDirectoryChooser);
        this.localDirectoryInput = localDirectoryChooser;
    }

    private final Pair<JComponent, JTextField> createDirectoryChooserComponentAndTextField(@Nls String preDefinedText) {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.singleDir();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"singleDir(...)");
        TextFieldWithBrowseButton chooser = ComponentsKt.textFieldWithBrowseButton$default((Project)this.project, (FileChooserDescriptor)fileChooserDescriptor, null, (int)4, null);
        String string = preDefinedText;
        if (string == null) {
            Path path = QueryFileSettings.Companion.getDefaultQueriesPath(this.project);
            string = path != null ? ((Object)path).toString() : null;
            if (string == null) {
                string = "";
            }
        }
        chooser.setText(string);
        return TuplesKt.to((Object)chooser, (Object)chooser.getTextField());
    }

    private final void addFileNameInput() {
        JPanel jPanel;
        JPanel $this$addFileNameInput_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$addFileNameInput_u24lambda_u240.setLayout(new BoxLayout($this$addFileNameInput_u24lambda_u240, 0));
        $this$addFileNameInput_u24lambda_u240.add((Component)this.createPrefixLabel());
        $this$addFileNameInput_u24lambda_u240.add(Box.createHorizontalStrut(JBUI.scale((int)8)));
        $this$addFileNameInput_u24lambda_u240.add((Component)this.fileNameInput);
        JPanel inputWithLabel = jPanel;
        new ComponentValidator(this.parentDisposable).withValidator(() -> ConsolesMigrationSettingsPanel.addFileNameInput$lambda$1(this)).andRegisterOnDocumentListener((JTextComponent)this.fileNameInput).installOn((JComponent)this.fileNameInput);
        ConsolesMigrationSettingsPanel.addComponent$default(this, this, inputWithLabel, 0, 0, 6, null);
    }

    private final JBLabel createPrefixLabel() {
        return new JBLabel(DatabaseBundle.message((String)"consoles.migration.files.prefix.migration", (Object[])new Object[0]));
    }

    private final void addComponent(JPanel $this$addComponent, JComponent component, int bottomOffset, int leftOffset) {
        this.constraints.insets = (Insets)JBUI.insets((int)0, (int)leftOffset, (int)bottomOffset, (int)0);
        $this$addComponent.add((Component)component, this.constraints);
        GridBagConstraints gridBagConstraints = this.constraints;
        int n = gridBagConstraints.gridy;
        gridBagConstraints.gridy = n + 1;
    }

    static /* synthetic */ void addComponent$default(ConsolesMigrationSettingsPanel consolesMigrationSettingsPanel, JPanel jPanel, JComponent jComponent, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 4;
        }
        if ((n3 & 4) != 0) {
            n2 = 22;
        }
        consolesMigrationSettingsPanel.addComponent(jPanel, jComponent, n, n2);
    }

    private final void setupListeners() {
        block0: {
            OnTextUpdatedDocumentListener documentListener2 = new OnTextUpdatedDocumentListener(this){
                final /* synthetic */ ConsolesMigrationSettingsPanel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onTextUpdated() {
                    ConsolesMigrationSettingsPanel.access$updateMigrationInfo(this.this$0);
                }
            };
            this.fileNameInput.getDocument().addDocumentListener(documentListener2);
            Object object = this.localDirectoryInput;
            if (object == null || (object = ((JTextComponent)object).getDocument()) == null) break block0;
            object.addDocumentListener(documentListener2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkValidation() {
        block4: {
            v0 = this.localDirectoryInput;
            if (v0 == null) {
                return;
            }
            localDirectory = v0;
            v1 = ComponentValidator.getInstance((JComponent)localDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
            v2 = (ComponentValidator)OptionalsKt.getOrNull((Optional)v1);
            if ((v2 != null ? v2.getValidationInfo() : null) != null) ** GOTO lbl-1000
            v3 = ComponentValidator.getInstance((JComponent)((JComponent)this.fileNameInput));
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
            v4 = (ComponentValidator)OptionalsKt.getOrNull((Optional)v3);
            if ((v4 != null ? v4.getValidationInfo() : null) == null) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = newIsValid = false;
            }
            if (newIsValid == this.isMigrationInfoValid) break block4;
            this.isMigrationInfoValid = newIsValid;
            v6 = this.validationStatusChangedListener;
            if (v6 != null) {
                v6.onValidationStatusChanged(newIsValid);
            }
        }
    }

    private final void updateMigrationInfo() {
        ConsolesMigrationManagerImpl.MigrationInfo migrationInfo;
        ConsolesMigrationManagerImpl.MigrationInfo $this$updateMigrationInfo_u24lambda_u240 = migrationInfo = this.migrationInfo;
        boolean bl = false;
        String string = this.fileNameInput.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $this$updateMigrationInfo_u24lambda_u240.setFileNameTemplate(((Object)StringsKt.trim((CharSequence)string)).toString());
        Object object = this.localDirectoryInput;
        if (object == null || (object = ((JTextComponent)object).getText()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
            object = "";
        }
        $this$updateMigrationInfo_u24lambda_u240.setQueriesDirectory((String)object);
        this.exampleLabel.setText(this.getExampleLabelText($this$updateMigrationInfo_u24lambda_u240));
        ApplicationManager.getApplication().invokeLater(() -> ConsolesMigrationSettingsPanel.updateMigrationInfo$lambda$1(this));
    }

    @Nls
    private final String getExampleLabelText(ConsolesMigrationManagerImpl.MigrationInfo $this$getExampleLabelText) {
        Object[] objectArray = new Object[]{QueryFileSettings.Companion.getNameForQueryFile($this$getExampleLabelText.getFileNameTemplate(), this.exampleDataSourceName)};
        String string = DatabaseBundle.message((String)"console.migration.files.names.example.migration", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final ValidationInfo setDirectoryValidator$lambda$0(JTextField $textField, ConsolesMigrationSettingsPanel this$0) {
        Object object;
        block7: {
            block6: {
                String string = $textField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string)) break block6;
                String string2 = $textField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (!(((CharSequence)string2).length() == 0)) break block7;
            }
            return new ValidationInfo(DatabaseBundle.message((String)"consoles.migration.validation.message.empty.path", (Object[])new Object[0]), (JComponent)$textField);
        }
        Object object2 = this$0;
        try {
            ConsolesMigrationSettingsPanel $this$setDirectoryValidator_u24lambda_u240_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Paths.get($textField.getText(), new String[0]));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Path path = (Path)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (QueryFileSettings.Companion.getValidPathOrNull(path) == null) {
            return new ValidationInfo(DatabaseBundle.message((String)"consoles.migration.validation.message.invalid.path", (Object[])new Object[0]), (JComponent)$textField);
        }
        return null;
    }

    private static final ValidationInfo addFileNameInput$lambda$1(ConsolesMigrationSettingsPanel this$0) {
        return QueryFileSettings.Companion.getValidFileNameOrNull(this$0.fileNameInput.getText()) != null ? null : new ValidationInfo(DatabaseBundle.message((String)"consoles.migration.validation.message.invalid.file.name", (Object[])new Object[0]), (JComponent)this$0.fileNameInput);
    }

    private static final void updateMigrationInfo$lambda$1(ConsolesMigrationSettingsPanel this$0) {
        this$0.checkValidation();
    }

    public static final /* synthetic */ void access$updateMigrationInfo(ConsolesMigrationSettingsPanel $this) {
        $this.updateMigrationInfo();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e2\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0012\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\b\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/migration/view/ConsolesMigrationSettingsPanel$OnTextUpdatedDocumentListener;", "Ljavax/swing/event/DocumentListener;", "onTextUpdated", "", "insertUpdate", "e", "Ljavax/swing/event/DocumentEvent;", "removeUpdate", "changedUpdate", "intellij.database.impl"})
    private static interface OnTextUpdatedDocumentListener
    extends DocumentListener {
        public void onTextUpdated();

        @Override
        default public void insertUpdate(@Nullable DocumentEvent e) {
            this.onTextUpdated();
        }

        @Override
        default public void removeUpdate(@Nullable DocumentEvent e) {
            this.onTextUpdated();
        }

        @Override
        default public void changedUpdate(@Nullable DocumentEvent e) {
            this.onTextUpdated();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/console/migration/view/ConsolesMigrationSettingsPanel$ValidationStatusChangedListener;", "", "onValidationStatusChanged", "", "isValid", "", "intellij.database.impl"})
    public static interface ValidationStatusChangedListener {
        public void onValidationStatusChanged(boolean var1);
    }
}

