/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.IntrospectionTaskHelperFun;
import com.intellij.database.model.basic.BasicMultiLevelSchema;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.properties.Level;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J#\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/intellij/database/dataSource/DesktopUserNotifier;", "Lcom/intellij/database/introspection/DBIntrospectionContext$UserNotifier;", "project", "Lcom/intellij/openapi/project/Project;", "dsName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDsName", "()Ljava/lang/String;", "notifyLevelAutoSelection", "", "databaseName", "schemas", "", "Lcom/intellij/database/model/basic/BasicMultiLevelSchema;", "makeLevelList", "Lorg/jetbrains/annotations/Nls;", "level", "Lcom/intellij/database/model/properties/Level;", "Lcom/intellij/database/model/basic/BasicSchema;", "notifyDiagnosticMonitorFile", "eventType", "Lcom/intellij/database/introspection/DBIntrospectionContext$DiagnosticNotificationEventType;", "filePath", "Ljava/nio/file/Path;", "Companion", "LevelsHelpAction", "DiagnosticFileRevealAction", "DiagnosticFileOpenAction", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDesktopUserNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopUserNotifier.kt\ncom/intellij/database/dataSource/DesktopUserNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n777#2:122\n873#2,2:123\n777#2:125\n873#2,2:126\n777#2:128\n873#2,2:129\n*S KotlinDebug\n*F\n+ 1 DesktopUserNotifier.kt\ncom/intellij/database/dataSource/DesktopUserNotifier\n*L\n46#1:122\n46#1:123,2\n47#1:125\n47#1:126,2\n48#1:128\n48#1:129,2\n*E\n"})
public final class DesktopUserNotifier
implements DBIntrospectionContext.UserNotifier {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String dsName;
    @NotNull
    private static final String helpId = "introspection.levels";

    public DesktopUserNotifier(@NotNull Project project, @NotNull String dsName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dsName, (String)"dsName");
        this.project = project;
        this.dsName = dsName;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getDsName() {
        return this.dsName;
    }

    /*
     * WARNING - void declaration
     */
    public void notifyLevelAutoSelection(@NotNull String databaseName, @NotNull Collection<? extends BasicMultiLevelSchema> schemas) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        Iterable $this$filter$iv = schemas;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            BasicMultiLevelSchema it = (BasicMultiLevelSchema)element$iv$iv;
            boolean bl = false;
            if (!(it.getAutoIntrospectionLevel() == Level.L3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List schemas3 = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = schemas;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            BasicMultiLevelSchema it = (BasicMultiLevelSchema)element$iv$iv;
            boolean bl = false;
            if (!(it.getAutoIntrospectionLevel() == Level.L2)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List schemas2 = (List)destination$iv$iv2;
        Iterable $this$filter$iv3 = schemas;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BasicMultiLevelSchema it = (BasicMultiLevelSchema)element$iv$iv;
            boolean bl = false;
            if (!(it.getAutoIntrospectionLevel() == Level.L1)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List schemas1 = (List)destination$iv$iv3;
        Object object = new Object[]{this.dsName};
        String string = DatabaseBundle.message((String)"introspection.level.autoSelect.notification.title", (Object[])object);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        Object $this$notifyLevelAutoSelection_u24lambda_u243 = object = new StringBuilder();
        boolean bl = false;
        if (((CharSequence)databaseName).length() > 0) {
            Object[] objectArray = new Object[]{databaseName};
            StringBuilder stringBuilder = ((StringBuilder)$this$notifyLevelAutoSelection_u24lambda_u243).append(DatabaseBundle.message((String)"introspection.level.autoSelect.notification.database.text", (Object[])objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append("<br/>").append('\n');
        }
        if (IntrospectionTaskHelperFun.isNotEmpty((Iterable)schemas3)) {
            StringBuilder stringBuilder = ((StringBuilder)$this$notifyLevelAutoSelection_u24lambda_u243).append(this.makeLevelList(Level.L3, schemas3));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.append("<br/>").append('\n');
        }
        if (IntrospectionTaskHelperFun.isNotEmpty((Iterable)schemas2)) {
            StringBuilder stringBuilder = ((StringBuilder)$this$notifyLevelAutoSelection_u24lambda_u243).append(this.makeLevelList(Level.L2, schemas2));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder4 = stringBuilder;
            stringBuilder4.append("<br/>").append('\n');
        }
        if (IntrospectionTaskHelperFun.isNotEmpty((Iterable)schemas1)) {
            StringBuilder stringBuilder = ((StringBuilder)$this$notifyLevelAutoSelection_u24lambda_u243).append(this.makeLevelList(Level.L1, schemas1));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            StringBuilder stringBuilder5 = stringBuilder;
            stringBuilder5.append("<br/>").append('\n');
        }
        StringBuilder stringBuilder = ((StringBuilder)$this$notifyLevelAutoSelection_u24lambda_u243).append("<p>").append(DatabaseBundle.message((String)"introspection.level.autoSelect.notification.footer", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        StringBuilder stringBuilder6 = stringBuilder;
        stringBuilder6.append("</p>").append('\n');
        String text = ((StringBuilder)object).toString();
        ApplicationManager.getApplication().invokeLater(() -> DesktopUserNotifier.notifyLevelAutoSelection$lambda$4(title, text, this));
    }

    private final String makeLevelList(Level level, Collection<? extends BasicSchema> schemas) {
        int n = schemas.size();
        Object list = null;
        if (n <= 6) {
            list = CollectionsKt.joinToString$default((Iterable)schemas, null, null, null, (int)0, null, DesktopUserNotifier::makeLevelList$lambda$0, (int)31, null);
        } else {
            String listPart1 = SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)schemas), (int)5), null, null, null, (int)0, null, DesktopUserNotifier::makeLevelList$lambda$1, (int)31, null);
            Object[] objectArray = new Object[]{n - 5};
            String string = DatabaseBundle.message((String)"introspection.level.autoSelect.notification.level.andMore", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String listPart2 = string;
            list = listPart1 + ", " + listPart2;
        }
        Object[] objectArray = new Object[]{level.level, list};
        String string = DatabaseBundle.message((String)"introspection.level.autoSelect.notification.level.list", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void notifyDiagnosticMonitorFile(@NotNull DBIntrospectionContext.DiagnosticNotificationEventType eventType, @NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String title = null;
        String text = null;
        String filePathStr = ((Object)filePath.toAbsolutePath()).toString();
        switch (WhenMappings.$EnumSwitchMapping$0[eventType.ordinal()]) {
            case 1: {
                String string = DatabaseBundle.message((String)"introspector.diagnostic.notification.start.title", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                title = string;
                Object[] objectArray = new Object[]{filePathStr};
                String string2 = DatabaseBundle.message((String)"introspector.diagnostic.notification.start.text", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                text = string2;
                break;
            }
            case 2: {
                String string = DatabaseBundle.message((String)"introspector.diagnostic.notification.stop.title", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                title = string;
                Object[] objectArray = new Object[]{filePathStr};
                String string3 = DatabaseBundle.message((String)"introspector.diagnostic.notification.stop.text", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                text = string3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> DesktopUserNotifier.notifyDiagnosticMonitorFile$lambda$0(title, text, filePath, this));
    }

    private static final void notifyLevelAutoSelection$lambda$4(String $title, String $text, DesktopUserNotifier this$0) {
        NotificationGroupManager.getInstance().getNotificationGroup("Introspection Level Auto-selection").createNotification($title, $text, NotificationType.INFORMATION).addAction((AnAction)LevelsHelpAction.INSTANCE).notify(this$0.project);
    }

    private static final CharSequence makeLevelList$lambda$0(BasicSchema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    private static final CharSequence makeLevelList$lambda$1(BasicSchema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    private static final void notifyDiagnosticMonitorFile$lambda$0(String $title, String $text, Path $filePath, DesktopUserNotifier this$0) {
        NotificationGroupManager.getInstance().getNotificationGroup("Introspection Diagnostic").createNotification($title, $text, NotificationType.INFORMATION).addAction((AnAction)new DiagnosticFileRevealAction($filePath)).addAction((AnAction)new DiagnosticFileOpenAction($filePath)).notify(this$0.project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/DesktopUserNotifier$Companion;", "", "<init>", "()V", "helpId", "", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dataSource/DesktopUserNotifier$DiagnosticFileOpenAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "filePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDesktopUserNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopUserNotifier.kt\ncom/intellij/database/dataSource/DesktopUserNotifier$DiagnosticFileOpenAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
    private static final class DiagnosticFileOpenAction
    extends DumbAwareAction {
        @NotNull
        private final Path filePath;

        public DiagnosticFileOpenAction(@NotNull Path filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            super(DatabaseBundle.messagePointer((String)"introspector.diagnostic.notification.open.file.action.text", (Object[])new Object[0]));
            this.filePath = filePath;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                if (project == null) break block0;
                Project project2 = project;
                boolean bl = false;
                OpenFileAction.Companion.openFile(((Object)this.filePath).toString(), project2);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dataSource/DesktopUserNotifier$DiagnosticFileRevealAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "filePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private static final class DiagnosticFileRevealAction
    extends DumbAwareAction {
        @NotNull
        private final Path filePath;

        public DiagnosticFileRevealAction(@NotNull Path filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            super(DatabaseBundle.messagePointer((String)"introspector.diagnostic.notification.action.text", (Object[])new Object[0]));
            this.filePath = filePath;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RevealFileAction.openFile((Path)this.filePath);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dataSource/DesktopUserNotifier$LevelsHelpAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private static final class LevelsHelpAction
    extends DumbAwareAction {
        @NotNull
        public static final LevelsHelpAction INSTANCE = new LevelsHelpAction();

        private LevelsHelpAction() {
            super(DatabaseBundle.messagePointer((String)"introspection.level.autoSelect.notification.help.action.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            HelpManager.getInstance().invokeHelp(DesktopUserNotifier.helpId);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DBIntrospectionContext.DiagnosticNotificationEventType.values().length];
            try {
                nArray[DBIntrospectionContext.DiagnosticNotificationEventType.DIAGNOSTIC_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DBIntrospectionContext.DiagnosticNotificationEventType.DIAGNOSTIC_STOPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

