/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor.editor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ColumnMappingStrategy;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.dbimport.editor.DbImportAutoTableManager;
import com.intellij.database.dbimport.editor.DbImportDataPreviewManager;
import com.intellij.database.dbimport.editor.data.DataSourceData;
import com.intellij.database.dbimport.editor.data.DbTableSourceData;
import com.intellij.database.dbimport.editor.data.DetectedColumnsData;
import com.intellij.database.dbimport.editor.data.MappingData;
import com.intellij.database.dbimport.editor.editor.DbCsvColumnsEditor;
import com.intellij.database.dbimport.editor.editor.DbMappingColumnsEditorKt;
import com.intellij.database.dbimport.editor.model.state.DbAutoReferenceModelState;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbTableCollectionEditor;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ImmutableColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TableViewModel;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 @*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003:\u0007:;<=>?@B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u001e0\u001dH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0014\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0010H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001dJ\u0010\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'H\u0002J\u001f\u0010)\u001a\u00070\u0017\u00a2\u0006\u0002\b*2\u0006\u0010+\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010-\u001a\u00020.H\u0014J\b\u0010/\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u0017J\u0018\u00103\u001a\u00020\u001b2\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000304H\u0002J\b\u00105\u001a\u00020\u001bH\u0002J\b\u00106\u001a\u00020\u001bH\u0002J\b\u00107\u001a\u00020\u001bH\u0002J\u0018\u00108\u001a\u00020\r2\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000304H\u0002J\u0014\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor;", "E", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/schemaEditor/ui/DbTableCollectionEditor;", "Lcom/intellij/database/dbimport/editor/data/MappingData$ColumnMapping;", "controller", "Lcom/intellij/database/schemaEditor/ui/DbEditorController;", "model", "Lcom/intellij/database/schemaEditor/model/DbModelRef;", "Lcom/intellij/database/schemaEditor/model/state/DbCollectionModelState;", "<init>", "(Lcom/intellij/database/schemaEditor/ui/DbEditorController;Lcom/intellij/database/schemaEditor/model/DbModelRef;)V", "myNeedsValidation", "", "myValidating", "myAutoMappingsCache", "", "Lcom/intellij/database/datagrid/AutoValueDescriptor;", "Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$DetectedColumnDescriptor;", "mySourceColumnsCache", "", "Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$Column;", "myTargetColumnNamesCache", "", "createModelListener", "Lcom/intellij/database/schemaEditor/model/DbEditorModelListener;", "onTableModelChanged", "", "createColumns", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/util/ui/ColumnInfo;", "createDecorator", "Lcom/intellij/ui/ToolbarDecorator;", "getSourceColumns", "getSourceColumnsImpl", "getTargetColumnNames", "getTargetColumnsImpl", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "getTargetTableId", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "Lcom/intellij/database/model/basic/BasicTable;", "getTargetColumnType", "Lcom/intellij/openapi/util/NlsSafe;", "mapping", "column", "createContextMenu", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "isAutoMode", "getAutoMapping", "Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$ColId;", "col", "resetAutoMappings", "Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "updateToolbarPresence", "invalidateMappings", "validateMapping", "isAutoMappingAffected", "getAutoMappings", "TargetColumnInfo", "TargetColumnTypeInfo", "MyMappingCellEditor", "DetectedColumnDescriptor", "SourceColumnInfo", "CleanupNonExisting", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMappingColumnsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingColumnsEditor.kt\ncom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,608:1\n1#2:609\n1205#3,2:610\n1282#3,4:612\n1538#3,3:616\n1541#3,3:626\n383#4,7:619\n*S KotlinDebug\n*F\n+ 1 DbMappingColumnsEditor.kt\ncom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor\n*L\n157#1:610,2\n157#1:612,4\n113#1:616,3\n113#1:626,3\n113#1:619,7\n*E\n"})
public final class DbMappingColumnsEditor<E extends BasicElement>
extends DbTableCollectionEditor<E, MappingData.ColumnMapping> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private volatile boolean myNeedsValidation;
    private volatile boolean myValidating;
    @Nullable
    private Map<AutoValueDescriptor, DetectedColumnDescriptor> myAutoMappingsCache;
    @Nullable
    private List<DetectedColumnsData.Column> mySourceColumnsCache;
    @Nullable
    private Map<String, String> myTargetColumnNamesCache;

    public DbMappingColumnsEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbCollectionModelState<MappingData.ColumnMapping>> model) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super(controller, model, true);
        this.myTable.setShowVerticalLines(false);
        this.myTable.setShowHorizontalLines(false);
    }

    @Override
    @NotNull
    protected DbEditorModelListener createModelListener() {
        return new DbEditorModelListener(this){
            final /* synthetic */ DbMappingColumnsEditor<E> this$0;
            {
                this.this$0 = $receiver;
            }

            public void modified(DbEditorModel<?, ?> model) {
                Intrinsics.checkNotNullParameter(model, (String)"model");
                DbMappingColumnsEditor.access$resetAutoMappings(this.this$0, model);
                DbMappingColumnsEditor.access$getMyTable$p$s-1377066182(this.this$0).repaint();
            }
        };
    }

    @Override
    protected void onTableModelChanged() {
        if (!this.myValidating) {
            super.onTableModelChanged();
        }
    }

    @Override
    @NotNull
    protected JBIterable<ColumnInfo<MappingData.ColumnMapping, ?>> createColumns() {
        Object[] objectArray = new ColumnInfo[]{new TargetColumnInfo(), new TargetColumnTypeInfo(), new SourceColumnInfo()};
        JBIterable jBIterable = JBIterable.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"of(...)");
        return jBIterable;
    }

    @Override
    @NotNull
    protected ToolbarDecorator createDecorator() {
        ToolbarDecorator toolbarDecorator = super.createDecorator().setRemoveAction(arg_0 -> DbMappingColumnsEditor.createDecorator$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)toolbarDecorator, (String)"setRemoveAction(...)");
        return toolbarDecorator;
    }

    @NotNull
    public final List<DetectedColumnsData.Column> getSourceColumns() {
        List<DetectedColumnsData.Column> list;
        List<DetectedColumnsData.Column> list2 = this.mySourceColumnsCache;
        if (list2 != null) {
            List<DetectedColumnsData.Column> it = list2;
            boolean bl = false;
            return it;
        }
        List<DetectedColumnsData.Column> it = list = Collections.unmodifiableList(this.getSourceColumnsImpl());
        boolean bl = false;
        this.mySourceColumnsCache = it;
        List<DetectedColumnsData.Column> list3 = list;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"also(...)");
        return list3;
    }

    private final List<DetectedColumnsData.Column> getSourceColumnsImpl() {
        DbEditorModelController dbEditorModelController = this.getController().getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        DbEditorModelController controller = dbEditorModelController;
        ElementIdentity<?> parentId = this.getController().getParent(this.getIdentity());
        DbCollectionModelState columnsModel = DbCollectionModelState.resolve(controller, parentId, DetectedColumnsData.COLUMNS);
        if (columnsModel != null) {
            return new ArrayList(columnsModel.getItems());
        }
        ElementIdentity<BasicLikeTable> srcId = DbReferenceModelState.resolveReference(controller, parentId, DbTableSourceData.TABLE_REF);
        List list = DbMappingColumnsEditor.Companion.getColumns(controller, srcId).map(arg_0 -> DbMappingColumnsEditor.getSourceColumnsImpl$lambda$1(DbMappingColumnsEditor::getSourceColumnsImpl$lambda$0, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getTargetColumnNames() {
        void $this$associateTo$iv$iv;
        Map map2 = this.myTargetColumnNamesCache;
        if (map2 != null) {
            Map it = map2;
            boolean bl = false;
            return it;
        }
        Iterable $this$associate$iv = (Iterable)this.getTargetColumnsImpl();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable bl = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map3 = destination$iv$iv;
            BasicLikeColumn it = (BasicLikeColumn)element$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getDasType().getSpecification());
            map3.put(pair.getFirst(), pair.getSecond());
        }
        Map it = map2 = destination$iv$iv;
        boolean bl3 = false;
        this.myTargetColumnNamesCache = it;
        return map2;
    }

    @NotNull
    public final JBIterable<BasicLikeColumn> getTargetColumnsImpl() {
        DbEditorModelController dbEditorModelController = this.getController().getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        DbEditorModelController controller = dbEditorModelController;
        ElementIdentity<BasicTable> tableId = this.getTargetTableId();
        return DbMappingColumnsEditor.Companion.getColumns(controller, tableId);
    }

    private final ElementIdentity<BasicTable> getTargetTableId() {
        return DbReferenceModelState.resolveReference(this.getController().getModelController(), this.getIdentity(), MappingData.TABLE_REF);
    }

    private final String getTargetColumnType(MappingData.ColumnMapping mapping, DetectedColumnsData.Column column) {
        String string;
        if (!this.isAutoMode() && (string = this.getTargetColumnNames().get(mapping.getTgtName())) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        DbEditorModelController dbEditorModelController = this.getController().getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        ElementIdentity elementIdentity = this.getIdentity();
        Intrinsics.checkNotNullExpressionValue(elementIdentity, (String)"getIdentity(...)");
        return DbImportAutoTableManager.Companion.getTypeName(column, dbEditorModelController, elementIdentity);
    }

    @Override
    @NotNull
    protected ActionGroup createContextMenu() {
        AnAction[] anActionArray = new AnAction[]{new CleanupNonExisting(), new DbCsvColumnsEditor.SimplifyName()};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    private final boolean isAutoMode() {
        DbAutoReferenceModelState state = this.getController().getModelController().resolveState(this.getIdentity(), (BasicMetaId)MappingData.TABLE_REF, DbAutoReferenceModelState.class);
        return state != null && state.getDefinesTable();
    }

    @Nullable
    public final DetectedColumnsData.ColId getAutoMapping(@NotNull String col) {
        Intrinsics.checkNotNullParameter((Object)col, (String)"col");
        Map<AutoValueDescriptor, DetectedColumnDescriptor> map2 = this.getAutoMappings();
        for (Map.Entry<AutoValueDescriptor, DetectedColumnDescriptor> entry : map2.entrySet()) {
            AutoValueDescriptor key = entry.getKey();
            DetectedColumnDescriptor value = entry.getValue();
            if (!Intrinsics.areEqual((Object)col, (Object)key.getName())) continue;
            return value.getId();
        }
        return null;
    }

    private final void resetAutoMappings(DbEditorModel<?, ?> model) {
        this.updateToolbarPresence();
        if (this.myAutoMappingsCache == null && this.myNeedsValidation) {
            return;
        }
        boolean affectsMapping = this.isAutoMappingAffected(model);
        if (affectsMapping) {
            this.invalidateMappings();
        }
    }

    private final void updateToolbarPresence() {
        CommonActionsPanel actionsPanel = (CommonActionsPanel)UIUtil.findComponentOfType((JComponent)this.getComponent(), CommonActionsPanel.class);
        if (actionsPanel != null) {
            actionsPanel.setVisible(this.isAutoMode());
        }
    }

    private final void invalidateMappings() {
        this.myAutoMappingsCache = null;
        this.mySourceColumnsCache = null;
        this.myTargetColumnNamesCache = null;
        if (this.myNeedsValidation) {
            return;
        }
        this.myNeedsValidation = true;
        ApplicationManager.getApplication().invokeLater(() -> DbMappingColumnsEditor.invalidateMappings$lambda$0(this), this.getController().getModalityState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void validateMapping() {
        if (!this.myNeedsValidation) {
            return;
        }
        try {
            this.myValidating = true;
            this.resetImpl();
        }
        finally {
            this.myNeedsValidation = false;
            this.myValidating = false;
        }
    }

    private final boolean isAutoMappingAffected(DbEditorModel<?, ?> model) {
        ElementIdentity<?> elementIdentity = model.getIdentity();
        Intrinsics.checkNotNullExpressionValue(elementIdentity, (String)"getIdentity(...)");
        ElementIdentity<?> modId = elementIdentity;
        BasicMetaId basicMetaId = model.getModelInternalKey();
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaId, (String)"getModelInternalKey(...)");
        BasicMetaId modKey = basicMetaId;
        if (modKey == DetectedColumnsData.COLUMNS) {
            return this.getController().getParent(this.getIdentity()) == modId;
        }
        ElementIdentity<BasicTable> tgtId = this.getTargetTableId();
        if (tgtId == null) {
            return false;
        }
        return tgtId == model.getIdentity() || tgtId == this.getController().getParent(model.getIdentity());
    }

    private final Map<AutoValueDescriptor, DetectedColumnDescriptor> getAutoMappings() {
        Map<AutoValueDescriptor, DetectedColumnDescriptor> map2;
        Map<AutoValueDescriptor, DetectedColumnDescriptor> map3 = this.myAutoMappingsCache;
        if (map3 != null) {
            Map<AutoValueDescriptor, DetectedColumnDescriptor> it = map3;
            boolean bl = false;
            return it;
        }
        List<DetectedColumnsData.Column> columns = this.getSourceColumns();
        List<MappingData.ColumnMapping> list = this.getItems();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getItems(...)");
        List<MappingData.ColumnMapping> mappings = list;
        DbEditorModelController dbEditorModelController = this.getController().getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        DasDataSource dataSource = (DasDataSource)DataSourceData.Companion.getDataSource(dbEditorModelController, this.getTargetTableId());
        JBIterable<BasicLikeColumn> targetCols = this.getTargetColumnsImpl();
        Map<AutoValueDescriptor, DetectedColumnDescriptor> it = map2 = Companion.getDefaultMappings(columns, targetCols, mappings, dataSource, false);
        boolean bl = false;
        this.myAutoMappingsCache = it;
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void createDecorator$lambda$0(DbMappingColumnsEditor this$0, AnActionButton it) {
        void $this$groupByTo$iv;
        int[] nArray = this$0.myTable.getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
        List selection = ArraysKt.sortedDescending((int[])nArray);
        List list = this$0.getItems();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getItems(...)");
        List items = CollectionsKt.toMutableList((Collection)list);
        Iterator iterator = items;
        Map destination$iv = new HashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            void $this$getOrPut$iv$iv;
            MappingData.ColumnMapping it2 = (MappingData.ColumnMapping)element$iv;
            boolean bl = false;
            DetectedColumnsData.ColId key$iv = it2.getSrcId();
            Map map2 = destination$iv;
            DetectedColumnsData.ColId key$iv$iv = key$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        HashMap usages = (HashMap)destination$iv;
        iterator = selection.iterator();
        while (iterator.hasNext()) {
            int idx = ((Number)iterator.next()).intValue();
            MappingData.ColumnMapping item = (MappingData.ColumnMapping)items.get(idx);
            List list2 = (List)usages.get(item.getSrcId());
            if (list2 == null) continue;
            list2.remove(item);
        }
        iterator = selection.iterator();
        while (iterator.hasNext()) {
            List usage;
            MappingData.ColumnMapping item;
            int idx;
            block9: {
                block8: {
                    idx = ((Number)iterator.next()).intValue();
                    item = (MappingData.ColumnMapping)items.get(idx);
                    usage = (List)usages.get(item.getSrcId());
                    if (((CharSequence)item.getTgtName()).length() == 0) break block8;
                    List list3 = usage;
                    boolean bl = list3 != null ? !list3.isEmpty() : false;
                    if (!bl) break block9;
                }
                items.remove(idx);
                continue;
            }
            Intrinsics.checkNotNull((Object)item);
            items.set(idx, MappingData.ColumnMapping.copy$default(item, null, "", null, false, 5, null));
            List list4 = usage;
            if (list4 == null) continue;
            Object e = items.get(idx);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            list4.add(e);
        }
        this$0.setItems(items);
    }

    private static final DetectedColumnsData.Column getSourceColumnsImpl$lambda$0(BasicLikeColumn it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        DetectedColumnsData.ColId colId = new DetectedColumnsData.ColId(string);
        String string2 = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = it.getDasType().getSpecification();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSpecification(...)");
        return new DetectedColumnsData.Column(colId, string2, null, string3);
    }

    private static final DetectedColumnsData.Column getSourceColumnsImpl$lambda$1(Function1 $tmp0, Object p0) {
        return (DetectedColumnsData.Column)$tmp0.invoke(p0);
    }

    private static final void invalidateMappings$lambda$0(DbMappingColumnsEditor this$0) {
        this$0.validateMapping();
    }

    public static final /* synthetic */ void access$resetAutoMappings(DbMappingColumnsEditor $this, DbEditorModel model) {
        $this.resetAutoMappings(model);
    }

    public static final /* synthetic */ TableView access$getMyTable$p$s-1377066182(DbMappingColumnsEditor $this) {
        return $this.myTable;
    }

    public static final /* synthetic */ String access$getTargetColumnType(DbMappingColumnsEditor $this, MappingData.ColumnMapping mapping, DetectedColumnsData.Column column) {
        return $this.getTargetColumnType(mapping, column);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u000b\u001a\u000e\u0018\u00010\fR\b\u0012\u0004\u0012\u00028\u00000\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0002J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$CleanupNonExisting;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "findTargetColumnInfo", "Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$TargetColumnInfo;", "Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor;", "table", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/database/dbimport/editor/data/MappingData$ColumnMapping;", "getTable", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMappingColumnsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingColumnsEditor.kt\ncom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$CleanupNonExisting\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,608:1\n1#2:609\n*E\n"})
    private final class CleanupNonExisting
    extends DumbAwareAction {
        public CleanupNonExisting() {
            super(DatabaseBundle.message((String)"action.remove.non.existent.column.text", (Object[])new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            table = this.getTable(e);
            existing = DbMappingColumnsEditor.access$getTargetColumnNames(DbMappingColumnsEditor.this);
            v0 = e.getPresentation();
            if (this.findTargetColumnInfo(table) == null) ** GOTO lbl-1000
            v1 /* !! */  = table;
            if (v1 /* !! */  != null && (v1 /* !! */  = v1 /* !! */ .getSelectedObjects()) != null) {
                block5: {
                    var4_4 = (Iterable)v1 /* !! */ ;
                    var10_5 = v0;
                    var5_6 = var4_4;
                    for (T var7_8 : var5_6) {
                        it = (MappingData.ColumnMapping)var7_8;
                        $i$a$-find-DbMappingColumnsEditor$CleanupNonExisting$update$1 = false;
                        if (!(existing.containsKey(it.getTgtName()) == false)) continue;
                        v2 = var7_8;
                        break block5;
                    }
                    v2 = null;
                }
                v0 = var10_5;
                v3 = v2;
            } else {
                v3 = null;
            }
            if (v3 != null) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            v0.setEnabledAndVisible(v4);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TableView<MappingData.ColumnMapping> table = this.getTable(e);
            TargetColumnInfo column = this.findTargetColumnInfo(table);
            if (column == null) {
                return;
            }
            Map existing = DbMappingColumnsEditor.this.getTargetColumnNames();
            TableView<MappingData.ColumnMapping> tableView = table;
            Intrinsics.checkNotNull(tableView);
            IntOpenHashSet selection = new IntOpenHashSet(tableView.getSelectedRows());
            TableViewModel model = table.getTableViewModel();
            List items = new ArrayList(model.getItems());
            ListIterator it = items.listIterator();
            while (it.hasNext()) {
                MappingData.ColumnMapping item = (MappingData.ColumnMapping)it.next();
                if (!selection.contains(it.previousIndex())) continue;
                MappingData.ColumnMapping columnMapping = item;
                Intrinsics.checkNotNull((Object)columnMapping);
                if (existing.containsKey(columnMapping.getTgtName())) continue;
                it.remove();
            }
            model.setItems(items);
        }

        private final TargetColumnInfo findTargetColumnInfo(TableView<MappingData.ColumnMapping> table) {
            TargetColumnInfo targetColumnInfo;
            block3: {
                if (table == null) {
                    return null;
                }
                ColumnInfo[] columnInfoArray = table.getTableViewModel().getColumnInfos();
                Intrinsics.checkNotNullExpressionValue((Object)columnInfoArray, (String)"getColumnInfos(...)");
                Object[] objectArray = columnInfoArray;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    ColumnInfo it = (ColumnInfo)objectArray[i];
                    boolean bl = false;
                    targetColumnInfo = it instanceof TargetColumnInfo ? (TargetColumnInfo)it : null;
                    if (targetColumnInfo == null) {
                        continue;
                    }
                    break block3;
                }
                targetColumnInfo = null;
            }
            return targetColumnInfo;
        }

        private final TableView<MappingData.ColumnMapping> getTable(AnActionEvent e) {
            Object object = e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
            return object instanceof TableView ? (TableView)object : null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tJ\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tJ$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0002JN\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0005JL\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\u001c\u001a\u00020\u0005J(\u0010\"\u001a\u0004\u0018\u00010\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010#\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J&\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0007\u00a8\u0006+"}, d2={"Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$Companion;", "", "<init>", "()V", "isAuto", "", "value", "Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$Column;", "isNotMapped", "Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$ColId;", "getColumns", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "tableId", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "getDefaultMappings", "", "Lcom/intellij/database/datagrid/AutoValueDescriptor;", "Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$DetectedColumnDescriptor;", "columns", "", "targetCols", "mappings", "Lcom/intellij/database/dbimport/editor/data/MappingData$ColumnMapping;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "ignoreAuto", "getMapping", "targetDbms", "Lcom/intellij/database/Dbms;", "sourceColumns", "targetColumns", "findMapping", "consumer", "asDescriptor", "dbms", "version", "Lcom/intellij/database/util/Version;", "idx", "", "c", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMappingColumnsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingColumnsEditor.kt\ncom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,608:1\n1596#2:609\n1629#2,4:610\n777#2:615\n873#2,2:616\n777#2:618\n873#2,2:619\n1#3:614\n*S KotlinDebug\n*F\n+ 1 DbMappingColumnsEditor.kt\ncom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$Companion\n*L\n554#1:609\n554#1:610,4\n572#1:615\n572#1:616,2\n576#1:618\n576#1:619,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAuto(@NotNull DetectedColumnsData.Column value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.isAuto(value.getId());
        }

        public final boolean isNotMapped(@NotNull DetectedColumnsData.Column value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.isNotMapped(value.getId());
        }

        public final boolean isAuto(@NotNull DetectedColumnsData.ColId value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.areEqual((Object)DbMappingColumnsEditorKt.access$getMY_AUTO$p(), (Object)value);
        }

        public final boolean isNotMapped(@NotNull DetectedColumnsData.ColId value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ((CharSequence)value.getValue()).length() == 0;
        }

        private final JBIterable<BasicLikeColumn> getColumns(DbEditorModelController controller, ElementIdentity<?> tableId) {
            ElementIdentity<?> elementIdentity = tableId;
            BasicMetaObject colMeta = elementIdentity == null ? null : BasicMetaUtils.findChild((BasicMetaObject)elementIdentity.getMetaObject(), (ObjectKind)ObjectKind.COLUMN);
            ElementOwner owner = controller.getActualOwner();
            if (colMeta == null || owner == null) {
                JBIterable jBIterable = JBIterable.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
                return jBIterable;
            }
            ElementIdentity<?> elementIdentity2 = tableId;
            Intrinsics.checkNotNull(elementIdentity2);
            JBIterable jBIterable = owner.getChildren(elementIdentity2, colMeta).filterMap(arg_0 -> Companion.getColumns$lambda$1(arg_0 -> Companion.getColumns$lambda$0(owner, arg_0), arg_0)).sort(Comparator.comparing(arg_0 -> Companion.getColumns$lambda$3(Companion::getColumns$lambda$2, arg_0)));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"sort(...)");
            return jBIterable;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<AutoValueDescriptor, DetectedColumnDescriptor> getDefaultMappings(@NotNull List<DetectedColumnsData.Column> columns, @NotNull JBIterable<BasicLikeColumn> targetCols, @NotNull List<MappingData.ColumnMapping> mappings, @Nullable DasDataSource dataSource, boolean ignoreAuto) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter(targetCols, (String)"targetCols");
            Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
            if (dataSource == null) {
                return MapsKt.emptyMap();
            }
            Dbms dbms = dataSource.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms dbms2 = dbms;
            Version version = (Version)ObjectUtils.chooseNotNull((Object)dataSource.getVersion(), (Object)Version.INFINITY);
            Iterable $this$mapIndexed$iv = columns;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void c2;
                void idx;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DetectedColumnsData.Column column = (DetectedColumnsData.Column)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)version);
                collection.add(Companion.asDescriptor(dbms2, version, (int)idx, (DetectedColumnsData.Column)c2));
            }
            List sourceColumns = (List)destination$iv$iv;
            List list = targetCols.map(arg_0 -> Companion.getDefaultMappings$lambda$2(Companion::getDefaultMappings$lambda$1, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            List targetColumns = list;
            return this.getMapping(dbms2, sourceColumns, targetColumns, mappings, ignoreAuto);
        }

        @NotNull
        public final Map<AutoValueDescriptor, DetectedColumnDescriptor> getMapping(@NotNull Dbms targetDbms, @NotNull List<DetectedColumnDescriptor> sourceColumns, @NotNull List<? extends AutoValueDescriptor> targetColumns, @NotNull List<MappingData.ColumnMapping> mappings, boolean ignoreAuto) {
            Iterable $this$filterTo$iv$iv;
            Object producer;
            boolean bl;
            DetectedColumnDescriptor it;
            Intrinsics.checkNotNullParameter((Object)targetDbms, (String)"targetDbms");
            Intrinsics.checkNotNullParameter(sourceColumns, (String)"sourceColumns");
            Intrinsics.checkNotNullParameter(targetColumns, (String)"targetColumns");
            Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
            LinkedHashMap res2 = new LinkedHashMap();
            for (AutoValueDescriptor autoValueDescriptor : targetColumns) {
                Object v0;
                block4: {
                    MappingData.ColumnMapping mv = this.findMapping(mappings, autoValueDescriptor, ignoreAuto);
                    if (mv == null) continue;
                    Iterable iterable = sourceColumns;
                    for (Object t : iterable) {
                        it = (DetectedColumnDescriptor)((Object)t);
                        bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)mv.getSrcId())) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                if ((producer = (DetectedColumnDescriptor)v0) == null) continue;
                ((Map)res2).put(autoValueDescriptor, producer);
            }
            LinkedHashSet mappedSources = new LinkedHashSet(res2.values());
            Iterable iterable = targetColumns;
            LinkedHashMap linkedHashMap = res2;
            boolean $i$f$filter = false;
            producer = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (AutoValueDescriptor)element$iv$iv;
                bl = false;
                if (!(!res2.containsKey((Object)it) && Companion.findMapping(mappings, (AutoValueDescriptor)it, ignoreAuto) == null && JdbcEngineUtils.shouldParticipateInInsert((Dbms)targetDbms, (AutoValueDescriptor)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = sourceColumns;
            List list = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = iterable2;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (DetectedColumnDescriptor)((Object)element$iv$iv);
                bl = false;
                if (!(!mappedSources.contains((Object)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            linkedHashMap.putAll(ColumnMappingStrategy.map((List)list, (List)list2));
            return res2;
        }

        private final MappingData.ColumnMapping findMapping(List<MappingData.ColumnMapping> mappings, AutoValueDescriptor consumer, boolean ignoreAuto) {
            Object v0;
            block1: {
                Iterable iterable = mappings;
                for (Object t : iterable) {
                    MappingData.ColumnMapping it = (MappingData.ColumnMapping)t;
                    boolean bl = false;
                    if (!((!ignoreAuto || !it.isAuto()) && Intrinsics.areEqual((Object)it.getTgtName(), (Object)consumer.getName()))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final DetectedColumnDescriptor asDescriptor(@NotNull Dbms dbms, @NotNull Version version, int idx, @NotNull DetectedColumnsData.Column c2) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            TypeNameColumnDescriptor typeNameColumnDescriptor = ImportUtilCore.asDescriptor((String)c2.getSrcName(), (DasType)DasUnresolvedTypeReference.Companion.of(c2.getType()));
            Intrinsics.checkNotNullExpressionValue((Object)typeNameColumnDescriptor, (String)"asDescriptor(...)");
            TypeNameColumnDescriptor desc = typeNameColumnDescriptor;
            String typeName = ImportUtilCore.convertTypeName((Dbms)Dbms.UNKNOWN, (Version)Version.INFINITY, (Dbms)dbms, (Version)version, (ColumnDescriptor)((ColumnDescriptor)desc));
            DetectedColumnsData.ColId colId = c2.getId();
            String string = c2.getSrcName();
            Intrinsics.checkNotNull((Object)typeName);
            return new DetectedColumnDescriptor(colId, idx, string, typeName);
        }

        private static final BasicLikeColumn getColumns$lambda$0(ElementOwner $owner, ElementIdentity it) {
            return (BasicLikeColumn)$owner.find(it);
        }

        private static final BasicLikeColumn getColumns$lambda$1(Function1 $tmp0, Object p0) {
            return (BasicLikeColumn)$tmp0.invoke(p0);
        }

        private static final Short getColumns$lambda$2(BasicLikeColumn it) {
            return it.getPosition();
        }

        private static final Short getColumns$lambda$3(Function1 $tmp0, Object p0) {
            return (Short)$tmp0.invoke(p0);
        }

        private static final AutoValueDescriptor getDefaultMappings$lambda$1(BasicLikeColumn it) {
            return ImportUtilCore.createDescriptor((BasicLikeColumn)it);
        }

        private static final AutoValueDescriptor getDefaultMappings$lambda$2(Function1 $tmp0, Object p0) {
            return (AutoValueDescriptor)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$DetectedColumnDescriptor;", "Lcom/intellij/database/util/TypeNameColumnDescriptor;", "Lcom/intellij/database/datagrid/GridColumn;", "id", "Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$ColId;", "num", "", "name", "", "typeName", "<init>", "(Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$ColId;ILjava/lang/String;Ljava/lang/String;)V", "getId", "()Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$ColId;", "getNum", "()I", "getColumnNumber", "intellij.database.impl"})
    public static final class DetectedColumnDescriptor
    extends TypeNameColumnDescriptor
    implements GridColumn {
        @NotNull
        private final DetectedColumnsData.ColId id;
        private final int num;

        public DetectedColumnDescriptor(@NotNull DetectedColumnsData.ColId id, int num, @NotNull String name, @NotNull String typeName) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
            super(name, typeName);
            this.id = id;
            this.num = num;
        }

        @NotNull
        public final DetectedColumnsData.ColId getId() {
            return this.id;
        }

        public final int getNum() {
            return this.num;
        }

        public int getColumnNumber() {
            return this.num;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0017\u0010\u0013\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\rH\u0002J8\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fH\u0016J\"\u0010\"\u001a\u00020#2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$MyMappingCellEditor;", "Lcom/intellij/openapi/ui/ComboBoxTableRenderer;", "Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$Column;", "myAccessibleValues", "", "<init>", "(Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor;Ljava/util/List;)V", "getMyAccessibleValues", "()Ljava/util/List;", "curCol", "Lcom/intellij/database/dbimport/editor/data/MappingData$ColumnMapping;", "myAccessibleValuesById", "", "Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$ColId;", "getPreferredSizeMaxValues", "", "getTextFor", "", "value", "getAutoMappingText", "Lcom/intellij/openapi/util/NlsSafe;", "autoId", "findExisting", "id", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "", "isSelected", "", "hasFocus", "row", "column", "customizeComponent", "", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMappingColumnsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingColumnsEditor.kt\ncom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$MyMappingCellEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,608:1\n1220#2,2:609\n1249#2,4:611\n*S KotlinDebug\n*F\n+ 1 DbMappingColumnsEditor.kt\ncom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$MyMappingCellEditor\n*L\n307#1:609,2\n307#1:611,4\n*E\n"})
    private final class MyMappingCellEditor
    extends ComboBoxTableRenderer<DetectedColumnsData.Column> {
        @NotNull
        private final List<DetectedColumnsData.Column> myAccessibleValues;
        @Nullable
        private MappingData.ColumnMapping curCol;
        @NotNull
        private final Map<DetectedColumnsData.ColId, DetectedColumnsData.Column> myAccessibleValuesById;

        /*
         * WARNING - void declaration
         */
        public MyMappingCellEditor(List<DetectedColumnsData.Column> myAccessibleValues) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Intrinsics.checkNotNullParameter(myAccessibleValues, (String)"myAccessibleValues");
            super((Object[])DbMappingColumnsEditorKt.access$withExtraItems(myAccessibleValues));
            this.myAccessibleValues = myAccessibleValues;
            Iterable iterable = this.myAccessibleValues;
            MyMappingCellEditor myMappingCellEditor = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var6_7 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                DetectedColumnsData.Column column = (DetectedColumnsData.Column)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.getId(), element$iv$iv);
            }
            myMappingCellEditor.myAccessibleValuesById = destination$iv$iv;
        }

        @NotNull
        public final List<DetectedColumnsData.Column> getMyAccessibleValues() {
            return this.myAccessibleValues;
        }

        protected int getPreferredSizeMaxValues() {
            return 10;
        }

        @NotNull
        protected String getTextFor(@NotNull DetectedColumnsData.Column value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Companion.isNotMapped(value)) {
                String string = DatabaseBundle.message((String)"not.mapped", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
            if (Companion.isAuto(value)) {
                return this.getAutoMappingText(null);
            }
            MappingData.ColumnMapping cur = this.curCol;
            if (cur != null && cur.isAuto()) {
                return this.getAutoMappingText(cur.getSrcId());
            }
            DetectedColumnsData.Column column = this.findExisting(value.getId());
            DetectedColumnsData.Column column2 = column;
            if (column2 == null) {
                column2 = value;
            }
            return column2.getName();
        }

        private final String getAutoMappingText(DetectedColumnsData.ColId autoId) {
            DetectedColumnsData.ColId colId = autoId;
            DetectedColumnsData.Column mappedColumn = colId == null ? null : this.findExisting(colId);
            Object object = mappedColumn;
            if (object == null || (object = ((DetectedColumnsData.Column)object).getName()) == null) {
                DetectedColumnsData.ColId colId2 = autoId;
                object = colId2 != null ? colId2.getValue() : null;
            }
            Object mappedColumnName = object;
            Object object2 = mappedColumnName;
            return DatabaseBundle.message((String)"label.auto", (Object[])new Object[0]) + (String)(object2 == null ? "" : " (" + (String)object2 + ")");
        }

        private final DetectedColumnsData.Column findExisting(DetectedColumnsData.ColId id) {
            return this.myAccessibleValuesById.get(id);
        }

        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.curCol = row >= 0 && row < DbMappingColumnsEditor.this.getItems().size() ? (MappingData.ColumnMapping)DbMappingColumnsEditor.this.getItems().get(row) : null;
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getTableCellRendererComponent(...)");
            return component;
        }

        protected void customizeComponent(@Nullable DetectedColumnsData.Column value, @NotNull JTable table, boolean isSelected) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            super.customizeComponent((Object)value, table, isSelected);
            this.setForeground(value == null || StringUtil.isEmpty((String)value.getSrcName()) ? UIUtil.getLabelDisabledForeground() : (((object = this.curCol) != null && (object = ((MappingData.ColumnMapping)object).getTgtName()) != null ? ((CharSequence)object).length() == 0 : false) ? UIUtil.getLabelDisabledForeground() : UIUtil.getLabelForeground()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u001a\u0010\u0006\u001a\u000e\u0018\u00010\u0007R\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$SourceColumnInfo;", "Lcom/intellij/util/ui/ImmutableColumnInfo;", "Lcom/intellij/database/dbimport/editor/data/MappingData$ColumnMapping;", "Lcom/intellij/database/dbimport/editor/data/DetectedColumnsData$Column;", "<init>", "(Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor;)V", "rr", "Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$MyMappingCellEditor;", "Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor;", "valueOf", "value", "isCellEditable", "", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "getEditor", "Ljavax/swing/table/TableCellEditor;", "withValue", "item", "intellij.database.impl"})
    private final class SourceColumnInfo
    extends ImmutableColumnInfo<MappingData.ColumnMapping, DetectedColumnsData.Column> {
        @Nullable
        private MyMappingCellEditor rr;

        public SourceColumnInfo() {
            super(DatabaseBundle.message((String)"column.name.source.column", (Object[])new Object[0]));
        }

        @NotNull
        public DetectedColumnsData.Column valueOf(@NotNull MappingData.ColumnMapping value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new DetectedColumnsData.Column(value.getSrcId(), value.getSrcId().getValue(), null, "");
        }

        public boolean isCellEditable(@NotNull MappingData.ColumnMapping value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return true;
        }

        @Nullable
        public TableCellRenderer getRenderer(@NotNull MappingData.ColumnMapping value) {
            block3: {
                List<DetectedColumnsData.Column> columns;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    columns = DbMappingColumnsEditor.this.getSourceColumns();
                    if (this.rr == null) break block2;
                    MyMappingCellEditor myMappingCellEditor = this.rr;
                    Intrinsics.checkNotNull((Object)((Object)myMappingCellEditor));
                    if (myMappingCellEditor.getMyAccessibleValues() == columns) break block3;
                }
                this.rr = new MyMappingCellEditor(columns);
            }
            return (TableCellRenderer)((Object)this.rr);
        }

        @Nullable
        public TableCellEditor getEditor(@NotNull MappingData.ColumnMapping value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return (TableCellEditor)new MyMappingCellEditor(DbMappingColumnsEditor.this.getSourceColumns()).withClickCount(1);
        }

        @NotNull
        public MappingData.ColumnMapping withValue(@NotNull MappingData.ColumnMapping item, @NotNull DetectedColumnsData.Column value) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new MappingData.ColumnMapping(value.getId(), item.getTgtName(), item.getTgtTypeOverride(), false);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$TargetColumnInfo;", "Lcom/intellij/util/ui/ImmutableColumnInfo;", "Lcom/intellij/database/dbimport/editor/data/MappingData$ColumnMapping;", "", "Lcom/intellij/database/dbimport/editor/editor/DbCsvColumnsEditor$SimplifyName$SimplifiableMarker;", "<init>", "(Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor;)V", "withValue", "mapping", "value", "isCellEditable", "", "valueOf", "getEditor", "Ljavax/swing/table/TableCellEditor;", "item", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMappingColumnsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingColumnsEditor.kt\ncom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$TargetColumnInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,608:1\n1#2:609\n*E\n"})
    public final class TargetColumnInfo
    extends ImmutableColumnInfo<MappingData.ColumnMapping, String>
    implements DbCsvColumnsEditor.SimplifyName.SimplifiableMarker {
        public TargetColumnInfo() {
            super(DatabaseBundle.message((String)"column.name.target.column", (Object[])new Object[0]));
        }

        @NotNull
        public MappingData.ColumnMapping withValue(@NotNull MappingData.ColumnMapping mapping, @NotNull String value) {
            DetectedColumnsData.ColId srcId;
            DetectedColumnsData.ColId colId;
            DetectedColumnsData.ColId colId2;
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (Intrinsics.areEqual((Object)mapping.getTgtName(), (Object)value)) {
                return mapping;
            }
            DetectedColumnsData.ColId it = colId2 = mapping.getSrcId();
            boolean bl = false;
            DetectedColumnsData.ColId colId3 = !Companion.isAuto(it) ? colId2 : null;
            if (colId3 == null) {
                colId3 = DbMappingColumnsEditor.this.getAutoMapping(mapping.getTgtName());
            }
            if ((colId = (srcId = colId3)) == null) {
                colId = new DetectedColumnsData.ColId("");
            }
            return new MappingData.ColumnMapping(colId, value, mapping.getTgtTypeOverride(), false);
        }

        public boolean isCellEditable(@NotNull MappingData.ColumnMapping mapping) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            return DbMappingColumnsEditor.this.isAutoMode();
        }

        @NotNull
        public String valueOf(@NotNull MappingData.ColumnMapping value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.getTgtName();
        }

        @Nullable
        public TableCellEditor getEditor(@Nullable MappingData.ColumnMapping item) {
            return new DefaultCellEditor(new JTextField());
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull MappingData.ColumnMapping mapping) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            Map targetNames = DbMappingColumnsEditor.this.getTargetColumnNames();
            return (TableCellRenderer)new ColoredTableCellRenderer(targetNames){
                final /* synthetic */ Map<String, String> $targetNames;
                {
                    this.$targetNames = $targetNames;
                }

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (value != null) {
                        SimpleTextAttributes attr;
                        String strVal = value.toString();
                        SimpleTextAttributes simpleTextAttributes = attr = ((CharSequence)strVal).length() == 0 ? SimpleTextAttributes.GRAYED_ATTRIBUTES : (this.$targetNames.isEmpty() || this.$targetNames.containsKey(strVal) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
                        String string = StringKt.nullize$default((String)strVal, (boolean)false, (int)1, null);
                        if (string == null) {
                            string = "<skip>";
                        }
                        this.append(string, attr);
                    }
                }
            };
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$TargetColumnTypeInfo;", "Lcom/intellij/util/ui/ImmutableColumnInfo;", "Lcom/intellij/database/dbimport/editor/data/MappingData$ColumnMapping;", "", "<init>", "(Lcom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor;)V", "withValue", "mapping", "value", "isCellEditable", "", "valueOf", "getEditor", "Ljavax/swing/table/TableCellEditor;", "item", "findDataSource", "Lcom/intellij/database/psi/DbDataSource;", "createEditor", "Lcom/intellij/ui/EditorTextField;", "dataSource", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbMappingColumnsEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingColumnsEditor.kt\ncom/intellij/database/dbimport/editor/editor/DbMappingColumnsEditor$TargetColumnTypeInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,608:1\n1#2:609\n*E\n"})
    public final class TargetColumnTypeInfo
    extends ImmutableColumnInfo<MappingData.ColumnMapping, String> {
        public TargetColumnTypeInfo() {
            super(DatabaseBundle.message((String)"column.name.target.column.type", (Object[])new Object[0]));
        }

        @NotNull
        public MappingData.ColumnMapping withValue(@NotNull MappingData.ColumnMapping mapping, @Nullable String value) {
            DetectedColumnsData.ColId srcId;
            DetectedColumnsData.ColId colId;
            DetectedColumnsData.ColId colId2;
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            if (Intrinsics.areEqual((Object)value, (Object)"")) {
                return this.withValue(mapping, null);
            }
            if (Intrinsics.areEqual((Object)mapping.getTgtTypeOverride(), (Object)value)) {
                return mapping;
            }
            DetectedColumnsData.ColId it = colId2 = mapping.getSrcId();
            boolean bl = false;
            DetectedColumnsData.ColId colId3 = !Companion.isAuto(it) ? colId2 : null;
            if (colId3 == null) {
                colId3 = DbMappingColumnsEditor.this.getAutoMapping(mapping.getTgtName());
            }
            if ((colId = (srcId = colId3)) == null) {
                colId = new DetectedColumnsData.ColId("");
            }
            return new MappingData.ColumnMapping(colId, mapping.getTgtName(), value, false);
        }

        public boolean isCellEditable(@NotNull MappingData.ColumnMapping mapping) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            return DbMappingColumnsEditor.this.isAutoMode();
        }

        @Nullable
        public String valueOf(@NotNull MappingData.ColumnMapping value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value.getTgtTypeOverride();
        }

        @NotNull
        public TableCellEditor getEditor(@Nullable MappingData.ColumnMapping item) {
            DetectedColumnsData.Column column;
            EditorTextField editor2 = this.createEditor(this.findDataSource());
            if (DbMappingColumnsEditor.this.isAutoMode() && item != null) {
                Object v0;
                block3: {
                    Iterable iterable = DbMappingColumnsEditor.this.getSourceColumns();
                    for (Object t : iterable) {
                        DetectedColumnsData.Column it = (DetectedColumnsData.Column)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)item.getSrcId())) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                column = v0;
            } else {
                column = null;
            }
            DetectedColumnsData.Column srcCol = column;
            return new TableCellEditor(editor2, item, DbMappingColumnsEditor.this, srcCol){
                final /* synthetic */ EditorTextField $editor;
                final /* synthetic */ MappingData.ColumnMapping $item;
                final /* synthetic */ DbMappingColumnsEditor<E> this$0;
                final /* synthetic */ DetectedColumnsData.Column $srcCol;
                {
                    this.$editor = $editor;
                    this.$item = $item;
                    this.this$0 = $receiver;
                    this.$srcCol = $srcCol;
                }

                public Object getCellEditorValue() {
                    String string;
                    String string2 = StringKt.nullize$default((String)this.$editor.getText(), (boolean)false, (int)1, null);
                    if (string2 != null) {
                        String string3;
                        String it = string3 = string2;
                        boolean bl = false;
                        string = !Intrinsics.areEqual((Object)it, (Object)this.getDefType()) ? string3 : null;
                    } else {
                        string = null;
                    }
                    return string;
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
                    Object object = value;
                    if ((object == null || (object = object.toString()) == null) && (object = this.getDefType()) == null) {
                        object = "";
                    }
                    this.$editor.setText((String)object);
                    return (Component)this.$editor;
                }

                private final String getDefType() {
                    String string;
                    MappingData.ColumnMapping columnMapping = this.$item;
                    if (columnMapping != null) {
                        MappingData.ColumnMapping columnMapping2 = columnMapping;
                        DbMappingColumnsEditor<E> dbMappingColumnsEditor = this.this$0;
                        MappingData.ColumnMapping columnMapping3 = this.$item;
                        DetectedColumnsData.Column column = this.$srcCol;
                        MappingData.ColumnMapping it = columnMapping2;
                        boolean bl = false;
                        string = DbMappingColumnsEditor.access$getTargetColumnType(dbMappingColumnsEditor, columnMapping3, column);
                    } else {
                        string = null;
                    }
                    return string;
                }
            };
        }

        private final DbDataSource findDataSource() {
            DbEditorModelController dbEditorModelController = DbMappingColumnsEditor.this.getController().getModelController();
            Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
            ElementIdentity elementIdentity = DbMappingColumnsEditor.this.getIdentity();
            Intrinsics.checkNotNullExpressionValue(elementIdentity, (String)"getIdentity(...)");
            return DbImportDataPreviewManager.Companion.findDataSource(dbEditorModelController, elementIdentity, MappingData.DATA_SOURCE_REF);
        }

        private final EditorTextField createEditor(DbDataSource dataSource) {
            SqlCodeFragment sqlCodeFragment = SqlPsiFacade.getInstance((Project)DbMappingColumnsEditor.this.getController().getProject()).createTypeElementFragment(DbSqlUtil.getLanguage((DbDataSource)dataSource), dataSource, null, "");
            Intrinsics.checkNotNullExpressionValue((Object)sqlCodeFragment, (String)"createTypeElementFragment(...)");
            SqlCodeFragment file = sqlCodeFragment;
            EditorTextField editorTextField2 = DatabaseDialogsHelper.createLanguageEditorField((PsiFile)file);
            Intrinsics.checkNotNullExpressionValue((Object)editorTextField2, (String)"createLanguageEditorField(...)");
            EditorTextField editor2 = editorTextField2;
            editor2.setFontInheritedFromLAF(true);
            editor2.addSettingsProvider(TargetColumnTypeInfo::createEditor$lambda$0);
            return editor2;
        }

        @NotNull
        public TableCellRenderer getRenderer(@NotNull MappingData.ColumnMapping mapping) {
            DetectedColumnsData.Column column;
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            if (DbMappingColumnsEditor.this.isAutoMode()) {
                Object v0;
                block3: {
                    Iterable iterable = DbMappingColumnsEditor.this.getSourceColumns();
                    for (Object t : iterable) {
                        DetectedColumnsData.Column it = (DetectedColumnsData.Column)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)mapping.getSrcId())) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                column = v0;
            } else {
                column = null;
            }
            DetectedColumnsData.Column srcCol = column;
            return (TableCellRenderer)new ColoredTableCellRenderer(DbMappingColumnsEditor.this, mapping, srcCol){
                final /* synthetic */ DbMappingColumnsEditor<E> this$0;
                final /* synthetic */ MappingData.ColumnMapping $mapping;
                final /* synthetic */ DetectedColumnsData.Column $srcCol;
                {
                    this.this$0 = $receiver;
                    this.$mapping = $mapping;
                    this.$srcCol = $srcCol;
                }

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (value != null) {
                        String strVal = value.toString();
                        SimpleColoredComponent simpleColoredComponent = this.append(strVal);
                        Intrinsics.checkNotNull((Object)simpleColoredComponent);
                    } else {
                        this.append(DbMappingColumnsEditor.access$getTargetColumnType(this.this$0, this.$mapping, this.$srcCol), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            };
        }

        private static final void createEditor$lambda$0(EditorEx it) {
            it.setBorder((Border)JBUI.Borders.empty((int)4, (int)6));
        }
    }
}

