/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DbModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.editor.DatabaseCompositeTableEditorDescriptor;
import com.intellij.database.editor.DatabaseCompositeTableEditorProviderKt;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.SourceNavigationImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.TriConsumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001aM\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\"\b\u0002\u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000fH\u0000\u00a2\u0006\u0002\u0010\u0014\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\nH\u0000\u001a \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u00a8\u0006\u001d"}, d2={"openInCompositeEditor", "", "project", "Lcom/intellij/openapi/project/Project;", "basicElement", "Lcom/intellij/database/model/basic/BasicElement;", "canOpenInCompositeEditor", "createDataFileDescriptor", "Lcom/intellij/database/editor/OpenDataFileDescriptor;", "element", "Lcom/intellij/database/psi/DbElement;", "columnNames", "", "", "filterCondition", "Lcom/intellij/util/TriConsumer;", "Lcom/intellij/database/util/DdlBuilder;", "", "Lcom/intellij/database/model/DasColumn;", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/psi/DbElement;[Ljava/lang/String;Lcom/intellij/util/TriConsumer;)Lcom/intellij/database/editor/OpenDataFileDescriptor;", "createCompositeFileDescriptor", "Lcom/intellij/database/editor/DatabaseCompositeTableEditorDescriptor;", "navigateToSource", "", "dbElement", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "requestFocus", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbNavigationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbNavigationUtils.kt\ncom/intellij/database/view/DbNavigationUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class DbNavigationUtilsKt {
    public static final boolean openInCompositeEditor(@NotNull Project project, @NotNull BasicElement basicElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)basicElement, (String)"basicElement");
        DatabaseCompositeTableEditorDescriptor databaseCompositeTableEditorDescriptor = DbNavigationUtilsKt.createCompositeFileDescriptor(project, basicElement);
        if (databaseCompositeTableEditorDescriptor == null) {
            return false;
        }
        DatabaseCompositeTableEditorDescriptor descriptor2 = databaseCompositeTableEditorDescriptor;
        descriptor2.navigate(true);
        return true;
    }

    public static final boolean canOpenInCompositeEditor(@NotNull Project project, @NotNull BasicElement basicElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)basicElement, (String)"basicElement");
        return DbNavigationUtilsKt.createCompositeFileDescriptor(project, basicElement) != null;
    }

    @Nullable
    public static final OpenDataFileDescriptor createDataFileDescriptor(@NotNull DbElement element, @Nullable String[] columnNames, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> filterCondition) {
        OpenDataFileDescriptor openDataFileDescriptor;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (columnNames == null && element.getKind() == ObjectKind.COLUMN) {
            String[] stringArray2 = new String[]{element.getName()};
            stringArray = stringArray2;
        } else {
            stringArray = columnNames;
        }
        String[] columnNamesGuessed = stringArray;
        DbElement dbElement = DbNavigationUtils.adjustForDataNavigation(element);
        Intrinsics.checkNotNullExpressionValue((Object)dbElement, (String)"adjustForDataNavigation(...)");
        DbElement adjusted = dbElement;
        if (DatabaseEditorHelper.isTableDataAvailable(adjusted)) {
            VirtualFile virtualFile = DbImplUtil.findDataVirtualFile((DbElement)adjusted, (boolean)false);
            if (virtualFile != null) {
                VirtualFile virtualFile2 = virtualFile;
                boolean bl = false;
                openDataFileDescriptor = new OpenDataFileDescriptor(element.getProject(), virtualFile2, columnNamesGuessed, null, null, filterCondition);
            } else {
                openDataFileDescriptor = null;
            }
        } else {
            openDataFileDescriptor = null;
        }
        return openDataFileDescriptor;
    }

    public static /* synthetic */ OpenDataFileDescriptor createDataFileDescriptor$default(DbElement dbElement, String[] stringArray, TriConsumer triConsumer, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = null;
        }
        if ((n & 4) != 0) {
            triConsumer = null;
        }
        return DbNavigationUtilsKt.createDataFileDescriptor(dbElement, stringArray, (TriConsumer<DdlBuilder, List<DasColumn>, Dbms>)triConsumer);
    }

    private static final DatabaseCompositeTableEditorDescriptor createCompositeFileDescriptor(Project project, BasicElement basicElement) {
        DatabaseCompositeTableEditorDescriptor databaseCompositeTableEditorDescriptor;
        DbModelRegistry dbModelRegistry = (DbModelRegistry)project.getService(DbModelRegistry.class);
        if (dbModelRegistry != null && (dbModelRegistry = dbModelRegistry.findDbElement(basicElement)) != null) {
            DbModelRegistry p0 = dbModelRegistry;
            boolean bl = false;
            databaseCompositeTableEditorDescriptor = DbNavigationUtilsKt.createCompositeFileDescriptor((DbElement)p0);
        } else {
            databaseCompositeTableEditorDescriptor = null;
        }
        return databaseCompositeTableEditorDescriptor;
    }

    @Nullable
    public static final DatabaseCompositeTableEditorDescriptor createCompositeFileDescriptor(@NotNull DbElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!DatabaseCompositeTableEditorProviderKt.isCompositeEditorEnabled()) {
            return null;
        }
        OpenDataFileDescriptor openDataFileDescriptor = DbNavigationUtilsKt.createDataFileDescriptor$default(element, null, null, 6, null);
        if (openDataFileDescriptor == null) {
            return null;
        }
        OpenDataFileDescriptor dataDescriptor = openDataFileDescriptor;
        return new DatabaseCompositeTableEditorDescriptor(dataDescriptor);
    }

    public static final void navigateToSource(@NotNull DbElement dbElement, @NotNull VirtualFile virtualFile, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)dbElement, (String)"dbElement");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        new SourceNavigationImpl(dbElement, virtualFile, requestFocus).start();
    }
}

