/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.migration.dialog;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.migration.ConsolesMigrationManagerImpl;
import com.intellij.database.console.migration.dialog.ConsolesMigrationDialog;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00142\b\b\u0001\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u0018\u001a\u00020\u00162\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u001c\u0010\u001f\u001a\u00020\n*\u00020 2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/console/migration/dialog/SimpleConsolesMigrationDialog;", "Lcom/intellij/database/console/migration/dialog/ConsolesMigrationDialog;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "migrationInfo", "Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;", "onMigrated", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/database/console/migration/ConsolesMigrationManagerImpl$MigrationInfo;Lkotlin/jvm/functions/Function0;)V", "noPath", "", "getActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "getProductName", "", "createLabelWithIcon", "text", "icon", "Ljavax/swing/Icon;", "createLabel", "Lcom/intellij/ui/components/JBLabel;", "foreground", "Ljava/awt/Color;", "addWithConstrains", "Ljavax/swing/JPanel;", "component", "constraints", "Ljava/awt/GridBagConstraints;", "intellij.database.impl"})
public final class SimpleConsolesMigrationDialog
extends ConsolesMigrationDialog {
    private final boolean noPath;

    public SimpleConsolesMigrationDialog(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull ConsolesMigrationManagerImpl.MigrationInfo migrationInfo, @NotNull Function0<Unit> onMigrated) {
        JButton migrateButton;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)migrationInfo, (String)"migrationInfo");
        Intrinsics.checkNotNullParameter(onMigrated, (String)"onMigrated");
        super(project, coroutineScope, migrationInfo, onMigrated);
        this.noPath = QueryFileSettings.Companion.getDefaultQueriesPath(project) == null;
        JButton jButton = migrateButton = this.getButton((Action)this.getMigrateAction());
        if (jButton != null) {
            jButton.setText(DatabaseBundle.message((String)"consoles.migration.apply.all", (Object[])new Object[0]));
        }
        if (this.noPath) {
            JButton jButton2 = migrateButton;
            if (jButton2 != null) {
                jButton2.setEnabled(false);
            }
        }
        this.pack();
        this.setResizable(false);
    }

    @Override
    @NotNull
    protected Action[] getActions() {
        Action[] actionArray = new Action[]{this.getNeverShowAction(), this.getAdvancedSettingsAction(), this.getMigrateAction()};
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel jPanel;
        JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.insets = (Insets)JBUI.insetsBottom((int)20);
        Object[] objectArray = new Object[]{this.getProductName()};
        String string = DatabaseBundle.message((String)"consoles.migration.simple.dialog.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addWithConstrains($this$createCenterPanel_u24lambda_u240, (JComponent)SimpleConsolesMigrationDialog.createLabel$default(this, string, null, 2, null), constraints);
        constraints.insets = (Insets)JBUI.insetsBottom((int)8);
        String string2 = DatabaseBundle.message((String)"consoles.migration.simple.dialog.what.is.happening", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.addWithConstrains($this$createCenterPanel_u24lambda_u240, (JComponent)SimpleConsolesMigrationDialog.createLabel$default(this, string2, null, 2, null), constraints);
        String string3 = DatabaseBundle.message((String)"consoles.migration.simple.dialog.line1", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        Icon icon = DatabaseIcons.DbmsBlue;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DbmsBlue");
        this.addWithConstrains($this$createCenterPanel_u24lambda_u240, this.createLabelWithIcon(string3, icon), constraints);
        String string4 = DatabaseBundle.message((String)"consoles.migration.simple.dialog.line2", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        Icon icon2 = DatabaseIcons.RunHistoryBlue;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"RunHistoryBlue");
        this.addWithConstrains($this$createCenterPanel_u24lambda_u240, this.createLabelWithIcon(string4, icon2), constraints);
        String string5 = DatabaseBundle.message((String)"consoles.migration.simple.dialog.line3", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        Icon icon3 = DatabaseIcons.AudioToAudioBlue;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AudioToAudioBlue");
        this.addWithConstrains($this$createCenterPanel_u24lambda_u240, this.createLabelWithIcon(string5, icon3), constraints);
        constraints.insets = (Insets)JBUI.emptyInsets();
        String string6 = DatabaseBundle.message((String)"consoles.migration.simple.dialog.line4", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        Icon icon4 = DatabaseIcons.ShieldBlue;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ShieldBlue");
        this.addWithConstrains($this$createCenterPanel_u24lambda_u240, this.createLabelWithIcon(string6, icon4), constraints);
        if (this.noPath) {
            constraints.insets = (Insets)JBUI.insetsTop((int)30);
            String string7 = DatabaseBundle.message((String)"consoles.migration.simple.dialog.no.project.path", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
            this.addWithConstrains($this$createCenterPanel_u24lambda_u240, (JComponent)this.createLabel(string7, UIUtil.getErrorForeground()), constraints);
        }
        $this$createCenterPanel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)8, (int)8, (int)8, (int)30));
        return jPanel;
    }

    private final String getProductName() {
        String string;
        if (PlatformUtils.isDataGrip()) {
            String string2 = DatabaseBundle.message((String)"consoles.migration.simple.dialog.description.datagrip", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = DatabaseBundle.message((String)"consoles.migration.simple.dialog.description.database.plugin", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final JComponent createLabelWithIcon(@NlsContexts.Label String text, Icon icon) {
        JPanel jPanel;
        JPanel $this$createLabelWithIcon_u24lambda_u240 = jPanel = new JPanel();
        boolean bl = false;
        $this$createLabelWithIcon_u24lambda_u240.setAlignmentX(0.0f);
        $this$createLabelWithIcon_u24lambda_u240.setLayout(new FlowLayout(0, 0, 0));
        $this$createLabelWithIcon_u24lambda_u240.add((Component)new JBLabel(icon));
        $this$createLabelWithIcon_u24lambda_u240.add(Box.createHorizontalStrut(JBUI.scale((int)10)));
        $this$createLabelWithIcon_u24lambda_u240.add((Component)new JBLabel(text));
        return jPanel;
    }

    private final JBLabel createLabel(@NlsContexts.Label String text, Color foreground) {
        JBLabel jBLabel;
        JBLabel $this$createLabel_u24lambda_u240 = jBLabel = new JBLabel(text);
        boolean bl = false;
        if (foreground != null) {
            $this$createLabel_u24lambda_u240.setForeground(foreground);
        }
        return jBLabel;
    }

    static /* synthetic */ JBLabel createLabel$default(SimpleConsolesMigrationDialog simpleConsolesMigrationDialog, String string, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            color = null;
        }
        return simpleConsolesMigrationDialog.createLabel(string, color);
    }

    private final void addWithConstrains(JPanel $this$addWithConstrains, JComponent component, GridBagConstraints constraints) {
        $this$addWithConstrains.add((Component)component, constraints);
        int n = constraints.gridy;
        constraints.gridy = n + 1;
    }
}

