/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.editor.DbImportAutoTableManager;
import com.intellij.database.dbimport.editor.DbImportCachedDataManager;
import com.intellij.database.dbimport.editor.DbImportDataPreviewManager;
import com.intellij.database.dbimport.editor.DbImportEditorFactory;
import com.intellij.database.dbimport.editor.DbImportEditorModelFactory;
import com.intellij.database.dbimport.editor.data.CsvSourceData;
import com.intellij.database.dbimport.editor.data.DataSourceData;
import com.intellij.database.dbimport.editor.data.DbQuerySourceData;
import com.intellij.database.dbimport.editor.data.DbTableSourceData;
import com.intellij.database.dbimport.editor.data.FakeRootData;
import com.intellij.database.dbimport.editor.data.MappingData;
import com.intellij.database.dbimport.editor.data.ScriptedSourceData;
import com.intellij.database.dbimport.editor.editor.DbAutoReferenceEditor;
import com.intellij.database.dbimport.editor.model.applier.DbAutoDefinitionApplier;
import com.intellij.database.dbimport.editor.model.state.DbAutoDefinitionState;
import com.intellij.database.dbimport.editor.model.state.DbAutoReferenceModelState;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.WrapperElementFactory;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.DbObjectEditorBuilder;
import com.intellij.database.schemaEditor.DbObjectEditorModelFactory;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorUtilsKt;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbStructureEditorActions;
import com.intellij.database.schemaEditor.ui.DbStructureNodeEditor;
import com.intellij.database.schemaEditor.ui.DbStructureNodeTreeModel;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbImportEditorBuilder
extends DbObjectEditorBuilder {
    public DbImportEditorBuilder() {
        super(new DbImportEditorModelFactory(), new DbImportEditorFactory());
    }

    @Override
    protected <E extends BasicElement> boolean createReferenceEditorModel(@NotNull DbObjectEditorModelFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaReference<E, ?> reference, @NotNull List<BasicMetaField<E>> fields, @NotNull List<DbEditorModel<E, ?>> models) {
        if (factory == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(0);
        }
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(1);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(3);
        }
        if (fields == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(4);
        }
        if (models == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(5);
        }
        if (reference.id == MappingData.DATA_SOURCE_REF) {
            return true;
        }
        return super.createReferenceEditorModel(factory, controller, id, reference, fields, models);
    }

    @Override
    protected <E extends BasicElement> boolean createPropertyEditorModel(@NotNull DbObjectEditorModelFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaProperty<E, ?> property, @NotNull List<BasicMetaField<E>> fields, @NotNull List<DbEditorModel<E, ?>> models) {
        DbImportCachedDataManager checker;
        if (factory == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(6);
        }
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(7);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(8);
        }
        if (property == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(9);
        }
        if (fields == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(10);
        }
        if (models == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(11);
        }
        if (property.id == MappingData.AUTO_NAME) {
            return true;
        }
        if (property.id == DbTableSourceData.USE_CACHED && (checker = DbImportCachedDataManager.getInstance(controller)) != null && !checker.hasCachedData(id)) {
            return true;
        }
        return super.createPropertyEditorModel(factory, controller, id, property, fields, models);
    }

    @Override
    protected boolean isIncludedInStructured(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(12);
        }
        return super.isIncludedInStructured(meta) && meta.kind != DataSourceData.KIND;
    }

    @Override
    public boolean shouldHaveEditor(@NotNull DbModelRef<?, ?> model) {
        if (model == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(13);
        }
        return super.shouldHaveEditor(model) && model.getModelInternalKey() != DbAutoDefinitionState.ID;
    }

    @Override
    @NotNull
    public <E extends BasicElement> List<DbEditorModel<E, ?>> createObjectPropertiesModels(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @Nullable List<BasicMetaId> invalid) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(14);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(15);
        }
        List<DbEditorModel<DbEditorModelBase<E, DbAutoDefinitionState>, ?>> models = super.createObjectPropertiesModels(controller, id, invalid);
        if (id.getMetaObject().kindOf(BasicTable.class)) {
            models.add(new DbEditorModelBase<E, DbAutoDefinitionState>(controller, id, null, new DbAutoDefinitionState(), new DbAutoDefinitionApplier(), null));
        }
        List<DbEditorModel<DbEditorModelBase<E, DbAutoDefinitionState>, ?>> list = models;
        if (list == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    @Nullable
    public Icon getIcon(BasicElement properties2) {
        if (properties2.getMetaObject().kind == CsvSourceData.KIND) {
            return DatabaseIcons.FileFormat;
        }
        if (properties2.getMetaObject().kind == DbTableSourceData.KIND) {
            return DatabaseIcons.Table;
        }
        if (properties2.getMetaObject().kind == DbQuerySourceData.KIND) {
            return AllIcons.Nodes.DataSchema;
        }
        if (properties2.getMetaObject().kind == ScriptedSourceData.KIND) {
            return DatabaseIcons.Udf_script;
        }
        if (properties2.getMetaObject().kind == MappingData.KIND) {
            return DatabaseIcons.Synonym;
        }
        return super.getIcon(properties2);
    }

    @Override
    public boolean isUnaligned(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(17);
        }
        return super.isUnaligned(editor2) || editor2.getModelInternalKey() == CsvSourceData.FIRST_ROW_IS_HEADER || editor2.getModelInternalKey() == CsvSourceData.FIRST_COLUMN_IS_HEADER || editor2.getModelInternalKey() == CsvSourceData.TRIM_WHITESPACES;
    }

    @Override
    public boolean startsNewLine(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(18);
        }
        return super.startsNewLine(editor2) || editor2.getModelInternalKey() == CsvSourceData.FIRST_ROW_IS_HEADER;
    }

    @Override
    public boolean isHideFromStructure(@NotNull DbModelRef<?, ?> ref) {
        DbStructureFamilyModelState fs;
        if (ref == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(19);
        }
        if (super.isHideFromStructure(ref)) {
            return true;
        }
        Object obj = ref.getState();
        return obj instanceof DbStructureFamilyModelState && DbImportEditorBuilder.isHiddenGroup((fs = (DbStructureFamilyModelState)obj).getMetaObject());
    }

    @Override
    @Nullable
    public String getLocationText(@NotNull DbEditorController controller, @NotNull ElementIdentity<?> identity) {
        ObjectKind kind;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(20);
        }
        if (identity == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(21);
        }
        if ((kind = identity.getMetaObject().kind) == DbTableSourceData.KIND) {
            ElementIdentity<BasicLikeTable> tgtId = DbReferenceModelState.resolveReference(controller.getModelController(), identity, DbTableSourceData.TABLE_REF);
            return this.computeLocationString(controller, tgtId);
        }
        if (kind == MappingData.KIND) {
            ElementIdentity<BasicTable> tgtId = DbReferenceModelState.resolveReference(controller.getModelController(), identity, MappingData.TABLE_REF);
            return this.computeLocationString(controller, tgtId);
        }
        if (kind == DbQuerySourceData.KIND) {
            ElementIdentity<BasicNamespace> tgtId = DbReferenceModelState.resolveReference(controller.getModelController(), identity, DbQuerySourceData.TARGET_REF);
            return this.computePathString(controller, tgtId);
        }
        return super.getLocationText(controller, identity);
    }

    private static boolean isHiddenGroup(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(22);
        }
        return DbImportDataPreviewManager.Companion.isSourceKind(meta.kind) || meta.kind == MappingData.KIND;
    }

    @Override
    @NotNull
    public Dbms getDbms(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        RawDataSource ds;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(23);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(24);
        }
        if (id.getMetaObject().kind == DataSourceData.KIND && (ds = DataSourceData.getDataSource(controller, id)) != null) {
            Dbms dbms = ds.getDbms();
            if (dbms == null) {
                DbImportEditorBuilder.$$$reportNull$$$0(25);
            }
            return dbms;
        }
        ElementIdentity<?> dsId = DbImportEditorBuilder.getAssociatedElementId(controller, id);
        if (dsId != null) {
            Dbms dbms = this.getDbms(controller, dsId);
            if (dbms == null) {
                DbImportEditorBuilder.$$$reportNull$$$0(26);
            }
            return dbms;
        }
        Dbms dbms = super.getDbms(controller, id);
        if (dbms == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(27);
        }
        return dbms;
    }

    @Override
    @Nullable
    public Version getServerVersion(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        RawDataSource ds;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(28);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(29);
        }
        if (id.getMetaObject().kind == DataSourceData.KIND && (ds = DataSourceData.getDataSource(controller, id)) != null) {
            return ds.getVersion();
        }
        ElementIdentity<?> dsId = DbImportEditorBuilder.getAssociatedElementId(controller, id);
        if (dsId != null) {
            return this.getServerVersion(controller, dsId);
        }
        return super.getServerVersion(controller, id);
    }

    @Override
    @Nls
    @Nullable
    public String getDisplayNamePrefix(@NotNull ElementIdentity<?> id) {
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(30);
        }
        if (DbImportDataPreviewManager.Companion.isSourceKind(id.getMetaObject().kind)) {
            return DatabaseBundle.message((String)"import.source.label", (Object[])new Object[0]);
        }
        if (DbImportDataPreviewManager.Companion.isTargetKind(id.getMetaObject().kind)) {
            return DatabaseBundle.message((String)"import.target.label", (Object[])new Object[0]);
        }
        return super.getDisplayNamePrefix(id);
    }

    @Nullable
    private static ElementIdentity<?> getAssociatedElementId(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        ObjectKind kind;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(31);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(32);
        }
        if ((kind = id.getMetaObject().kind) == DbTableSourceData.KIND) {
            return DbReferenceModelState.resolveReference(controller, id, DbTableSourceData.TABLE_REF);
        }
        if (kind == DbQuerySourceData.KIND) {
            return DbReferenceModelState.resolveReference(controller, id, DbQuerySourceData.TARGET_REF);
        }
        if (kind == MappingData.KIND) {
            return DbReferenceModelState.resolveReference(controller, id, MappingData.TABLE_REF);
        }
        return null;
    }

    @Override
    @Nullable
    protected String getStructureRootGroup(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> rootId2, @NotNull DbModelRef<?, ? extends DbStructureNodeState<?, ?>> checkRef) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(33);
        }
        if (rootId2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(34);
        }
        if (checkRef == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(35);
        }
        ElementMatcher matcher = controller.getMatcher();
        if (checkRef.getIdentity() == rootId2) {
            return checkRef.getState() instanceof DbStructureFamilyModelState ? "" : null;
        }
        if (checkRef.getState() instanceof DbStructureObjectModelState) {
            DbEditorModel node;
            ElementIdentity parent2 = matcher.getParent(checkRef.getIdentity());
            DbEditorModel dbEditorModel = node = parent2 == null ? null : controller.getStructureNodeModel(parent2);
            if (node != null) {
                return null;
            }
            DbAutoDefinitionState autoDefState = DbAutoDefinitionState.resolve(controller, checkRef.getIdentity());
            return autoDefState == null || autoDefState.isInManualMode() ? checkRef.getIdentity().getMetaObject().kind.getPluralPresentableName() : null;
        }
        return null;
    }

    @Override
    @Nullable
    protected DbModelRef<?, ? extends DbStructureNodeState<?, ?>> getAffectedStructureNodeByChange(@NotNull DbEditorModel<?, ?> m) {
        if (m == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(36);
        }
        return m.getState() instanceof DbAutoDefinitionState ? DbModelRef.create(m.getController().getStructureNodeModel(m.getIdentity())) : null;
    }

    @Override
    @Nullable
    public BasicMetaObject<?> getParent(@Nullable BasicMetaObject<?> meta) {
        if (meta != null && meta.kind == ObjectKind.ROOT) {
            return DataSourceData.META.get(FakeRootData.META);
        }
        return super.getParent(meta);
    }

    @Override
    public <T extends BasicElement> void initNewObject(@NotNull DbEditorModelController controller, @NotNull DbModelRef<T, DbStructureObjectModelState<T>> child, @NotNull ModelHelper.ObjectKindVariant variant, int position, @NotNull Set<DbModelRef<?, ? extends DbStructureNodeState<?, ?>>> selection) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(37);
        }
        if (child == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(38);
        }
        if (variant == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(39);
        }
        if (selection == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(40);
        }
        super.initNewObject(controller, child, variant, position, selection);
        ElementIdentity identity = child.getIdentity();
        if (identity.getMetaObject().kind == CsvSourceData.KIND) {
            this.initCsvSource(controller, child);
        } else if (identity.getMetaObject().kind == DbTableSourceData.KIND) {
            this.initDbSource(controller, child);
        }
    }

    @Override
    @NotNull
    public DefaultActionGroup createStructureContextMenu() {
        DefaultActionGroup group = super.createStructureContextMenu();
        group.add((AnAction)new SetAutomaticAction());
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(41);
        }
        return defaultActionGroup;
    }

    private <T extends BasicElement> void initCsvSource(@NotNull DbEditorModelController controller, @NotNull DbModelRef<T, DbStructureObjectModelState<T>> child) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(42);
        }
        if (child == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(43);
        }
        ElementIdentity identity = child.getIdentity();
        this.addObjectToFamily(controller, child, MappingData.META.get(identity.getMetaObject()));
    }

    private <T extends BasicElement> void initDbSource(@NotNull DbEditorModelController controller, @NotNull DbModelRef<T, DbStructureObjectModelState<T>> child) {
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(44);
        }
        if (child == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(45);
        }
        ElementIdentity identity = child.getIdentity();
        this.addObjectToFamily(controller, child, MappingData.META.get(identity.getMetaObject()));
    }

    private <P extends BasicElement, T extends BasicElement> void addObjectToFamily(@NotNull DbEditorModelController controller, @NotNull DbModelRef<P, DbStructureObjectModelState<P>> parent2, @NotNull BasicMetaObject<T> meta) {
        DbModelRef<P, DbStructureFamilyModelState<T>> family;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(46);
        }
        if (parent2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(47);
        }
        if (meta == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(48);
        }
        if ((family = parent2.getState().getFamily(meta)) == null) {
            return;
        }
        ElementIdentity parentId = parent2.getIdentity();
        ElementIdentity childId = controller.getMatcher().create(parentId, meta);
        DbEditorModel child = this.createStructureNodeModel(controller, childId);
        family.getState().setCollection(controller, ContainerUtil.append(family.getState().getCollection(), (Object[])new DbModelRef[]{new DbModelRef(child)}));
    }

    @Override
    public boolean isEnabled(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id, @Nullable BasicElement e, @NotNull BasicMetaId prop) {
        ObjectKind kind;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(49);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(50);
        }
        if (prop == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(51);
        }
        if ((kind = id.getMetaObject().kind) == MappingData.KIND) {
            if (prop == MappingData.DISABLE_CONSTRAINTS) {
                ElementIdentity<BasicTable> tableId = DbReferenceModelState.resolveReference(controller, id, MappingData.TABLE_REF);
                if (tableId == null) {
                    return true;
                }
                Dbms dbms = controller.getDbms(tableId);
                Version version = this.getServerVersion(controller, id);
                return ImportManager.of((Dbms)dbms, (Version)version).isSupportFastMode();
            }
            if (prop == MappingData.ERRORS_PATH) {
                MappingData m = (MappingData)WrapperElementFactory.getDelegate((BasicElement)e, MappingData.class);
                return m == null || m.getDumpErrors();
            }
        }
        if ((kind == DbTableSourceData.KIND || kind == DbQuerySourceData.KIND) && prop == DbTableSourceData.USE_CACHED) {
            DbImportCachedDataManager cachedDataManager = DbImportCachedDataManager.getInstance(controller);
            return cachedDataManager != null && cachedDataManager.isCachedDataAvailable(id, e);
        }
        return super.isEnabled(controller, id, e, prop);
    }

    @Override
    public boolean canDrop(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> element) {
        DbAutoDefinitionState autoDef;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(52);
        }
        if (element == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(53);
        }
        if ((autoDef = DbAutoDefinitionState.resolve(controller, element)) != null && !autoDef.getAutoDefinitionSources().isEmpty()) {
            return false;
        }
        return super.canDrop(controller, element);
    }

    @Override
    @Nullable
    public DbDataSource getDataSource(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        ElementIdentity<?> assId;
        if (controller == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(54);
        }
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(55);
        }
        if ((assId = DbImportEditorBuilder.getAssociatedElementId(controller, id)) != null) {
            return this.getDataSource(controller, assId);
        }
        return DataSourceData.getDbDataSource(controller, id);
    }

    @Override
    public <T extends BasicElement> String getDisplayName(@NotNull ElementIdentity<T> id, @NotNull T properties2) {
        ObjectKind kind;
        String name;
        if (id == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(56);
        }
        if (properties2 == null) {
            DbImportEditorBuilder.$$$reportNull$$$0(57);
        }
        if ((name = properties2.getName()).isEmpty() && !(id instanceof MultiElementIdentity) && ((kind = id.getMetaObject().kind) == MappingData.KIND || kind == CsvSourceData.KIND || kind == DbTableSourceData.KIND)) {
            return DatabaseBundle.message((String)"label.incomplete", (Object[])new Object[0]);
        }
        return super.getDisplayName(id, properties2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 25, 26, 27, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 20: 
            case 23: 
            case 28: 
            case 31: 
            case 33: 
            case 37: 
            case 42: 
            case 44: 
            case 46: 
            case 49: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 24: 
            case 29: 
            case 30: 
            case 32: 
            case 50: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: 
            case 22: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 16: 
            case 25: 
            case 26: 
            case 27: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/editor/DbImportEditorBuilder";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkRef";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 38: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/editor/DbImportEditorBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectPropertiesModels";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureContextMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceEditorModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyEditorModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isIncludedInStructured";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shouldHaveEditor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createObjectPropertiesModels";
                break;
            }
            case 16: 
            case 25: 
            case 26: 
            case 27: 
            case 41: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isUnaligned";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "startsNewLine";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isHideFromStructure";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLocationText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isHiddenGroup";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getServerVersion";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayNamePrefix";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedElementId";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getStructureRootGroup";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedStructureNodeByChange";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "initNewObject";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "initCsvSource";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "initDbSource";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addObjectToFamily";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "canDrop";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 25, 26, 27, 41 -> new IllegalStateException(string);
        };
    }

    public static class SetAutomaticAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SetAutomaticAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SetAutomaticAction.$$$reportNull$$$0(1);
            }
            JBIterable<DbStructureNodeEditor<?, ?>> nodes = SetAutomaticAction.getDetachableNodes(e);
            DbStructureNodeEditor first = (DbStructureNodeEditor)nodes.first();
            e.getPresentation().setText(first != null && DbEditorUtilsKt.existsOriginally(first.getController(), first.getIdentity()) ? DatabaseBundle.message((String)"action.import.hide.text", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.import.set.automatic.text", (Object[])new Object[0]));
            e.getPresentation().setEnabledAndVisible(nodes.isNotEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetAutomaticAction.$$$reportNull$$$0(2);
            }
            for (DbStructureNodeEditor node : SetAutomaticAction.getDetachableNodes(e)) {
                DbEditorModelController controller = node.getController().getModelController();
                DbAutoDefinitionState autoState = DbAutoDefinitionState.resolve(controller, node.getIdentity());
                if (autoState == null) continue;
                if (DbImportAutoTableManager.Companion.canBeDefinedByMapping(controller, node.getIdentity())) {
                    for (DbEditor<?, ?> editor2 : node.getController().getAllEditors()) {
                        DbAutoReferenceEditor cde;
                        if (!(editor2 instanceof DbAutoReferenceEditor) || ((DbAutoReferenceModelState)(cde = (DbAutoReferenceEditor)editor2).getState()).getTargetId() != node.getIdentity()) continue;
                        cde.setDefinesTable(true);
                        break;
                    }
                }
                autoState.setInManualMode(false);
            }
        }

        @NotNull
        private static JBIterable<DbStructureNodeEditor<?, ?>> getDetachableNodes(@NotNull AnActionEvent e) {
            DbStructureEditor editor2;
            if (e == null) {
                SetAutomaticAction.$$$reportNull$$$0(3);
            }
            if ((editor2 = (DbStructureEditor)e.getData(DbStructureEditor.KEY)) == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    SetAutomaticAction.$$$reportNull$$$0(4);
                }
                return jBIterable;
            }
            JBIterable jBIterable = DbStructureEditorActions.getSelectedNodes(e).filter(n -> SetAutomaticAction.isDetachable(editor2, n)).collect();
            if (jBIterable == null) {
                SetAutomaticAction.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        private static boolean isDetachable(DbStructureEditor<?> editor2, DbStructureNodeEditor<?, ?> n) {
            DbEditorModelController modelController = n.getController().getModelController();
            DbAutoDefinitionState autoDefState = DbAutoDefinitionState.resolve(modelController, n.getIdentity());
            if (autoDefState == null || !autoDefState.isInManualMode()) {
                return false;
            }
            ElementOwner oOwner = modelController.getMatcher().getOriginalOwner();
            if (oOwner != null && autoDefState.getAutoDefinitionSources().isEmpty() && oOwner.find(n.getIdentity()) == null) {
                return false;
            }
            DbStructureNodeTreeModel structure = editor2.getStructure();
            if (!(structure.getParentNode(n) instanceof DbStructureModelState.Group)) {
                return false;
            }
            FileStatus status = DbVisualEditorBase.getStatus(n);
            return status == FileStatus.ADDED || status == FileStatus.NOT_CHANGED;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/editor/DbImportEditorBuilder$SetAutomaticAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/editor/DbImportEditorBuilder$SetAutomaticAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDetachableNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDetachableNodes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

