/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbScopeProvider;
import com.intellij.database.editor.CompositeFileEditorState;
import com.intellij.database.editor.DatabaseCompositeTableEditor;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.editor.DatabaseTableFileEditorProvider;
import com.intellij.database.editor.Editors;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.serialization.SerializationException;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\r\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/editor/DatabaseCompositeTableEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "readState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "sourceElement", "Lorg/jdom/Element;", "writeState", "", "state", "targetElement", "getEditorTypeId", "", "Lorg/jetbrains/annotations/NonNls;", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseCompositeTableEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseCompositeTableEditorProvider.kt\ncom/intellij/database/editor/DatabaseCompositeTableEditorProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,122:1\n42#2,3:123\n*S KotlinDebug\n*F\n+ 1 DatabaseCompositeTableEditorProvider.kt\ncom/intellij/database/editor/DatabaseCompositeTableEditorProvider\n*L\n35#1:123,3\n*E\n"})
public final class DatabaseCompositeTableEditorProvider
implements FileEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return DatabaseEditorUtil.isTableFile(file) && DbImplUtilCore.isInLocalDataSource((DbElement)((DbElement)DbImplUtilCore.findDataSource((Project)project, (VirtualFile)file)));
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile codeFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean $i$f$service = false;
        Class<DbScopeProvider> serviceClass$iv = DbScopeProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        CoroutineScope coroutineScope = ((DbScopeProvider)object).getCs();
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        CoroutineScope coroutineScope2 = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)string, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState), (boolean)false, (int)4, null);
        DatabaseTableFileEditorProvider dataEditorProvider = new DatabaseTableFileEditorProvider();
        FileEditorProvider fileEditorProvider = FileEditorProviderManager.Companion.getInstance().getProvider("text-editor");
        Intrinsics.checkNotNull((Object)fileEditorProvider);
        FileEditorProvider codeEditorProvider = fileEditorProvider;
        FileEditor fileEditor = dataEditorProvider.createEditor(project, file);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"createEditor(...)");
        FileEditor dataEditor = fileEditor;
        VirtualFile virtualFile = codeFile = file.getFileSystem().findFileByPath(file.getPath() + ".sql");
        Intrinsics.checkNotNull((Object)virtualFile);
        FileEditor fileEditor2 = codeEditorProvider.createEditor(project, virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor2, (String)"createEditor(...)");
        FileEditor codeEditor = fileEditor2;
        TextEditor textEditor = codeEditor instanceof TextEditor ? (TextEditor)codeEditor : null;
        if (textEditor != null) {
            TextEditor it = textEditor;
            boolean bl = false;
            DatabaseEditorHelper.configureToolbar(project, file, ((TextEditor)codeEditor).getEditor());
        }
        DatabaseTableFileEditor databaseTableFileEditor = (DatabaseTableFileEditor)dataEditor;
        String string2 = DatabaseBundle.message((String)"editor.tab.data.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = string2;
        String string4 = DatabaseBundle.message((String)"editor.tab.ddl.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        String string5 = string4;
        return (FileEditor)new DatabaseCompositeTableEditor(project, file, codeFile, coroutineScope2, new Editors(databaseTableFileEditor, dataEditorProvider, codeEditor, codeEditorProvider, string3, string5));
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        FileEditorState fileEditorState;
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            fileEditorState = (FileEditorState)XmlSerializer.deserialize((Element)sourceElement, CompositeFileEditorState.class);
        }
        catch (SerializationException serializationException) {
            FileEditorState fileEditorState2 = FileEditorState.INSTANCE;
            Intrinsics.checkNotNull((Object)fileEditorState2);
            fileEditorState = fileEditorState2;
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetElement, (String)"targetElement");
        if (state instanceof CompositeFileEditorState) {
            XmlSerializer.serializeObjectInto$default((Object)state, (Element)targetElement, null, (int)4, null);
        }
    }

    @NotNull
    public String getEditorTypeId() {
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

