/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SimplePattern;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlAlterInnerElementBlock;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlLeafBlocksKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.UntilPattern;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.stubs.elementTypes.SqlColumnDefinitionElementType;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\nH\u0014J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterInstructionBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "countOfInnerEntries", "", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "considerBlock", "", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "Companion", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlAlterTableBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlAlterTableBlock.kt\ncom/intellij/sql/formatter/model/SqlAlterInstructionBlock\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n+ 3 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n*L\n1#1,147:1\n14#2:148\n112#3,4:149\n*S KotlinDebug\n*F\n+ 1 SqlAlterTableBlock.kt\ncom/intellij/sql/formatter/model/SqlAlterInstructionBlock\n*L\n121#1:148\n124#1:149,4\n*E\n"})
public final class SqlAlterInstructionBlock
extends SqlNodeBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int countOfInnerEntries;
    @NotNull
    private static final Set<SqlTokenType> instructionStartWords;
    @NotNull
    private static final Set<SqlTokenType> instructionContinueWords;
    @NotNull
    private static final List<FlowPattern> patterns;

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    @Override
    protected void considerBlock(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        super.considerBlock(block);
        if (block instanceof SqlAlterInnerElementBlock) {
            int n = this.countOfInnerEntries;
            this.countOfInnerEntries = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        void _true_$iv;
        void $this$choose$iv;
        if (this.countOfInnerEntries == 0) {
            return;
        }
        SqlCodeStyleSettings s = this.getContext().getSql();
        boolean toIndent = s.TABLE_ALTER_ITEM_INDENT;
        boolean toAlign = s.TABLE_ALTER_ITEM_ALIGN && this.countOfInnerEntries >= 2;
        Wrap w = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, s.TABLE_ALTER_ITEM_WRAP, false, 2, null);
        boolean bl = toIndent;
        Indent indent = SqlFormattingFunKt.getNORMAL_INDENT();
        Indent _false_$iv = SqlFormattingFunKt.getNONE_INDENT();
        boolean $i$f$choose2 = false;
        Indent i = $this$choose$iv != false ? _true_$iv : _false_$iv;
        Alignment a = toAlign ? SqlFormattingModelFun.makeLeftAlignment() : null;
        for (SqlBlock b : this.getNestedBlocks()) {
            void indent$iv;
            void wrap$iv;
            void this_$iv;
            if (!(b instanceof SqlAlterInnerElementBlock)) continue;
            SqlBlock $i$f$choose2 = b;
            Wrap wrap = w;
            Indent indent2 = i;
            Alignment align$iv = a;
            boolean $i$f$setAttributes = false;
            this_$iv.setMyWrap((Wrap)wrap$iv);
            this_$iv.setMyIndent((Indent)indent$iv);
            this_$iv.setMyAlign(align$iv);
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        if (r1 == BlockRole.PREFIX && r2 == BlockRole.PREFIX) {
            spacing = this.getContext().makeSafeSpaceOrBreak();
        } else if (SqlLeafBlocksKt.isSymbol(block1, '(') || SqlLeafBlocksKt.isSymbol(block2, ')')) {
            spacing = this.getContext().makeNoSpace(true);
        } else if (block2 instanceof SqlComma) {
            spacing = this.getContext().makeNoSpace(this.getContext().getSql().TABLE_ALTER_ITEM_WRAP == 0);
        } else if (r2 == BlockRole.ELEMENT) {
            switch (this.getContext().getSql().TABLE_ALTER_ITEM_WRAP) {
                case 1: {
                    spacing = this.getContext().makeBreak(false);
                    break;
                }
                case 2: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, false, 1, null);
                    break;
                }
                default: {
                    spacing = this.getContext().makeSafeSpaceOrBreak();
                    break;
                }
            }
        } else {
            spacing = super.decideSpacing(block1, block2);
        }
        return spacing;
    }

    static {
        Object[] objectArray = new SqlTokenType[]{SqlCommonKeywords.SQL_ADD, SqlCommonKeywords.SQL_ALTER, SqlCommonKeywords.SQL_MODIFY, SqlCommonKeywords.SQL_ENABLE, SqlCommonKeywords.SQL_DISABLE, SqlCommonKeywords.SQL_SET, SqlCommonKeywords.SQL_DROP};
        instructionStartWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new SqlTokenType[]{SqlCommonKeywords.SQL_CONSTRAINT, SqlCommonKeywords.SQL_TRIGGER};
        instructionContinueWords = SetsKt.setOf((Object[])objectArray);
        objectArray = new FlowPattern[7];
        objectArray[0] = new SimplePattern((byte)0, (byte)5, NodeMatcherKt.matchType(instructionStartWords), NodeMatcherKt.matchType(instructionContinueWords), false, BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
        Byte by = 0;
        Byte by2 = 5;
        SqlTokenType sqlTokenType = SqlCommonTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
        objectArray[1] = new SingletonPattern(by, by2, NodeMatcherKt.matchType((IElementType)sqlTokenType), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
        Byte by3 = 5;
        Byte by4 = 5;
        SqlTokenType sqlTokenType2 = SqlCommonTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_LEFT_PAREN");
        objectArray[2] = new SingletonPattern(by3, by4, NodeMatcherKt.matchType((IElementType)sqlTokenType2), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
        Byte by5 = 5;
        Byte by6 = 5;
        SqlColumnDefinitionElementType sqlColumnDefinitionElementType = SqlCompositeElementTypes.SQL_COLUMN_DEFINITION;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlColumnDefinitionElementType), (String)"SQL_COLUMN_DEFINITION");
        objectArray[3] = new SingletonPattern(by5, by6, NodeMatcherKt.matchType((IElementType)sqlColumnDefinitionElementType), BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
        Byte by7 = 5;
        Byte by8 = 5;
        IElementType[] iElementTypeArray = new IElementType[2];
        Intrinsics.checkNotNullExpressionValue((Object)SqlCommonTokens.SQL_COMMA, (String)"SQL_COMMA");
        Intrinsics.checkNotNullExpressionValue((Object)SqlCommonTokens.SQL_RIGHT_PAREN, (String)"SQL_RIGHT_PAREN");
        objectArray[4] = new UntilPattern(by7, by8, NodeMatcherKt.matchType(iElementTypeArray), false, BlockRole.ELEMENT, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
        Byte by9 = 5;
        Byte by10 = 5;
        SqlTokenType sqlTokenType3 = SqlCommonTokens.SQL_COMMA;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_COMMA");
        objectArray[5] = new SingletonPattern(by9, by10, NodeMatcherKt.matchType((IElementType)sqlTokenType3), BlockRole.DELIMITER, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
        Byte by11 = 5;
        Byte by12 = 6;
        SqlTokenType sqlTokenType4 = SqlCommonTokens.SQL_RIGHT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType4, (String)"SQL_RIGHT_PAREN");
        objectArray[6] = new SingletonPattern(by11, by12, NodeMatcherKt.matchType((IElementType)sqlTokenType4), BlockRole.SUFFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.7.INSTANCE));
        patterns = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterInstructionBlock$Companion;", "", "<init>", "()V", "instructionStartWords", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "instructionContinueWords", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

