/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasOperator;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.symbols.DasSymbolUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0014R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/psi/impl/SqlNAryExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlExpressionImpl;", "Lcom/intellij/sql/psi/SqlNAryExpression;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "operands", "", "Lcom/intellij/sql/psi/SqlExpression;", "getOperands", "()Ljava/util/List;", "getOpSignElement", "Lcom/intellij/psi/PsiElement;", "i", "", "lOperand", "getLOperand", "()Lcom/intellij/sql/psi/SqlExpression;", "opSignElement", "()Lcom/intellij/psi/PsiElement;", "opSign", "getOpSign", "()Lcom/intellij/psi/tree/IElementType;", "dasTypeWithOperatorResolution", "Lcom/intellij/database/types/DasType;", "getDasTypeWithOperatorResolution", "()Lcom/intellij/database/types/DasType;", "computeDasType", "Companion", "intellij.database.sql.core.impl"})
public class SqlNAryExpressionImpl
extends SqlExpressionImpl
implements SqlNAryExpression {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SqlNAryExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    public List<SqlExpression> getOperands() {
        List list = SqlImplUtil.childrenIt((PsiElement)this).filter(SqlExpression.class).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return list;
    }

    @Nullable
    public PsiElement getOpSignElement(int i2) {
        SqlExpression op = i2 != 0 ? (SqlExpression)CollectionsKt.getOrNull(this.getOperands(), (int)i2) : this.getLOperand();
        return SqlNAryExpressionImpl.Companion.getOpAfter((PsiElement)op);
    }

    @NotNull
    public SqlExpression getLOperand() {
        SqlExpression sqlExpression = this.findNotNullChildByClass(SqlExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"findNotNullChildByClass(...)");
        return sqlExpression;
    }

    @Nullable
    public PsiElement getOpSignElement() {
        return SqlNAryExpressionImpl.Companion.getOpAfter((PsiElement)this.getLOperand());
    }

    @Nullable
    public IElementType getOpSign() {
        PsiElement sub;
        PsiElement signElement = this.getOpSignElement();
        IElementType sign = PsiUtilCore.getElementType((PsiElement)signElement);
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCompositeElementTypes.SQL_GENERIC_ELEMENT) && (sub = (PsiElement)SqlImplUtil.sqlChildren(signElement).filter(arg_0 -> SqlNAryExpressionImpl._get_opSign_$lambda$1(SqlNAryExpressionImpl::_get_opSign_$lambda$0, arg_0)).first()) != null) {
            sign = PsiTreeUtilKt.getElementType((PsiElement)sub);
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE)) {
            PsiElement nameToken;
            SqlIdentifier identifier;
            SqlReferenceExpression ref;
            PsiElement psiElement = this.getOpSignElement();
            SqlReferenceExpression sqlReferenceExpression = ref = psiElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement : null;
            SqlIdentifier sqlIdentifier = identifier = sqlReferenceExpression != null ? sqlReferenceExpression.getIdentifier() : null;
            PsiElement psiElement2 = nameToken = sqlIdentifier == null ? null : PsiTreeUtil.getDeepestFirst((PsiElement)((PsiElement)sqlIdentifier));
            if (nameToken != null) {
                sign = PsiUtilCore.getElementType((PsiElement)nameToken);
            }
        }
        return sign;
    }

    @NotNull
    public final DasType getDasTypeWithOperatorResolution() {
        PsiElement opSignElement = this.getOpSignElement();
        if (opSignElement instanceof SqlReferenceExpression) {
            DasType dasType;
            ResolveResult[] opResults = ((SqlReferenceExpression)opSignElement).multiResolve(false);
            if (opResults.length == 0) {
                return (DasType)DasTypeSystemBase.UNKNOWN;
            }
            DasType resultType = null;
            PsiElement resultPsi = null;
            for (ResolveResult opResult : opResults) {
                DasType dasType2;
                DasOperator dasObject;
                DasSymbol symbol;
                resultPsi = opResult.getElement();
                DasSymbol dasSymbol = symbol = DasSymbolUtil.getSymbol(opResult);
                Object object = dasSymbol != null ? dasSymbol.getDasObject() : null;
                if ((object instanceof DasOperator ? (DasOperator)object : null) == null) continue;
                dasObject = dasObject;
                Intrinsics.checkNotNullExpressionValue((Object)dasObject.getResultType(), (String)"getResultType(...)");
                if (resultType != null && !resultType.toDataType().equals(dasType2.toDataType())) {
                    return (DasType)DasTypeSystemBase.UNKNOWN;
                }
                resultType = dasType2;
            }
            if (resultType != null && resultPsi != null) {
                DasType dasType3 = SqlImplUtil.rebuildDasType(resultType, SqlImplUtil.getSqlDialectSafe((PsiElement)this), resultPsi);
                dasType = dasType3;
                Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"rebuildDasType(...)");
            } else {
                dasType = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            return dasType;
        }
        return this.getDasType();
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        DasType dasType = this.getLOperand().getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType lDasType = dasType;
        IElementType sign = this.getOpSign();
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)this);
        DasTypeSystem typeSystem = SqlPsiUtilKt.getTypeSystem((SqlElement)this);
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_EQ) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_NEQ) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_GT) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_LT) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_GE) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_LE) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_LOGICAL_AND) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_NULLSAFE_EQ) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_LOGICAL_OR) && (dbms2.isTransactSql() || dbms2.isMysql()) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_NEQ2) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_NEQ3) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_NEQ_WS) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_NEQ2_WS) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_NEQ3_WS) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_LIKE) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_IS) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_IN)) {
            DasType dasType2 = typeSystem.getBooleanType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getBooleanType(...)");
            return dasType2;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_PLUS) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_MINUS) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_MUL) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_DIV)) {
            if (DasTypeUtilsKt.is((DasType)lDasType, (DasTypeCategory)DasTypeCategory.REAL) || DasTypeUtilsKt.is((DasType)lDasType, (DasTypeCategory)DasTypeCategory.DATE) || DasTypeUtilsKt.is((DasType)lDasType, (DasTypeCategory)DasTypeCategory.TIME) || DasTypeUtilsKt.is((DasType)lDasType, (DasTypeCategory)DasTypeCategory.TIMESTAMP) || DasTypeUtilsKt.is((DasType)lDasType, (DasTypeCategory)DasTypeCategory.DATE_TIME) || DasTypeUtilsKt.is((DasType)lDasType, (DasTypeCategory)DasTypeCategory.INTEGER)) {
                return lDasType;
            }
            DasType dasType3 = typeSystem.getIntType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getIntType(...)");
            return dasType3;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_BITWISE_XOR) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_BITWISE_AND) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_BITWISE_OR) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_INVERT) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_LEFT_SHIFT) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_RIGHT_SHIFT) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_MODULO)) {
            DasType dasType4 = typeSystem.getIntType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType4, (String)"getIntType(...)");
            return dasType4;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_CONCAT)) {
            DasType dasType5 = typeSystem.getStringType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType5, (String)"getStringType(...)");
            return dasType5;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_LEFT_BRACKET) && lDasType instanceof DasArrayType) {
            DasType dasType6 = ((DasArrayType)lDasType).getComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType6, (String)"getComponentType(...)");
            return dasType6;
        }
        return (DasType)DasTypeSystemBase.UNKNOWN;
    }

    private static final boolean _get_opSign_$lambda$0(PsiElement it) {
        IElementType type = PsiTreeUtilKt.getElementType((PsiElement)it);
        return !Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_NOT) && !Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_GLOBAL) && !SqlTokens.WS_OR_COMMENTS.contains(type);
    }

    private static final boolean _get_opSign_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/sql/psi/impl/SqlNAryExpressionImpl$Companion;", "", "<init>", "()V", "getOpAfter", "Lcom/intellij/psi/PsiElement;", "el", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final PsiElement getOpAfter(PsiElement el) {
            if (el == null) {
                return null;
            }
            PsiElement node = el.getNextSibling();
            while (node != null) {
                IElementType type = PsiTreeUtilKt.getElementType((PsiElement)node);
                if (SqlTokens.WS_OR_COMMENTS.contains(type)) {
                    node = node.getNextSibling();
                    continue;
                }
                if (type instanceof SqlTokenType) {
                    return node;
                }
                if (type == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
                    return node;
                }
                if (type == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT) {
                    return node;
                }
                if (type instanceof SqlCompositeElementType) break;
                node = node.getNextSibling();
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

