/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.types.DasType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralConcatenation;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralEscaper;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0012\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlLiteralExpressionImpl;", "Lcom/intellij/sql/psi/SqlStringLiteralExpression;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "accept", "", "visitor", "Lcom/intellij/sql/psi/SqlVisitor;", "getDasType", "Lcom/intellij/database/types/DasType;", "getReference", "Lcom/intellij/psi/PsiReference;", "getValue", "", "isValidHost", "", "updateText", "text", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlStringLiteralExpressionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlStringLiteralExpressionImpl.kt\ncom/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class SqlStringLiteralExpressionImpl
extends SqlLiteralExpressionImpl
implements SqlStringLiteralExpression {
    public SqlStringLiteralExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    public void accept(@NotNull SqlVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitSqlStringLiteralExpression((SqlStringLiteralExpression)this);
    }

    @Override
    @NotNull
    public DasType getDasType() {
        DasType dasType = SqlPsiUtilKt.getTypeSystem((SqlElement)this).getStringType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getStringType(...)");
        return dasType;
    }

    @Nullable
    public PsiReference getReference() {
        PsiElement parent = this.getParent();
        if (!(parent instanceof SqlOrderByClause) && !(parent instanceof SqlGroupByClause)) {
            return super.getReference();
        }
        if (parent instanceof SqlStringLiteralConcatenation) {
            return super.getReference();
        }
        SqlReferenceImpl reference2 = new SqlReferenceImpl(this, parent){
            final /* synthetic */ SqlStringLiteralExpressionImpl this$0;
            final /* synthetic */ PsiElement $parent;
            {
                this.this$0 = $receiver;
                this.$parent = $parent;
                super((SqlElement)$receiver);
            }

            public SqlExpression getQualifierExpression() {
                PsiElement psiElement = this.$parent;
                SqlReferenceExpression sqlReferenceExpression = psiElement instanceof SqlReferenceExpression ? (SqlReferenceExpression)psiElement : null;
                return sqlReferenceExpression != null ? sqlReferenceExpression.getQualifierExpression() : null;
            }

            public String getReferenceName() {
                String string = this.this$0.getValue();
                if (string == null) {
                    string = "";
                }
                return string;
            }

            public TextRange getRangeInElement() {
                TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)((PsiElement)this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
                return textRange;
            }

            public PsiElement handleElementRename(String newElementName) {
                Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
                return ElementManipulators.handleContentChange((PsiElement)((PsiElement)this.this$0), (String)newElementName);
            }
        };
        return reference2.resolve() != null ? (PsiReference)reference2 : super.getReference();
    }

    @Nullable
    public String getValue() {
        return SqlStringLiteralManipulator.getLiteralText(this);
    }

    public boolean isValidHost() {
        return true;
    }

    @Nullable
    public SqlStringLiteralExpressionImpl updateText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SqlExpression expression = SqlPsiElementFactory.createExpressionFromText(text, SqlImplUtil.getSqlDialectSafe((PsiElement)this), (PsiElement)this);
        boolean bl = expression instanceof SqlStringLiteralExpression;
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = text + "-->" + expression;
            throw new AssertionError((Object)string);
        }
        SqlExpression sqlExpression = expression;
        Intrinsics.checkNotNull((Object)sqlExpression);
        return (SqlStringLiteralExpressionImpl)this.replace((PsiElement)sqlExpression);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new SqlStringLiteralEscaper(this);
    }
}

