/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/psi/impl/SqlUnaryExpressionImpl;", "Lcom/intellij/sql/psi/impl/SqlExpressionImpl;", "Lcom/intellij/sql/psi/SqlUnaryExpression;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "accept", "", "visitor", "Lcom/intellij/sql/psi/SqlVisitor;", "computeDasType", "Lcom/intellij/database/types/DasType;", "opSign", "getOpSign", "()Lcom/intellij/psi/tree/IElementType;", "opSignElement", "Lcom/intellij/psi/PsiElement;", "getOpSignElement", "()Lcom/intellij/psi/PsiElement;", "operand", "Lcom/intellij/sql/psi/SqlExpression;", "getOperand", "()Lcom/intellij/sql/psi/SqlExpression;", "intellij.database.sql.core.impl"})
public class SqlUnaryExpressionImpl
extends SqlExpressionImpl
implements SqlUnaryExpression {
    public SqlUnaryExpressionImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    public void accept(@NotNull SqlVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitSqlUnaryExpression((SqlUnaryExpression)this);
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        IElementType sign = this.getOpSign();
        SqlExpression operand = this.getOperand();
        SqlExpression sqlExpression = operand;
        if (sqlExpression == null || (sqlExpression = sqlExpression.getDasType()) == null) {
            sqlExpression = (DasType)DasTypeSystemBase.UNKNOWN;
        }
        SqlExpression dasType = sqlExpression;
        DasTypeSystem typeSystem = SqlPsiUtilKt.getTypeSystem((SqlElement)this);
        if (sign == SqlCommonKeywords.SQL_NOT || sign == SqlCommonKeywords.SQL_EXISTS || sign == SqlCommonKeywords.SQL_UNIQUE || sign == SqlCommonKeywords.SQL_IS || sign == SqlCommonTokens.SQL_OP_NOT2) {
            DasType dasType2 = typeSystem.getBooleanType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getBooleanType(...)");
            return dasType2;
        }
        if (sign == SqlCommonTokens.SQL_OP_PLUS || sign == SqlCommonTokens.SQL_OP_MINUS) {
            SqlExpression sqlExpression2;
            if (DasTypeUtilsKt.is((DasType)dasType, (DasTypeCategory)DasTypeCategory.REAL)) {
                sqlExpression2 = dasType;
            } else {
                DasType dasType3 = typeSystem.getIntType();
                sqlExpression2 = dasType3;
                Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"getIntType(...)");
            }
            return sqlExpression2;
        }
        return (DasType)DasTypeSystemBase.UNKNOWN;
    }

    @NotNull
    public IElementType getOpSign() {
        IElementType iElementType = this.getOpSignElement().getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        return iElementType;
    }

    @NotNull
    public PsiElement getOpSignElement() {
        ASTNode[] aSTNodeArray = this.getNode().getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        for (ASTNode node : aSTNodeArray) {
            PsiElement element;
            IElementType type;
            Intrinsics.checkNotNullExpressionValue((Object)node.getElementType(), (String)"getElementType(...)");
            if (SqlTokens.WS_OR_COMMENTS.contains(type)) continue;
            if (type == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
                PsiElement psiElement = node.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                return psiElement;
            }
            if (type == SqlCompositeElementTypes.SQL_COLLATE_CLAUSE) {
                PsiElement psiElement = node.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                return psiElement;
            }
            if (type == SqlCompositeElementTypes.SQL_GENERIC_ELEMENT) {
                PsiElement psiElement = node.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                return psiElement;
            }
            if (!(type instanceof SqlTokenType) || (element = node.getPsi()) instanceof SqlExpression) continue;
            Intrinsics.checkNotNull((Object)element);
            return element;
        }
        throw new AssertionError((Object)"no opsign found");
    }

    @Nullable
    public SqlExpression getOperand() {
        return this.findChildByClass(SqlExpression.class);
    }
}

