/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasBuiltinTypeWithLengthUnits;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasBuiltinTypeWithScale;
import com.intellij.database.types.DasDataBuiltinType;
import com.intellij.database.types.DasSimpleBuiltinTypeClass;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlDasTypeAwareDeepRecursiveElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.impl.SqlTypeElementBase;
import com.intellij.util.containers.JBIterable;
import kotlin.DeepRecursiveScope;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0004J\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0018\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u0018\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0018\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\u0018\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0014J\"\u0010\u001e\u001a\u00020\u001b*\u0012\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001b0\u001fj\u0002`!H\u0096@\u00a2\u0006\u0002\u0010\"R\u0014\u0010\t\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0016\u001a\u00020\u00178TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/intellij/sql/psi/impl/SqlBuiltinTypeElementImpl;", "Lcom/intellij/sql/psi/impl/SqlTypeElementBase;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "getIntAttributePsi", "Lcom/intellij/psi/PsiElement;", "after", "intAttribute", "", "getIntAttribute", "()I", "adjustTypeWithPrecision", "Lcom/intellij/database/types/DasBuiltinTypeWithPrecision;", "dasType", "adjustTypeWithScale", "Lcom/intellij/database/types/DasBuiltinTypeWithScale;", "adjustTypeWithLength", "Lcom/intellij/database/types/DasBuiltinTypeWithLength;", "adjustTypeWithLengthUnits", "Lcom/intellij/database/types/DasBuiltinTypeWithLengthUnits;", "lengthUnit", "Lcom/intellij/database/model/LengthUnit;", "getLengthUnit", "()Lcom/intellij/database/model/LengthUnit;", "parseBuiltinTypeBase", "Lcom/intellij/database/types/DasType;", "adjustType", "Lcom/intellij/database/types/DasBuiltinType;", "computeDasType", "Lkotlin/DeepRecursiveScope;", "Lcom/intellij/sql/psi/impl/SqlDasTypeAwareDeepRecursiveElement;", "Lcom/intellij/sql/psi/impl/SqlDeepRecursiveTypeEvaluationScope;", "(Lkotlin/DeepRecursiveScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.database.sql.core.impl"})
public class SqlBuiltinTypeElementImpl
extends SqlTypeElementBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SqlBuiltinTypeElementImpl(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Nullable
    protected final PsiElement getIntAttributePsi(@Nullable PsiElement after) {
        JBIterable jBIterable = after != null ? SqlImplUtil.siblings(after).skip(1) : SqlImplUtil.sqlChildren((PsiElement)this);
        Intrinsics.checkNotNull((Object)jBIterable);
        JBIterable elements = jBIterable;
        JBIterable jBIterable2 = elements.filter(arg_0 -> SqlBuiltinTypeElementImpl.getIntAttributePsi$lambda$1(SqlBuiltinTypeElementImpl::getIntAttributePsi$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        return (PsiElement)CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable2));
    }

    protected final int getIntAttribute() {
        return SqlBuiltinTypeElementImpl.parseIntAttribute(this.getIntAttributePsi(null), -1);
    }

    private final DasBuiltinTypeWithPrecision<?> adjustTypeWithPrecision(DasBuiltinTypeWithPrecision<?> dasType) {
        PsiElement psiElement = this.getIntAttributePsi(null);
        if (psiElement == null) {
            return dasType;
        }
        PsiElement precisionPsi = psiElement;
        int precision = SqlBuiltinTypeElementImpl.parseIntAttribute(precisionPsi, -1);
        PsiElement scalePsi = this.getIntAttributePsi(precisionPsi);
        int scale = SqlBuiltinTypeElementImpl.parseIntAttribute(scalePsi, 0);
        DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision = dasType.copy(precision, scale);
        Intrinsics.checkNotNullExpressionValue((Object)dasBuiltinTypeWithPrecision, (String)"copy(...)");
        return dasBuiltinTypeWithPrecision;
    }

    private final DasBuiltinTypeWithScale<?> adjustTypeWithScale(DasBuiltinTypeWithScale<?> dasType) {
        PsiElement psiElement = this.getIntAttributePsi(null);
        if (psiElement == null) {
            return dasType;
        }
        PsiElement scalePsi = psiElement;
        int scale = SqlBuiltinTypeElementImpl.parseIntAttribute(scalePsi, 0);
        DasBuiltinTypeWithScale dasBuiltinTypeWithScale = dasType.copy(scale);
        Intrinsics.checkNotNullExpressionValue((Object)dasBuiltinTypeWithScale, (String)"copy(...)");
        return dasBuiltinTypeWithScale;
    }

    private final DasBuiltinTypeWithLength<?> adjustTypeWithLength(DasBuiltinTypeWithLength<?> dasType) {
        DasBuiltinTypeWithLength dasBuiltinTypeWithLength = dasType.copy(this.getIntAttribute());
        Intrinsics.checkNotNullExpressionValue((Object)dasBuiltinTypeWithLength, (String)"copy(...)");
        return dasBuiltinTypeWithLength;
    }

    private final DasBuiltinTypeWithLengthUnits<?> adjustTypeWithLengthUnits(DasBuiltinTypeWithLengthUnits<?> dasType) {
        LengthUnit unit;
        int length = this.getIntAttribute();
        DasBuiltinTypeWithLengthUnits dasBuiltinTypeWithLengthUnits = dasType.copy(length, unit, (unit = this.getLengthUnit()) != LengthUnit.NONE);
        Intrinsics.checkNotNullExpressionValue((Object)dasBuiltinTypeWithLengthUnits, (String)"copy(...)");
        return dasBuiltinTypeWithLengthUnits;
    }

    @NotNull
    protected LengthUnit getLengthUnit() {
        LengthUnit lengthUnit = LengthUnit.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"NONE");
        return lengthUnit;
    }

    @Nullable
    protected DasType parseBuiltinTypeBase() {
        DataType dataType = this.parseDataType();
        DasTypeCategory category = SqlPsiUtilKt.getSqlDialect((PsiElement)this).getTypeSystem().getTypeCategory(dataType);
        String string = dataType.typeName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName");
        DasSimpleBuiltinTypeClass typeClass = DasSimpleBuiltinTypeClass.Companion.of(string, category);
        return (DasType)DasDataBuiltinType.Companion.of(typeClass, dataType);
    }

    @NotNull
    protected DasBuiltinType<?> adjustType(@NotNull DasBuiltinType<?> dasType) {
        Intrinsics.checkNotNullParameter(dasType, (String)"dasType");
        if (dasType instanceof DasBuiltinTypeWithLengthUnits) {
            return (DasBuiltinType)this.adjustTypeWithLengthUnits((DasBuiltinTypeWithLengthUnits)dasType);
        }
        if (dasType instanceof DasBuiltinTypeWithLength) {
            return (DasBuiltinType)this.adjustTypeWithLength((DasBuiltinTypeWithLength)dasType);
        }
        if (dasType instanceof DasBuiltinTypeWithPrecision) {
            return (DasBuiltinType)this.adjustTypeWithPrecision((DasBuiltinTypeWithPrecision)dasType);
        }
        if (dasType instanceof DasBuiltinTypeWithScale) {
            return (DasBuiltinType)this.adjustTypeWithScale((DasBuiltinTypeWithScale)dasType);
        }
        return dasType;
    }

    @Override
    @Nullable
    public Object computeDasType(@NotNull DeepRecursiveScope<SqlDasTypeAwareDeepRecursiveElement, DasType> $this$computeDasType, @NotNull Continuation<? super DasType> $completion) {
        return SqlBuiltinTypeElementImpl.computeDasType$suspendImpl(this, $this$computeDasType, $completion);
    }

    static /* synthetic */ Object computeDasType$suspendImpl(SqlBuiltinTypeElementImpl $this, DeepRecursiveScope<SqlDasTypeAwareDeepRecursiveElement, DasType> $receiver, Continuation<? super DasType> $completion) {
        DasType dasType = $this.parseBuiltinTypeBase();
        if (dasType == null) {
            return DasTypeSystemBase.UNKNOWN;
        }
        DasType dasType2 = dasType;
        if (!(dasType2 instanceof DasBuiltinType)) {
            return dasType2;
        }
        return $this.adjustType((DasBuiltinType)dasType2);
    }

    private static final boolean getIntAttributePsi$lambda$0(PsiElement it) {
        IElementType elementType = PsiTreeUtilKt.getElementType((PsiElement)it);
        return Intrinsics.areEqual((Object)elementType, (Object)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL) || Intrinsics.areEqual((Object)elementType, (Object)SqlTokens.SQL_INTEGER_TOKEN) || Intrinsics.areEqual((Object)elementType, (Object)SqlCommonTokens.SQL_ASTERISK);
    }

    private static final boolean getIntAttributePsi$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    protected static final int parseIntAttribute(@Nullable PsiElement attributePsi, int defaultValue) {
        return Companion.parseIntAttribute(attributePsi, defaultValue);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0005\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/psi/impl/SqlBuiltinTypeElementImpl$Companion;", "", "<init>", "()V", "parseIntAttribute", "", "attributePsi", "Lcom/intellij/psi/PsiElement;", "defaultValue", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        protected final int parseIntAttribute(@Nullable PsiElement attributePsi, int defaultValue) {
            if (attributePsi == null) {
                return defaultValue;
            }
            String text = attributePsi.getText();
            if (Intrinsics.areEqual((Object)text, (Object)"*")) {
                return 0x7FFFFFFE;
            }
            return StringUtil.parseInt((String)text, (int)defaultValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

