/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring.extractFunction;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.refactoring.SqlIntroduceHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableCodeInfoKt;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0004J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\tJ\u0018\u0010,\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010-\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0014J\u0018\u00100\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0018\u00101\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u00102\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u00103\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ \u00104\u001a\u00020*2\u0006\u00105\u001a\u00020*2\b\u00106\u001a\u0004\u0018\u00010\u00102\u0006\u00107\u001a\u000208R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00069"}, d2={"Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "<init>", "()V", "validateExpression", "", "e", "Lcom/intellij/sql/psi/SqlExpression;", "supportsTableFunctions", "", "getSupportsTableFunctions", "()Z", "getRoutineKeyword", "functionInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "findTopmostBlock", "Lcom/intellij/psi/PsiElement;", "element", "findAnchor", "container", "parenthesizeEmptyParameterList", "getParenthesizeEmptyParameterList", "returnTypeKeyword", "getReturnTypeKeyword", "()Ljava/lang/String;", "generateParameter", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "param", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "generateReturnExpression", "generateBodyStatement", "generateBody", "generateTableTypeColumns", "sqlType", "Lcom/intellij/sql/psi/SqlTableType;", "generateTableType", "generateType", "dasType", "Lcom/intellij/database/types/DasType;", "generateRoutine", "Lcom/intellij/sql/psi/SqlRoutineDefinition;", "isPreview", "generatePreamble", "generateReturnClause", "codeInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableCodeInfo;", "generateCallExpression", "generateTableCallExpression", "doGenerateCall", "generateCall", "addRoutine", "declaration", "anchor", "block", "Lcom/intellij/sql/psi/SqlElement;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlExtractFunctionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlExtractFunctionHelper.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,201:1\n1924#2,3:202\n1924#2,3:205\n66#3,2:208\n*S KotlinDebug\n*F\n+ 1 SqlExtractFunctionHelper.kt\ncom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper\n*L\n115#1:202,3\n151#1:205,3\n164#1:208,2\n*E\n"})
public abstract class SqlExtractFunctionHelper
implements SqlIntroduceHelper {
    @Nullable
    public final String validateExpression(@NotNull SqlExpression e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DasType dasType = e.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        DasType dasType2 = dasType;
        if (dasType2 instanceof DasBuiltinType && !Intrinsics.areEqual((Object)dasType2, (Object)DasTypeSystemBase.UNKNOWN) && !Intrinsics.areEqual((Object)dasType2, (Object)DasTypeSystemBase.VOID)) {
            return null;
        }
        if (this.getSupportsTableFunctions()) {
            if (!(dasType2 instanceof DasTableType)) {
                return "dialog.message.only.primitives.and.tables.are.supported";
            }
            if (e instanceof SqlQueryExpression || e instanceof SqlResultSetExpression) {
                return null;
            }
            if (UtilsKt.wrapAlias(e) instanceof SqlFromClause) {
                return null;
            }
            return "dialog.message.only.queries.and.froms.are.supported";
        }
        return "dialog.message.only.primitives.are.supported";
    }

    public boolean getSupportsTableFunctions() {
        return false;
    }

    @NotNull
    public String getRoutineKeyword(@NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        return "function";
    }

    @Override
    @Nullable
    public PsiElement findTopmostBlock(@Nullable PsiElement element) {
        PsiElement psiElement = element;
        return (PsiElement)(psiElement != null ? psiElement.getContainingFile() : null);
    }

    @Nullable
    public PsiElement findAnchor(@NotNull PsiElement element, @NotNull PsiElement container) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        return PsiTreeUtil.findPrevParent((PsiElement)container, (PsiElement)element);
    }

    public boolean getParenthesizeEmptyParameterList() {
        return true;
    }

    @NotNull
    public String getReturnTypeKeyword() {
        return "returns";
    }

    protected void generateParameter(@NotNull DdlBuilder builder2, @NotNull SqlExtractableParameterInfo param) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        builder2.identifier(param.getName(), ObjectKind.VARIABLE);
        builder2.space();
        builder2.type(param.getDasType().toDataType());
    }

    protected void generateReturnExpression(@NotNull DdlBuilder builder2, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        if (functionInfo.getCodeInfo().isTableFunction() && !functionInfo.getCodeInfo().isQuery()) {
            builder2.keyword("select ").symbol("*").keyword(" from ");
        }
        builder2.plain(functionInfo.getSubstitutedExpression().getText());
    }

    protected void generateBodyStatement(@NotNull DdlBuilder builder2, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        DdlBuilder $this$generateBodyStatement_u24lambda_u240 = builder2;
        boolean bl = false;
        $this$generateBodyStatement_u24lambda_u240.keyword("begin");
        $this$generateBodyStatement_u24lambda_u240.newLine();
        $this$generateBodyStatement_u24lambda_u240.keyword("return ");
        this.generateReturnExpression($this$generateBodyStatement_u24lambda_u240, functionInfo);
        $this$generateBodyStatement_u24lambda_u240.symbol(";");
        $this$generateBodyStatement_u24lambda_u240.newLine();
        $this$generateBodyStatement_u24lambda_u240.keyword("end");
    }

    public void generateBody(@NotNull DdlBuilder builder2, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        DdlBuilder $this$generateBody_u24lambda_u240 = builder2;
        boolean bl = false;
        $this$generateBody_u24lambda_u240.keyword("as ");
        this.generateBodyStatement($this$generateBody_u24lambda_u240, functionInfo);
    }

    protected final void generateTableTypeColumns(@NotNull DdlBuilder builder2, @NotNull SqlTableType sqlType) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        int n = sqlType.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                builder2.symbol(", ");
            }
            ObjectName name = ObjectName.create((String)sqlType.getColumnName(i), (boolean)sqlType.isColumnQuoted(i));
            builder2.identifier(name, ObjectKind.COLUMN);
            builder2.space();
            DasType dasType = sqlType.getColumnDasType(i);
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getColumnDasType(...)");
            this.generateType(builder2, dasType);
        }
    }

    public void generateTableType(@NotNull DdlBuilder builder2, @NotNull SqlTableType sqlType) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        builder2.keyword("table");
        builder2.symbol("(");
        this.generateTableTypeColumns(builder2, sqlType);
        builder2.symbol(")");
    }

    public void generateType(@NotNull DdlBuilder builder2, @NotNull DasType dasType) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dasType, (String)"dasType");
        if (dasType instanceof SqlTableType) {
            this.generateTableType(builder2, (SqlTableType)dasType);
        } else {
            DdlBuilder ddlBuilder = builder2.type(dasType.toDataType());
            Intrinsics.checkNotNull((Object)ddlBuilder);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SqlRoutineDefinition generateRoutine(@NotNull SqlExtractFunctionInfo functionInfo, boolean isPreview) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        SqlExtractableCodeInfo codeInfo = functionInfo.getCodeInfo();
        DdlBuilder $this$generateRoutine_u24lambda_u240 = ddlBuilder = SqlExtractableCodeInfoKt.createBuilder(functionInfo);
        boolean bl = false;
        this.generatePreamble($this$generateRoutine_u24lambda_u240, functionInfo);
        Collection<SqlExtractableParameterInfo> parameters = functionInfo.getParameters();
        if (!parameters.isEmpty()) {
            $this$generateRoutine_u24lambda_u240.symbol("(");
            Iterable $this$forEachIndexed$iv = parameters;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void param;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)item$iv;
                int i = n;
                boolean bl2 = false;
                if (i > 0) {
                    $this$generateRoutine_u24lambda_u240.symbol(", ");
                }
                this.generateParameter($this$generateRoutine_u24lambda_u240, (SqlExtractableParameterInfo)param);
            }
            $this$generateRoutine_u24lambda_u240.symbol(")");
        } else if (this.getParenthesizeEmptyParameterList()) {
            $this$generateRoutine_u24lambda_u240.symbol("()");
        }
        this.generateReturnClause($this$generateRoutine_u24lambda_u240, codeInfo);
        if (!isPreview) {
            $this$generateRoutine_u24lambda_u240.space();
            this.generateBody($this$generateRoutine_u24lambda_u240, functionInfo);
        }
        DdlBuilder builder2 = ddlBuilder;
        SqlStatement sqlStatement = SqlPsiElementFactory.createStatementFromText(builder2.getStatement(), codeInfo.getDialect(), codeInfo.getProject(), null);
        Intrinsics.checkNotNull((Object)sqlStatement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlRoutineDefinition");
        return (SqlRoutineDefinition)sqlStatement;
    }

    protected void generatePreamble(@NotNull DdlBuilder builder2, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        DdlBuilder $this$generatePreamble_u24lambda_u240 = builder2;
        boolean bl = false;
        $this$generatePreamble_u24lambda_u240.keyword("create " + this.getRoutineKeyword(functionInfo) + " ");
        $this$generatePreamble_u24lambda_u240.identifier(functionInfo.getName(), ObjectKind.ROUTINE);
    }

    protected void generateReturnClause(@NotNull DdlBuilder builder2, @NotNull SqlExtractableCodeInfo codeInfo) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)codeInfo, (String)"codeInfo");
        DdlBuilder $this$generateReturnClause_u24lambda_u240 = builder2;
        boolean bl = false;
        $this$generateReturnClause_u24lambda_u240.keyword(" " + this.getReturnTypeKeyword() + " ");
        DasType dasType = codeInfo.getOriginalExpression().getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        this.generateType($this$generateReturnClause_u24lambda_u240, dasType);
    }

    /*
     * WARNING - void declaration
     */
    protected final void generateCallExpression(@NotNull DdlBuilder builder2, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        builder2.identifier(functionInfo.getName(), ObjectKind.ROUTINE);
        builder2.symbol("(");
        Iterable $this$forEachIndexed$iv = functionInfo.getParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SqlExtractableParameterInfo sqlExtractableParameterInfo = (SqlExtractableParameterInfo)item$iv;
            int i = n;
            boolean bl = false;
            if (i > 0) {
                builder2.symbol(", ");
            }
            builder2.plain(param.getOriginalExpression().getText());
        }
        builder2.symbol(")");
    }

    protected void generateTableCallExpression(@NotNull DdlBuilder builder2, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        this.generateCallExpression(builder2, functionInfo);
    }

    private final void doGenerateCall(DdlBuilder builder2, SqlExtractFunctionInfo functionInfo) {
        if (functionInfo.getCodeInfo().isTableFunction()) {
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)functionInfo.getCodeInfo().getOriginalExpression();
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlQueryExpression.class, (boolean)true) == null) {
                builder2.keyword("select ").symbol("*").keyword(" from ");
            }
            this.generateTableCallExpression(builder2, functionInfo);
        } else {
            this.generateCallExpression(builder2, functionInfo);
        }
    }

    @NotNull
    public final SqlExpression generateCall(@NotNull SqlExtractFunctionInfo functionInfo) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        SqlExtractableCodeInfo codeInfo = functionInfo.getCodeInfo();
        DdlBuilder $this$generateCall_u24lambda_u240 = ddlBuilder = SqlExtractableCodeInfoKt.createBuilder(functionInfo);
        boolean bl = false;
        $this$generateCall_u24lambda_u240.configureBuilder(codeInfo.getProject(), (SqlLanguageDialect)codeInfo.getDialect());
        this.doGenerateCall($this$generateCall_u24lambda_u240, functionInfo);
        DdlBuilder builder2 = ddlBuilder;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(builder2.getStatement(), codeInfo.getDialect(), codeInfo.getProject(), null);
        Intrinsics.checkNotNull((Object)sqlExpression);
        return sqlExpression;
    }

    @NotNull
    public final SqlRoutineDefinition addRoutine(@NotNull SqlRoutineDefinition declaration, @Nullable PsiElement anchor, @NotNull SqlElement block) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        PsiElement psiElement = block.addBefore((PsiElement)declaration, anchor);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlRoutineDefinition");
        SqlRoutineDefinition element = (SqlRoutineDefinition)psiElement;
        Project project = block.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        SqlLanguageDialectEx dialect = SqlPsiUtilKt.getSqlDialect((PsiElement)declaration);
        PsiElement psiElement2 = SqlPsiElementFactory.createLeafFromText(project2, dialect, ";");
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"createLeafFromText(...)");
        PsiElement semi = psiElement2;
        PsiElement psiElement3 = SqlPsiElementFactory.newLine(project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"newLine(...)");
        PsiElement newLine = psiElement3;
        block.addBefore(newLine, (PsiElement)element);
        block.addAfter(newLine, (PsiElement)element);
        block.addAfter(newLine, (PsiElement)element);
        block.addAfter(semi, (PsiElement)element);
        return element;
    }
}

