/*
 * Decompiled with CFR 0.152.
 */
package andel.editor;

import andel.editor.AnchorId;
import andel.editor.AnchorLifetime;
import andel.editor.DocumentComponent;
import andel.editor.DocumentMeta;
import andel.editor.EditListener;
import andel.editor.MutableDocument;
import andel.editor.RangeMarkerId;
import andel.editor.TransientDocument;
import andel.intervals.AnchorStorage;
import andel.intervals.Interval;
import andel.operation.EditLog;
import andel.operation.NewOffsetProvider;
import andel.operation.Operation;
import andel.operation.OperationKt;
import andel.operation.Sticky;
import andel.text.MutableTextView;
import andel.text.Text;
import andel.text.TextRange;
import fleet.util.UID;
import fleet.util.openmap.BoundedOpenMap;
import fleet.util.openmap.MutableBoundedOpenMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0016\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000fJ\u0018\u00104\u001a\u0002022\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\tH\u0016J\u0010\u00108\u001a\u0002022\u0006\u00109\u001a\u00020\u0016H\u0016J \u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020*2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u0002022\u0006\u0010A\u001a\u00020)H\u0016J \u0010B\u001a\u00020.2\u0006\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020*2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010E\u001a\u0002022\u0006\u0010F\u001a\u00020.H\u0016J\u0017\u0010G\u001a\u0004\u0018\u00010*2\u0006\u0010A\u001a\u00020)H\u0016\u00a2\u0006\u0002\u0010HJ\u0012\u0010I\u001a\u0004\u0018\u00010/2\u0006\u0010F\u001a\u00020.H\u0016J:\u0010J\u001a\u0002022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020)0'2\u0006\u0010K\u001a\u00020L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020.0'2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020/0'H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001c0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\u0018\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 j\b\u0012\u0004\u0012\u00020!`#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R#\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(0'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R#\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0(0'8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010,R\u0014\u0010O\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010QR\u0014\u0010R\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0014\u0010U\u001a\u00020V8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010X\u00a8\u0006Y"}, d2={"Landel/editor/TransientDocumentImpl;", "Landel/editor/TransientDocument;", "original", "Landel/editor/MutableDocument;", "<init>", "(Landel/editor/MutableDocument;)V", "getOriginal", "()Landel/editor/MutableDocument;", "intermediateText", "Landel/text/Text;", "documentIntermediateAnchorStorage", "Landel/intervals/AnchorStorage;", "intermediateAnchorStorage", "editListeners", "", "Landel/editor/EditListener;", "anchorIds", "Ljava/util/HashSet;", "Lfleet/util/UID;", "Lkotlin/collections/HashSet;", "rangeMarkerIds", "value", "Landel/operation/Operation;", "accumulatedChanges", "getAccumulatedChanges", "()Landel/operation/Operation;", "components", "Lfleet/util/openmap/BoundedOpenMap;", "Landel/editor/DocumentComponent;", "getComponents", "()Lfleet/util/openmap/BoundedOpenMap;", "meta", "Lfleet/util/openmap/MutableBoundedOpenMap;", "Landel/editor/DocumentMeta;", "", "Lfleet/util/openmap/MutableOpenMap;", "getMeta", "()Lfleet/util/openmap/MutableBoundedOpenMap;", "anchorsForDocument", "", "Lkotlin/Pair;", "Landel/editor/AnchorId;", "", "getAnchorsForDocument", "()Ljava/util/List;", "rangeMarkersForDocument", "Landel/editor/RangeMarkerId;", "Landel/text/TextRange;", "getRangeMarkersForDocument", "addEditListener", "", "listener", "applyOthersChangesAndReset", "newOffsetProvider", "Landel/operation/NewOffsetProvider;", "afterText", "edit", "operation", "createAnchor", "offset", "lifetime", "Landel/editor/AnchorLifetime;", "sticky", "Landel/operation/Sticky;", "removeAnchor", "anchorId", "createRangeMarker", "rangeStart", "rangeEnd", "removeRangeMarker", "markerId", "resolveAnchor", "(Landel/editor/AnchorId;)Ljava/lang/Long;", "resolveRangeMarker", "batchUpdateAnchors", "anchorOffsets", "", "rangeIds", "ranges", "text", "getText", "()Landel/text/Text;", "timestamp", "getTimestamp", "()J", "edits", "Landel/operation/EditLog;", "getEdits", "()Landel/operation/EditLog;", "fleet.andel"})
@SourceDebugExtension(value={"SMAP\nMultiCaretActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiCaretActions.kt\nandel/editor/TransientDocumentImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,380:1\n777#2:381\n873#2,2:382\n1586#2:384\n1661#2,3:385\n777#2:388\n873#2,2:389\n1586#2:391\n1661#2,3:392\n1915#2,2:395\n1915#2,2:398\n1#3:397\n*S KotlinDebug\n*F\n+ 1 MultiCaretActions.kt\nandel/editor/TransientDocumentImpl\n*L\n266#1:381\n266#1:382,2\n266#1:384\n266#1:385,3\n269#1:388\n269#1:389,2\n269#1:391\n269#1:392,3\n281#1:395,2\n294#1:398,2\n*E\n"})
final class TransientDocumentImpl
implements TransientDocument {
    @NotNull
    private final MutableDocument original;
    @NotNull
    private Text intermediateText;
    @NotNull
    private AnchorStorage documentIntermediateAnchorStorage;
    @NotNull
    private AnchorStorage intermediateAnchorStorage;
    @NotNull
    private final List<EditListener> editListeners;
    @NotNull
    private final HashSet<UID> anchorIds;
    @NotNull
    private final HashSet<UID> rangeMarkerIds;
    @NotNull
    private Operation accumulatedChanges;

    public TransientDocumentImpl(@NotNull MutableDocument original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.original = original;
        this.intermediateText = this.original.getText();
        this.documentIntermediateAnchorStorage = AnchorStorage.Companion.empty();
        this.intermediateAnchorStorage = AnchorStorage.Companion.empty();
        this.editListeners = new ArrayList();
        this.anchorIds = new HashSet();
        this.rangeMarkerIds = new HashSet();
        this.accumulatedChanges = Operation.Companion.empty();
    }

    @NotNull
    public final MutableDocument getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    public Operation getAccumulatedChanges() {
        return this.accumulatedChanges;
    }

    @Override
    @NotNull
    public BoundedOpenMap<MutableDocument, DocumentComponent> getComponents() {
        return this.original.getComponents();
    }

    @Override
    @NotNull
    public MutableBoundedOpenMap<DocumentMeta, Object> getMeta() {
        return this.original.getMeta();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<AnchorId, Long>> getAnchorsForDocument() {
        void $this$mapTo$iv$iv;
        Interval it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.documentIntermediateAnchorStorage.getIntervals().asIterable();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Interval)element$iv$iv;
            boolean bl = false;
            if (!this.anchorIds.contains(it.id)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)new AnchorId((UID)it.id), (Object)it.from));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<RangeMarkerId, TextRange>> getRangeMarkersForDocument() {
        void $this$mapTo$iv$iv;
        Interval it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.documentIntermediateAnchorStorage.getIntervals().asIterable();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Interval)element$iv$iv;
            boolean bl = false;
            if (!this.rangeMarkerIds.contains(it.id)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)new RangeMarkerId((UID)it.id), (Object)new TextRange(it.from, it.to)));
        }
        return (List)destination$iv$iv;
    }

    public final void addEditListener(@NotNull EditListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.editListeners.add(listener);
    }

    @Override
    public void applyOthersChangesAndReset(@NotNull NewOffsetProvider newOffsetProvider, @NotNull Text afterText) {
        Intrinsics.checkNotNullParameter((Object)newOffsetProvider, (String)"newOffsetProvider");
        Intrinsics.checkNotNullParameter((Object)afterText, (String)"afterText");
        this.documentIntermediateAnchorStorage = this.documentIntermediateAnchorStorage.edit(newOffsetProvider);
        this.intermediateAnchorStorage = this.intermediateAnchorStorage.edit(newOffsetProvider);
        this.intermediateText = afterText;
        this.accumulatedChanges = Operation.Companion.empty();
        Iterable $this$forEach$iv = this.editListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditListener it = (EditListener)element$iv;
            boolean bl = false;
            it.edit(newOffsetProvider);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void edit(@NotNull Operation operation) {
        void $this$edit_u24lambda_u240;
        MutableTextView mutableTextView;
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        this.accumulatedChanges = OperationKt.compose(this.getAccumulatedChanges(), operation);
        Text before = this.intermediateText;
        MutableTextView mutableTextView2 = mutableTextView = this.intermediateText.mutableView();
        TransientDocumentImpl transientDocumentImpl = this;
        boolean bl = false;
        $this$edit_u24lambda_u240.edit(operation);
        transientDocumentImpl.intermediateText = mutableTextView.text();
        this.documentIntermediateAnchorStorage = this.documentIntermediateAnchorStorage.edit(before, this.intermediateText, operation);
        this.intermediateAnchorStorage = this.intermediateAnchorStorage.edit(before, this.intermediateText, operation);
        Iterable $this$forEach$iv = this.editListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditListener it = (EditListener)element$iv;
            boolean bl2 = false;
            it.edit(operation);
        }
    }

    @Override
    @NotNull
    public AnchorId createAnchor(long offset, @NotNull AnchorLifetime lifetime, @NotNull Sticky sticky) {
        AnchorId anchorId;
        Intrinsics.checkNotNullParameter((Object)((Object)lifetime), (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)sticky), (String)"sticky");
        AnchorId it = anchorId = new AnchorId(UID.Companion.random());
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[lifetime.ordinal()]) {
            case 1: {
                this.intermediateAnchorStorage = this.intermediateAnchorStorage.addAnchor(it, offset, sticky);
                break;
            }
            case 2: {
                this.documentIntermediateAnchorStorage = this.documentIntermediateAnchorStorage.addAnchor(it, offset, sticky);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.anchorIds.add(it.getId());
        return anchorId;
    }

    @Override
    public void removeAnchor(@NotNull AnchorId anchorId) {
        Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
        this.documentIntermediateAnchorStorage = this.documentIntermediateAnchorStorage.removeAnchor(anchorId);
        this.intermediateAnchorStorage = this.intermediateAnchorStorage.removeAnchor(anchorId);
        this.anchorIds.remove(anchorId.getId());
    }

    @Override
    @NotNull
    public RangeMarkerId createRangeMarker(long rangeStart, long rangeEnd, @NotNull AnchorLifetime lifetime) {
        RangeMarkerId rangeMarkerId;
        Intrinsics.checkNotNullParameter((Object)((Object)lifetime), (String)"lifetime");
        RangeMarkerId it = rangeMarkerId = new RangeMarkerId(UID.Companion.random());
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[lifetime.ordinal()]) {
            case 1: {
                this.intermediateAnchorStorage = this.intermediateAnchorStorage.addRangeMarker(it, rangeStart, rangeEnd, false, false);
                break;
            }
            case 2: {
                this.documentIntermediateAnchorStorage = this.documentIntermediateAnchorStorage.addRangeMarker(it, rangeStart, rangeEnd, false, false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.rangeMarkerIds.add(it.getId());
        return rangeMarkerId;
    }

    @Override
    public void removeRangeMarker(@NotNull RangeMarkerId markerId) {
        Intrinsics.checkNotNullParameter((Object)markerId, (String)"markerId");
        this.documentIntermediateAnchorStorage = this.documentIntermediateAnchorStorage.removeRangeMarker(markerId);
        this.rangeMarkerIds.remove(markerId.getId());
    }

    @Override
    @Nullable
    public Long resolveAnchor(@NotNull AnchorId anchorId) {
        Intrinsics.checkNotNullParameter((Object)anchorId, (String)"anchorId");
        Long l = this.intermediateAnchorStorage.resolveAnchor(anchorId);
        if (l == null && (l = this.documentIntermediateAnchorStorage.resolveAnchor(anchorId)) == null) {
            l = this.original.resolveAnchor(anchorId);
        }
        return l;
    }

    @Override
    @Nullable
    public TextRange resolveRangeMarker(@NotNull RangeMarkerId markerId) {
        Intrinsics.checkNotNullParameter((Object)markerId, (String)"markerId");
        TextRange textRange = this.intermediateAnchorStorage.resolveRangeMarker(markerId);
        if (textRange == null && (textRange = this.documentIntermediateAnchorStorage.resolveRangeMarker(markerId)) == null) {
            textRange = this.original.resolveRangeMarker(markerId);
        }
        return textRange;
    }

    @Override
    public void batchUpdateAnchors(@NotNull List<AnchorId> anchorIds, @NotNull long[] anchorOffsets, @NotNull List<RangeMarkerId> rangeIds, @NotNull List<TextRange> ranges) {
        Intrinsics.checkNotNullParameter(anchorIds, (String)"anchorIds");
        Intrinsics.checkNotNullParameter((Object)anchorOffsets, (String)"anchorOffsets");
        Intrinsics.checkNotNullParameter(rangeIds, (String)"rangeIds");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        throw new IllegalStateException(("transient document " + this.original + " shouldn't be original of another transient document " + this).toString());
    }

    @Override
    @NotNull
    public Text getText() {
        return this.intermediateText;
    }

    @Override
    public long getTimestamp() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public EditLog getEdits() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnchorLifetime.values().length];
            try {
                nArray[AnchorLifetime.MUTATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnchorLifetime.DOCUMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

