/*
 * Decompiled with CFR 0.152.
 */
package andel.tokens;

import andel.operation.Op;
import andel.operation.Operation;
import andel.text.IntersectionType;
import andel.text.TextRange;
import andel.text.TextRangeKt;
import andel.tokens.MutableTokensView;
import andel.tokens.Token2;
import andel.tokens.Tokens;
import andel.tokens.TokensKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001aA\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\b\u001a1\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u000b\u001a3\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a&\u0010\u0012\u001a\u00020\r\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004\u001aC\u0010\u0013\u001a\u00020\r\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0007\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"adjust", "Landel/tokens/Tokens;", "T", "offset", "", "delete", "insert", "emptyType", "(Landel/tokens/Tokens;IIILjava/lang/Object;)Landel/tokens/Tokens;", "operation", "Landel/operation/Operation;", "(Landel/tokens/Tokens;Landel/operation/Operation;Ljava/lang/Object;)Landel/tokens/Tokens;", "extendAtOffset", "", "Landel/tokens/MutableTokensView;", "length", "emptyTokenType", "(Landel/tokens/MutableTokensView;IILjava/lang/Object;)V", "shrinkAtOffset", "bulkAdjust", "lexemeStores", "", "textRanges", "", "Landel/text/TextRange;", "edit", "(Ljava/util/List;Ljava/util/List;Landel/operation/Operation;Ljava/lang/Object;)V", "fleet.andel"})
public final class AdjustKt {
    @NotNull
    public static final <T> Tokens<T> adjust(@NotNull Tokens<T> $this$adjust, int offset, int delete, int insert, T emptyType) {
        Intrinsics.checkNotNullParameter($this$adjust, (String)"<this>");
        MutableTokensView<T> mut = $this$adjust.mutable();
        if (delete > 0) {
            AdjustKt.shrinkAtOffset(mut, offset, delete);
        }
        if (insert > 0) {
            AdjustKt.extendAtOffset(mut, offset, insert, emptyType);
        }
        return mut.tokens();
    }

    @NotNull
    public static final <T> Tokens<T> adjust(@NotNull Tokens<T> $this$adjust, @NotNull Operation operation, T emptyType) {
        Intrinsics.checkNotNullParameter($this$adjust, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        int charOffset = 0;
        MutableTokensView<T> mut = $this$adjust.mutable();
        for (Op op : operation.getOps()) {
            Op op2 = op;
            if (op2 instanceof Op.Retain) {
                charOffset += (int)((Op.Retain)op).getLen();
                continue;
            }
            if (op2 instanceof Op.Replace) {
                if (((Op.Replace)op).getDelete().length() > 0) {
                    AdjustKt.shrinkAtOffset(mut, charOffset, ((Op.Replace)op).getDelete().length());
                }
                if (((Op.Replace)op).getInsert().length() > 0) {
                    AdjustKt.extendAtOffset(mut, charOffset, ((Op.Replace)op).getInsert().length(), emptyType);
                }
                charOffset += ((Op.Replace)op).getInsert().length();
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return mut.tokens();
    }

    public static final <T> void extendAtOffset(@NotNull MutableTokensView<T> $this$extendAtOffset, int offset, int length, T emptyTokenType) {
        Intrinsics.checkNotNullParameter($this$extendAtOffset, (String)"<this>");
        if ($this$extendAtOffset.getTokenCount() == 0) {
            $this$extendAtOffset.replaceTokens-v6D073k(TokensKt.getTokenIndex(0), TokensKt.getTokenIndex(0), CollectionsKt.listOf(new Token2<T>(length, emptyTokenType, true, true)));
        } else {
            int tokenIndexAtOffset = $this$extendAtOffset.tokenIndexAtOffset-Wbv35VY(offset);
            int oldCharCount = $this$extendAtOffset.getCharCount();
            $this$extendAtOffset.replaceTokens-v6D073k(tokenIndexAtOffset, TokensKt.getTokenIndex(tokenIndexAtOffset + 1), CollectionsKt.listOf(new Token2($this$extendAtOffset.tokenEnd-tVNiw6U(tokenIndexAtOffset) - $this$extendAtOffset.tokenStart-tVNiw6U(tokenIndexAtOffset) + length, $this$extendAtOffset.tokenType-tVNiw6U(tokenIndexAtOffset), true, $this$extendAtOffset.isRestartable-tVNiw6U(tokenIndexAtOffset))));
            if (!($this$extendAtOffset.getCharCount() == oldCharCount + length)) {
                boolean bl = false;
                String string2 = "extend failed, expected charCount = " + oldCharCount + " + " + length + ", actual = " + $this$extendAtOffset.getCharCount();
                throw new IllegalArgumentException(string2.toString());
            }
        }
    }

    public static final <T> void shrinkAtOffset(@NotNull MutableTokensView<T> $this$shrinkAtOffset, int offset, int length) {
        Intrinsics.checkNotNullParameter($this$shrinkAtOffset, (String)"<this>");
        int tokenIndexAtOffset = $this$shrinkAtOffset.tokenIndexAtOffset-Wbv35VY(offset);
        List replacements = new ArrayList();
        int tokenIndex = tokenIndexAtOffset;
        int cutStart = offset;
        int remainingLength = length;
        while (0 < remainingLength) {
            int tokenStart = $this$shrinkAtOffset.tokenStart-tVNiw6U(TokensKt.getTokenIndex(tokenIndex));
            int tokenEnd = $this$shrinkAtOffset.tokenEnd-tVNiw6U(TokensKt.getTokenIndex(tokenIndex));
            Object tokenType = $this$shrinkAtOffset.tokenType-tVNiw6U(TokensKt.getTokenIndex(tokenIndex));
            boolean restartable = $this$shrinkAtOffset.isRestartable-tVNiw6U(TokensKt.getTokenIndex(tokenIndex));
            int cut = Math.min(tokenEnd - cutStart, remainingLength);
            int oldLen = tokenEnd - tokenStart;
            replacements.add(new Token2(oldLen - cut, tokenType, true, restartable));
            remainingLength -= cut;
            cutStart = tokenEnd;
            ++tokenIndex;
        }
        int oldCharCount = $this$shrinkAtOffset.getCharCount();
        $this$shrinkAtOffset.replaceTokens-v6D073k(tokenIndexAtOffset, TokensKt.getTokenIndex(tokenIndex), replacements);
        if (!($this$shrinkAtOffset.getCharCount() == oldCharCount - length)) {
            boolean bl = false;
            String string2 = "shrink failed, expected charCount = " + oldCharCount + " - " + length + ", actual = " + $this$shrinkAtOffset.getCharCount();
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public static final <T> void bulkAdjust(@NotNull List<Tokens<T>> lexemeStores, @NotNull List<TextRange> textRanges, @NotNull Operation edit, T emptyType) {
        Intrinsics.checkNotNullParameter(lexemeStores, (String)"lexemeStores");
        Intrinsics.checkNotNullParameter(textRanges, (String)"textRanges");
        Intrinsics.checkNotNullParameter((Object)edit, (String)"edit");
        int lexemeStoreIndex = 0;
        Iterator opIter = edit.getOps().iterator();
        Op op = opIter.hasNext() ? (Op)opIter.next() : null;
        long oldCharOffset = 0L;
        int relativeCharOffset = -1;
        block11: while (lexemeStoreIndex < lexemeStores.size() && op != null) {
            TextRange lexemeTextRange = textRanges.get(lexemeStoreIndex);
            long start = lexemeTextRange.component1();
            long end = lexemeTextRange.component2();
            long oldCharOffsetEnd = oldCharOffset + op.getLenBefore();
            Pair<TextRange, IntersectionType> pair = TextRangeKt.intersect(new TextRange(oldCharOffset, oldCharOffsetEnd), lexemeTextRange);
            TextRange intersection = (TextRange)pair.component1();
            IntersectionType intersectionType = (IntersectionType)((Object)pair.component2());
            Op op2 = op;
            if (op2 instanceof Op.Retain) {
                if (intersectionType == IntersectionType.After || intersectionType == IntersectionType.Outside) {
                    ++lexemeStoreIndex;
                    relativeCharOffset = -1;
                    continue;
                }
                oldCharOffset += (long)((int)((Op.Retain)op).getLen());
                if (relativeCharOffset != -1) {
                    relativeCharOffset += (int)((Op.Retain)op).getLen();
                }
                op = opIter.hasNext() ? (Op)opIter.next() : null;
                continue;
            }
            if (op2 instanceof Op.Replace) {
                if (relativeCharOffset == -1) {
                    relativeCharOffset = switch (WhenMappings.$EnumSwitchMapping$0[intersectionType.ordinal()]) {
                        case 1, 2 -> (int)(oldCharOffset - start);
                        case 3, 4 -> 0;
                        default -> -1;
                    };
                }
                switch (WhenMappings.$EnumSwitchMapping$0[intersectionType.ordinal()]) {
                    case 1: {
                        lexemeStores.set(lexemeStoreIndex, AdjustKt.adjust(lexemeStores.get(lexemeStoreIndex), relativeCharOffset, (int)intersection.getLength(), ((Op.Replace)op).getInsert().length(), emptyType));
                        relativeCharOffset += ((Op.Replace)op).getInsert().length();
                        oldCharOffset += (long)((Op.Replace)op).getDelete().length();
                        op = opIter.hasNext() ? (Op)opIter.next() : null;
                        continue block11;
                    }
                    case 3: {
                        lexemeStores.set(lexemeStoreIndex, AdjustKt.adjust(lexemeStores.get(lexemeStoreIndex), relativeCharOffset, (int)intersection.getLength(), 0, emptyType));
                        oldCharOffset += (long)((Op.Replace)op).getDelete().length();
                        op = opIter.hasNext() ? (Op)opIter.next() : null;
                        continue block11;
                    }
                    case 2: {
                        lexemeStores.set(lexemeStoreIndex, AdjustKt.adjust(lexemeStores.get(lexemeStoreIndex), relativeCharOffset, (int)intersection.getLength(), ((Op.Replace)op).getInsert().length(), emptyType));
                        ++lexemeStoreIndex;
                        relativeCharOffset = -1;
                        continue block11;
                    }
                    case 4: {
                        lexemeStores.set(lexemeStoreIndex, AdjustKt.adjust(lexemeStores.get(lexemeStoreIndex), relativeCharOffset, (int)intersection.getLength(), 0, emptyType));
                        ++lexemeStoreIndex;
                        relativeCharOffset = -1;
                        continue block11;
                    }
                    case 5: {
                        if (oldCharOffset > end) {
                            ++lexemeStoreIndex;
                            relativeCharOffset = -1;
                            continue block11;
                        }
                        oldCharOffset += (long)((Op.Replace)op).getDelete().length();
                        op = opIter.hasNext() ? (Op)opIter.next() : null;
                        continue block11;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IntersectionType.values().length];
            try {
                nArray[IntersectionType.Inside.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntersectionType.After.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntersectionType.Before.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntersectionType.Outside.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntersectionType.None.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

