/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.ints;

import fleet.fastutil.Arrays;
import fleet.fastutil.ints.IntArrays;
import fleet.fastutil.ints.IntList;
import fleet.fastutil.ints.IntListExtensionsKt;
import fleet.fastutil.ints.MutableIntList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 <2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001<B\u0019\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\rB\t\b\u0016\u00a2\u0006\u0004\b\b\u0010\u000eB\u0017\b\u0016\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010\u00a2\u0006\u0004\b\b\u0010\u0011B\u0011\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\u0013B\u0011\b\u0016\u0012\u0006\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\u0015J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000bJ\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u000bH\u0016J\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0019\u0010$\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0096\u0002J\b\u0010%\u001a\u00020\u001bH\u0016J\u0011\u0010&\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0096\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0016J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0010\u0010)\u001a\u00020\u001b2\b\b\u0002\u0010*\u001a\u00020\u000bJ\b\u0010+\u001a\u00020\u001bH\u0016J(\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J&\u0010.\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0018\u00100\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0016J(\u00102\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0014\u00103\u001a\u00020\u00072\b\u00104\u001a\u0004\u0018\u000105H\u0096\u0082\u0004J\u0012\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u0003H\u0096\u0082\u0004J\n\u00108\u001a\u00020\u000bH\u0096\u0080\u0004J\u0006\u00109\u001a\u00020\u0000J\n\u0010:\u001a\u00020;H\u0096\u0080\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u0015\u00a8\u0006="}, d2={"Lfleet/fastutil/ints/IntArrayList;", "Lfleet/fastutil/ints/MutableIntList;", "", "Lfleet/fastutil/ints/IntList;", "a", "", "wrapped", "", "<init>", "([IZ)V", "offset", "", "length", "([III)V", "()V", "i", "", "(Ljava/util/Iterator;)V", "list", "(Lfleet/fastutil/ints/IntList;)V", "capacity", "(I)V", "size", "getSize", "()I", "setSize", "initArrayFromCapacity", "", "backingArray", "ensureCapacity", "grow", "add", "index", "element", "addAll", "elements", "set", "clear", "get", "removeAt", "resize", "trim", "n", "sort", "toArray", "from", "getElements", "targetList", "removeElements", "to", "addElements", "equals", "o", "", "compareTo", "l", "hashCode", "clone", "toString", "", "Companion", "fleet.fastutil"})
public final class IntArrayList
implements MutableIntList,
Comparable<IntList> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int[] a;
    private int size;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    private IntArrayList(int[] a, boolean wrapped) {
        this.a = a;
    }

    public IntArrayList(@NotNull int[] a, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        this(length);
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        ArraysKt.copyInto((int[])a, (int[])nArray, (int)0, (int)offset, (int)(offset + length));
        this.setSize(length);
    }

    public /* synthetic */ IntArrayList(int[] nArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = nArray.length;
        }
        this(nArray, n, n2);
    }

    private final void initArrayFromCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0 ? new int[]{} : new int[capacity];
    }

    public IntArrayList() {
        this.a = IntArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY();
    }

    public IntArrayList(@NotNull Iterator<Integer> i) {
        Intrinsics.checkNotNullParameter(i, (String)"i");
        this();
        while (i.hasNext()) {
            this.add(((Number)i.next()).intValue());
        }
    }

    public IntArrayList(@NotNull IntList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this();
        IntRange intRange = IntListExtensionsKt.getIndices(list);
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            while (true) {
                this.add(list.get(i));
                if (i == n) break;
                ++i;
            }
        }
    }

    public IntArrayList(int capacity) {
        this.initArrayFromCapacity(capacity);
    }

    @NotNull
    public final int[] backingArray() {
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        return nArray;
    }

    public final void ensureCapacity(int capacity) {
        block9: {
            block8: {
                int[] nArray;
                int[] nArray2 = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                    nArray2 = null;
                }
                if (capacity <= nArray2.length) break block8;
                int[] nArray3 = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                    nArray3 = null;
                }
                if (!java.util.Arrays.equals(nArray = nArray3, IntArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY()) || capacity > 10) break block9;
            }
            return;
        }
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        this.a = IntArrays.INSTANCE.ensureCapacity(nArray, capacity, this.getSize());
        int n = this.getSize();
        int[] nArray4 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray4 = null;
        }
        if (!(n <= nArray4.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private final void grow(int capacity) {
        int[] nArray;
        int capacity2 = capacity;
        int[] nArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray2 = null;
        }
        if (capacity2 <= nArray2.length) {
            return;
        }
        int[] nArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray3 = null;
        }
        if (!java.util.Arrays.equals(nArray = nArray3, IntArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY())) {
            int[] nArray4 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                nArray4 = null;
            }
            int n = nArray4.length;
            int[] nArray5 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                nArray5 = null;
            }
            int n2 = n + (nArray5.length >> 1);
            int n3 = 0x7FFFFFF7;
            capacity2 = Math.max(Math.min(n2, n3), capacity2);
        } else if (capacity2 < 10) {
            capacity2 = 10;
        }
        int[] nArray6 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray6 = null;
        }
        this.a = IntArrays.INSTANCE.forceCapacity(nArray6, capacity2, this.getSize());
        int n = this.getSize();
        int[] nArray7 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray7 = null;
        }
        if (!(n <= nArray7.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public void add(int index, int element) {
        IntListExtensionsKt.ensureIndex(this, index);
        this.grow(this.getSize() + 1);
        if (index != this.getSize()) {
            int[] nArray = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                nArray = null;
            }
            int[] nArray2 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                nArray2 = null;
            }
            ArraysKt.copyInto((int[])nArray, (int[])nArray2, (int)(index + 1), (int)index, (int)this.getSize());
        }
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        nArray[index] = element;
        int n = this.getSize();
        this.setSize(n + 1);
        int n2 = this.getSize();
        int[] nArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray3 = null;
        }
        if (!(n2 <= nArray3.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public void add(int element) {
        this.grow(this.getSize() + 1);
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        int n = this.getSize();
        this.setSize(n + 1);
        nArray[n] = element;
        int n2 = this.getSize();
        int[] nArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray2 = null;
        }
        if (!(n2 <= nArray2.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public boolean addAll(int index, @NotNull IntList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        IntListExtensionsKt.ensureIndex(this, index);
        int index2 = index;
        int n = elements.getSize();
        if (n == 0) {
            return false;
        }
        this.grow(this.getSize() + n);
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        int[] nArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray2 = null;
        }
        ArraysKt.copyInto((int[])nArray, (int[])nArray2, (int)(index2 + n), (int)index2, (int)(index2 + (this.getSize() - index2)));
        int i = IntListExtensionsKt.getIndices(elements).getFirst();
        this.setSize(this.getSize() + n);
        while (n-- != 0) {
            int[] nArray3 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                nArray3 = null;
            }
            nArray3[index2++] = elements.get(i++);
        }
        int n2 = this.getSize();
        int[] nArray4 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray4 = null;
        }
        if (!(n2 <= nArray4.length)) {
            throw new IllegalStateException("Check failed.");
        }
        return true;
    }

    @Override
    public int set(int index, int element) {
        if (index >= this.getSize() || index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is out of bounds for size (" + this.getSize() + ")");
        }
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        int old = nArray[index];
        int[] nArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray2 = null;
        }
        nArray2[index] = element;
        return old;
    }

    @Override
    public void clear() {
        this.setSize(0);
        int n = this.getSize();
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        if (!(n <= nArray.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public int get(int index) {
        if (index >= this.getSize() || index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.getSize());
        }
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        return nArray[index];
    }

    @Override
    public int removeAt(int index) {
        if (index >= this.getSize() || index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") out of bounds for length (" + this.getSize() + ")");
        }
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        int[] a = nArray;
        int old = a[index];
        this.setSize(this.getSize() - 1);
        if (index != this.getSize()) {
            ArraysKt.copyInto((int[])a, (int[])a, (int)index, (int)(index + 1), (int)(this.getSize() + 1));
        }
        if (!(this.getSize() <= a.length)) {
            throw new IllegalStateException("Check failed.");
        }
        return old;
    }

    @Override
    public void resize(int size) {
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        if (size > nArray.length) {
            int[] nArray2 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                nArray2 = null;
            }
            this.a = IntArrays.INSTANCE.forceCapacity(nArray2, size, this.getSize());
        }
        if (size > this.getSize()) {
            int[] nArray3 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                nArray3 = null;
            }
            ArraysKt.fill((int[])nArray3, (int)0, (int)this.getSize(), (int)size);
        }
        this.setSize(size);
    }

    public final void trim(int n) {
        block9: {
            block8: {
                int[] nArray = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                    nArray = null;
                }
                if (n >= nArray.length) break block8;
                int n2 = this.getSize();
                int[] nArray2 = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                    nArray2 = null;
                }
                if (n2 != nArray2.length) break block9;
            }
            return;
        }
        int[] t = new int[Math.max(n, this.getSize())];
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        ArraysKt.copyInto((int[])nArray, (int[])t, (int)0, (int)0, (int)this.getSize());
        this.a = t;
        int n3 = this.getSize();
        int[] nArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray3 = null;
        }
        if (!(n3 <= nArray3.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public static /* synthetic */ void trim$default(IntArrayList intArrayList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        intArrayList.trim(n);
    }

    @Override
    public void sort() {
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        ArraysKt.sort((int[])nArray, (int)0, (int)this.getSize());
    }

    @Override
    @NotNull
    public int[] toArray(int from, @NotNull int[] a, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        IntListExtensionsKt.ensureIndex(this, from);
        Arrays.INSTANCE.ensureOffsetLength(a, offset, length);
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        ArraysKt.copyInto((int[])nArray, (int[])a, (int)offset, (int)from, (int)(from + length));
        return a;
    }

    public final void getElements(int from, @NotNull IntArrayList targetList, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)targetList, (String)"targetList");
        IntListExtensionsKt.ensureIndex(this, from);
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        Arrays.INSTANCE.ensureOffsetLength(nArray, offset, length);
        int[] nArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray2 = null;
        }
        int[] nArray3 = targetList.a;
        if (targetList.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray3 = null;
        }
        ArraysKt.copyInto((int[])nArray2, (int[])nArray3, (int)offset, (int)from, (int)(from + length));
    }

    @Override
    public void removeElements(int from, int to) {
        Arrays.INSTANCE.ensureFromTo(this.getSize(), from, to);
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        int[] nArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray2 = null;
        }
        ArraysKt.copyInto((int[])nArray, (int[])nArray2, (int)from, (int)to, (int)this.getSize());
        this.setSize(this.getSize() - (to - from));
    }

    @Override
    public void addElements(int index, @NotNull int[] a, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        IntListExtensionsKt.ensureIndex(this, index);
        Arrays.INSTANCE.ensureOffsetLength(a, offset, length);
        this.grow(this.getSize() + length);
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        int[] nArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray2 = null;
        }
        ArraysKt.copyInto((int[])nArray, (int[])nArray2, (int)(index + length), (int)index, (int)(index + (this.getSize() - index)));
        int[] nArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray3 = null;
        }
        ArraysKt.copyInto((int[])a, (int[])nArray3, (int)index, (int)offset, (int)(offset + length));
        this.setSize(this.getSize() + length);
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof IntList && this.compareTo((IntList)o) == 0;
    }

    @Override
    public int compareTo(@NotNull IntList l) {
        int i;
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        int s1 = IntListExtensionsKt.length(this);
        int s2 = IntListExtensionsKt.length(l);
        int e1 = 0;
        int e2 = 0;
        int r = 0;
        for (i = 0; i < s1 && i < s2; ++i) {
            e1 = this.get(i);
            e2 = l.get(i);
            int n = e1 > e2 ? 1 : (r = e1 < e2 ? -1 : 0);
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    public int hashCode() {
        int i = IntListExtensionsKt.getIndices(this).getFirst();
        int h = 1;
        int s = this.getSize();
        while (s-- != 0) {
            int k = this.get(i++);
            h = 31 * h + k;
        }
        return h;
    }

    @NotNull
    public final IntArrayList clone() {
        IntArrayList clone = new IntArrayList();
        clone.setSize(this.getSize());
        int[] nArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            nArray = null;
        }
        int[] nArray2 = nArray;
        int[] nArray3 = java.util.Arrays.copyOf(nArray2, nArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"copyOf(...)");
        clone.a = nArray3;
        return clone;
    }

    @NotNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        int i = IntListExtensionsKt.getIndices(this).getFirst();
        int n = this.getSize();
        int k = 0;
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            k = this.get(i);
            ++i;
            s.append(String.valueOf(k));
        }
        s.append("]");
        String string = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public /* synthetic */ IntArrayList(int[] a, boolean wrapped, DefaultConstructorMarker $constructor_marker) {
        this(a, wrapped);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0007J\u0012\u0010\u000b\u001a\u00020\u00072\n\u0010\f\u001a\u00020\t\"\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lfleet/fastutil/ints/IntArrayList$Companion;", "", "<init>", "()V", "DEFAULT_INITIAL_CAPACITY", "", "wrap", "Lfleet/fastutil/ints/IntArrayList;", "a", "", "length", "of", "init", "fleet.fastutil"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntArrayList wrap(@NotNull int[] a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return this.wrap(a, a.length);
        }

        @NotNull
        public final IntArrayList wrap(@NotNull int[] a, int length) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (length > a.length) {
                throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
            }
            IntArrayList l = new IntArrayList(a, true, null);
            l.setSize(length);
            return l;
        }

        @NotNull
        public final IntArrayList of() {
            return new IntArrayList();
        }

        @NotNull
        public final IntArrayList of(int ... init) {
            Intrinsics.checkNotNullParameter((Object)init, (String)"init");
            return this.wrap(init);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

