/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb;

import com.jetbrains.rhizomedb.APIKt;
import com.jetbrains.rhizomedb.Attribute;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.ChangeScopeKt;
import com.jetbrains.rhizomedb.DBUtilKt;
import com.jetbrains.rhizomedb.Datom;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityKt;
import com.jetbrains.rhizomedb.IndexQuery;
import com.jetbrains.rhizomedb.Instruction;
import com.jetbrains.rhizomedb.InstructionEffect;
import com.jetbrains.rhizomedb.InstructionExpansion;
import com.jetbrains.rhizomedb.Mut;
import com.jetbrains.rhizomedb.Op;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.RetractableEntity;
import com.jetbrains.rhizomedb.Schema;
import fleet.fastutil.ints.IntArrayList;
import fleet.fastutil.ints.IntList;
import fleet.fastutil.ints.IntListExtensionsKt;
import fleet.fastutil.ints.IntOpenHashSet;
import fleet.fastutil.ints.IntSet;
import fleet.fastutil.ints.IntSetExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\r\u0010\u0011\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J!\u0010\u0013\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rhizomedb/RetractEntityInPartition;", "Lcom/jetbrains/rhizomedb/Instruction;", "eid", "", "Lcom/jetbrains/rhizomedb/EID;", "seed", "", "<init>", "(IJ)V", "getEid", "()I", "getSeed", "()J", "expand", "Lcom/jetbrains/rhizomedb/InstructionExpansion;", "Lcom/jetbrains/rhizomedb/DbContext;", "Lcom/jetbrains/rhizomedb/Q;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "fleet.rhizomedb"})
@SourceDebugExtension(value={"SMAP\nInstructions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instructions.kt\ncom/jetbrains/rhizomedb/RetractEntityInPartition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1869#2,2:168\n1869#2,2:170\n*S KotlinDebug\n*F\n+ 1 Instructions.kt\ncom/jetbrains/rhizomedb/RetractEntityInPartition\n*L\n134#1:168,2\n143#1:170,2\n*E\n"})
public final class RetractEntityInPartition
implements Instruction {
    private final int eid;
    private final long seed;

    public RetractEntityInPartition(int eid, long seed) {
        this.eid = eid;
        this.seed = seed;
    }

    public final int getEid() {
        return this.eid;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    @NotNull
    public InstructionExpansion expand(@NotNull DbContext<? extends Q> $this$expand) {
        Intrinsics.checkNotNullParameter($this$expand, (String)"<this>");
        ArrayList<Op.Retract> res = new ArrayList<Op.Retract>();
        IntOpenHashSet retractedEntities = new IntOpenHashSet(0, 0.0f, 3, null);
        IntArrayList entitiesToRetract = new IntArrayList();
        entitiesToRetract.add(this.eid);
        while (IntListExtensionsKt.isNotEmpty((IntList)((IntList)entitiesToRetract))) {
            Datom datom;
            int nextEID = entitiesToRetract.removeAt(entitiesToRetract.getSize() - 1);
            if (!retractedEntities.add(nextEID)) continue;
            Iterable $this$forEach$iv = (Iterable)DBUtilKt.queryIndex($this$expand, new IndexQuery.Entity(nextEID));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                datom = (Datom)element$iv;
                boolean bl = false;
                if (Schema.getCascadeDelete-impl(Attribute.getSchema-HLBllEs(datom.getAttr-dkwPBow()))) {
                    Object object = datom.getValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                    int value = (Integer)object;
                    if (APIKt.partition(value) == APIKt.partition(this.eid)) {
                        entitiesToRetract.add(value);
                    }
                }
                res.add(new Op.Retract(datom.getEid(), datom.getAttr-dkwPBow(), datom.getValue(), null));
            }
            $this$forEach$iv = (Iterable)DBUtilKt.queryIndex($this$expand, new IndexQuery.RefsTo(nextEID, null, 2, null));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                datom = (Datom)element$iv;
                boolean bl = false;
                if ((Schema.getCascadeDeleteBy-impl(Attribute.getSchema-HLBllEs(datom.getAttr-dkwPBow())) || Schema.getRequired-impl(Attribute.getSchema-HLBllEs(datom.getAttr-dkwPBow()))) && APIKt.partition(datom.getEid()) == APIKt.partition(this.eid)) {
                    entitiesToRetract.add(datom.getEid());
                }
                res.add(new Op.Retract(datom.getEid(), datom.getAttr-dkwPBow(), datom.getValue(), null));
            }
        }
        return new InstructionExpansion((List<? extends Op>)res, IntSetExtensionsKt.mapNotNull((IntSet)((IntSet)retractedEntities), (Function1)((Function1)new Function1<Integer, InstructionEffect>(this){
            final /* synthetic */ RetractEntityInPartition this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final InstructionEffect invoke(int it) {
                InstructionEffect instructionEffect;
                Entity entity = EntityKt.entity(it);
                Object object = entity instanceof RetractableEntity ? (RetractableEntity)entity : null;
                if (object != null && (object = object.onRetract()) != null) {
                    Object object2 = object;
                    RetractEntityInPartition retractEntityInPartition = this.this$0;
                    Object cb = object2;
                    boolean bl = false;
                    instructionEffect = new InstructionEffect(retractEntityInPartition, (Function1<? super DbContext<? extends Mut>, Unit>)((Function1)new Function1<DbContext<? extends Mut>, Unit>((RetractableEntity.Callback)cb){
                        final /* synthetic */ RetractableEntity.Callback $cb;
                        {
                            this.$cb = $cb;
                            super(1);
                        }

                        public final void invoke(DbContext<? extends Mut> $this$InstructionEffect) {
                            Intrinsics.checkNotNullParameter($this$InstructionEffect, (String)"$this$InstructionEffect");
                            RetractableEntity.Callback $this$invoke_u24lambda_u240 = this.$cb;
                            boolean bl = false;
                            ChangeScopeKt.withChangeScope($this$InstructionEffect, (Function1)new Function1<ChangeScope, Unit>($this$invoke_u24lambda_u240){
                                final /* synthetic */ RetractableEntity.Callback $this_with;
                                {
                                    this.$this_with = $receiver;
                                    super(1);
                                }

                                public final void invoke(ChangeScope $this$withChangeScope) {
                                    Intrinsics.checkNotNullParameter((Object)$this$withChangeScope, (String)"$this$withChangeScope");
                                    this.$this_with.afterRetract($this$withChangeScope);
                                }
                            });
                        }
                    }));
                } else {
                    instructionEffect = null;
                }
                return instructionEffect;
            }
        })));
    }

    public final int component1() {
        return this.eid;
    }

    public final long component2() {
        return this.seed;
    }

    @NotNull
    public final RetractEntityInPartition copy(int eid, long seed) {
        return new RetractEntityInPartition(eid, seed);
    }

    public static /* synthetic */ RetractEntityInPartition copy$default(RetractEntityInPartition retractEntityInPartition, int n, long l, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = retractEntityInPartition.eid;
        }
        if ((n2 & 2) != 0) {
            l = retractEntityInPartition.seed;
        }
        return retractEntityInPartition.copy(n, l);
    }

    @NotNull
    public String toString() {
        return "RetractEntityInPartition(eid=" + this.eid + ", seed=" + this.seed + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.eid);
        result2 = result2 * 31 + Long.hashCode(this.seed);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RetractEntityInPartition)) {
            return false;
        }
        RetractEntityInPartition retractEntityInPartition = (RetractEntityInPartition)other;
        if (this.eid != retractEntityInPartition.eid) {
            return false;
        }
        return this.seed == retractEntityInPartition.seed;
    }
}

