package fleet.codepoints.generated

/**
 * Auto-generated Unicode character property data facade.
 * Unicode version: 16.0.0
 *
 * Generated by https://github.com/zolotov/kodepoint
 */
internal object CharacterData {
    const val CASE_DELTA_MASK = 0x3FF
    const val DELTA_TO_LOWERCASE_BIT = 1 shl 10
    const val CATEGORY_MASK = 0x1F shl 11
    const val CATEGORY_SHIFT = 11
    const val IS_OTHER_UPPERCASE_BIT = 1 shl 16
    const val IS_OTHER_LOWERCASE_BIT = 1 shl 17
    const val IS_WHITESPACE_BIT = 1 shl 18
    const val IS_IDEOGRAPHIC_BIT = 1 shl 19
    const val IS_UNICODE_ID_START_BIT = 1 shl 20
    const val IS_UNICODE_ID_PART_BIT = 1 shl 21
    const val IS_JAVA_ID_START_BIT = 1 shl 22
    const val IS_JAVA_ID_PART_BIT = 1 shl 23
    const val HAS_LARGE_LOWERCASE_DELTA_BIT = 1 shl 24
    const val HAS_LARGE_UPPERCASE_DELTA_BIT = 1 shl 25

    const val CAT_LU = 1
    const val CAT_LL = 2
    const val CAT_LT = 3
    const val CAT_LM = 4
    const val CAT_LO = 5
    const val CAT_ND = 9
    const val CAT_ZS = 23
    const val CAT_ZL = 24
    const val CAT_ZP = 25
    const val CAT_CC = 26
    const val CAT_CF = 27

    val UNIQUE_PROPERTY_VALUES = intArrayOf(
        0x0, 0x4000, 0x5800, 0x6800, 0x7000, 0x7800, 0x8000, 0x8800, 0x9000, 0x9800, 0xA800, 0xB000, 0xD000, 0xE000, 0xE800, 0x1B000, 0x1B41A, 0x2B3E6, 0x4B800, 0x4C000, 0x4C800, 0x4D000, 0x205800, 0x209000, 0x309800, 0x30A800, 0x30B000, 0x80D000, 0x80D800, 0x84D000, 0xA03000, 0xA03800, 0xA04800, 0xA0D800, 0xA23054, 0xA83000, 0xB03000, 0xC02000, 0xC0A000, 0xE06000, 0xF00800, 0xF00C01, 0xF00C02, 0xF00C08, 0xF00C0F, 0xF00C1C, 0xF00C20, 0xF00C22, 0xF00C25, 0xF00C26, 0xF00C27, 0xF00C28, 0xF00C30, 0xF00C3F, 0xF00C40, 0xF00C45, 0xF00C47, 0xF00C4F, 0xF00C50, 0xF00C74, 0xF00CCA, 0xF00CCB, 0xF00CCD, 0xF00CCE, 0xF00CCF, 0xF00CD1, 0xF00CD2, 0xF00CD3, 0xF00CD5, 0xF00CD6, 0xF00CD9, 0xF00CDA, 0xF00CDB, 0xF00F39, 0xF00F3D, 0xF00F5D, 0xF00F7E, 0xF00F80, 0xF00F82, 0xF00F87, 0xF00F90, 0xF00F9C, 0xF00F9F, 0xF00FAA, 0xF00FB6, 0xF00FC4, 0xF00FC8, 0xF00FD0, 0xF00FF8, 0xF00FF9, 0xF01000, 0xF01007, 0xF01008, 0xF01009, 0xF01030, 0xF01038, 0xF0104A, 0xF01056, 0xF01061, 0xF01064, 0xF01070, 0xF01079, 0xF0107E, 0xF01080, 0xF01082, 0xF010A3, 0xF010C3, 0xF012D4, 0xF01318, 0xF01325, 0xF01326, 0xF01327, 0xF0132A, 0xF0132B, 0xF0132D, 0xF0132E, 0xF0132F, 0xF01331, 0xF01332, 0xF01333, 0xF01335, 0xF01336, 0xF0138C, 0xF013A0, 0xF013AA, 0xF013B0, 0xF013B1, 0xF013B9, 0xF013BB, 0xF013C0, 0xF013C1, 0xF013C2, 0xF013C5, 0xF013C7, 0xF013CA, 0xF013D0, 0xF013D1, 0xF013D8, 0xF013D9, 0xF013DA, 0xF013DB, 0xF013DE, 0xF013E0, 0xF013E1, 0xF013E4, 0xF013F1, 0xF013F8, 0xF013FE, 0xF013FF, 0xF01C01, 0xF01FF7, 0xF01FF8, 0xF02000, 0xF02800, 0xF05000, 0xF15410, 0xF22000, 0xF22800, 0xF253F0, 0xF82800, 0xF85000, 0x1F00800, 0x2F01000
    )

    val largeLowercaseRanges = intArrayOf(
        0x23A, 0x23A, 10795, 0x23E, 0x23E, 10792, 0x10A0, 0x10C5, 7264, 0x10C7, 0x10C7, 7264, 0x10CD, 0x10CD, 7264, 0x13A0, 0x13EF, 38864, 0x1C90, 0x1CBA, -3008, 0x1CBD, 0x1CBF, -3008, 0x1E9E, 0x1E9E, -7615, 0x2126, 0x2126, -7517, 0x212A, 0x212A, -8383, 0x212B, 0x212B, -8262, 0x2C62, 0x2C62, -10743, 0x2C63, 0x2C63, -3814, 0x2C64, 0x2C64, -10727, 0x2C6D, 0x2C6D, -10780, 0x2C6E, 0x2C6E, -10749, 0x2C6F, 0x2C6F, -10783, 0x2C70, 0x2C70, -10782, 0x2C7E, 0x2C7F, -10815, 0xA77D, 0xA77D, -35332, 0xA78D, 0xA78D, -42280, 0xA7AA, 0xA7AA, -42308, 0xA7AB, 0xA7AB, -42319, 0xA7AC, 0xA7AC, -42315, 0xA7AD, 0xA7AD, -42305, 0xA7AE, 0xA7AE, -42308, 0xA7B0, 0xA7B0, -42258, 0xA7B1, 0xA7B1, -42282, 0xA7B2, 0xA7B2, -42261, 0xA7B3, 0xA7B3, 928, 0xA7C5, 0xA7C5, -42307, 0xA7C6, 0xA7C6, -35384, 0xA7CB, 0xA7CB, -42343, 0xA7DC, 0xA7DC, -42561
    )
    val largeUppercaseRanges = intArrayOf(
        0xB5, 0xB5, 743, 0x19B, 0x19B, 42561, 0x23F, 0x240, 10815, 0x250, 0x250, 10783, 0x251, 0x251, 10780, 0x252, 0x252, 10782, 0x25C, 0x25C, 42319, 0x261, 0x261, 42315, 0x264, 0x264, 42343, 0x265, 0x265, 42280, 0x266, 0x266, 42308, 0x26A, 0x26A, 42308, 0x26B, 0x26B, 10743, 0x26C, 0x26C, 42305, 0x271, 0x271, 10749, 0x27D, 0x27D, 10727, 0x282, 0x282, 42307, 0x287, 0x287, 42282, 0x29D, 0x29D, 42261, 0x29E, 0x29E, 42258, 0x10D0, 0x10FA, 3008, 0x10FD, 0x10FF, 3008, 0x1C80, 0x1C80, -6254, 0x1C81, 0x1C81, -6253, 0x1C82, 0x1C82, -6244, 0x1C83, 0x1C84, -6242, 0x1C85, 0x1C85, -6243, 0x1C86, 0x1C86, -6236, 0x1C87, 0x1C87, -6181, 0x1C88, 0x1C88, 35266, 0x1D79, 0x1D79, 35332, 0x1D7D, 0x1D7D, 3814, 0x1D8E, 0x1D8E, 35384, 0x1FBE, 0x1FBE, -7205, 0x2C65, 0x2C65, -10795, 0x2C66, 0x2C66, -10792, 0x2D00, 0x2D25, -7264, 0x2D27, 0x2D27, -7264, 0x2D2D, 0x2D2D, -7264, 0xAB53, 0xAB53, -928, 0xAB70, 0xABBF, -38864
    )

    fun getProperties(cp: Int): Int {
        return when {
            cp < 0 -> 0
            cp < 0x100 -> UNIQUE_PROPERTY_VALUES[CharacterDataLatin1.INDICES_DATA[cp].code]
            cp <= 0xFFFF -> UNIQUE_PROPERTY_VALUES[CharacterDataBMP.getPropertyIndex(cp - 0x100)]
            cp <= 0x1FFFF -> CharacterDataSMP.getProperties(cp - 0x10000)
            cp <= 0x2FFFF -> CharacterDataSIP.getProperties(cp - 0x20000)
            cp <= 0x10FFFF -> CharacterDataSSP.getProperties(cp - 0x30000)
            else -> 0
        }
    }
}
