/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.transformer;

import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.DiagnosableProposalTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/KeepFirstOrMeaningfulParagraphTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/DiagnosableProposalTransformer;", "minLengthValuableFilter", "", "<init>", "(I)V", "getMinLengthValuableFilter", "()I", "MAX_NUMBER_OF_PARAGRAPHS_TO_SHOW", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "isParagraphSeparator", "", "line", "", "getOrder", "intellij.fullLine.core.completion"})
public final class KeepFirstOrMeaningfulParagraphTransformer
extends DiagnosableProposalTransformer {
    private final int minLengthValuableFilter;
    private final int MAX_NUMBER_OF_PARAGRAPHS_TO_SHOW;

    public KeepFirstOrMeaningfulParagraphTransformer(int minLengthValuableFilter) {
        super("Keep first paragraph only transformer");
        this.minLengthValuableFilter = minLengthValuableFilter;
        this.MAX_NUMBER_OF_PARAGRAPHS_TO_SHOW = 2;
    }

    public final int getMinLengthValuableFilter() {
        return this.minLengthValuableFilter;
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        return (RawMLCompletionProposal)this.diagnoseMapping((MLCompletionProposal)proposal, () -> KeepFirstOrMeaningfulParagraphTransformer.transformRaw$lambda$0(proposal, this));
    }

    public final boolean isParagraphSeparator(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
        if (((CharSequence)trimmed).length() == 0) {
            return true;
        }
        if (Intrinsics.areEqual((Object)trimmed, (Object)"*")) {
            return true;
        }
        String string = trimmed.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowerTrimmed = string;
        return StringsKt.startsWith$default((String)lowerTrimmed, (String)"* <br>", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lowerTrimmed, (String)"* <p>", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lowerTrimmed, (String)"* </p>", (boolean)false, (int)2, null);
    }

    @Override
    public int getOrder() {
        return 750;
    }

    private static final RawMLCompletionProposal transformRaw$lambda$0(RawMLCompletionProposal $proposal, KeepFirstOrMeaningfulParagraphTransformer this$0) {
        List lines = StringsKt.lines((CharSequence)$proposal.getSuggestion());
        List firstParagraph = new ArrayList();
        boolean paragraphStarted = false;
        int numberOfAddedParagraphs = 0;
        for (String line : lines) {
            boolean bl;
            if (this$0.isParagraphSeparator(line)) {
                if (paragraphStarted) {
                    boolean isMeaningful;
                    boolean bl2 = isMeaningful = CollectionsKt.joinToString$default((Iterable)firstParagraph, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null).length() >= this$0.minLengthValuableFilter;
                    if (isMeaningful || numberOfAddedParagraphs > this$0.MAX_NUMBER_OF_PARAGRAPHS_TO_SHOW) break;
                    paragraphStarted = false;
                }
                bl = firstParagraph.add(line);
                continue;
            }
            if (!paragraphStarted) {
                paragraphStarted = true;
                ++numberOfAddedParagraphs;
            }
            bl = firstParagraph.add(line);
        }
        String result = CollectionsKt.joinToString$default((Iterable)firstParagraph, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return $proposal.withSuggestion(result);
    }
}

