/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.inline;

import com.intellij.codeInsight.inline.completion.DefaultInlineCompletionInsertHandler;
import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionEvent;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.InlineCompletionInsertEnvironment;
import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionSkipTextElement;
import com.intellij.codeInsight.inline.completion.utils.InlineCompletionSkipElementUtils;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.FormattingService;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.lang.Language;
import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.inline.completion.features.autoimport.ImportFixer;
import com.intellij.ml.inline.completion.features.autoimport.ImportFixerKt;
import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposalsDetails;
import com.intellij.ml.inline.completion.impl.cache.LightweightCacheKey;
import com.intellij.ml.inline.completion.impl.cache.MLInlineCompletionCache;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionCustomInlineEventsKt;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionExtractedFirstLine;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionFirstLineModeInfo;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionInsertHandler;
import com.intellij.ml.inline.completion.impl.inline.MLCompletionManualCallPurpose;
import com.intellij.ml.inline.completion.impl.inline.tracking.MLCompletionAcceptedFirstUserActionListener;
import com.intellij.ml.inline.completion.impl.inline.tracking.MLCompletionUsageTracker;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionEnclosuresSupporter;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.lang.MLCompletionLanguageUtils;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 02\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH$J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH$J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH$J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J'\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0**\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010,*\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010.\u001a\u00020,H\u0002J\u0010\u0010/\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0018\u0010\t\u001a\u00020\n*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/MLCompletionInsertHandler;", "Lcom/intellij/codeInsight/inline/completion/DefaultInlineCompletionInsertHandler;", "providerId", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionProviderID;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "Ljava/lang/String;", "getLanguageKit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "language", "Lcom/intellij/lang/Language;", "getCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "getCacheService", "Lcom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache;", "afterInsertion", "", "environment", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionInsertEnvironment;", "elements", "", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "moveCaretBeforeSuffix", "performAutoImport", "getLanguage", "(Lcom/intellij/codeInsight/inline/completion/InlineCompletionInsertEnvironment;)Lcom/intellij/lang/Language;", "formatSpacesAfterSuggestion", "getEnclosureOffsetRightAfter", "", "file", "Lcom/intellij/psi/PsiFile;", "offset", "enclosureSupporter", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionEnclosuresSupporter;", "(Lcom/intellij/psi/PsiFile;ILcom/intellij/ml/inline/completion/impl/kit/MLCompletionEnclosuresSupporter;)Ljava/lang/Integer;", "doQuickFormat", "range", "Lcom/intellij/openapi/util/TextRange;", "handleFirstLineMode", "getSkipOffsets", "", "trimEndingMatchedSymbols", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "cacheSuggestion", "proposal", "recordCompletionAcceptance", "Companion", "intellij.fullLine.core.completion"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMLCompletionInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionInsertHandler.kt\ncom/intellij/ml/inline/completion/impl/inline/MLCompletionInsertHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,245:1\n1807#2,3:246\n1#3:249\n50#4:250\n13#5:251\n*S KotlinDebug\n*F\n+ 1 MLCompletionInsertHandler.kt\ncom/intellij/ml/inline/completion/impl/inline/MLCompletionInsertHandler\n*L\n47#1:246,3\n242#1:250\n242#1:251\n*E\n"})
public abstract class MLCompletionInsertHandler
extends DefaultInlineCompletionInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String providerId;
    @NotNull
    private static final Key<Integer> CARET_SHIFT_AFTER_INSERTION_KEY;
    @NotNull
    private static final Logger LOG;

    private MLCompletionInsertHandler(String providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        this.providerId = providerId;
    }

    @Nullable
    protected abstract MLCompletionLanguageKit getLanguageKit(@NotNull Language var1);

    @NotNull
    protected abstract CoroutineScope getCoroutineScope(@NotNull Project var1);

    @NotNull
    protected abstract MLInlineCompletionCache getCacheService(@NotNull Project var1);

    public void afterInsertion(@NotNull InlineCompletionInsertEnvironment environment, @NotNull List<? extends InlineCompletionElement> elements2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            super.afterInsertion(environment, elements2);
            this.moveCaretBeforeSuffix(environment);
            Iterable $this$any$iv = elements2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    InlineCompletionElement it = (InlineCompletionElement)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it.getText(), (char)'\n', (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            this.formatSpacesAfterSuggestion(environment);
        }
        this.performAutoImport(environment);
        this.handleFirstLineMode(environment);
        this.recordCompletionAcceptance(environment);
    }

    private final void moveCaretBeforeSuffix(InlineCompletionInsertEnvironment environment) {
        block0: {
            Integer n = (Integer)environment.getUserData(CARET_SHIFT_AFTER_INSERTION_KEY);
            if (n == null) break block0;
            int shift = ((Number)n).intValue();
            boolean bl = false;
            Caret caret = environment.getEditor().getCaretModel().getCurrentCaret();
            boolean bl2 = false;
            caret.moveToOffset(caret.getOffset() + shift);
        }
    }

    private final void performAutoImport(InlineCompletionInsertEnvironment environment) {
        Language language = this.getLanguage(environment);
        Object object = this.getLanguageKit(language);
        if (object == null || (object = object.getImportFixer()) == null) {
            return;
        }
        Object importFixer = object;
        Project project2 = environment.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ImportFixerKt.runAutoImportAsync((ImportFixer)importFixer, this.getCoroutineScope(project2), environment.getFile(), environment.getEditor(), environment.getInsertedRange());
    }

    private final Language getLanguage(InlineCompletionInsertEnvironment $this$language) {
        InlineCompletionRequest inlineCompletionRequest;
        block3: {
            block2: {
                inlineCompletionRequest = $this$language.getRequest();
                if (inlineCompletionRequest == null) break block2;
                InlineCompletionRequest it = inlineCompletionRequest;
                boolean bl = false;
                Language language = MLCompletionLanguageUtils.getMostAccurateLanguage(it);
                inlineCompletionRequest = language;
                if (language != null) break block3;
            }
            Language language = $this$language.getFile().getLanguage();
            inlineCompletionRequest = language;
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        }
        return inlineCompletionRequest;
    }

    private final void formatSpacesAfterSuggestion(InlineCompletionInsertEnvironment environment) {
        ThreadingAssertions.assertWriteAccess();
        try {
            Editor editor2 = environment.getEditor();
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            PsiFile file = environment.getFile();
            TextRange insertedRange = environment.getInsertedRange();
            int insertedEndOffset = insertedRange.getEndOffset();
            if (environment.getInsertedRange().isEmpty() || environment.getInsertedRange().getEndOffset() >= document2.getTextLength()) {
                return;
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor2.getDocument());
            Language language = file.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            MLCompletionLanguageKit mLCompletionLanguageKit = this.getLanguageKit(language);
            if (mLCompletionLanguageKit == null) {
                return;
            }
            MLCompletionLanguageKit languageKit = mLCompletionLanguageKit;
            Integer n = this.getEnclosureOffsetRightAfter(file, insertedEndOffset, languageKit.getEnclosures());
            if (n == null) {
                return;
            }
            int enclosureOffset = n;
            if (document2.getLineNumber(insertedEndOffset) != document2.getLineNumber(enclosureOffset)) {
                return;
            }
            if (enclosureOffset + 1 <= insertedEndOffset || enclosureOffset >= document2.getTextLength()) {
                return;
            }
            this.doQuickFormat(file, new TextRange(insertedEndOffset, enclosureOffset + 1));
        }
        catch (Exception e) {
            MLCompletionLogger.box-impl(LOG).errorIfNotMessage(e);
        }
    }

    private final Integer getEnclosureOffsetRightAfter(PsiFile file, int offset, MLCompletionEnclosuresSupporter enclosureSupporter) {
        PsiElement psiElement;
        block8: {
            block7: {
                ThreadingAssertions.assertReadAccess();
                if (!file.getTextRange().contains(offset)) {
                    return null;
                }
                psiElement = file.findElementAt(offset);
                if (psiElement == null) break block7;
                PsiElement it = psiElement;
                boolean bl = false;
                PsiElement psiElement2 = PsiTreeUtil.getDeepestLast((PsiElement)it);
                psiElement = psiElement2;
                if (psiElement2 != null) break block8;
            }
            return null;
        }
        PsiElement currentElement = psiElement;
        if (currentElement instanceof PsiWhiteSpace) {
            PsiElement psiElement3 = PsiTreeUtil.skipWhitespacesForward((PsiElement)currentElement);
            if (psiElement3 == null) {
                psiElement3 = currentElement;
            }
            currentElement = psiElement3;
        }
        String string = currentElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Character c = StringsKt.firstOrNull((CharSequence)string);
        if (c == null) {
            return null;
        }
        char firstLetter = c.charValue();
        return enclosureSupporter.getDefinition().isEnclosure(firstLetter) ? Integer.valueOf(PsiTreeUtilKt.getStartOffset((PsiElement)currentElement)) : null;
    }

    private final void doQuickFormat(PsiFile file, TextRange range) {
        FormattingService formattingService = FormattingServiceUtil.findService((PsiFile)file, (boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)formattingService, (String)"findService(...)");
        FormattingService formattingService2 = formattingService;
        FormatTextRanges formatTextRanges = new FormatTextRanges(range, true);
        formattingService2.formatRanges(file, (FormattingRangesInfo)formatTextRanges, true, true);
    }

    private final void handleFirstLineMode(InlineCompletionInsertEnvironment environment) {
        int prefixLength;
        MLCompletionExtractedFirstLine extractedFirstLine;
        MLCompletionFirstLineModeInfo firstLineModeInfo;
        MLCompletionFirstLineModeInfo mLCompletionFirstLineModeInfo = firstLineModeInfo = (MLCompletionFirstLineModeInfo)environment.getUserData(MLCompletionFirstLineModeInfo.Companion.getKEY());
        MLCompletionExtractedFirstLine mLCompletionExtractedFirstLine = extractedFirstLine = mLCompletionFirstLineModeInfo != null ? mLCompletionFirstLineModeInfo.getExtractedFirstLine() : null;
        if (extractedFirstLine == null) {
            return;
        }
        AnalyzedMLCompletionProposal initialProposal = firstLineModeInfo.getInitialProposal();
        List<InlineCompletionElement> suffixElements = extractedFirstLine.getOtherLines();
        String suffixText2 = CollectionsKt.joinToString$default((Iterable)suffixElements, (CharSequence)"", null, null, (int)0, null, (Function1)handleFirstLineMode.suffixText.1.INSTANCE, (int)30, null);
        List newSuffixElements = InlineCompletionSkipElementUtils.INSTANCE.insertOffsetsAndAdditionalLines(suffixElements, extractedFirstLine.getOffsetsToInsertAutomatically(), environment.getEditor(), environment.getEditor().getCaretModel().getOffset(), suffixText2);
        Set<Integer> newSkipOffsets = this.getSkipOffsets(newSuffixElements);
        String initialSuggestion = initialProposal.getSuggestion() + initialProposal.getSuffix().getPresentation$intellij_fullLine_core_completion();
        AnalyzedMLCompletionProposal finalProposal = initialProposal.trimPrefix(StringsKt.take((String)initialSuggestion, (int)(prefixLength = initialSuggestion.length() - suffixText2.length())));
        if (finalProposal == null) {
            DiagnosticsLogger.warn$default((DiagnosticsLogger)MLCompletionLogger.box-impl(LOG), (String)"ML Completion: cannot trim a suggestion's prefix for the first-line mode. Prefix mismatch.", null, (int)2, null);
            return;
        }
        finalProposal.getDetails().set(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES(), newSkipOffsets);
        finalProposal = this.trimEndingMatchedSymbols(finalProposal);
        if (finalProposal == null) {
            DiagnosticsLogger.warn$default((DiagnosticsLogger)MLCompletionLogger.box-impl(LOG), (String)"ML Completion: cannot trim a suggestion's suffix for the first-line mode. Suffix mismatch.", null, (int)2, null);
            return;
        }
        this.cacheSuggestion(environment, finalProposal);
        ApplicationKt.getApplication().invokeLater(() -> MLCompletionInsertHandler.handleFirstLineMode$lambda$0(environment, this));
    }

    private final Set<Integer> getSkipOffsets(List<? extends InlineCompletionElement> $this$getSkipOffsets) {
        Set result2 = new LinkedHashSet();
        int offset = 0;
        for (InlineCompletionElement inlineCompletionElement : $this$getSkipOffsets) {
            if (inlineCompletionElement instanceof InlineCompletionSkipTextElement) {
                int n = ((InlineCompletionSkipTextElement)inlineCompletionElement).getText().length();
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    ((Collection)result2).add(offset + it);
                }
            }
            offset += inlineCompletionElement.getText().length();
        }
        return result2;
    }

    private final AnalyzedMLCompletionProposal trimEndingMatchedSymbols(AnalyzedMLCompletionProposal $this$trimEndingMatchedSymbols) {
        Set matched;
        int length;
        int finalLength = length = $this$trimEndingMatchedSymbols.getSuggestion().length() + $this$trimEndingMatchedSymbols.getSuffix().getPresentation$intellij_fullLine_core_completion().length();
        Set set = $this$trimEndingMatchedSymbols.getDetails().get(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES());
        if (set == null) {
            set = matched = SetsKt.emptySet();
        }
        while (finalLength > 0 && matched.contains(finalLength - 1)) {
            --finalLength;
        }
        return $this$trimEndingMatchedSymbols.trimSuffix(StringsKt.takeLast((String)($this$trimEndingMatchedSymbols.getSuggestion() + $this$trimEndingMatchedSymbols.getSuffix().getPresentation$intellij_fullLine_core_completion()), (int)(length - finalLength)));
    }

    private final void cacheSuggestion(InlineCompletionInsertEnvironment environment, AnalyzedMLCompletionProposal proposal2) {
        LightweightCacheKey cacheKey2 = (LightweightCacheKey)ActionsKt.runReadAction((Function0)((Function0)new Function0<LightweightCacheKey>(environment){
            final /* synthetic */ InlineCompletionInsertEnvironment $environment;
            {
                this.$environment = $environment;
                super(0);
            }

            public final LightweightCacheKey invoke() {
                return LightweightCacheKey.Companion.of$default(LightweightCacheKey.Companion, this.$environment.getEditor(), 0, 2, null);
            }
        }));
        Project project2 = environment.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.getCacheService(project2).cacheAnalyzed(cacheKey2, proposal2);
    }

    private final void recordCompletionAcceptance(InlineCompletionInsertEnvironment environment) {
        String string = this.getLanguage(environment).getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        MLCompletionUsageTracker tracker = MLCompletionUsageTracker.Companion.getOrCreate(string);
        tracker.onSuggestionAccepted();
        Document document = environment.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        MLCompletionAcceptedFirstUserActionListener listener = MLCompletionAcceptedFirstUserActionListener.Companion.getOrCreate(document2, tracker);
        listener.recordAcceptedSuggestion(environment.getInsertedRange());
    }

    private static final void handleFirstLineMode$lambda$0(InlineCompletionInsertEnvironment $environment, MLCompletionInsertHandler this$0) {
        block0: {
            InlineCompletionEvent.ManualCall newEvent = MLCompletionCustomInlineEventsKt.create-WmoXmhE(InlineCompletionEvent.ManualCall.Companion, $environment.getEditor(), this$0.providerId, MLCompletionManualCallPurpose.ShowRemainingMultiline.INSTANCE);
            InlineCompletionHandler inlineCompletionHandler = InlineCompletion.INSTANCE.getHandlerOrNull($environment.getEditor());
            if (inlineCompletionHandler == null) break block0;
            inlineCompletionHandler.invokeEvent((InlineCompletionEvent)newEvent);
        }
    }

    public /* synthetic */ MLCompletionInsertHandler(String providerId, DefaultConstructorMarker $constructor_marker) {
        this(providerId);
    }

    static {
        Key key2 = Key.create((String)"full.line.inline.caret.shift");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        CARET_SHIFT_AFTER_INSERTION_KEY = key2;
        Companion $this$thisMLCompletionLogger$iv = Companion;
        boolean $i$f$thisMLCompletionLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = MLCompletionLogger.constructor-impl(logger);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/MLCompletionInsertHandler$Companion;", "", "<init>", "()V", "CARET_SHIFT_AFTER_INSERTION_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCARET_SHIFT_AFTER_INSERTION_KEY", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.fullLine.core.completion"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Integer> getCARET_SHIFT_AFTER_INSERTION_KEY() {
            return CARET_SHIFT_AFTER_INSERTION_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

