/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.analyzer;

import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.inline.completion.features.correctness.CorrectnessError;
import com.intellij.ml.inline.completion.features.correctness.EnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.SpecialRange;
import com.intellij.ml.inline.completion.features.correctness.SuggestionEnricher;
import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposalSuffix;
import com.intellij.ml.inline.completion.impl.MLCompletionProposalsDetails;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.configuration.RedCodePolicy;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionSessionEventsReporter;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.CorrectnessAnalysisState;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.MLProposalSuffixComputer;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.ProposalAnalyzer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/analyzer/MLCompletionAnalyzer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/analyzer/ProposalAnalyzer;", "kit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;I)V", "suffixComputer", "Lcom/intellij/ml/inline/completion/impl/postprocessing/analyzer/MLProposalSuffixComputer;", "getAspectsToEnrich", "", "Lcom/intellij/ml/inline/completion/features/correctness/EnrichmentTool$Aspect;", "redCodePolicy", "Lcom/intellij/ml/inline/completion/impl/configuration/RedCodePolicy;", "analyze", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "proposal", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "sessionLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "getSafeSpecialRanges", "", "Lcom/intellij/ml/inline/completion/features/correctness/SpecialRange;", "enrichment", "Lcom/intellij/ml/inline/completion/features/correctness/SuggestionEnricher$Enrichment;", "Companion", "intellij.fullLine.core.completion"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMLCompletionAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionAnalyzer.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/analyzer/MLCompletionAnalyzer\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,91:1\n95#2:92\n135#2,3:93\n1586#3:96\n1661#3,3:97\n50#4:100\n13#5:101\n*S KotlinDebug\n*F\n+ 1 MLCompletionAnalyzer.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/analyzer/MLCompletionAnalyzer\n*L\n46#1:92\n46#1:93,3\n76#1:96\n76#1:97,3\n88#1:100\n88#1:101\n*E\n"})
public final class MLCompletionAnalyzer
implements ProposalAnalyzer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final MLCompletionLanguageKit kit;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Editor editor;
    private final int offset;
    @NotNull
    private final MLProposalSuffixComputer suffixComputer;
    @NotNull
    private static final Logger LOG;

    public MLCompletionAnalyzer(@NotNull MLCompletionLanguageKit kit, @NotNull PsiFile file, @NotNull Editor editor2, int offset) {
        Intrinsics.checkNotNullParameter((Object)kit, (String)"kit");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.kit = kit;
        this.file = file;
        this.editor = editor2;
        this.offset = offset;
        this.suffixComputer = new MLProposalSuffixComputer(this.kit, this.file, this.editor, this.offset);
    }

    private final Set<EnrichmentTool.Aspect> getAspectsToEnrich(RedCodePolicy redCodePolicy) {
        return switch (WhenMappings.$EnumSwitchMapping$0[redCodePolicy.ordinal()]) {
            case 1 -> {
                EnrichmentTool.Aspect[] var2_2 = new EnrichmentTool.Aspect[]{EnrichmentTool.Aspect.HIGHLIGHTING, EnrichmentTool.Aspect.COMMENTS, EnrichmentTool.Aspect.UNKNOWN};
                yield SetsKt.setOf((Object[])var2_2);
            }
            case 2, 3 -> ArraysKt.toSet((Object[])EnrichmentTool.Aspect.values());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public AnalyzedMLCompletionProposal analyze(@NotNull RawMLCompletionProposal proposal2, @NotNull RedCodePolicy redCodePolicy, @Nullable MLCompletionSessionEventsReporter sessionLogger) {
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        Intrinsics.checkNotNullParameter((Object)((Object)redCodePolicy), (String)"redCodePolicy");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        MLCompletionProposalSuffix suffix = this.suffixComputer.getSuffix(proposal2);
        SuggestionEnricher suggestionEnricher = this.kit.getSuggestionEnricher();
        Project project2 = this.file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project2) && !(suggestionEnricher instanceof DumbAware)) {
            return new AnalyzedMLCompletionProposal(proposal2, suffix, CorrectnessAnalysisState.Unknown.INSTANCE, 0);
        }
        Set<EnrichmentTool.Aspect> aspectsToEnrich = this.getAspectsToEnrich(redCodePolicy);
        SuggestionEnricher.Enrichment it = suggestionEnricher.enrich(this.editor, this.file, this.offset, proposal2.getSuggestion(), suffix.getPresentation$intellij_fullLine_core_completion(), aspectsToEnrich, sessionLogger, proposal2.getDetails().get(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES()));
        boolean bl2 = false;
        SuggestionEnricher.Enrichment checkResult = SuggestionEnricher.Enrichment.copy$default(it, this.getSafeSpecialRanges(it, proposal2), null, null, 6, null);
        Pair result$iv$iv = TuplesKt.to((Object)new CorrectnessAnalysisState.Analyzed(checkResult), (Object)suffix);
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        Pair stateAndSuffix = (Pair)timedValue.component1();
        long time = timedValue.component2-UwyO8pc();
        return new AnalyzedMLCompletionProposal(proposal2, (MLCompletionProposalSuffix)stateAndSuffix.getSecond(), (CorrectnessAnalysisState)stateAndSuffix.getFirst(), (int)Duration.getInWholeMilliseconds-impl((long)time));
    }

    /*
     * WARNING - void declaration
     */
    private final List<SpecialRange> getSafeSpecialRanges(SuggestionEnricher.Enrichment enrichment, RawMLCompletionProposal proposal2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = enrichment.getSpecialRanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            SpecialRange specialRange;
            void it;
            SpecialRange specialRange2 = (SpecialRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(it instanceof CorrectnessError)) {
                specialRange = it;
            } else if (0 <= ((CorrectnessError)it).getLocation().getStartOffset() && ((CorrectnessError)it).getLocation().getEndOffset() <= proposal2.getSuggestion().length()) {
                specialRange = it;
            } else {
                DiagnosticsLogger.error$default((DiagnosticsLogger)MLCompletionLogger.box-impl(LOG), (String)("Invalid special range: " + (SpecialRange)it + " for suggestion " + proposal2.getSuggestion() + " with len " + proposal2.getSuggestion().length()), null, (int)2, null);
                TextRange textRange = ((CorrectnessError)it).getLocation().intersection(new TextRange(0, proposal2.getSuggestion().length()));
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"intersection(...)");
                specialRange = new CorrectnessError(textRange, ((CorrectnessError)it).getSeverity(), ((CorrectnessError)it).getDebugName());
            }
            collection.add(specialRange);
        }
        return (List)destination$iv$iv;
    }

    static {
        Companion $this$thisMLCompletionLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisMLCompletionLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = MLCompletionLogger.constructor-impl(logger);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/analyzer/MLCompletionAnalyzer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.fullLine.core.completion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedCodePolicy.values().length];
            try {
                nArray[RedCodePolicy.ALLOW_EVERYTHING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedCodePolicy.PROHIBIT_CRITICAL_ERRORS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RedCodePolicy.PROHIBIT_CRITICAL_ERRORS_IN_FIRST_LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

