/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.transformer;

import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.DiagnosableProposalTransformer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/RemoveSensitiveTagsTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/DiagnosableProposalTransformer;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "<init>", "(Lcom/intellij/openapi/editor/Document;I)V", "tagRegex", "Lkotlin/text/Regex;", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "getOrder", "intellij.fullLine.core.completion"})
public final class RemoveSensitiveTagsTransformer
extends DiagnosableProposalTransformer {
    @NotNull
    private final Document document;
    private final int offset;
    @NotNull
    private final Regex tagRegex;

    public RemoveSensitiveTagsTransformer(@NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super("Remove sensitive tags");
        this.document = document;
        this.offset = offset;
        this.tagRegex = new Regex("<(NAME|EMAIL|USERNAME|KEY|PASSWORD|IP_ADDRESS)>");
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal2) {
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        return (RawMLCompletionProposal)this.diagnoseMapping((MLCompletionProposal)proposal2, (Function0)new Function0<RawMLCompletionProposal>(this, proposal2){
            final /* synthetic */ RemoveSensitiveTagsTransformer this$0;
            final /* synthetic */ RawMLCompletionProposal $proposal;
            {
                this.this$0 = $receiver;
                this.$proposal = $proposal;
                super(0);
            }

            public final RawMLCompletionProposal invoke() {
                Sequence matches = Regex.findAll$default((Regex)RemoveSensitiveTagsTransformer.access$getTagRegex$p(this.this$0), (CharSequence)this.$proposal.getSuggestion(), (int)0, (int)2, null);
                if (!SequencesKt.any((Sequence)matches)) {
                    return this.$proposal;
                }
                String string = RemoveSensitiveTagsTransformer.access$getDocument$p(this.this$0).getText(new TextRange(RangesKt.coerceAtLeast((int)(RemoveSensitiveTagsTransformer.access$getOffset$p(this.this$0) - 500), (int)0), RangesKt.coerceAtMost((int)(RemoveSensitiveTagsTransformer.access$getOffset$p(this.this$0) + 500), (int)RemoveSensitiveTagsTransformer.access$getDocument$p(this.this$0).getTextLength())));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String fileContentAroundCaret = string;
                String newSuggestion = this.$proposal.getSuggestion();
                for (MatchResult match : matches) {
                    String tag = match.getValue();
                    if (StringsKt.contains$default((CharSequence)fileContentAroundCaret, (CharSequence)tag, (boolean)false, (int)2, null)) continue;
                    newSuggestion = StringsKt.replace$default((String)newSuggestion, (String)tag, (String)"", (boolean)false, (int)4, null);
                }
                return !Intrinsics.areEqual((Object)newSuggestion, (Object)this.$proposal.getSuggestion()) ? this.$proposal.withSuggestion(newSuggestion) : this.$proposal;
            }
        });
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public static final /* synthetic */ Regex access$getTagRegex$p(RemoveSensitiveTagsTransformer $this) {
        return $this.tagRegex;
    }

    public static final /* synthetic */ Document access$getDocument$p(RemoveSensitiveTagsTransformer $this) {
        return $this.document;
    }

    public static final /* synthetic */ int access$getOffset$p(RemoveSensitiveTagsTransformer $this) {
        return $this.offset;
    }
}

