/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.language.supporters;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.LocalInferenceType;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.language.ModelVersion;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/completion/full/line/language/supporters/ModelsVersions;", "", "jvm", "Lorg/jetbrains/completion/full/line/language/ModelVersion;", "onnxNative", "llama", "<init>", "(Lorg/jetbrains/completion/full/line/language/ModelVersion;Lorg/jetbrains/completion/full/line/language/ModelVersion;Lorg/jetbrains/completion/full/line/language/ModelVersion;)V", "getJvm", "()Lorg/jetbrains/completion/full/line/language/ModelVersion;", "getOnnxNative", "getLlama", "getAll", "", "isEmpty", "", "selectVersion", "descriptor", "Lorg/jetbrains/completion/full/line/LocalModelDescriptor;", "selectVersionValueOrThrow", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.fullLine.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nModelsVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelsVersions.kt\norg/jetbrains/completion/full/line/language/supporters/ModelsVersions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1786#2,3:54\n*S KotlinDebug\n*F\n+ 1 ModelsVersions.kt\norg/jetbrains/completion/full/line/language/supporters/ModelsVersions\n*L\n11#1:54,3\n*E\n"})
public final class ModelsVersions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelVersion jvm;
    @NotNull
    private final ModelVersion onnxNative;
    @NotNull
    private final ModelVersion llama;

    public ModelsVersions(@NotNull ModelVersion jvm, @NotNull ModelVersion onnxNative, @NotNull ModelVersion llama) {
        Intrinsics.checkNotNullParameter((Object)jvm, (String)"jvm");
        Intrinsics.checkNotNullParameter((Object)onnxNative, (String)"onnxNative");
        Intrinsics.checkNotNullParameter((Object)llama, (String)"llama");
        this.jvm = jvm;
        this.onnxNative = onnxNative;
        this.llama = llama;
    }

    @NotNull
    public final ModelVersion getJvm() {
        return this.jvm;
    }

    @NotNull
    public final ModelVersion getOnnxNative() {
        return this.onnxNative;
    }

    @NotNull
    public final ModelVersion getLlama() {
        return this.llama;
    }

    @NotNull
    public final List<ModelVersion> getAll() {
        Object[] objectArray = new ModelVersion[]{this.jvm, this.onnxNative, this.llama};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.getAll();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ModelVersion it = (ModelVersion)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)ModelVersion.Companion.getUNSUPPORTED())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final ModelVersion selectVersion(LocalModelDescriptor descriptor) {
        return switch (WhenMappings.$EnumSwitchMapping$0[descriptor.getInferenceType().ordinal()]) {
            case 1 -> this.onnxNative;
            case 2 -> this.llama;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String selectVersionValueOrThrow(@NotNull LocalModelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String string = this.selectVersion(descriptor).getOrNull();
        if (string == null) {
            boolean bl = false;
            String string2 = "The model version for the " + descriptor + " is not supported";
            throw new IllegalStateException(string2.toString());
        }
        return string;
    }

    @NotNull
    public final ModelVersion component1() {
        return this.jvm;
    }

    @NotNull
    public final ModelVersion component2() {
        return this.onnxNative;
    }

    @NotNull
    public final ModelVersion component3() {
        return this.llama;
    }

    @NotNull
    public final ModelsVersions copy(@NotNull ModelVersion jvm, @NotNull ModelVersion onnxNative, @NotNull ModelVersion llama) {
        Intrinsics.checkNotNullParameter((Object)jvm, (String)"jvm");
        Intrinsics.checkNotNullParameter((Object)onnxNative, (String)"onnxNative");
        Intrinsics.checkNotNullParameter((Object)llama, (String)"llama");
        return new ModelsVersions(jvm, onnxNative, llama);
    }

    public static /* synthetic */ ModelsVersions copy$default(ModelsVersions modelsVersions, ModelVersion modelVersion, ModelVersion modelVersion2, ModelVersion modelVersion3, int n, Object object) {
        if ((n & 1) != 0) {
            modelVersion = modelsVersions.jvm;
        }
        if ((n & 2) != 0) {
            modelVersion2 = modelsVersions.onnxNative;
        }
        if ((n & 4) != 0) {
            modelVersion3 = modelsVersions.llama;
        }
        return modelsVersions.copy(modelVersion, modelVersion2, modelVersion3);
    }

    @NotNull
    public String toString() {
        return "ModelsVersions(jvm=" + this.jvm + ", onnxNative=" + this.onnxNative + ", llama=" + this.llama + ")";
    }

    public int hashCode() {
        int result = this.jvm.hashCode();
        result = result * 31 + this.onnxNative.hashCode();
        result = result * 31 + this.llama.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelsVersions)) {
            return false;
        }
        ModelsVersions modelsVersions = (ModelsVersions)other;
        if (!Intrinsics.areEqual((Object)this.jvm, (Object)modelsVersions.jvm)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.onnxNative, (Object)modelsVersions.onnxNative)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.llama, (Object)modelsVersions.llama);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/language/supporters/ModelsVersions$Companion;", "", "<init>", "()V", "isBeta", "", "version", "", "isBundle", "intellij.fullLine.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isBeta(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return StringsKt.contains$default((CharSequence)version, (CharSequence)"-beta", (boolean)false, (int)2, null);
        }

        public final boolean isBundle(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return StringsKt.contains$default((CharSequence)version, (CharSequence)"-bundle", (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LocalInferenceType.values().length];
            try {
                nArray[LocalInferenceType.ONNX_NATIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocalInferenceType.LLAMA_NATIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

