/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.impl;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PlatformUtils;
import com.jetbrains.gateway.impl.BootstrapClassLoaderUtil;
import com.jetbrains.gateway.impl.ExternalGatewayConfigMerger;
import com.jetbrains.gateway.impl.GatewayStarterKt;
import com.jetbrains.gateway.plugins.IdeaPluginDescriptorExKt;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/gateway/impl/GatewayStarter;", "", "<init>", "()V", "gatewayPluginId", "", "runGatewayProcess", "", "url", "extraEnv", "Lkotlin/Pair;", "onSuccessfulDeploy", "Lkotlin/Function1;", "intellij.gateway.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGatewayStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayStarter.kt\ncom/jetbrains/gateway/impl/GatewayStarter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,363:1\n1#2:364\n24197#3,10:365\n*S KotlinDebug\n*F\n+ 1 GatewayStarter.kt\ncom/jetbrains/gateway/impl/GatewayStarter\n*L\n108#1:365,10\n*E\n"})
public final class GatewayStarter {
    @NotNull
    public static final GatewayStarter INSTANCE = new GatewayStarter();
    @NotNull
    public static final String gatewayPluginId = "com.jetbrains.gateway";

    private GatewayStarter() {
    }

    public final void runGatewayProcess(@NotNull String url, @NotNull Pair<String, String> extraEnv, @NotNull Function1<? super String, Unit> onSuccessfulDeploy) {
        int debugPort;
        String licensePropertyName;
        String licenseProperty;
        Object vmOptionsPath;
        Object gatewayPluginPath;
        File currentConfigPath;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(extraEnv, (String)"extraEnv");
        Intrinsics.checkNotNullParameter(onSuccessfulDeploy, (String)"onSuccessfulDeploy");
        GatewayUsagesCollector.INSTANCE.onGtwFromStandaloneIdeStarted();
        boolean isInDevServerMode = AppMode.isRunningFromDevBuild();
        boolean isProductionMode = isInDevServerMode || !PluginManagerCore.isRunningFromSources();
        File javaHome = new File(System.getProperty("java.home"));
        if (!JdkUtil.checkForJre((Path)javaHome.toPath())) {
            File file = javaHome.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            javaHome = file;
            if (!JdkUtil.checkForJre((Path)javaHome.toPath())) {
                throw new IllegalStateException("Invalid Java home " + System.getProperty("java.home"));
            }
        }
        SimpleJavaParameters javaParameters = new SimpleJavaParameters();
        SimpleJavaSdkType sdkType = new SimpleJavaSdkType();
        Sdk jdk = sdkType.createJdk("", javaHome.getPath());
        Path path = PathManager.getTempDir().resolve("JetBrainsGateway");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        Path path3 = Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        File rootTempDir = path3.toFile();
        Object it = object = new File(rootTempDir, "config");
        boolean bl = false;
        ((File)it).mkdirs();
        Object configDir = object;
        Object it2 = it = new File((File)configDir, "plugins");
        boolean bl2 = false;
        ((File)it2).mkdirs();
        Object pluginDir = it;
        Object it3 = it2 = new File(rootTempDir, "system");
        boolean $i$a$-also-GatewayStarter$runGatewayProcess$systemDir$232 = false;
        ((File)it3).mkdirs();
        Object systemDir = it2;
        Path path4 = PathManager.getLogDir().resolve("gateway").resolve(GatewayStarterKt.access$getCurrentTimeString());
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        it3 = path4;
        FileAttribute[] $i$a$-also-GatewayStarter$runGatewayProcess$systemDir$232 = new FileAttribute[]{};
        Path path5 = Files.createDirectories((Path)it3, Arrays.copyOf($i$a$-also-GatewayStarter$runGatewayProcess$systemDir$232, $i$a$-also-GatewayStarter$runGatewayProcess$systemDir$232.length));
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"createDirectories(...)");
        File logDir = path5.toFile();
        Path path6 = ((File)configDir).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"toPath(...)");
        GatewayStarterKt.access$cleanTrustedHostsSettingsIfExists(path6);
        StoreUtil.saveSettings((ComponentManager)((ComponentManager)ApplicationKt.getApplication()), (boolean)true);
        File currentOptionsDir = PathManager.getOptionsDir().toFile();
        if (currentOptionsDir.isDirectory()) {
            FileUtil.copyDir((File)currentOptionsDir, (File)new File((File)configDir, "options"));
        }
        if ((currentConfigPath = new File(PathManager.getConfigPath())).isDirectory()) {
            File[] fileArray = currentConfigPath.listFiles();
            if (fileArray == null) {
                fileArray = new File[]{};
            }
            for (File configFile : fileArray) {
                String string = configFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith((String)string, (String)"key", (boolean)true)) {
                    String string2 = configFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    if (!StringsKt.endsWith((String)string2, (String)"kdbx", (boolean)true)) {
                        String string3 = configFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                        if (!StringsKt.endsWith((String)string3, (String)"pwd", (boolean)true)) continue;
                    }
                }
                String string4 = configFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                File target = FilesKt.resolve((File)configDir, (String)string4);
                try {
                    GatewayStarterKt.access$getLogger$p().info("Copy \"" + configFile + "\" -> \"" + target + "\"");
                    Intrinsics.checkNotNull((Object)configFile);
                    FilesKt.copyTo$default((File)configFile, (File)target, (boolean)false, (int)0, (int)6, null);
                }
                catch (Exception ex) {
                    GatewayStarterKt.access$getLogger$p().warn((Throwable)ex);
                }
            }
        }
        ExternalGatewayConfigMerger stateUpdater = new ExternalGatewayConfigMerger();
        Path path7 = ((File)configDir).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"toPath(...)");
        Path path8 = ((File)systemDir).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"toPath(...)");
        boolean isGatewayRunning = GatewayStarterKt.access$isGatewayRunning(path7, path8);
        if (isProductionMode && !isGatewayRunning) {
            IdeaPluginDescriptor[] $this$partition$iv = PluginManagerCore.getPlugins();
            boolean $i$f$partition = false;
            ArrayList<IdeaPluginDescriptor> arrayList = new ArrayList<IdeaPluginDescriptor>();
            ArrayList<IdeaPluginDescriptor> second$iv = new ArrayList<IdeaPluginDescriptor>();
            int n = $this$partition$iv.length;
            for (int i = 0; i < n; ++i) {
                IdeaPluginDescriptor element$iv;
                IdeaPluginDescriptor it4 = element$iv = $this$partition$iv[i];
                boolean bl3 = false;
                boolean bl4 = it4 instanceof IdeaPluginDescriptorImpl && IdeaPluginDescriptorExKt.isGatewayPlugin((IdeaPluginDescriptorImpl)it4) ? arrayList.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(arrayList, second$iv);
            List gatewayPlugins = (List)pair.component1();
            List pluginsToDisable = (List)pair.component2();
            for (IdeaPluginDescriptor pluginDescriptor : gatewayPlugins) {
                Path ideaPluginPath = pluginDescriptor.getPluginPath();
                Intrinsics.checkNotNull((Object)ideaPluginPath);
                String pluginDirName = PathsKt.getName((Path)ideaPluginPath);
                gatewayPluginPath = new File((File)pluginDir, pluginDirName);
                if (((File)gatewayPluginPath).exists()) {
                    try {
                        FileUtilRt.deleteRecursively((Path)((File)gatewayPluginPath).toPath());
                    }
                    catch (Throwable t) {
                        GatewayStarterKt.access$getLogger$p().info("Failed to delete file(s) in directory: <" + ((File)gatewayPluginPath).getCanonicalPath() + ">", t);
                        continue;
                    }
                }
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(ideaPluginPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                try {
                    FileUtil.copyDir((File)ideaPluginPath.toFile(), (File)gatewayPluginPath);
                }
                catch (Throwable t) {
                    GatewayStarterKt.access$getLogger$p().info("Unable to copy plugin path: <" + ((Object)ideaPluginPath).toString() + "> -> <" + ((File)gatewayPluginPath).getCanonicalPath() + ">");
                }
            }
            FilesKt.writeText$default((File)FilesKt.resolve((File)configDir, (String)"disabled_plugins.txt"), (String)CollectionsKt.joinToString$default((Iterable)pluginsToDisable, (CharSequence)"\n", null, null, (int)0, null, GatewayStarter::runGatewayProcess$lambda$4, (int)30, null), null, (int)2, null);
        }
        File gatewayAppInfoPath = FilesKt.resolve((File)configDir, (String)"info.xml");
        String gatewayAppInfo = GatewayStarterKt.access$getGatewayAppInfo();
        FilesKt.writeText$default((File)gatewayAppInfoPath, (String)gatewayAppInfo, null, (int)2, null);
        javaParameters.getVMParametersList().defineProperty("idea.application.info.value", gatewayAppInfoPath.getPath());
        if (isProductionMode) {
            String[] stringArray = new String[]{gatewayPluginId};
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.Companion.findId(stringArray));
            if (plugin == null) {
                throw new Exception("Can not start gateway: plugin com.jetbrains.gateway is not found.");
            }
            Path path9 = plugin.getPluginPath().resolve("lib").resolve("gateway-standalone");
            Intrinsics.checkNotNull((Object)path9);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path9, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new Exception("Can not start gateway: directory \"" + path9 + "\" is not found in plugin com.jetbrains.gateway.");
            }
            List additionalClassPath = new ArrayList();
            for (Path standaloneFile : PathsKt.listDirectoryEntries$default((Path)path9, null, (int)1, null)) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isRegularFile(standaloneFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) || !StringsKt.equals((String)PathsKt.getExtension((Path)standaloneFile), (String)"jar", (boolean)true)) continue;
                javaParameters.getClassPath().add(standaloneFile.toFile());
                additionalClassPath.add(((Object)standaloneFile).toString());
            }
            ParametersList parametersList = javaParameters.getVMParametersList();
            Path path10 = plugin.getPluginPath();
            Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"getPluginPath(...)");
            parametersList.defineProperty("com.jetbrains.gateway.plugin.path.for.remote.dev.workers", ((Object)path10.toAbsolutePath()).toString());
            ParametersList parametersList2 = javaParameters.getVMParametersList();
            Iterable iterable = additionalClassPath;
            String string = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
            parametersList2.defineProperty("idea.additional.classpath", CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
            vmOptionsPath = plugin.getPluginPath().resolve("resources").resolve("gateway.vmoptions");
            Intrinsics.checkNotNull((Object)vmOptionsPath);
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (!Files.exists((Path)vmOptionsPath, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                throw new Exception("Can not start gateway: resource \"" + (Path)vmOptionsPath + "\" is not found in plugin com.jetbrains.gateway.");
            }
            GatewayStarterKt.access$getLogger$p().info("Use vmOptions: " + (Path)vmOptionsPath);
            GatewayStarterKt.access$addDefaultVmOptions(javaParameters, PathsKt.readText$default((Path)vmOptionsPath, null, (int)1, null));
        } else {
            Path path11 = PathManager.getJarForClass(GatewayStarter.class);
            Intrinsics.checkNotNull((Object)path11);
            Path root = path11.getParent();
            Path path12 = root.resolve("intellij.gateway");
            Intrinsics.checkNotNull((Object)path12);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path12, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                throw new Exception("Can not find \"intellij.gateway\" in \"" + (Path)root + "\", try rebuild whole project and restart IDE.");
            }
            javaParameters.getClassPath().add(path12.toFile());
            URL vmOptionsPath2 = GatewayStarter.class.getResource("/gateway.vmoptions");
            if (vmOptionsPath2 == null) {
                throw new Exception("Can not find \"gateway.vmoptions\" in resources, try rebuild whole project and restart IDE.");
            }
            GatewayStarterKt.access$getLogger$p().info("Use vmOptions from resources");
            vmOptionsPath = vmOptionsPath2;
            Charset standaloneFile = Charsets.UTF_8;
            gatewayPluginPath = TextStreamsKt.readBytes((URL)vmOptionsPath);
            GatewayStarterKt.access$addDefaultVmOptions(javaParameters, new String((byte[])gatewayPluginPath, standaloneFile));
        }
        for (Path path13 : BootstrapClassLoaderUtil.getProductClassPath()) {
            Intrinsics.checkNotNull((Object)path13);
            if (StringsKt.equals((String)PathsKt.getName((Path)path13), (String)"intellij.gateway.plugin", (boolean)true)) continue;
            javaParameters.getClassPath().add(path13.toFile());
        }
        javaParameters.setJdk(jdk);
        javaParameters.setMainClass("com.intellij.idea.Main");
        javaParameters.setShortenCommandLine(ShortenCommandLine.ARGS_FILE, null);
        javaParameters.getVMParametersList().defineProperty("idea.platform.prefix", "Gateway");
        javaParameters.getVMParametersList().defineProperty("idea.parent.product", PlatformUtils.getPlatformPrefix());
        javaParameters.getVMParametersList().defineProperty("idea.config.path", ((File)configDir).getPath());
        javaParameters.getVMParametersList().defineProperty("idea.system.path", ((File)systemDir).getPath());
        javaParameters.getVMParametersList().defineProperty("idea.log.path", logDir.getPath());
        javaParameters.getVMParametersList().defineProperty("gateway.trusted.host.ui.not.changeable", "true");
        if (!isProductionMode) {
            javaParameters.getVMParametersList().defineProperty("idea.is.internal", "true");
        }
        Object[] objectArray = new String[]{"jna.boot.library.path", "pty4j.preferred.native.folder", "intellij.platform.runtime.repository.path", "skiko.library.path"};
        List propertiesToPass = CollectionsKt.listOf((Object[])objectArray);
        for (String property : propertiesToPass) {
            javaParameters.getVMParametersList().defineProperty(property, System.getProperty(property));
        }
        String string = "idea.suppressed.plugins.set.selector";
        String suppressedPluginsSetValue = System.getProperty("idea.suppressed.plugins.set.selector");
        vmOptionsPath = suppressedPluginsSetValue;
        if (!(vmOptionsPath == null || StringsKt.isBlank((CharSequence)vmOptionsPath))) {
            javaParameters.getVMParametersList().defineProperty(string, suppressedPluginsSetValue);
        }
        if ((licenseProperty = System.getProperty(licensePropertyName = "eap.require.license")) != null && ((CharSequence)licenseProperty).length() > 0) {
            javaParameters.getVMParametersList().defineProperty(licensePropertyName, licenseProperty);
        }
        if ((debugPort = Registry.Companion.get("gateway.embedded.process.debug.port").asInteger()) > 0) {
            String suspend = Registry.Companion.is("gateway.embedded.process.debug.suspend") ? "y" : "n";
            javaParameters.getVMParametersList().add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + suspend + ",address=" + debugPort);
        }
        javaParameters.getProgramParametersList().add(url);
        javaParameters.addEnv((String)extraEnv.getFirst(), (String)extraEnv.getSecond());
        GatewayStarterKt.access$getLogger$p().info("Start Gateway process, log directory: " + logDir);
        OSProcessHandler oSProcessHandler = javaParameters.createOSProcessHandler();
        Intrinsics.checkNotNullExpressionValue((Object)oSProcessHandler, (String)"createOSProcessHandler(...)");
        OSProcessHandler processHandler = oSProcessHandler;
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(logDir, stateUpdater, (File)configDir, onSuccessfulDeploy){
            final /* synthetic */ File $logDir;
            final /* synthetic */ ExternalGatewayConfigMerger $stateUpdater;
            final /* synthetic */ File $configDir;
            final /* synthetic */ Function1<String, Unit> $onSuccessfulDeploy;
            {
                this.$logDir = $logDir;
                this.$stateUpdater = $stateUpdater;
                this.$configDir = $configDir;
                this.$onSuccessfulDeploy = $onSuccessfulDeploy;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                File logFile;
                File file;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (ProcessOutputType.isStdout(outputType)) {
                    var4_3 = this.$logDir;
                    Intrinsics.checkNotNull((Object)var4_3);
                    file = FilesKt.resolve((File)var4_3, (String)"out.log");
                } else if (ProcessOutputType.isStderr(outputType)) {
                    var4_3 = this.$logDir;
                    Intrinsics.checkNotNull((Object)var4_3);
                    file = FilesKt.resolve((File)var4_3, (String)"err.log");
                } else {
                    file = null;
                }
                File file2 = logFile = file;
                if (file2 != null) {
                    String string = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    FilesKt.appendText$default((File)file2, (String)((Object)StringsKt.trim((CharSequence)string)).toString(), null, (int)2, null);
                }
                File file3 = logFile;
                if (file3 != null) {
                    FilesKt.appendText$default((File)file3, (String)"\n", null, (int)2, null);
                }
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.checkForSuccessfulDeploy(string);
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.syncTrustedHosts();
            }

            private final void syncTrustedHosts() {
                Path path = this.$configDir.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                Path path2 = path;
                Path path3 = path2.resolve("options");
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                path2 = path3;
                Path path4 = path2.resolve("GatewayTrustedHostsConfigProvider.xml");
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                this.$stateUpdater.updateTrustedHostsState(path4);
            }

            private final void checkForSuccessfulDeploy(String message) {
                if (!StringsKt.contains$default((CharSequence)message, (CharSequence)"Deployment Successful #$hi#", (boolean)false, (int)2, null)) {
                    return;
                }
                this.syncTrustedHosts();
                this.$onSuccessfulDeploy.invoke((Object)message);
            }
        });
        processHandler.startNotify();
        Intrinsics.checkNotNull((Object)logDir);
        File launchLogFile = FilesKt.resolve((File)logDir, (String)"launch.log");
        String string5 = processHandler.getCommandLineForLog();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getCommandLineForLog(...)");
        FilesKt.appendText$default((File)launchLogFile, (String)string5, null, (int)2, null);
        FilesKt.appendText$default((File)launchLogFile, (String)"\n", null, (int)2, null);
        FilesKt.appendText$default((File)launchLogFile, (String)"\nClassPath:", null, (int)2, null);
        for (String path11 : javaParameters.getClassPath().getPathList()) {
            FilesKt.appendText$default((File)launchLogFile, (String)("\n" + path11), null, (int)2, null);
        }
        FilesKt.appendText$default((File)launchLogFile, (String)"\n", null, (int)2, null);
        FilesKt.appendText$default((File)launchLogFile, (String)"\nApplicationInfo:", null, (int)2, null);
        FilesKt.appendText$default((File)launchLogFile, (String)("\n" + gatewayAppInfo), null, (int)2, null);
    }

    private static final CharSequence runGatewayProcess$lambda$4(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPluginId().getIdString();
    }
}

