/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter;

import com.intellij.go.linter.model.RunProcessResult;
import com.intellij.go.linter.platform.PlatformKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JH\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/go/linter/MergingLinterExecutor;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "scheduledRequests", "", "Lcom/intellij/go/linter/MergingLinterExecutor$LintRequest;", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/go/linter/model/RunProcessResult;", "semaphore", "Lkotlinx/coroutines/sync/Semaphore;", "execute", "executablePath", "", "runningPath", "parameters", "", "environment", "", "encoding", "Ljava/nio/charset/Charset;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;Ljava/nio/charset/Charset;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isPending", "", "LintRequest", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nGoLinterExternalAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoLinterExternalAnnotator.kt\ncom/intellij/go/linter/MergingLinterExecutor\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,445:1\n374#2:446\n488#3,7:447\n*S KotlinDebug\n*F\n+ 1 GoLinterExternalAnnotator.kt\ncom/intellij/go/linter/MergingLinterExecutor\n*L\n421#1:446\n442#1:447,7\n*E\n"})
public final class MergingLinterExecutor {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Map<LintRequest, Deferred<RunProcessResult>> scheduledRequests;
    @NotNull
    private final Semaphore semaphore;

    public MergingLinterExecutor(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.scheduledRequests = new ConcurrentHashMap();
        this.semaphore = SemaphoreKt.Semaphore$default((int)1, (int)0, (int)2, null);
    }

    @Nullable
    public final Object execute(@NotNull String executablePath, @NotNull String runningPath, @NotNull List<String> parameters, @NotNull Map<String, String> environment, @NotNull Charset encoding, @NotNull Continuation<? super RunProcessResult> $completion) {
        LintRequest request = new LintRequest(executablePath, runningPath, parameters, environment, encoding);
        boolean $i$f$currentCoroutineContext = false;
        Job currentJob = JobKt.getJob((CoroutineContext)$completion.getContext());
        Deferred deferred = this.scheduledRequests.computeIfAbsent(request, arg_0 -> MergingLinterExecutor.execute$lambda$1(arg_0 -> MergingLinterExecutor.execute$lambda$0(this, currentJob, request, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)deferred, (String)"computeIfAbsent(...)");
        Deferred resultFuture2 = deferred;
        return resultFuture2.await($completion);
    }

    public final boolean isPending(@NotNull String runningPath) {
        Intrinsics.checkNotNullParameter((Object)runningPath, (String)"runningPath");
        Map<LintRequest, Deferred<RunProcessResult>> $this$filterKeys$iv = this.scheduledRequests;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<LintRequest, Deferred<RunProcessResult>> result$iv = new LinkedHashMap<LintRequest, Deferred<RunProcessResult>>();
        for (Map.Entry<LintRequest, Deferred<RunProcessResult>> entry$iv : $this$filterKeys$iv.entrySet()) {
            LintRequest it = entry$iv.getKey();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getRunningPath(), (Object)runningPath)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return !((Map)result$iv).isEmpty();
    }

    private static final Deferred execute$lambda$0(MergingLinterExecutor this$0, Job $currentJob, LintRequest $request, LintRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CoroutineScope coroutineScope = this$0.coroutineScope;
        CoroutineStart coroutineStart = CoroutineStart.LAZY;
        Deferred future2 = BuildersKt.async((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)$currentJob), (CoroutineStart)coroutineStart, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super RunProcessResult>, Object>(this$0, $request, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ MergingLinterExecutor this$0;
            final /* synthetic */ LintRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = MergingLinterExecutor.access$getSemaphore$p(this.this$0);
                        var3_4 = this.this$0;
                        var4_5 = this.$request;
                        $i$f$withPermit = 0;
                        this.L$0 = $this$withPermit$iv;
                        this.L$1 = var3_4;
                        this.L$2 = var4_5;
                        this.I$0 = $i$f$withPermit;
                        this.label = 1;
                        v0 = $this$withPermit$iv.acquire((Continuation)this);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        $i$f$withPermit = this.I$0;
                        var4_5 = (LintRequest)this.L$2;
                        var3_4 = (MergingLinterExecutor)this.L$1;
                        $this$withPermit$iv = (Semaphore)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 3 sources

                        $i$a$-withPermit-MergingLinterExecutor$execute$resultFuture$1$future$1$1 = 0;
                        this.L$0 = $this$withPermit$iv;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.I$0 = $i$f$withPermit;
                        this.I$1 = $i$a$-withPermit-MergingLinterExecutor$execute$resultFuture$1$future$1$1;
                        this.label = 2;
                        v1 = PlatformKt.runProcess(MergingLinterExecutor.access$getProject$p(var3_4), var4_5.getExecutablePath(), var4_5.getParameters(), var4_5.getRunningPath(), var4_5.getEnvironment(), var4_5.getEncoding(), (Continuation<? super RunProcessResult>)this);
                        ** if (v1 != var9_2) goto lbl37
lbl36:
                        // 1 sources

                        return var9_2;
lbl37:
                        // 1 sources

                        ** GOTO lbl47
                    }
                    case 2: {
                        $i$a$-withPermit-MergingLinterExecutor$execute$resultFuture$1$future$1$1 = this.I$1;
                        $i$f$withPermit = this.I$0;
                        $this$withPermit$iv = (Semaphore)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl47:
                            // 2 sources

                            var7_10 = (RunProcessResult)v1;
                        }
                        catch (Throwable var8_11) {
                            throw var8_11;
                        }
                        finally {
                            $this$withPermit$iv.release();
                        }
                        return var7_10;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super RunProcessResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        future2.invokeOnCompletion(arg_0 -> MergingLinterExecutor.execute$lambda$0$0(this$0, $request, arg_0));
        return future2;
    }

    private static final Unit execute$lambda$0$0(MergingLinterExecutor this$0, LintRequest $request, Throwable it) {
        this$0.scheduledRequests.remove($request);
        return Unit.INSTANCE;
    }

    private static final Deferred execute$lambda$1(Function1 $tmp0, Object p0) {
        return (Deferred)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Semaphore access$getSemaphore$p(MergingLinterExecutor $this) {
        return $this.semaphore;
    }

    public static final /* synthetic */ Project access$getProject$p(MergingLinterExecutor $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003JM\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/go/linter/MergingLinterExecutor$LintRequest;", "", "executablePath", "", "runningPath", "parameters", "", "environment", "", "encoding", "Ljava/nio/charset/Charset;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Map;Ljava/nio/charset/Charset;)V", "getExecutablePath", "()Ljava/lang/String;", "getRunningPath", "getParameters", "()Ljava/util/List;", "getEnvironment", "()Ljava/util/Map;", "getEncoding", "()Ljava/nio/charset/Charset;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.go.linter"})
    private static final class LintRequest {
        @NotNull
        private final String executablePath;
        @NotNull
        private final String runningPath;
        @NotNull
        private final List<String> parameters;
        @NotNull
        private final Map<String, String> environment;
        @NotNull
        private final Charset encoding;

        public LintRequest(@NotNull String executablePath, @NotNull String runningPath, @NotNull List<String> parameters, @NotNull Map<String, String> environment, @NotNull Charset encoding) {
            Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
            Intrinsics.checkNotNullParameter((Object)runningPath, (String)"runningPath");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            this.executablePath = executablePath;
            this.runningPath = runningPath;
            this.parameters = parameters;
            this.environment = environment;
            this.encoding = encoding;
        }

        @NotNull
        public final String getExecutablePath() {
            return this.executablePath;
        }

        @NotNull
        public final String getRunningPath() {
            return this.runningPath;
        }

        @NotNull
        public final List<String> getParameters() {
            return this.parameters;
        }

        @NotNull
        public final Map<String, String> getEnvironment() {
            return this.environment;
        }

        @NotNull
        public final Charset getEncoding() {
            return this.encoding;
        }

        @NotNull
        public final String component1() {
            return this.executablePath;
        }

        @NotNull
        public final String component2() {
            return this.runningPath;
        }

        @NotNull
        public final List<String> component3() {
            return this.parameters;
        }

        @NotNull
        public final Map<String, String> component4() {
            return this.environment;
        }

        @NotNull
        public final Charset component5() {
            return this.encoding;
        }

        @NotNull
        public final LintRequest copy(@NotNull String executablePath, @NotNull String runningPath, @NotNull List<String> parameters, @NotNull Map<String, String> environment, @NotNull Charset encoding) {
            Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
            Intrinsics.checkNotNullParameter((Object)runningPath, (String)"runningPath");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter(environment, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            return new LintRequest(executablePath, runningPath, parameters, environment, encoding);
        }

        public static /* synthetic */ LintRequest copy$default(LintRequest lintRequest, String string, String string2, List list, Map map, Charset charset, int n, Object object) {
            if ((n & 1) != 0) {
                string = lintRequest.executablePath;
            }
            if ((n & 2) != 0) {
                string2 = lintRequest.runningPath;
            }
            if ((n & 4) != 0) {
                list = lintRequest.parameters;
            }
            if ((n & 8) != 0) {
                map = lintRequest.environment;
            }
            if ((n & 0x10) != 0) {
                charset = lintRequest.encoding;
            }
            return lintRequest.copy(string, string2, list, map, charset);
        }

        @NotNull
        public String toString() {
            return "LintRequest(executablePath=" + this.executablePath + ", runningPath=" + this.runningPath + ", parameters=" + this.parameters + ", environment=" + this.environment + ", encoding=" + this.encoding + ")";
        }

        public int hashCode() {
            int result = this.executablePath.hashCode();
            result = result * 31 + this.runningPath.hashCode();
            result = result * 31 + ((Object)this.parameters).hashCode();
            result = result * 31 + ((Object)this.environment).hashCode();
            result = result * 31 + this.encoding.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LintRequest)) {
                return false;
            }
            LintRequest lintRequest = (LintRequest)other;
            if (!Intrinsics.areEqual((Object)this.executablePath, (Object)lintRequest.executablePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.runningPath, (Object)lintRequest.runningPath)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.parameters, lintRequest.parameters)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.environment, lintRequest.environment)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.encoding, (Object)lintRequest.encoding);
        }
    }
}

