/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter;

import com.google.gson.Gson;
import com.intellij.go.linter.GoLinterExecutableService;
import com.intellij.go.linter.GoLinterSettings;
import com.intellij.go.linter.form.VersionedLinter;
import com.intellij.go.linter.model.GithubRelease;
import com.intellij.go.linter.model.GoLinter;
import com.intellij.go.linter.model.RunProcessResult;
import com.intellij.go.linter.platform.Platform;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0017\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u001a \u0010\u001e\u001a\u0004\u0018\u00010\u000e*\u00020\u000e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a0 \u001a\u0011\u0010!\u001a\u00070\u0002\u00a2\u0006\u0002\b\"*\u0004\u0018\u00010\u000e\u001a\n\u0010#\u001a\u00020\u001a*\u00020\u000e\u001a\u001d\u0010$\u001a\u00020\u001a*\u0004\u0018\u00010\u000e\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0001\u001a\u0004\b\u0003\u0010\u0000\u001a\n\u0010%\u001a\u00020\u001a*\u00020&\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"configFiles", "", "", "getConfigFiles", "()Ljava/util/List;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "findCustomConfigInPath", "Ljava/nio/file/Path;", "path", "parseLinters", "Lcom/intellij/go/linter/model/GoLinter;", "result", "Lcom/intellij/go/linter/model/RunProcessResult;", "getLatestReleaseMeta", "Lcom/intellij/go/linter/model/GithubRelease;", "timeout", "", "(Ljava/lang/Integer;)Lcom/intellij/go/linter/model/GithubRelease;", "canExecuteConfiguration", "", "Lcom/intellij/go/linter/GoLinterSettings;", "project", "Lcom/intellij/openapi/project/Project;", "takeIfNotEmptyAnd", "predicate", "Lkotlin/Function1;", "getDisplayTextOrEmpty", "Lcom/intellij/openapi/util/NlsSafe;", "isEmpty", "isNullOrEmpty", "isAtLeastV2", "Lcom/intellij/go/linter/form/VersionedLinter;", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utilities.kt\ncom/intellij/go/linter/UtilitiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,153:1\n1#2:154\n30#3,2:155\n*S KotlinDebug\n*F\n+ 1 Utilities.kt\ncom/intellij/go/linter/UtilitiesKt\n*L\n118#1:155,2\n*E\n"})
public final class UtilitiesKt {
    @NotNull
    private static final List<String> configFiles;
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final List<String> getConfigFiles() {
        return configFiles;
    }

    @NotNull
    public static final Logger getLogger() {
        return logger;
    }

    @NotNull
    public static final NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Go linter notifications");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    @Nullable
    public static final Path findCustomConfigInPath(@Nullable String path) {
        String varPath = path;
        if (varPath != null) {
            for (Path cur = Paths.get(varPath, new String[0]); cur != null && cur.toFile().isDirectory(); cur = cur.getParent()) {
                for (String s : configFiles) {
                    Path f = cur.resolve(s);
                    Intrinsics.checkNotNull((Object)f);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(f, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (!Files.isRegularFile(f, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                    return f;
                }
            }
        }
        return null;
    }

    @NotNull
    public static final List<GoLinter> parseLinters(@NotNull RunProcessResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result.getReturnCode() != 0) {
            CharSequence charSequence;
            CharSequence charSequence2 = result.getStderr();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = result.getStdout();
            } else {
                charSequence = charSequence2;
            }
            String string = (String)charSequence;
            throw new RuntimeException(string);
        }
        List linters = new ArrayList();
        Regex regex = new Regex("^(?<name>\\w+)( \\((?<aka>[\\w, ]+)\\))?( \\[(?<deprecated>deprecated)])?: (?<description>[^\\[\\n\\r]+)( \\[(fast: (?<fast>true|false), auto-fix: (?<autofix>true|false)|(?<newFlags>(fast(?:, auto-fix)?|auto-fix)))])?$");
        boolean enabled = false;
        enabled = true;
        for (String line : StringsKt.lines((CharSequence)result.getStdout())) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            MatchResult it;
            if (((CharSequence)line).length() == 0) continue;
            if (StringsKt.startsWith$default((String)line, (String)"Enabled", (boolean)false, (int)2, null)) {
                enabled = true;
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"Disabled", (boolean)false, (int)2, null)) {
                enabled = false;
                continue;
            }
            if (regex.matchEntire((CharSequence)line) == null) continue;
            boolean bl = false;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"name");
            Intrinsics.checkNotNull((Object)matchGroup);
            String string = matchGroup.getValue();
            Object object5 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"aka");
            if (object5 == null || (object5 = object5.getValue()) == null) {
                object5 = "";
            }
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"deprecated");
            boolean bl2 = Intrinsics.areEqual((Object)(matchGroup2 != null ? matchGroup2.getValue() : null), (Object)"deprecated");
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"description");
            Intrinsics.checkNotNull((Object)matchGroup3);
            linters.add(new GoLinter(enabled, string, (String)object5, bl2, matchGroup3.getValue(), (object4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"fast")) != null && (object4 = object4.getValue()) != null ? Boolean.parseBoolean((String)object4) : ((object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"newFlags")) != null && (object3 = object3.getValue()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object3), (CharSequence)"fast", (boolean)false, (int)2, null) : false), (object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"autofix")) != null && (object2 = object2.getValue()) != null ? Boolean.parseBoolean((String)object2) : ((object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)it.getGroups(), (String)"newFlags")) != null && (object = object.getValue()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"auto-fix", (boolean)false, (int)2, null) : false)));
        }
        if (linters.isEmpty()) {
            throw new RuntimeException("Linter returned list of enabled linters, but it was impossible to parse it.");
        }
        return linters;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GithubRelease getLatestReleaseMeta(@Nullable Integer timeout) {
        RequestBuilder requestBuilder;
        RequestBuilder requestBuilder2 = requestBuilder = HttpRequests.request((String)"https://api.github.com/repos/golangci/golangci-lint/releases/latest");
        Gson gson = new Gson();
        boolean bl = false;
        Integer n = timeout;
        if (n != null) {
            void $this$getLatestReleaseMeta_u24lambda_u240;
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            $this$getLatestReleaseMeta_u24lambda_u240.connectTimeout(it);
            $this$getLatestReleaseMeta_u24lambda_u240.readTimeout(it);
        }
        Object object = gson.fromJson(requestBuilder.readString(), GithubRelease.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (GithubRelease)object;
    }

    public static /* synthetic */ GithubRelease getLatestReleaseMeta$default(Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return UtilitiesKt.getLatestReleaseMeta(n);
    }

    public static final boolean canExecuteConfiguration(@NotNull GoLinterSettings $this$canExecuteConfiguration, @NotNull Project project) {
        Path path;
        Platform platform;
        block5: {
            block4: {
                Path path2;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$canExecuteConfiguration), (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                platform = Platform.Companion.platformFactory(project);
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<GoLinterExecutableService> serviceClass$iv = GoLinterExecutableService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                path = ((GoLinterExecutableService)((Object)object)).getPath();
                if (path == null) break block4;
                Path it = path2 = path;
                boolean bl = false;
                path = !UtilitiesKt.isEmpty(it) ? path2 : null;
                if (path != null) break block5;
            }
            return false;
        }
        Path linterExePath = path;
        boolean hasValidLinterExe = platform.canExecute(linterExePath);
        boolean hasValidLintersList = !UtilitiesKt.isNullOrEmpty($this$canExecuteConfiguration.getCustomConfigFile()) || !((Collection)$this$canExecuteConfiguration.getEnabledLinters()).isEmpty();
        return hasValidLinterExe && hasValidLintersList;
    }

    @Nullable
    public static final Path takeIfNotEmptyAnd(@NotNull Path $this$takeIfNotEmptyAnd, @NotNull Function1<? super Path, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$takeIfNotEmptyAnd, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (((CharSequence)((Object)$this$takeIfNotEmptyAnd).toString()).length() == 0) {
            return null;
        }
        Path path = $this$takeIfNotEmptyAnd;
        return (Boolean)predicate.invoke((Object)path) != false ? path : null;
    }

    @NotNull
    public static final String getDisplayTextOrEmpty(@Nullable Path $this$getDisplayTextOrEmpty) {
        if ($this$getDisplayTextOrEmpty == null) {
            return "";
        }
        Path normalizedPath = $this$getDisplayTextOrEmpty.normalize();
        String string = PathUtil.toSystemDependentName((String)((Object)normalizedPath).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        return string;
    }

    public static final boolean isEmpty(@NotNull Path $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return ((CharSequence)((Object)$this$isEmpty).toString()).length() == 0;
    }

    public static final boolean isNullOrEmpty(@Nullable Path $this$isNullOrEmpty) {
        return $this$isNullOrEmpty == null || UtilitiesKt.isEmpty($this$isNullOrEmpty);
    }

    public static final boolean isAtLeastV2(@NotNull VersionedLinter $this$isAtLeastV2) {
        Intrinsics.checkNotNullParameter((Object)$this$isAtLeastV2, (String)"<this>");
        String[] stringArray = new String[]{"."};
        Object object = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)$this$isAtLeastV2.getVersion(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            return false;
        }
        int majorVersion = (Integer)object;
        return majorVersion >= 2;
    }

    static {
        List list;
        List $this$configFiles_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"yml", "yaml", "toml", "json"};
        List formats = CollectionsKt.listOf((Object[])stringArray);
        for (String ext : formats) {
            $this$configFiles_u24lambda_u240.add(".golangci." + ext);
        }
        for (String ext : formats) {
            $this$configFiles_u24lambda_u240.add("golangci." + ext);
        }
        configFiles = CollectionsKt.build((List)list);
        Logger logger = Logger.getInstance((String)"go-linter");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UtilitiesKt.logger = logger;
    }
}

