/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.form;

import com.intellij.go.linter.GoLinterBundle;
import com.intellij.go.linter.GoLinterSettings;
import com.intellij.go.linter.form.ChangeSource;
import com.intellij.go.linter.form.CheckBoxCellEditor;
import com.intellij.go.linter.form.LinterTableEntry;
import com.intellij.go.linter.form.ThreeStateCheckBoxHeaderEditor;
import com.intellij.go.linter.model.GoLinter;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001f !B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J\u0014\u0010\u0013\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012J\u0006\u0010\u0014\u001a\u00020\u0010J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017J\u0006\u0010\u0018\u001a\u00020\u0010J\u0006\u0010\u0019\u001a\u00020\u0010J\b\u0010\u001a\u001a\u00020\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/go/linter/form/LinterTable;", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/go/linter/form/LinterTableEntry;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "headerRenderer", "Lcom/intellij/go/linter/form/ThreeStateCheckBoxHeaderEditor;", "allLinters", "", "Lcom/intellij/go/linter/model/GoLinter;", "enabledLinters", "", "", "addLinters", "", "linters", "", "enableAll", "disableAll", "getAllLinters", "getEnabledLinters", "", "clear", "refresh", "refreshTableHeader", "refreshTableContent", "initUi", "createModel", "Lcom/intellij/util/ui/ListTableModel;", "EnabledColumnInfo", "NameColumnInfo", "DescriptionColumnInfo", "intellij.go.linter"})
@SourceDebugExtension(value={"SMAP\nLinterTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinterTable.kt\ncom/intellij/go/linter/form/LinterTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1563#2:168\n1634#2,3:169\n1563#2:172\n1634#2,3:173\n*S KotlinDebug\n*F\n+ 1 LinterTable.kt\ncom/intellij/go/linter/form/LinterTable\n*L\n85#1:168\n85#1:169,3\n26#1:172\n26#1:173,3\n*E\n"})
public final class LinterTable
extends TableView<LinterTableEntry> {
    @NotNull
    private final Project project;
    @NotNull
    private final ThreeStateCheckBoxHeaderEditor headerRenderer;
    @NotNull
    private final List<GoLinter> allLinters;
    @NotNull
    private final Set<String> enabledLinters;

    public LinterTable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.headerRenderer = new ThreeStateCheckBoxHeaderEditor((Function2<? super ThreeStateCheckBox.State, ? super ChangeSource, Unit>)((Function2)(arg_0, arg_1) -> LinterTable.headerRenderer$lambda$0(this, arg_0, arg_1)));
        this.allLinters = new ArrayList();
        this.enabledLinters = new HashSet();
        this.setModelAndUpdateColumns(this.createModel());
        this.initUi();
    }

    public final void addLinters(@NotNull Collection<GoLinter> linters) {
        Intrinsics.checkNotNullParameter(linters, (String)"linters");
        this.allLinters.addAll(linters);
    }

    public final void enableAll(@NotNull Collection<String> linters) {
        Intrinsics.checkNotNullParameter(linters, (String)"linters");
        this.enabledLinters.addAll(linters);
    }

    public final void disableAll() {
        this.enabledLinters.clear();
    }

    @NotNull
    public final Collection<GoLinter> getAllLinters() {
        return CollectionsKt.toList((Iterable)this.allLinters);
    }

    @NotNull
    public final Set<String> getEnabledLinters() {
        return CollectionsKt.toSet((Iterable)this.enabledLinters);
    }

    public final void clear() {
        this.allLinters.clear();
        this.enabledLinters.clear();
    }

    public final void refresh() {
        this.refreshTableHeader();
        this.refreshTableContent();
    }

    private final void refreshTableHeader() {
        ThreeStateCheckBox.State state = this.enabledLinters.size() == this.allLinters.size() ? ThreeStateCheckBox.State.SELECTED : (this.enabledLinters.isEmpty() ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
        ThreeStateCheckBoxHeaderEditor.setState$default(this.headerRenderer, state, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshTableContent() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.allLinters;
        ListTableModel listTableModel = this.getListTableModel();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GoLinter goLinter = (GoLinter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LinterTableEntry(this.enabledLinters.contains(it.getName()), it.getName(), it.getFullDescription()));
        }
        listTableModel.setItems((List)destination$iv$iv);
    }

    private final void initUi() {
        this.autoResizeMode = 3;
        this.tableHeader.setReorderingAllowed(false);
        this.columnModel.getColumn(0).setHeaderRenderer(this.headerRenderer);
        this.tableHeader.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ LinterTable this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                int column;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = e.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.table.JTableHeader");
                JTableHeader tableHeader = (JTableHeader)object;
                if (tableHeader.getTable().isEnabled() && (column = tableHeader.columnAtPoint(e.getPoint())) == 0) {
                    LinterTable.access$getHeaderRenderer$p(this.this$0).nextState();
                    LinterTable.access$refreshTableContent(this.this$0);
                }
            }
        });
    }

    private final ListTableModel<LinterTableEntry> createModel() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new EnabledColumnInfo(), new NameColumnInfo(), new DescriptionColumnInfo()};
        return new ListTableModel(columnInfoArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit headerRenderer$lambda$0(LinterTable this$0, ThreeStateCheckBox.State state, ChangeSource reason) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this$0.allLinters;
                Set<String> set = this$0.enabledLinters;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    GoLinter goLinter = (GoLinter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(p0.getName());
                }
                set.addAll(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
                break;
            }
            case 2: {
                this$0.enabledLinters.clear();
                break;
            }
            case 3: {
                if (reason != ChangeSource.HEADER) break;
                this$0.enabledLinters.addAll((Collection<String>)GoLinterSettings.Companion.getInstance(this$0.project).getEnabledLinters());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this$0.tableHeader.repaint();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ThreeStateCheckBoxHeaderEditor access$getHeaderRenderer$p(LinterTable $this) {
        return $this.headerRenderer;
    }

    public static final /* synthetic */ void access$refreshTableContent(LinterTable $this) {
        $this.refreshTableContent();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/go/linter/form/LinterTable$DescriptionColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/go/linter/form/LinterTableEntry;", "", "<init>", "()V", "valueOf", "item", "intellij.go.linter"})
    private static final class DescriptionColumnInfo
    extends ColumnInfo<LinterTableEntry, String> {
        public DescriptionColumnInfo() {
            super(GoLinterBundle.message("settings.linter.table.column.name.description", new Object[0]));
        }

        @Nullable
        public String valueOf(@Nullable LinterTableEntry item) {
            LinterTableEntry linterTableEntry = item;
            return linterTableEntry != null ? linterTableEntry.getDescription() : null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/go/linter/form/LinterTable$EnabledColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/go/linter/form/LinterTableEntry;", "", "<init>", "(Lcom/intellij/go/linter/form/LinterTable;)V", "valueOf", "item", "(Lcom/intellij/go/linter/form/LinterTableEntry;)Ljava/lang/Boolean;", "isCellEditable", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "getEditor", "Ljavax/swing/table/TableCellEditor;", "getWidth", "", "table", "Ljavax/swing/JTable;", "getEditorAndRenderer", "Lcom/intellij/go/linter/form/CheckBoxCellEditor;", "intellij.go.linter"})
    private final class EnabledColumnInfo
    extends ColumnInfo<LinterTableEntry, Boolean> {
        public EnabledColumnInfo() {
            super("");
        }

        @Nullable
        public Boolean valueOf(@Nullable LinterTableEntry item) {
            LinterTableEntry linterTableEntry = item;
            return linterTableEntry != null ? Boolean.valueOf(linterTableEntry.getEnabled()) : null;
        }

        public boolean isCellEditable(@Nullable LinterTableEntry item) {
            return true;
        }

        @Nullable
        public TableCellRenderer getRenderer(@Nullable LinterTableEntry item) {
            return this.getEditorAndRenderer(item);
        }

        @Nullable
        public TableCellEditor getEditor(@Nullable LinterTableEntry item) {
            return this.getEditorAndRenderer(item);
        }

        public int getWidth(@Nullable JTable table) {
            return new JBCheckBox().getPreferredSize().width;
        }

        private final CheckBoxCellEditor getEditorAndRenderer(LinterTableEntry item) {
            if (item == null) {
                return null;
            }
            return new CheckBoxCellEditor(arg_0 -> EnabledColumnInfo.getEditorAndRenderer$lambda$0(LinterTable.this, item, arg_0));
        }

        private static final void getEditorAndRenderer$lambda$0(LinterTable this$0, LinterTableEntry $item, ItemEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Object object = e.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JCheckBox");
            JCheckBox checkBox = (JCheckBox)object;
            boolean bl = checkBox.isSelected() ? this$0.enabledLinters.add($item.getName()) : this$0.enabledLinters.remove($item.getName());
            this$0.refresh();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/go/linter/form/LinterTable$NameColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/go/linter/form/LinterTableEntry;", "", "<init>", "()V", "valueOf", "item", "getWidth", "", "table", "Ljavax/swing/JTable;", "intellij.go.linter"})
    private static final class NameColumnInfo
    extends ColumnInfo<LinterTableEntry, String> {
        public NameColumnInfo() {
            super(GoLinterBundle.message("settings.linter.table.column.name.linter", new Object[0]));
        }

        @Nullable
        public String valueOf(@Nullable LinterTableEntry item) {
            LinterTableEntry linterTableEntry = item;
            return linterTableEntry != null ? linterTableEntry.getName() : null;
        }

        public int getWidth(@Nullable JTable table) {
            return 120;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeStateCheckBox.State.values().length];
            try {
                nArray[ThreeStateCheckBox.State.SELECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeStateCheckBox.State.NOT_SELECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeStateCheckBox.State.DONT_CARE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

