/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.go.linter.platform;

import com.intellij.go.linter.platform.Platform;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/go/linter/platform/UnixLikePlatform;", "Lcom/intellij/go/linter/platform/Platform;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tempPath", "", "decompress", "", "archive", "Ljava/io/File;", "targetDir", "fileName", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "linterName", "defaultPath", "Ljava/nio/file/Path;", "intellij.go.linter"})
public abstract class UnixLikePlatform
extends Platform {
    public UnixLikePlatform(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    protected String tempPath() {
        return "/tmp";
    }

    @Override
    protected void decompress(@NotNull File archive, @NotNull File targetDir, @NotNull String fileName, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        progressIndicator.setIndeterminate(true);
        String string = archive.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String directoryPrefix = StringsKt.substringBefore$default((String)string, (String)".tar.gz", null, (int)2, null);
        new Decompressor.Tar((InputStream)new FileInputStream(archive)).entryFilter(arg_0 -> UnixLikePlatform.decompress$lambda$1(arg_0 -> UnixLikePlatform.decompress$lambda$0(directoryPrefix, fileName, arg_0), arg_0)).removePrefixPath(directoryPrefix).extract(targetDir.toPath());
    }

    @Override
    @NotNull
    public String linterName() {
        return "golangci-lint";
    }

    @Override
    @NotNull
    public Path defaultPath() {
        Path path = Paths.get("/usr/local/bin", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean decompress$lambda$0(String $directoryPrefix, String $fileName, Decompressor.Entry it) {
        if (it.type != Decompressor.Entry.Type.FILE) return false;
        String string = it.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!Intrinsics.areEqual((Object)StringsKt.substringAfter$default((String)string, (String)($directoryPrefix + "/"), null, (int)2, null), (Object)$fileName)) return false;
        return true;
    }

    private static final boolean decompress$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

