/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.model.properties;

import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaPropertyKind;
import com.intellij.database.dialects.cassandra.model.defaults.CassTablePropertyKind;
import com.intellij.database.dialects.cassandra.model.properties.CassKeyColumn;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CassPropertyConverter
extends PropertyConverter {
    public static final BasicMetaType<CassKeyColumn> T_CASS_KEY_COLUMN = BasicMetaType.createType(CassKeyColumn.class, CassPropertyConverter::importCassKeyColumn, CassPropertyConverter::export);
    public static final BasicMetaType<List<CassKeyColumn>> T_LIST_OF_CASS_KEY_COLUMN = new BasicMetaType.CollectionMetaType(List.class, T_CASS_KEY_COLUMN, CassPropertyConverter::importListOfCassKeyColumn, CassPropertyConverter::exportListOfCassKeyColumn);
    public static final BasicMetaType<CassSchemaPropertyKind> T_CASS_SCHEMA_PROPERTY_KIND = BasicMetaType.createType(CassSchemaPropertyKind.class, CassPropertyConverter::importCassSchemaPropertyKind, CassPropertyConverter::export);
    public static final BasicMetaType<Map<CassSchemaPropertyKind, String>> T_MAP_OF_CASS_SCHEMA_PROPERTY_KIND_STRING = new BasicMetaType.MapMetaType(T_CASS_SCHEMA_PROPERTY_KIND, T_STRING, CassPropertyConverter::importMapOfCassSchemaPropertyKindString, CassPropertyConverter::exportMapOfCassSchemaPropertyKindString);
    public static final BasicMetaType<CassTablePropertyKind> T_CASS_TABLE_PROPERTY_KIND = BasicMetaType.createType(CassTablePropertyKind.class, CassPropertyConverter::importCassTablePropertyKind, CassPropertyConverter::export);
    public static final BasicMetaType<Map<CassTablePropertyKind, String>> T_MAP_OF_CASS_TABLE_PROPERTY_KIND_STRING = new BasicMetaType.MapMetaType(T_CASS_TABLE_PROPERTY_KIND, T_STRING, CassPropertyConverter::importMapOfCassTablePropertyKindString, CassPropertyConverter::exportMapOfCassTablePropertyKindString);

    public static String exportListOfCassKeyColumn(List<CassKeyColumn> columns) {
        StringBuilder sb = new StringBuilder();
        for (CassKeyColumn column : columns) {
            sb.append(column.export()).append("\n");
        }
        return sb.toString();
    }

    public static String export(CassKeyColumn column) {
        return column == null ? null : column.export();
    }

    @NotNull
    public static List<CassKeyColumn> importListOfCassKeyColumn(String text) {
        String[] lines;
        if (text == null || text.isEmpty()) {
            List<CassKeyColumn> list = Collections.emptyList();
            if (list == null) {
                CassPropertyConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<CassKeyColumn> res = new ArrayList<CassKeyColumn>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            res.add(CassKeyColumn.read(line));
        }
        ArrayList<CassKeyColumn> arrayList = res;
        if (arrayList == null) {
            CassPropertyConverter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public static CassKeyColumn importCassKeyColumn(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        return CassKeyColumn.read(text);
    }

    public static String exportMapOfCassSchemaPropertyKindString(Map<CassSchemaPropertyKind, String> properties) {
        return CassPropertyConverter.exportMap(properties);
    }

    public static String export(CassSchemaPropertyKind property) {
        return property == null ? null : property.name().toLowerCase(Locale.ENGLISH);
    }

    public static String exportMapOfCassTablePropertyKindString(Map<CassTablePropertyKind, String> properties) {
        return CassPropertyConverter.exportMap(properties);
    }

    public static String export(CassTablePropertyKind property) {
        return property == null ? null : property.name().toLowerCase(Locale.ENGLISH);
    }

    public static <T extends Enum<T>> String exportMap(Map<T, String> properties) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<T, String> entry : properties.entrySet()) {
            sb.append(((Enum)entry.getKey()).name().toLowerCase(Locale.ENGLISH)).append(":").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @Nullable
    public static CassSchemaPropertyKind importCassSchemaPropertyKind(String text) {
        return StringUtil.isEmpty((String)text) ? null : Enum.valueOf(CassSchemaPropertyKind.class, text.toUpperCase(Locale.ENGLISH));
    }

    @NotNull
    public static Map<CassSchemaPropertyKind, String> importMapOfCassSchemaPropertyKindString(String text) {
        return CassPropertyConverter.importMap(text, CassSchemaPropertyKind.class);
    }

    @Nullable
    public static CassTablePropertyKind importCassTablePropertyKind(String text) {
        return StringUtil.isEmpty((String)text) ? null : Enum.valueOf(CassTablePropertyKind.class, text.toUpperCase(Locale.ENGLISH));
    }

    @NotNull
    public static Map<CassTablePropertyKind, String> importMapOfCassTablePropertyKindString(String text) {
        return CassPropertyConverter.importMap(text, CassTablePropertyKind.class);
    }

    @NotNull
    public static <T extends Enum<T>> Map<T, String> importMap(String text, Class<T> enumClass) {
        String[] lines;
        LinkedHashMap<T, String> properties = new LinkedHashMap<T, String>();
        for (String line : lines = StringUtil.splitByLines((String)text)) {
            int colon = line.indexOf(58);
            if (colon == -1) continue;
            String name2 = line.substring(0, colon);
            try {
                T kind = Enum.valueOf(enumClass, name2.toUpperCase(Locale.ENGLISH));
                properties.put(kind, line.substring(colon + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        LinkedHashMap<T, String> linkedHashMap = properties;
        if (linkedHashMap == null) {
            CassPropertyConverter.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/dialects/cassandra/model/properties/CassPropertyConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfCassKeyColumn";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "importMap";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

