/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.model.properties.references;

import com.intellij.database.dialects.snowflake.model.SFlakeClass;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SFlakeClassReference
implements BasicReference {
    public final String className;
    public final String schemaName;
    public final String databaseName;

    public SFlakeClassReference(String className, String schemaName, String databaseName) {
        this.className = className;
        this.schemaName = schemaName;
        this.databaseName = databaseName;
    }

    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        BasicModel model;
        if (source == null) {
            SFlakeClassReference.$$$reportNull$$$0(0);
        }
        if (meta == null) {
            SFlakeClassReference.$$$reportNull$$$0(1);
        }
        if (assistant == null) {
            SFlakeClassReference.$$$reportNull$$$0(2);
        }
        if ((model = source.getModel()) == null || meta.tryCast(SFlakeClass.class) == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SFlakeClassReference.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from((Iterable)model.getNameIndex().getObjectsByName(this.className)).filter(SFlakeClass.class).filter(klass -> this.matchesSchema((SFlakeClass)klass)).filter(meta.valueClass);
        if (jBIterable == null) {
            SFlakeClassReference.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Nullable
    public String getName() {
        return null;
    }

    @Nullable
    public String getParentName(int i) {
        return switch (i) {
            case 2 -> this.databaseName;
            case 1 -> this.schemaName;
            case 0 -> this.className;
            default -> null;
        };
    }

    public long getObjectId() {
        return Long.MIN_VALUE;
    }

    public boolean isPortable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SFlakeClassReference)) {
            return false;
        }
        SFlakeClassReference reference = (SFlakeClassReference)o;
        return this.className.equals(reference.className) && this.schemaName.equals(reference.schemaName) && this.databaseName.equals(reference.databaseName);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.schemaName, this.databaseName);
    }

    private boolean matchesSchema(@NotNull SFlakeClass target) {
        BasicReference schemaRef;
        if (target == null) {
            SFlakeClassReference.$$$reportNull$$$0(5);
        }
        if ((schemaRef = target.getClassSchemaRef()) == null) {
            return false;
        }
        return StringUtil.equals((CharSequence)schemaRef.getName(), (CharSequence)this.schemaName) && StringUtil.equals((CharSequence)schemaRef.getParentName(), (CharSequence)this.databaseName);
    }

    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target) {
        if (source == null) {
            SFlakeClassReference.$$$reportNull$$$0(6);
        }
        if (meta == null) {
            SFlakeClassReference.$$$reportNull$$$0(7);
        }
        if (target == null) {
            SFlakeClassReference.$$$reportNull$$$0(8);
        }
        if (!(target instanceof SFlakeClass)) {
            return false;
        }
        SFlakeClass klass = (SFlakeClass)target;
        if (!this.className.equals(klass.getName())) {
            return false;
        }
        return this.matchesSchema(klass);
    }

    public static boolean isDefault(String charsetName) {
        return StringUtil.isEmpty((String)charsetName);
    }

    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            SFlakeClassReference.$$$reportNull$$$0(9);
        }
        consumer.accept("ClassName", (Object)this.className);
        consumer.accept("SchemaName", (Object)this.schemaName);
        consumer.accept("DatabaseName", (Object)this.databaseName);
    }

    @NotNull
    public static BasicReference importProperties(@NotNull NameValueGetter<String> properties) {
        if (properties == null) {
            SFlakeClassReference.$$$reportNull$$$0(10);
        }
        return new SFlakeClassReference((String)properties.get("ClassName"), (String)properties.get("SchemaName"), (String)properties.get("DatabaseName"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/snowflake/model/properties/references/SFlakeClassReference";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/snowflake/model/properties/references/SFlakeClassReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchesSchema";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

