/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.gsonfire.PreProcessor;
import io.kubernetes.client.openapi.models.V1Status;

public class V1StatusPreProcessor
implements PreProcessor<V1Status> {
    @Override
    public void preDeserialize(Class<? extends V1Status> aClass, JsonElement jsonElement, Gson gson) {
        if (V1StatusPreProcessor.isLegitKubernetesStatus(jsonElement)) {
            return;
        }
        JsonObject obj = jsonElement.getAsJsonObject();
        JsonElement statusField = obj.get("status");
        if (statusField != null && statusField.isJsonObject()) {
            obj.addProperty("status", (String)null);
        }
    }

    private static boolean isLegitKubernetesStatus(JsonElement jsonElement) {
        String apiVersion = jsonElement.getAsJsonObject().get("apiVersion") != null ? jsonElement.getAsJsonObject().get("apiVersion").getAsString() : null;
        String kind = jsonElement.getAsJsonObject().get("kind") != null ? jsonElement.getAsJsonObject().get("kind").getAsString() : null;
        return "v1".equals(apiVersion) && "Status".equals(kind);
    }
}

