/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.gec.model.problem;

import ai.grazie.gec.model.CorrectionServiceType;
import ai.grazie.gec.model.problem.Category;
import ai.grazie.gec.model.problem.Problem;
import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.gec.model.problem.ProblemUtilsKt;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0004J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/grazie/gec/model/problem/ProblemAggregator;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "aggregate", "", "Lai/grazie/gec/model/problem/Problem;", "problems", "problemPriority", "", "problem", "filterIntersectingByPriority", "mergeIntersecting", "filterAdjacentProblems", "Companion", "model-gec"})
@SourceDebugExtension(value={"SMAP\nProblemAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProblemAggregator.kt\nai/grazie/gec/model/problem/ProblemAggregator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,153:1\n1062#2:154\n1755#2,2:155\n1757#2:159\n774#2:160\n865#2,2:161\n774#2:163\n865#2,2:164\n295#2:166\n1755#2,3:167\n296#2:170\n1010#2,2:171\n295#2,2:177\n360#2,7:179\n1053#2:190\n785#2:191\n796#2:192\n1872#2,2:193\n797#2:195\n798#2:198\n1874#2:199\n799#2:200\n12567#3,2:157\n18810#3,2:196\n11158#3:201\n11493#3,3:202\n37#4:173\n36#4,3:174\n37#4:186\n36#4,3:187\n*S KotlinDebug\n*F\n+ 1 ProblemAggregator.kt\nai/grazie/gec/model/problem/ProblemAggregator\n*L\n33#1:154\n37#1:155,2\n37#1:159\n54#1:160\n54#1:161,2\n58#1:163\n58#1:164,2\n74#1:166\n76#1:167,3\n74#1:170\n85#1:171,2\n97#1:177,2\n108#1:179,7\n138#1:190\n139#1:191\n139#1:192\n139#1:193,2\n139#1:195\n139#1:198\n139#1:199\n139#1:200\n37#1:157,2\n144#1:196,2\n64#1:201\n64#1:202,3\n90#1:173\n90#1:174,3\n126#1:186\n126#1:187,3\n*E\n"})
public class ProblemAggregator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    public static final int GRAZIE_RULE_PRIORITY = 30;
    public static final int SPELL_PRIORITY = 20;
    public static final int MLEC_PRIORITY = 10;

    public ProblemAggregator(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
    }

    @NotNull
    public final List<Problem> aggregate(@NotNull List<Problem> problems) {
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        List<Problem> merged = this.mergeIntersecting(problems);
        List<Problem> prioritized = this.filterIntersectingByPriority(merged);
        return this.filterAdjacentProblems(prioritized);
    }

    protected final int problemPriority(@NotNull Problem problem) {
        int n;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (ProblemUtilsKt.concedeToOtherGrammarCheckers(problem)) {
            n = 0;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[problem.getInfo().getService().ordinal()]) {
                case 1: {
                    n = 30;
                    break;
                }
                case 2: {
                    n = 20;
                    break;
                }
                case 3: {
                    n = 10;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return n;
    }

    private final List<Problem> filterIntersectingByPriority(List<Problem> problems) {
        Iterable $this$sortedByDescending$iv = problems;
        boolean $i$f$sortedByDescending = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(this){
            final /* synthetic */ ProblemAggregator this$0;
            {
                this.this$0 = problemAggregator;
            }

            public final int compare(T a, T b) {
                Problem it = (Problem)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(this.this$0.problemPriority(it));
                it = (Problem)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.this$0.problemPriority(it)));
            }
        });
        ArrayList<Problem> results = new ArrayList<Problem>();
        for (Problem correction : sorted) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = results;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block7: {
                            Problem it = (Problem)element$iv;
                            boolean bl3 = false;
                            TextRange[] $this$any$iv2 = it.getHighlighting().getAlways();
                            boolean $i$f$any2 = false;
                            int n = $this$any$iv2.length;
                            for (int i = 0; i < n; ++i) {
                                boolean bl4;
                                block6: {
                                    TextRange element$iv2;
                                    TextRange fst = element$iv2 = $this$any$iv2[i];
                                    boolean bl5 = false;
                                    TextRange[] $this$any$iv3 = correction.getHighlighting().getAlways();
                                    boolean $i$f$any3 = false;
                                    int n2 = $this$any$iv3.length;
                                    for (int j = 0; j < n2; ++j) {
                                        TextRange element$iv3;
                                        TextRange snd = element$iv3 = $this$any$iv3[j];
                                        boolean bl6 = false;
                                        if (!fst.intersects(snd)) continue;
                                        bl4 = true;
                                        break block6;
                                    }
                                    bl4 = false;
                                }
                                if (!bl4) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            results.add(correction);
        }
        return results;
    }

    /*
     * Unable to fully structure code
     */
    private final List<Problem> mergeIntersecting(List<Problem> problems) {
        $this$filter$iv = problems;
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Problem)element$iv$iv;
            $i$a$-filter-ProblemAggregator$mergeIntersecting$mlecSpellingProblems$1 = false;
            if (!(it.getInfo().getService() == CorrectionServiceType.MLEC && it.getInfo().getCategory() == Category.SPELLING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mlecSpellingProblems = (List)destination$iv$iv;
        $this$filter$iv = problems;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            it = (Problem)element$iv$iv;
            $i$a$-filter-ProblemAggregator$mergeIntersecting$mlecNotSpellingProblems$1 = false;
            if (!(it.getInfo().getService() == CorrectionServiceType.MLEC && it.getInfo().getCategory() != Category.SPELLING)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        mlecNotSpellingProblems = (List)destination$iv$iv;
        results = new ArrayList<E>();
        for (Problem problem : problems) {
            switch (WhenMappings.$EnumSwitchMapping$0[problem.getInfo().getService().ordinal()]) {
                case 1: {
                    ruleCorrections = ProblemAggregator.mergeIntersecting$getProblemCorrections(this, problem);
                    $this$firstOrNull$iv = mlecNotSpellingProblems;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        mlecProblem = (Problem)element$iv;
                        $i$a$-firstOrNull-ProblemAggregator$mergeIntersecting$matchingMlecProblem$1 = false;
                        mlecCorrections = ProblemAggregator.mergeIntersecting$getProblemCorrections(this, mlecProblem);
                        $this$any$iv = mlecCorrections;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl43
                        v0 = false;
                        ** GOTO lbl51
lbl43:
                        // 2 sources

                        for (T element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            $i$a$-any-ProblemAggregator$mergeIntersecting$matchingMlecProblem$1$1 = false;
                            if (!ruleCorrections.contains(it)) continue;
                            v0 = true;
                            ** GOTO lbl51
                        }
                        v0 = false;
lbl51:
                        // 3 sources

                        if (!v0) continue;
                        v1 = element$iv;
                        ** GOTO lbl55
                    }
                    v1 = null;
lbl55:
                    // 2 sources

                    matchingMlecProblem = v1;
                    if (matchingMlecProblem != null) {
                        mlecCorrections = ProblemAggregator.mergeIntersecting$getProblemCorrections(this, matchingMlecProblem);
                        $this$sortBy$iv = reorderedFixes = ArraysKt.toMutableList((Object[])problem.getFixes());
                        $i$f$sortBy = false;
                        if ($this$sortBy$iv.size() > 1) {
                            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(this, mlecCorrections){
                                final /* synthetic */ ProblemAggregator this$0;
                                final /* synthetic */ List $mlecCorrections$inlined;
                                {
                                    this.this$0 = problemAggregator;
                                    this.$mlecCorrections$inlined = list;
                                }

                                public final int compare(T a, T b) {
                                    ProblemFix fix = (ProblemFix)a;
                                    boolean bl = false;
                                    String correction = fix.apply(ProblemAggregator.access$getText$p(this.this$0));
                                    int n = this.$mlecCorrections$inlined.contains(correction) ? -1 : 0;
                                    fix = (ProblemFix)b;
                                    Comparable comparable = Integer.valueOf(n);
                                    bl = false;
                                    correction = fix.apply(ProblemAggregator.access$getText$p(this.this$0));
                                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(this.$mlecCorrections$inlined.contains(correction) ? -1 : 0));
                                }
                            });
                        }
                        $this$toTypedArray$iv = reorderedFixes;
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        v2 = results.add(Problem.copy$default(problem, null, null, null, thisCollection$iv.toArray(new ProblemFix[0]), null, null, null, false, null, false, 1015, null));
                        break;
                    }
                    v2 = results.add(problem);
                    break;
                }
                case 2: {
                    $this$firstOrNull$iv = mlecSpellingProblems;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (Problem)element$iv;
                        $i$a$-firstOrNull-ProblemAggregator$mergeIntersecting$matchingMlecProblem$2 = false;
                        if (!Arrays.equals(it.getHighlighting().getAlways(), problem.getHighlighting().getAlways())) continue;
                        v3 = element$iv;
                        ** GOTO lbl81
                    }
                    v3 = null;
lbl81:
                    // 2 sources

                    matchingMlecProblem = v3;
                    if (matchingMlecProblem == null) ** GOTO lbl115
                    mergedFixes = ArraysKt.toMutableList((Object[])problem.getFixes());
                    mlecFix = (ProblemFix)ArraysKt.firstOrNull((Object[])matchingMlecProblem.getFixes());
                    if (mlecFix == null) ** GOTO lbl110
                    v4 = (ProblemFix.Part.Change)ArraysKt.firstOrNull((Object[])mlecFix.getChanges());
                    mlecFixText = v4 != null ? v4.getText() : null;
                    $this$indexOfFirst$iv = mergedFixes;
                    $i$f$indexOfFirst = false;
                    index$iv = 0;
                    for (E item$iv : $this$indexOfFirst$iv) {
                        it = (ProblemFix)item$iv;
                        $i$a$-indexOfFirst-ProblemAggregator$mergeIntersecting$existingFixIndex$1 = false;
                        v5 = (ProblemFix.Part.Change)ArraysKt.firstOrNull((Object[])it.getChanges());
                        if (!Intrinsics.areEqual((Object)(v5 != null ? v5.getText() : null), (Object)mlecFixText)) ** GOTO lbl98
                        v6 = index$iv;
                        ** GOTO lbl101
lbl98:
                        // 1 sources

                        ++index$iv;
                    }
                    v6 = -1;
lbl101:
                    // 2 sources

                    existingFixIndex = v6;
                    if (existingFixIndex == -1) {
                        insertionIndex = mergedFixes.size() <= 1 ? mergedFixes.size() : mergedFixes.size() - 1;
                        mergedFixes.add(insertionIndex, mlecFix);
                    } else if (existingFixIndex > 0) {
                        fix = (ProblemFix)mergedFixes.remove(existingFixIndex);
                        mergedFixes.add(0, fix);
                    }
lbl110:
                    // 5 sources

                    $this$toTypedArray$iv = mergedFixes;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    v2 = results.add(Problem.copy$default(problem, null, null, null, thisCollection$iv.toArray(new ProblemFix[0]), null, null, null, false, null, false, 1015, null));
                    break;
lbl115:
                    // 1 sources

                    v2 = results.add(problem);
                    break;
                }
                default: {
                    v2 = results.add(problem);
                }
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Problem> filterAdjacentProblems(List<Problem> problems) {
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$sortedBy$iv = problems;
        boolean $i$f$sortedBy = false;
        List sortedProblems = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Problem it = (Problem)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getHighlighting().getAlways()[0].getStart());
                it = (Problem)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHighlighting().getAlways()[0].getStart()));
            }
        });
        Iterable $this$filterIndexed$iv = sortedProblems;
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            boolean bl;
            void element$iv$iv;
            block9: {
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl2 = false;
                Problem problem = (Problem)element$iv$iv;
                int i = index$iv$iv;
                boolean bl3 = false;
                if (i == 0) {
                    bl = true;
                } else {
                    Object object = (Object[])ArraysKt.singleOrNull((Object[])((Problem)sortedProblems.get(i - 1)).getFixes());
                    if (object == null || (object = ((ProblemFix)object).getChanges()) == null || (object = (ProblemFix.Part.Change)ArraysKt.singleOrNull((Object[])object)) == null) {
                        bl = true;
                    } else {
                        Object previousChange = object;
                        if (Intrinsics.areEqual((Object)StringsKt.replace$default((String)((ProblemFix.Part.Change)previousChange).getText(), (String)" ", (String)"", (boolean)false, (int)4, null), (Object)((ProblemFix.Part.Change)previousChange).getRange().substring(this.text))) {
                            void problem2;
                            Intrinsics.checkNotNullExpressionValue((Object)((ProblemFix.Part.Change)previousChange).getText().substring(StringsKt.lastIndexOf$default((CharSequence)((ProblemFix.Part.Change)previousChange).getText(), (char)' ', (int)0, (boolean)false, (int)6, null) + 1), (String)"substring(...)");
                            ProblemFix[] $this$none$iv = problem2.getFixes();
                            boolean $i$f$none = false;
                            int n2 = $this$none$iv.length;
                            for (int j = 0; j < n2; ++j) {
                                String ending;
                                ProblemFix element$iv;
                                ProblemFix it = element$iv = $this$none$iv[j];
                                boolean bl4 = false;
                                ProblemFix.Part.Change change = it.getChanges()[0];
                                if (!(change.getRange().getLength() == 0 && Intrinsics.areEqual((Object)change.getText(), (Object)(ending + " ")) && ((ProblemFix.Part.Change)previousChange).getRange().getEndExclusive() + 1 == change.getRange().getStart())) continue;
                                bl = false;
                                break block9;
                            }
                            bl = true;
                        } else {
                            bl = true;
                        }
                    }
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> mergeIntersecting$getProblemCorrections(ProblemAggregator this$0, Problem problem) {
        void $this$mapTo$iv$iv;
        ProblemFix[] $this$map$iv = problem.getFixes();
        boolean $i$f$map = false;
        ProblemFix[] problemFixArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.apply(this$0.text));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ String access$getText$p(ProblemAggregator $this) {
        return $this.text;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/grazie/gec/model/problem/ProblemAggregator$Companion;", "", "<init>", "()V", "GRAZIE_RULE_PRIORITY", "", "SPELL_PRIORITY", "MLEC_PRIORITY", "model-gec"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CorrectionServiceType.values().length];
            try {
                nArray[CorrectionServiceType.RULE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CorrectionServiceType.SPELL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CorrectionServiceType.MLEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

