/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.rider.csharp;

import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.utils.StringExtractionUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.lexer.CSharpTokenType;
import com.jetbrains.rider.languages.fileTypes.csharp.lexer.CSharpLexer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/inline/completion/rider/csharp/CSharpMLCompletionLexer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosuresDefinition", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;)V", "createBaseLexer", "Lcom/intellij/lexer/Lexer;", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "bracketsSet", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "intellij.fullLine.rider.csharp"})
@SourceDebugExtension(value={"SMAP\nCSharpMLCompletionLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CSharpMLCompletionLexer.kt\ncom/intellij/ml/inline/completion/rider/csharp/CSharpMLCompletionLexer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1869#2,2:149\n1869#2,2:151\n*S KotlinDebug\n*F\n+ 1 CSharpMLCompletionLexer.kt\ncom/intellij/ml/inline/completion/rider/csharp/CSharpMLCompletionLexer\n*L\n123#1:149,2\n131#1:151,2\n*E\n"})
public final class CSharpMLCompletionLexer
extends MLCompletionLexerAdapter {
    @NotNull
    private final TokenSet bracketsSet;

    public CSharpMLCompletionLexer(@NotNull MLCompletionEnclosuresDefinition enclosuresDefinition) {
        Intrinsics.checkNotNullParameter((Object)enclosuresDefinition, (String)"enclosuresDefinition");
        super(enclosuresDefinition);
        IElementType[] iElementTypeArray = new IElementType[]{CSharpTokenType.LPARENTH, CSharpTokenType.RPARENTH, CSharpTokenType.LBRACE, CSharpTokenType.RBRACE, CSharpTokenType.LBRACKET, CSharpTokenType.RBRACKET, CSharpTokenType.INTERPOLATION_LBRACE, CSharpTokenType.INTERPOLATION_RBRACE};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.bracketsSet = tokenSet;
    }

    @Override
    @NotNull
    protected Lexer createBaseLexer() {
        return (Lexer)new CSharpLexer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text2, int offset, @NotNull MLCompletionLexerAdapter.LexemesCollector collector) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        if (this.bracketsSet.contains(token)) {
            collector.bracket(StringsKt.first((CharSequence)text2), offset);
            return;
        }
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.STRING_LITERAL_REGULAR) || Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.STRING_LITERAL_VERBATIM)) {
            char quote = StringsKt.first((CharSequence)text2);
            if (this.getEnclosures().isStringMarker(quote)) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset, null, 4, null);
                if (StringsKt.last((CharSequence)text2) == quote && text2.length() > 1) {
                    MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset + text2.length() - 1, null, 4, null);
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.CHARACTER_LITERAL)) {
            if (StringsKt.first((CharSequence)text2) == '\'') {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, '\'', offset, null, 4, null);
                if (text2.length() > 1 && StringsKt.last((CharSequence)text2) == '\'') {
                    MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, '\'', offset + text2.length() - 1, null, 4, null);
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_REGULAR_START) || Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_VERBATIM_START)) {
            int braceIndex;
            int quoteIndex = StringsKt.indexOf$default((CharSequence)text2, (char)'\"', (int)0, (boolean)false, (int)6, null);
            if (this.getEnclosures().isStringMarker('\"')) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, '\"', offset + quoteIndex, null, 4, null);
            }
            if ((braceIndex = StringsKt.indexOf$default((CharSequence)text2, (char)'{', (int)0, (boolean)false, (int)6, null)) != -1) {
                collector.stringTemplate('{', offset + braceIndex, "\\{");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_REGULAR_MIDDLE) || Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_VERBATIM_MIDDLE)) {
            int braceIndex;
            if (StringsKt.startsWith$default((String)text2, (String)"}", (boolean)false, (int)2, null)) {
                MLCompletionLexerAdapter.LexemesCollector.stringTemplate$default(collector, '}', offset, null, 4, null);
            }
            if ((braceIndex = StringsKt.indexOf$default((CharSequence)text2, (char)'{', (int)0, (boolean)false, (int)6, null)) != -1) {
                collector.stringTemplate('{', offset + braceIndex, "\\{");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_REGULAR_END) || Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_VERBATIM_END)) {
            if (StringsKt.startsWith$default((String)text2, (String)"}", (boolean)false, (int)2, null)) {
                collector.stringTemplate('}', offset, "}");
            }
            char quote = StringsKt.last((CharSequence)text2);
            if (this.getEnclosures().isStringMarker(quote) && text2.length() > 1) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset + text2.length() - 1, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.SINGLE_LINE_RAW_STRING_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.MULTI_LINE_RAW_STRING_LITERAL)) {
            if (StringsKt.startsWith$default((String)text2, (String)"\"\"\"", (boolean)false, (int)2, null)) {
                MLCompletionLexerAdapter.LexemesCollector.multicharStringMarker$default(collector, "\"\"\"", offset, null, 4, null);
            }
            if (StringsKt.endsWith$default((String)text2, (String)"\"\"\"", (boolean)false, (int)2, null) && text2.length() >= 6) {
                MLCompletionLexerAdapter.LexemesCollector.multicharStringMarker$default(collector, "\"\"\"", offset + text2.length() - 3, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_RAW_SINGLE_LINE_START) || Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_RAW_MULTI_LINE_START)) {
            int quoteIndex = StringsKt.indexOf$default((CharSequence)text2, (String)"\"\"\"", (int)0, (boolean)false, (int)6, null);
            if (quoteIndex != -1) {
                MLCompletionLexerAdapter.LexemesCollector.multicharStringMarker$default(collector, "\"\"\"", offset + quoteIndex, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_RAW_END)) {
            if (StringsKt.endsWith$default((String)text2, (String)"\"\"\"", (boolean)false, (int)2, null)) {
                MLCompletionLexerAdapter.LexemesCollector.multicharStringMarker$default(collector, "\"\"\"", offset + text2.length() - 3, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_RAW_INSERT_START)) {
            int braceIndex = StringsKt.indexOf$default((CharSequence)text2, (char)'{', (int)0, (boolean)false, (int)6, null);
            if (braceIndex != -1) {
                String string = text2.substring(braceIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collector.stringTemplate('{', offset + braceIndex, string);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTERPOLATED_STRING_RAW_INSERT_END)) {
            int braceIndex = StringsKt.indexOf$default((CharSequence)text2, (char)'}', (int)0, (boolean)false, (int)6, null);
            if (braceIndex != -1) {
                String string = text2.substring(braceIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collector.stringTemplate('}', offset + braceIndex, string);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.C_STYLE_COMMENT)) {
            void $this$forEach$iv;
            if (StringsKt.startsWith$default((String)text2, (String)"/*", (boolean)false, (int)2, null)) {
                MLCompletionLexerAdapter.LexemesCollector.multicharStringMarker$default(collector, "/*", offset, null, 4, null);
            }
            Iterable braceIndex = StringExtractionUtil.INSTANCE.extractBracketsWithIndices(text2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                collector.bracket(((Character)it.getFirst()).charValue(), offset + ((Number)it.getSecond()).intValue());
            }
            if (StringsKt.endsWith$default((String)text2, (String)"*/", (boolean)false, (int)2, null) && text2.length() >= 4) {
                MLCompletionLexerAdapter.LexemesCollector.multicharStringMarker$default(collector, "*/", offset + text2.length() - 2, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.END_OF_LINE_COMMENT)) {
            Iterable $this$forEach$iv = StringExtractionUtil.INSTANCE.extractBracketsWithIndices(text2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                collector.bracket(((Character)it.getFirst()).charValue(), offset + ((Number)it.getSecond()).intValue());
            }
        } else if (this.seemsLikeSpecialToken(text2)) {
            collector.special(text2, offset);
        }
    }
}

