/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.markdown.completion;

import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.lexer.MarkdownLexerAdapter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u0015\u001a\u00020\t*\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0016\u001a\u00020\t*\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/markdown/completion/MarkdownCompletionLexer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosuresDefinition", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;)V", "createBaseLexer", "Lcom/intellij/lexer/Lexer;", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "isHeaderToken", "", "isBacktickedCodeStartOrEnd", "collectSplitHeader", "collectBacktickedEmphasize", "Companion", "intellij.ml.llm.markdown.completion"})
@SourceDebugExtension(value={"SMAP\nMarkdownCompletionLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownCompletionLexer.kt\ncom/intellij/ml/llm/markdown/completion/MarkdownCompletionLexer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,62:1\n1069#2,2:63\n1069#2,2:65\n1188#2,3:67\n*S KotlinDebug\n*F\n+ 1 MarkdownCompletionLexer.kt\ncom/intellij/ml/llm/markdown/completion/MarkdownCompletionLexer\n*L\n42#1:63,2\n43#1:65,2\n46#1:67,3\n*E\n"})
public final class MarkdownCompletionLexer
extends MLCompletionLexerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> BRACKETS;
    @NotNull
    private static final Set<String> EMPHASIZERS;
    @NotNull
    private static final Set<String> QUOTES;
    @NotNull
    private static final String BACKTICKS_PAIR = "``";

    public MarkdownCompletionLexer(@NotNull MLCompletionEnclosuresDefinition enclosuresDefinition) {
        Intrinsics.checkNotNullParameter((Object)enclosuresDefinition, (String)"enclosuresDefinition");
        super(enclosuresDefinition);
    }

    @Override
    @NotNull
    protected Lexer createBaseLexer() {
        return (Lexer)new MarkdownLexerAdapter();
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text2, int offset, @NotNull MLCompletionLexerAdapter.LexemesCollector collector) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        if (BRACKETS.contains(text2)) {
            collector.bracket(StringsKt.first((CharSequence)text2), offset);
        } else if (QUOTES.contains(text2)) {
            MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, StringsKt.first((CharSequence)text2), offset, null, 4, null);
        } else if (EMPHASIZERS.contains(text2)) {
            collector.special(text2, offset);
        } else if (this.isHeaderToken(text2)) {
            this.collectSplitHeader(collector, text2, offset);
        } else if (this.isBacktickedCodeStartOrEnd(text2)) {
            this.collectBacktickedEmphasize(collector, text2, offset);
        } else if (Intrinsics.areEqual((Object)text2, (Object)BACKTICKS_PAIR)) {
            MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, StringsKt.first((CharSequence)text2), offset, null, 4, null);
            MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, StringsKt.last((CharSequence)text2), offset + 1, null, 4, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHeaderToken(String text2) {
        int n = text2.length();
        if (1 > n) return false;
        if (n >= 7) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$all$iv = text2;
        boolean $i$f$all = false;
        int n2 = 0;
        while (n2 < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n2);
            boolean bl2 = false;
            if (it != '#') return false;
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private final boolean isBacktickedCodeStartOrEnd(String text2) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = text2;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (it == '`') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl && text2.length() > 2;
    }

    private final void collectSplitHeader(MLCompletionLexerAdapter.LexemesCollector $this$collectSplitHeader, String text2, int offset) {
        CharSequence $this$forEachIndexed$iv = text2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int i2 = index$iv++;
            boolean bl = false;
            $this$collectSplitHeader.special("#", offset + i2);
        }
    }

    private final void collectBacktickedEmphasize(MLCompletionLexerAdapter.LexemesCollector $this$collectBacktickedEmphasize, String text2, int offset) {
        MLCompletionLexerAdapter.LexemesCollector.multicharStringMarker$default($this$collectBacktickedEmphasize, text2, offset, null, 4, null);
    }

    static {
        Object[] objectArray = new String[]{"(", ")", "[", "]"};
        BRACKETS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"*", "_"};
        EMPHASIZERS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"\"", "'", "`"};
        QUOTES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/markdown/completion/MarkdownCompletionLexer$Companion;", "", "<init>", "()V", "BRACKETS", "", "", "EMPHASIZERS", "QUOTES", "BACKTICKS_PAIR", "intellij.ml.llm.markdown.completion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

